// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagent

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagent/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a static snapshot of your prompt that can be deployed to production.
// For more information, see [Deploy prompts using Prompt management by creating versions]in the Amazon Bedrock User Guide.
//
// [Deploy prompts using Prompt management by creating versions]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-deploy.html
func (c *Client) CreatePromptVersion(ctx context.Context, params *CreatePromptVersionInput, optFns ...func(*Options)) (*CreatePromptVersionOutput, error) {
	if params == nil {
		params = &CreatePromptVersionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreatePromptVersion", params, optFns, c.addOperationCreatePromptVersionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreatePromptVersionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreatePromptVersionInput struct {

	// The unique identifier of the prompt that you want to create a version of.
	//
	// This member is required.
	PromptIdentifier *string

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information, see [Ensuring idempotency].
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientToken *string

	// A description for the version of the prompt.
	Description *string

	// Any tags that you want to attach to the version of the prompt. For more
	// information, see [Tagging resources in Amazon Bedrock].
	//
	// [Tagging resources in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreatePromptVersionOutput struct {

	// The Amazon Resource Name (ARN) of the version of the prompt.
	//
	// This member is required.
	Arn *string

	// The time at which the prompt was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the prompt.
	//
	// This member is required.
	Id *string

	// The name of the prompt.
	//
	// This member is required.
	Name *string

	// The time at which the prompt was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The version of the prompt that was created. Versions are numbered
	// incrementally, starting from 1.
	//
	// This member is required.
	Version *string

	// The Amazon Resource Name (ARN) of the KMS key to encrypt the version of the
	// prompt.
	CustomerEncryptionKeyArn *string

	// The name of the default variant for the prompt. This value must match the name
	// field in the relevant [PromptVariant]object.
	//
	// [PromptVariant]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html
	DefaultVariant *string

	// A description for the version.
	Description *string

	// A list of objects, each containing details about a variant of the prompt.
	Variants []types.PromptVariant

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreatePromptVersionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreatePromptVersion{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreatePromptVersion{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreatePromptVersion"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreatePromptVersionMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreatePromptVersionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreatePromptVersion(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreatePromptVersion struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreatePromptVersion) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreatePromptVersion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreatePromptVersionInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreatePromptVersionInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreatePromptVersionMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreatePromptVersion{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreatePromptVersion(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreatePromptVersion",
	}
}
