// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagent

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagent/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves information about the working draft ( DRAFT version) of a prompt or a
// version of it, depending on whether you include the promptVersion field or not.
// For more information, see [View information about prompts using Prompt management]and [View information about a version of your prompt] in the Amazon Bedrock User Guide.
//
// [View information about a version of your prompt]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-deploy.html#prompt-management-versions-view.html
// [View information about prompts using Prompt management]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-manage.html#prompt-management-view.html
func (c *Client) GetPrompt(ctx context.Context, params *GetPromptInput, optFns ...func(*Options)) (*GetPromptOutput, error) {
	if params == nil {
		params = &GetPromptInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetPrompt", params, optFns, c.addOperationGetPromptMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetPromptOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetPromptInput struct {

	// The unique identifier of the prompt.
	//
	// This member is required.
	PromptIdentifier *string

	// The version of the prompt about which you want to retrieve information. Omit
	// this field to return information about the working draft of the prompt.
	PromptVersion *string

	noSmithyDocumentSerde
}

type GetPromptOutput struct {

	// The Amazon Resource Name (ARN) of the prompt or the prompt version (if you
	// specified a version in the request).
	//
	// This member is required.
	Arn *string

	// The time at which the prompt was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the prompt.
	//
	// This member is required.
	Id *string

	// The name of the prompt.
	//
	// This member is required.
	Name *string

	// The time at which the prompt was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The version of the prompt.
	//
	// This member is required.
	Version *string

	// The Amazon Resource Name (ARN) of the KMS key that the prompt is encrypted with.
	CustomerEncryptionKeyArn *string

	// The name of the default variant for the prompt. This value must match the name
	// field in the relevant [PromptVariant]object.
	//
	// [PromptVariant]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html
	DefaultVariant *string

	// The descriptino of the prompt.
	Description *string

	// A list of objects, each containing details about a variant of the prompt.
	Variants []types.PromptVariant

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetPromptMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetPrompt{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetPrompt{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetPrompt"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetPromptValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetPrompt(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetPrompt(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetPrompt",
	}
}
