// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentruntime

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpDeleteAgentMemory struct {
}

func (*validateOpDeleteAgentMemory) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteAgentMemory) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteAgentMemoryInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteAgentMemoryInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGenerateQuery struct {
}

func (*validateOpGenerateQuery) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGenerateQuery) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GenerateQueryInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGenerateQueryInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetAgentMemory struct {
}

func (*validateOpGetAgentMemory) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetAgentMemory) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetAgentMemoryInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetAgentMemoryInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpInvokeAgent struct {
}

func (*validateOpInvokeAgent) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpInvokeAgent) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*InvokeAgentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpInvokeAgentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpInvokeFlow struct {
}

func (*validateOpInvokeFlow) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpInvokeFlow) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*InvokeFlowInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpInvokeFlowInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpInvokeInlineAgent struct {
}

func (*validateOpInvokeInlineAgent) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpInvokeInlineAgent) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*InvokeInlineAgentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpInvokeInlineAgentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpOptimizePrompt struct {
}

func (*validateOpOptimizePrompt) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpOptimizePrompt) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*OptimizePromptInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpOptimizePromptInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRerank struct {
}

func (*validateOpRerank) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRerank) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RerankInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRerankInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRetrieveAndGenerate struct {
}

func (*validateOpRetrieveAndGenerate) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRetrieveAndGenerate) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RetrieveAndGenerateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRetrieveAndGenerateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRetrieveAndGenerateStream struct {
}

func (*validateOpRetrieveAndGenerateStream) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRetrieveAndGenerateStream) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RetrieveAndGenerateStreamInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRetrieveAndGenerateStreamInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRetrieve struct {
}

func (*validateOpRetrieve) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRetrieve) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RetrieveInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRetrieveInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpDeleteAgentMemoryValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteAgentMemory{}, middleware.After)
}

func addOpGenerateQueryValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGenerateQuery{}, middleware.After)
}

func addOpGetAgentMemoryValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetAgentMemory{}, middleware.After)
}

func addOpInvokeAgentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpInvokeAgent{}, middleware.After)
}

func addOpInvokeFlowValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpInvokeFlow{}, middleware.After)
}

func addOpInvokeInlineAgentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpInvokeInlineAgent{}, middleware.After)
}

func addOpOptimizePromptValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpOptimizePrompt{}, middleware.After)
}

func addOpRerankValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRerank{}, middleware.After)
}

func addOpRetrieveAndGenerateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRetrieveAndGenerate{}, middleware.After)
}

func addOpRetrieveAndGenerateStreamValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRetrieveAndGenerateStream{}, middleware.After)
}

func addOpRetrieveValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRetrieve{}, middleware.After)
}

func validateAgentActionGroup(v *types.AgentActionGroup) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AgentActionGroup"}
	if v.ActionGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionGroupName"))
	}
	if v.FunctionSchema != nil {
		if err := validateFunctionSchema(v.FunctionSchema); err != nil {
			invalidParams.AddNested("FunctionSchema", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAgentActionGroups(v []types.AgentActionGroup) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AgentActionGroups"}
	for i := range v {
		if err := validateAgentActionGroup(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateApiResult(v *types.ApiResult) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ApiResult"}
	if v.ActionGroup == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionGroup"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateBedrockRerankingConfiguration(v *types.BedrockRerankingConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BedrockRerankingConfiguration"}
	if v.ModelConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ModelConfiguration"))
	} else if v.ModelConfiguration != nil {
		if err := validateBedrockRerankingModelConfiguration(v.ModelConfiguration); err != nil {
			invalidParams.AddNested("ModelConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateBedrockRerankingModelConfiguration(v *types.BedrockRerankingModelConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BedrockRerankingModelConfiguration"}
	if v.ModelArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ModelArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateByteContentDoc(v *types.ByteContentDoc) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ByteContentDoc"}
	if v.Identifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Identifier"))
	}
	if v.ContentType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ContentType"))
	}
	if v.Data == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Data"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateByteContentFile(v *types.ByteContentFile) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ByteContentFile"}
	if v.MediaType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MediaType"))
	}
	if v.Data == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Data"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateConversationHistory(v *types.ConversationHistory) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ConversationHistory"}
	if v.Messages != nil {
		if err := validateMessages(v.Messages); err != nil {
			invalidParams.AddNested("Messages", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExternalSource(v *types.ExternalSource) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExternalSource"}
	if len(v.SourceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("SourceType"))
	}
	if v.S3Location != nil {
		if err := validateS3ObjectDoc(v.S3Location); err != nil {
			invalidParams.AddNested("S3Location", err.(smithy.InvalidParamsError))
		}
	}
	if v.ByteContent != nil {
		if err := validateByteContentDoc(v.ByteContent); err != nil {
			invalidParams.AddNested("ByteContent", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExternalSources(v []types.ExternalSource) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExternalSources"}
	for i := range v {
		if err := validateExternalSource(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExternalSourcesGenerationConfiguration(v *types.ExternalSourcesGenerationConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExternalSourcesGenerationConfiguration"}
	if v.GuardrailConfiguration != nil {
		if err := validateGuardrailConfiguration(v.GuardrailConfiguration); err != nil {
			invalidParams.AddNested("GuardrailConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExternalSourcesRetrieveAndGenerateConfiguration(v *types.ExternalSourcesRetrieveAndGenerateConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExternalSourcesRetrieveAndGenerateConfiguration"}
	if v.ModelArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ModelArn"))
	}
	if v.Sources == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Sources"))
	} else if v.Sources != nil {
		if err := validateExternalSources(v.Sources); err != nil {
			invalidParams.AddNested("Sources", err.(smithy.InvalidParamsError))
		}
	}
	if v.GenerationConfiguration != nil {
		if err := validateExternalSourcesGenerationConfiguration(v.GenerationConfiguration); err != nil {
			invalidParams.AddNested("GenerationConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFieldForReranking(v *types.FieldForReranking) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FieldForReranking"}
	if v.FieldName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FieldName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFieldsForReranking(v []types.FieldForReranking) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FieldsForReranking"}
	for i := range v {
		if err := validateFieldForReranking(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFileSource(v *types.FileSource) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FileSource"}
	if len(v.SourceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("SourceType"))
	}
	if v.S3Location != nil {
		if err := validateS3ObjectFile(v.S3Location); err != nil {
			invalidParams.AddNested("S3Location", err.(smithy.InvalidParamsError))
		}
	}
	if v.ByteContent != nil {
		if err := validateByteContentFile(v.ByteContent); err != nil {
			invalidParams.AddNested("ByteContent", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFilterAttribute(v *types.FilterAttribute) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FilterAttribute"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFlowInput(v *types.FlowInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FlowInput"}
	if v.NodeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NodeName"))
	}
	if v.Content == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Content"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFlowInputs(v []types.FlowInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FlowInputs"}
	for i := range v {
		if err := validateFlowInput(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFunctionDefinition(v *types.FunctionDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FunctionDefinition"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Parameters != nil {
		if err := validateParameterMap(v.Parameters); err != nil {
			invalidParams.AddNested("Parameters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFunctionResult(v *types.FunctionResult) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FunctionResult"}
	if v.ActionGroup == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionGroup"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFunctions(v []types.FunctionDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Functions"}
	for i := range v {
		if err := validateFunctionDefinition(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFunctionSchema(v types.FunctionSchema) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FunctionSchema"}
	switch uv := v.(type) {
	case *types.FunctionSchemaMemberFunctions:
		if err := validateFunctions(uv.Value); err != nil {
			invalidParams.AddNested("[functions]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGenerationConfiguration(v *types.GenerationConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GenerationConfiguration"}
	if v.GuardrailConfiguration != nil {
		if err := validateGuardrailConfiguration(v.GuardrailConfiguration); err != nil {
			invalidParams.AddNested("GuardrailConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGuardrailConfiguration(v *types.GuardrailConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GuardrailConfiguration"}
	if v.GuardrailId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GuardrailId"))
	}
	if v.GuardrailVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GuardrailVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGuardrailConfigurationWithArn(v *types.GuardrailConfigurationWithArn) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GuardrailConfigurationWithArn"}
	if v.GuardrailIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GuardrailIdentifier"))
	}
	if v.GuardrailVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GuardrailVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateImplicitFilterConfiguration(v *types.ImplicitFilterConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ImplicitFilterConfiguration"}
	if v.MetadataAttributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetadataAttributes"))
	} else if v.MetadataAttributes != nil {
		if err := validateMetadataAttributeSchemaList(v.MetadataAttributes); err != nil {
			invalidParams.AddNested("MetadataAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if v.ModelArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ModelArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInlineSessionState(v *types.InlineSessionState) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InlineSessionState"}
	if v.ReturnControlInvocationResults != nil {
		if err := validateReturnControlInvocationResults(v.ReturnControlInvocationResults); err != nil {
			invalidParams.AddNested("ReturnControlInvocationResults", err.(smithy.InvalidParamsError))
		}
	}
	if v.Files != nil {
		if err := validateInputFiles(v.Files); err != nil {
			invalidParams.AddNested("Files", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInputFile(v *types.InputFile) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InputFile"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Source == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Source"))
	} else if v.Source != nil {
		if err := validateFileSource(v.Source); err != nil {
			invalidParams.AddNested("Source", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.UseCase) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("UseCase"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInputFiles(v []types.InputFile) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InputFiles"}
	for i := range v {
		if err := validateInputFile(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInputPrompt(v types.InputPrompt) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InputPrompt"}
	switch uv := v.(type) {
	case *types.InputPromptMemberTextPrompt:
		if err := validateTextPrompt(&uv.Value); err != nil {
			invalidParams.AddNested("[textPrompt]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInvocationResultMember(v types.InvocationResultMember) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InvocationResultMember"}
	switch uv := v.(type) {
	case *types.InvocationResultMemberMemberApiResult:
		if err := validateApiResult(&uv.Value); err != nil {
			invalidParams.AddNested("[apiResult]", err.(smithy.InvalidParamsError))
		}

	case *types.InvocationResultMemberMemberFunctionResult:
		if err := validateFunctionResult(&uv.Value); err != nil {
			invalidParams.AddNested("[functionResult]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKnowledgeBase(v *types.KnowledgeBase) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KnowledgeBase"}
	if v.KnowledgeBaseId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KnowledgeBaseId"))
	}
	if v.Description == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Description"))
	}
	if v.RetrievalConfiguration != nil {
		if err := validateKnowledgeBaseRetrievalConfiguration(v.RetrievalConfiguration); err != nil {
			invalidParams.AddNested("RetrievalConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKnowledgeBaseConfiguration(v *types.KnowledgeBaseConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KnowledgeBaseConfiguration"}
	if v.KnowledgeBaseId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KnowledgeBaseId"))
	}
	if v.RetrievalConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RetrievalConfiguration"))
	} else if v.RetrievalConfiguration != nil {
		if err := validateKnowledgeBaseRetrievalConfiguration(v.RetrievalConfiguration); err != nil {
			invalidParams.AddNested("RetrievalConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKnowledgeBaseConfigurations(v []types.KnowledgeBaseConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KnowledgeBaseConfigurations"}
	for i := range v {
		if err := validateKnowledgeBaseConfiguration(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKnowledgeBaseQuery(v *types.KnowledgeBaseQuery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KnowledgeBaseQuery"}
	if v.Text == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Text"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKnowledgeBaseRetrievalConfiguration(v *types.KnowledgeBaseRetrievalConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KnowledgeBaseRetrievalConfiguration"}
	if v.VectorSearchConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VectorSearchConfiguration"))
	} else if v.VectorSearchConfiguration != nil {
		if err := validateKnowledgeBaseVectorSearchConfiguration(v.VectorSearchConfiguration); err != nil {
			invalidParams.AddNested("VectorSearchConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKnowledgeBaseRetrieveAndGenerateConfiguration(v *types.KnowledgeBaseRetrieveAndGenerateConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KnowledgeBaseRetrieveAndGenerateConfiguration"}
	if v.KnowledgeBaseId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KnowledgeBaseId"))
	}
	if v.ModelArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ModelArn"))
	}
	if v.RetrievalConfiguration != nil {
		if err := validateKnowledgeBaseRetrievalConfiguration(v.RetrievalConfiguration); err != nil {
			invalidParams.AddNested("RetrievalConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.GenerationConfiguration != nil {
		if err := validateGenerationConfiguration(v.GenerationConfiguration); err != nil {
			invalidParams.AddNested("GenerationConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.OrchestrationConfiguration != nil {
		if err := validateOrchestrationConfiguration(v.OrchestrationConfiguration); err != nil {
			invalidParams.AddNested("OrchestrationConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKnowledgeBases(v []types.KnowledgeBase) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KnowledgeBases"}
	for i := range v {
		if err := validateKnowledgeBase(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKnowledgeBaseVectorSearchConfiguration(v *types.KnowledgeBaseVectorSearchConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KnowledgeBaseVectorSearchConfiguration"}
	if v.Filter != nil {
		if err := validateRetrievalFilter(v.Filter); err != nil {
			invalidParams.AddNested("Filter", err.(smithy.InvalidParamsError))
		}
	}
	if v.RerankingConfiguration != nil {
		if err := validateVectorSearchRerankingConfiguration(v.RerankingConfiguration); err != nil {
			invalidParams.AddNested("RerankingConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.ImplicitFilterConfiguration != nil {
		if err := validateImplicitFilterConfiguration(v.ImplicitFilterConfiguration); err != nil {
			invalidParams.AddNested("ImplicitFilterConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMessage(v *types.Message) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Message"}
	if len(v.Role) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Role"))
	}
	if v.Content == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Content"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMessages(v []types.Message) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Messages"}
	for i := range v {
		if err := validateMessage(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetadataAttributeSchema(v *types.MetadataAttributeSchema) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetadataAttributeSchema"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.Description == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Description"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetadataAttributeSchemaList(v []types.MetadataAttributeSchema) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetadataAttributeSchemaList"}
	for i := range v {
		if err := validateMetadataAttributeSchema(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetadataConfigurationForReranking(v *types.MetadataConfigurationForReranking) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetadataConfigurationForReranking"}
	if len(v.SelectionMode) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("SelectionMode"))
	}
	if v.SelectiveModeConfiguration != nil {
		if err := validateRerankingMetadataSelectiveModeConfiguration(v.SelectiveModeConfiguration); err != nil {
			invalidParams.AddNested("SelectiveModeConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOrchestrationConfiguration(v *types.OrchestrationConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OrchestrationConfiguration"}
	if v.QueryTransformationConfiguration != nil {
		if err := validateQueryTransformationConfiguration(v.QueryTransformationConfiguration); err != nil {
			invalidParams.AddNested("QueryTransformationConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateParameterDetail(v *types.ParameterDetail) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ParameterDetail"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateParameterMap(v map[string]types.ParameterDetail) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ParameterMap"}
	for key := range v {
		value := v[key]
		if err := validateParameterDetail(&value); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%q]", key), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePromptOverrideConfiguration(v *types.PromptOverrideConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PromptOverrideConfiguration"}
	if v.PromptConfigurations == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PromptConfigurations"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateQueryGenerationInput(v *types.QueryGenerationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "QueryGenerationInput"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.Text == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Text"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateQueryTransformationConfiguration(v *types.QueryTransformationConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "QueryTransformationConfiguration"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRerankDocument(v *types.RerankDocument) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RerankDocument"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRerankingConfiguration(v *types.RerankingConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RerankingConfiguration"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.BedrockRerankingConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BedrockRerankingConfiguration"))
	} else if v.BedrockRerankingConfiguration != nil {
		if err := validateBedrockRerankingConfiguration(v.BedrockRerankingConfiguration); err != nil {
			invalidParams.AddNested("BedrockRerankingConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRerankingMetadataSelectiveModeConfiguration(v types.RerankingMetadataSelectiveModeConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RerankingMetadataSelectiveModeConfiguration"}
	switch uv := v.(type) {
	case *types.RerankingMetadataSelectiveModeConfigurationMemberFieldsToExclude:
		if err := validateFieldsForReranking(uv.Value); err != nil {
			invalidParams.AddNested("[fieldsToExclude]", err.(smithy.InvalidParamsError))
		}

	case *types.RerankingMetadataSelectiveModeConfigurationMemberFieldsToInclude:
		if err := validateFieldsForReranking(uv.Value); err != nil {
			invalidParams.AddNested("[fieldsToInclude]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRerankQueriesList(v []types.RerankQuery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RerankQueriesList"}
	for i := range v {
		if err := validateRerankQuery(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRerankQuery(v *types.RerankQuery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RerankQuery"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.TextQuery == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TextQuery"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRerankSource(v *types.RerankSource) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RerankSource"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.InlineDocumentSource == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InlineDocumentSource"))
	} else if v.InlineDocumentSource != nil {
		if err := validateRerankDocument(v.InlineDocumentSource); err != nil {
			invalidParams.AddNested("InlineDocumentSource", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRerankSourcesList(v []types.RerankSource) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RerankSourcesList"}
	for i := range v {
		if err := validateRerankSource(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRetrievalFilter(v types.RetrievalFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RetrievalFilter"}
	switch uv := v.(type) {
	case *types.RetrievalFilterMemberAndAll:
		if err := validateRetrievalFilterList(uv.Value); err != nil {
			invalidParams.AddNested("[andAll]", err.(smithy.InvalidParamsError))
		}

	case *types.RetrievalFilterMemberEquals:
		if err := validateFilterAttribute(&uv.Value); err != nil {
			invalidParams.AddNested("[equals]", err.(smithy.InvalidParamsError))
		}

	case *types.RetrievalFilterMemberGreaterThan:
		if err := validateFilterAttribute(&uv.Value); err != nil {
			invalidParams.AddNested("[greaterThan]", err.(smithy.InvalidParamsError))
		}

	case *types.RetrievalFilterMemberGreaterThanOrEquals:
		if err := validateFilterAttribute(&uv.Value); err != nil {
			invalidParams.AddNested("[greaterThanOrEquals]", err.(smithy.InvalidParamsError))
		}

	case *types.RetrievalFilterMemberIn:
		if err := validateFilterAttribute(&uv.Value); err != nil {
			invalidParams.AddNested("[in]", err.(smithy.InvalidParamsError))
		}

	case *types.RetrievalFilterMemberLessThan:
		if err := validateFilterAttribute(&uv.Value); err != nil {
			invalidParams.AddNested("[lessThan]", err.(smithy.InvalidParamsError))
		}

	case *types.RetrievalFilterMemberLessThanOrEquals:
		if err := validateFilterAttribute(&uv.Value); err != nil {
			invalidParams.AddNested("[lessThanOrEquals]", err.(smithy.InvalidParamsError))
		}

	case *types.RetrievalFilterMemberListContains:
		if err := validateFilterAttribute(&uv.Value); err != nil {
			invalidParams.AddNested("[listContains]", err.(smithy.InvalidParamsError))
		}

	case *types.RetrievalFilterMemberNotEquals:
		if err := validateFilterAttribute(&uv.Value); err != nil {
			invalidParams.AddNested("[notEquals]", err.(smithy.InvalidParamsError))
		}

	case *types.RetrievalFilterMemberNotIn:
		if err := validateFilterAttribute(&uv.Value); err != nil {
			invalidParams.AddNested("[notIn]", err.(smithy.InvalidParamsError))
		}

	case *types.RetrievalFilterMemberOrAll:
		if err := validateRetrievalFilterList(uv.Value); err != nil {
			invalidParams.AddNested("[orAll]", err.(smithy.InvalidParamsError))
		}

	case *types.RetrievalFilterMemberStartsWith:
		if err := validateFilterAttribute(&uv.Value); err != nil {
			invalidParams.AddNested("[startsWith]", err.(smithy.InvalidParamsError))
		}

	case *types.RetrievalFilterMemberStringContains:
		if err := validateFilterAttribute(&uv.Value); err != nil {
			invalidParams.AddNested("[stringContains]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRetrievalFilterList(v []types.RetrievalFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RetrievalFilterList"}
	for i := range v {
		if err := validateRetrievalFilter(v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRetrieveAndGenerateConfiguration(v *types.RetrieveAndGenerateConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RetrieveAndGenerateConfiguration"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.KnowledgeBaseConfiguration != nil {
		if err := validateKnowledgeBaseRetrieveAndGenerateConfiguration(v.KnowledgeBaseConfiguration); err != nil {
			invalidParams.AddNested("KnowledgeBaseConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.ExternalSourcesConfiguration != nil {
		if err := validateExternalSourcesRetrieveAndGenerateConfiguration(v.ExternalSourcesConfiguration); err != nil {
			invalidParams.AddNested("ExternalSourcesConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRetrieveAndGenerateInput(v *types.RetrieveAndGenerateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RetrieveAndGenerateInput"}
	if v.Text == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Text"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRetrieveAndGenerateSessionConfiguration(v *types.RetrieveAndGenerateSessionConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RetrieveAndGenerateSessionConfiguration"}
	if v.KmsKeyArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KmsKeyArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateReturnControlInvocationResults(v []types.InvocationResultMember) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReturnControlInvocationResults"}
	for i := range v {
		if err := validateInvocationResultMember(v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3ObjectDoc(v *types.S3ObjectDoc) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3ObjectDoc"}
	if v.Uri == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Uri"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3ObjectFile(v *types.S3ObjectFile) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3ObjectFile"}
	if v.Uri == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Uri"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSessionState(v *types.SessionState) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SessionState"}
	if v.ReturnControlInvocationResults != nil {
		if err := validateReturnControlInvocationResults(v.ReturnControlInvocationResults); err != nil {
			invalidParams.AddNested("ReturnControlInvocationResults", err.(smithy.InvalidParamsError))
		}
	}
	if v.Files != nil {
		if err := validateInputFiles(v.Files); err != nil {
			invalidParams.AddNested("Files", err.(smithy.InvalidParamsError))
		}
	}
	if v.KnowledgeBaseConfigurations != nil {
		if err := validateKnowledgeBaseConfigurations(v.KnowledgeBaseConfigurations); err != nil {
			invalidParams.AddNested("KnowledgeBaseConfigurations", err.(smithy.InvalidParamsError))
		}
	}
	if v.ConversationHistory != nil {
		if err := validateConversationHistory(v.ConversationHistory); err != nil {
			invalidParams.AddNested("ConversationHistory", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTextPrompt(v *types.TextPrompt) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TextPrompt"}
	if v.Text == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Text"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTextToSqlConfiguration(v *types.TextToSqlConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TextToSqlConfiguration"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.KnowledgeBaseConfiguration != nil {
		if err := validateTextToSqlKnowledgeBaseConfiguration(v.KnowledgeBaseConfiguration); err != nil {
			invalidParams.AddNested("KnowledgeBaseConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTextToSqlKnowledgeBaseConfiguration(v *types.TextToSqlKnowledgeBaseConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TextToSqlKnowledgeBaseConfiguration"}
	if v.KnowledgeBaseArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KnowledgeBaseArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTransformationConfiguration(v *types.TransformationConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TransformationConfiguration"}
	if len(v.Mode) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Mode"))
	}
	if v.TextToSqlConfiguration != nil {
		if err := validateTextToSqlConfiguration(v.TextToSqlConfiguration); err != nil {
			invalidParams.AddNested("TextToSqlConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVectorSearchBedrockRerankingConfiguration(v *types.VectorSearchBedrockRerankingConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VectorSearchBedrockRerankingConfiguration"}
	if v.ModelConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ModelConfiguration"))
	} else if v.ModelConfiguration != nil {
		if err := validateVectorSearchBedrockRerankingModelConfiguration(v.ModelConfiguration); err != nil {
			invalidParams.AddNested("ModelConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.MetadataConfiguration != nil {
		if err := validateMetadataConfigurationForReranking(v.MetadataConfiguration); err != nil {
			invalidParams.AddNested("MetadataConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVectorSearchBedrockRerankingModelConfiguration(v *types.VectorSearchBedrockRerankingModelConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VectorSearchBedrockRerankingModelConfiguration"}
	if v.ModelArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ModelArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVectorSearchRerankingConfiguration(v *types.VectorSearchRerankingConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VectorSearchRerankingConfiguration"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.BedrockRerankingConfiguration != nil {
		if err := validateVectorSearchBedrockRerankingConfiguration(v.BedrockRerankingConfiguration); err != nil {
			invalidParams.AddNested("BedrockRerankingConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteAgentMemoryInput(v *DeleteAgentMemoryInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteAgentMemoryInput"}
	if v.AgentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AgentId"))
	}
	if v.AgentAliasId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AgentAliasId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGenerateQueryInput(v *GenerateQueryInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GenerateQueryInput"}
	if v.QueryGenerationInput == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QueryGenerationInput"))
	} else if v.QueryGenerationInput != nil {
		if err := validateQueryGenerationInput(v.QueryGenerationInput); err != nil {
			invalidParams.AddNested("QueryGenerationInput", err.(smithy.InvalidParamsError))
		}
	}
	if v.TransformationConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TransformationConfiguration"))
	} else if v.TransformationConfiguration != nil {
		if err := validateTransformationConfiguration(v.TransformationConfiguration); err != nil {
			invalidParams.AddNested("TransformationConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetAgentMemoryInput(v *GetAgentMemoryInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetAgentMemoryInput"}
	if v.AgentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AgentId"))
	}
	if v.AgentAliasId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AgentAliasId"))
	}
	if len(v.MemoryType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("MemoryType"))
	}
	if v.MemoryId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MemoryId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpInvokeAgentInput(v *InvokeAgentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InvokeAgentInput"}
	if v.SessionState != nil {
		if err := validateSessionState(v.SessionState); err != nil {
			invalidParams.AddNested("SessionState", err.(smithy.InvalidParamsError))
		}
	}
	if v.AgentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AgentId"))
	}
	if v.AgentAliasId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AgentAliasId"))
	}
	if v.SessionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SessionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpInvokeFlowInput(v *InvokeFlowInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InvokeFlowInput"}
	if v.FlowIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FlowIdentifier"))
	}
	if v.FlowAliasIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FlowAliasIdentifier"))
	}
	if v.Inputs == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Inputs"))
	} else if v.Inputs != nil {
		if err := validateFlowInputs(v.Inputs); err != nil {
			invalidParams.AddNested("Inputs", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpInvokeInlineAgentInput(v *InvokeInlineAgentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InvokeInlineAgentInput"}
	if v.SessionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SessionId"))
	}
	if v.InlineSessionState != nil {
		if err := validateInlineSessionState(v.InlineSessionState); err != nil {
			invalidParams.AddNested("InlineSessionState", err.(smithy.InvalidParamsError))
		}
	}
	if v.FoundationModel == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FoundationModel"))
	}
	if v.Instruction == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Instruction"))
	}
	if v.ActionGroups != nil {
		if err := validateAgentActionGroups(v.ActionGroups); err != nil {
			invalidParams.AddNested("ActionGroups", err.(smithy.InvalidParamsError))
		}
	}
	if v.KnowledgeBases != nil {
		if err := validateKnowledgeBases(v.KnowledgeBases); err != nil {
			invalidParams.AddNested("KnowledgeBases", err.(smithy.InvalidParamsError))
		}
	}
	if v.GuardrailConfiguration != nil {
		if err := validateGuardrailConfigurationWithArn(v.GuardrailConfiguration); err != nil {
			invalidParams.AddNested("GuardrailConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.PromptOverrideConfiguration != nil {
		if err := validatePromptOverrideConfiguration(v.PromptOverrideConfiguration); err != nil {
			invalidParams.AddNested("PromptOverrideConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpOptimizePromptInput(v *OptimizePromptInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OptimizePromptInput"}
	if v.Input == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Input"))
	} else if v.Input != nil {
		if err := validateInputPrompt(v.Input); err != nil {
			invalidParams.AddNested("Input", err.(smithy.InvalidParamsError))
		}
	}
	if v.TargetModelId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetModelId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRerankInput(v *RerankInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RerankInput"}
	if v.Queries == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Queries"))
	} else if v.Queries != nil {
		if err := validateRerankQueriesList(v.Queries); err != nil {
			invalidParams.AddNested("Queries", err.(smithy.InvalidParamsError))
		}
	}
	if v.Sources == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Sources"))
	} else if v.Sources != nil {
		if err := validateRerankSourcesList(v.Sources); err != nil {
			invalidParams.AddNested("Sources", err.(smithy.InvalidParamsError))
		}
	}
	if v.RerankingConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RerankingConfiguration"))
	} else if v.RerankingConfiguration != nil {
		if err := validateRerankingConfiguration(v.RerankingConfiguration); err != nil {
			invalidParams.AddNested("RerankingConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRetrieveAndGenerateInput(v *RetrieveAndGenerateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RetrieveAndGenerateInput"}
	if v.Input == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Input"))
	} else if v.Input != nil {
		if err := validateRetrieveAndGenerateInput(v.Input); err != nil {
			invalidParams.AddNested("Input", err.(smithy.InvalidParamsError))
		}
	}
	if v.RetrieveAndGenerateConfiguration != nil {
		if err := validateRetrieveAndGenerateConfiguration(v.RetrieveAndGenerateConfiguration); err != nil {
			invalidParams.AddNested("RetrieveAndGenerateConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.SessionConfiguration != nil {
		if err := validateRetrieveAndGenerateSessionConfiguration(v.SessionConfiguration); err != nil {
			invalidParams.AddNested("SessionConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRetrieveAndGenerateStreamInput(v *RetrieveAndGenerateStreamInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RetrieveAndGenerateStreamInput"}
	if v.Input == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Input"))
	} else if v.Input != nil {
		if err := validateRetrieveAndGenerateInput(v.Input); err != nil {
			invalidParams.AddNested("Input", err.(smithy.InvalidParamsError))
		}
	}
	if v.RetrieveAndGenerateConfiguration != nil {
		if err := validateRetrieveAndGenerateConfiguration(v.RetrieveAndGenerateConfiguration); err != nil {
			invalidParams.AddNested("RetrieveAndGenerateConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.SessionConfiguration != nil {
		if err := validateRetrieveAndGenerateSessionConfiguration(v.SessionConfiguration); err != nil {
			invalidParams.AddNested("SessionConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRetrieveInput(v *RetrieveInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RetrieveInput"}
	if v.KnowledgeBaseId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KnowledgeBaseId"))
	}
	if v.RetrievalQuery == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RetrievalQuery"))
	} else if v.RetrievalQuery != nil {
		if err := validateKnowledgeBaseQuery(v.RetrievalQuery); err != nil {
			invalidParams.AddNested("RetrievalQuery", err.(smithy.InvalidParamsError))
		}
	}
	if v.RetrievalConfiguration != nil {
		if err := validateKnowledgeBaseRetrievalConfiguration(v.RetrievalConfiguration); err != nil {
			invalidParams.AddNested("RetrievalConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.GuardrailConfiguration != nil {
		if err := validateGuardrailConfiguration(v.GuardrailConfiguration); err != nil {
			invalidParams.AddNested("GuardrailConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
