// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockdataautomationruntime

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/bedrockdataautomationruntime/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"path"
)

type awsAwsjson11_serializeOpGetDataAutomationStatus struct {
}

func (*awsAwsjson11_serializeOpGetDataAutomationStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetDataAutomationStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDataAutomationStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonBedrockKeystoneRuntimeService.GetDataAutomationStatus")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetDataAutomationStatusInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpInvokeDataAutomationAsync struct {
}

func (*awsAwsjson11_serializeOpInvokeDataAutomationAsync) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpInvokeDataAutomationAsync) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*InvokeDataAutomationAsyncInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonBedrockKeystoneRuntimeService.InvokeDataAutomationAsync")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentInvokeDataAutomationAsyncInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsAwsjson11_serializeDocumentBlueprint(v *types.Blueprint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlueprintArn != nil {
		ok := object.Key("blueprintArn")
		ok.String(*v.BlueprintArn)
	}

	if len(v.Stage) > 0 {
		ok := object.Key("stage")
		ok.String(string(v.Stage))
	}

	if v.Version != nil {
		ok := object.Key("version")
		ok.String(*v.Version)
	}

	return nil
}

func awsAwsjson11_serializeDocumentBlueprintList(v []types.Blueprint, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentBlueprint(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentDataAutomationConfiguration(v *types.DataAutomationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataAutomationArn != nil {
		ok := object.Key("dataAutomationArn")
		ok.String(*v.DataAutomationArn)
	}

	if len(v.Stage) > 0 {
		ok := object.Key("stage")
		ok.String(string(v.Stage))
	}

	return nil
}

func awsAwsjson11_serializeDocumentEncryptionConfiguration(v *types.EncryptionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KmsEncryptionContext != nil {
		ok := object.Key("kmsEncryptionContext")
		if err := awsAwsjson11_serializeDocumentEncryptionContextMap(v.KmsEncryptionContext, ok); err != nil {
			return err
		}
	}

	if v.KmsKeyId != nil {
		ok := object.Key("kmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	return nil
}

func awsAwsjson11_serializeDocumentEncryptionContextMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentEventBridgeConfiguration(v *types.EventBridgeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EventBridgeEnabled != nil {
		ok := object.Key("eventBridgeEnabled")
		ok.Boolean(*v.EventBridgeEnabled)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputConfiguration(v *types.InputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Uri != nil {
		ok := object.Key("s3Uri")
		ok.String(*v.S3Uri)
	}

	return nil
}

func awsAwsjson11_serializeDocumentNotificationConfiguration(v *types.NotificationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EventBridgeConfiguration != nil {
		ok := object.Key("eventBridgeConfiguration")
		if err := awsAwsjson11_serializeDocumentEventBridgeConfiguration(v.EventBridgeConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentOutputConfiguration(v *types.OutputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Uri != nil {
		ok := object.Key("s3Uri")
		ok.String(*v.S3Uri)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetDataAutomationStatusInput(v *GetDataAutomationStatusInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InvocationArn != nil {
		ok := object.Key("invocationArn")
		ok.String(*v.InvocationArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentInvokeDataAutomationAsyncInput(v *InvokeDataAutomationAsyncInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Blueprints != nil {
		ok := object.Key("blueprints")
		if err := awsAwsjson11_serializeDocumentBlueprintList(v.Blueprints, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.DataAutomationConfiguration != nil {
		ok := object.Key("dataAutomationConfiguration")
		if err := awsAwsjson11_serializeDocumentDataAutomationConfiguration(v.DataAutomationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.EncryptionConfiguration != nil {
		ok := object.Key("encryptionConfiguration")
		if err := awsAwsjson11_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.InputConfiguration != nil {
		ok := object.Key("inputConfiguration")
		if err := awsAwsjson11_serializeDocumentInputConfiguration(v.InputConfiguration, ok); err != nil {
			return err
		}
	}

	if v.NotificationConfiguration != nil {
		ok := object.Key("notificationConfiguration")
		if err := awsAwsjson11_serializeDocumentNotificationConfiguration(v.NotificationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.OutputConfiguration != nil {
		ok := object.Key("outputConfiguration")
		if err := awsAwsjson11_serializeDocumentOutputConfiguration(v.OutputConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}
