// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockruntime

import (
	"bytes"
	"context"
	"encoding/base64"
	"encoding/json"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/eventstream"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/eventstream/eventstreamapi"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/restjson"
	"github.com/aws/aws-sdk-go-v2/service/bedrockruntime/document"
	internaldocument "github.com/aws/aws-sdk-go-v2/service/bedrockruntime/internal/document"
	"github.com/aws/aws-sdk-go-v2/service/bedrockruntime/types"
	smithy "github.com/aws/smithy-go"
	smithyio "github.com/aws/smithy-go/io"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"io"
	"math"
	"strings"
	"time"
)

func deserializeS3Expires(v string) (*time.Time, error) {
	t, err := smithytime.ParseHTTPDate(v)
	if err != nil {
		return nil, nil
	}
	return &t, nil
}

type awsRestjson1_deserializeOpApplyGuardrail struct {
}

func (*awsRestjson1_deserializeOpApplyGuardrail) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpApplyGuardrail) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorApplyGuardrail(response, &metadata)
	}
	output := &ApplyGuardrailOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentApplyGuardrailOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	span.End()
	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorApplyGuardrail(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	case strings.EqualFold("ServiceQuotaExceededException", errorCode):
		return awsRestjson1_deserializeErrorServiceQuotaExceededException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsRestjson1_deserializeErrorThrottlingException(response, errorBody)

	case strings.EqualFold("ValidationException", errorCode):
		return awsRestjson1_deserializeErrorValidationException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentApplyGuardrailOutput(v **ApplyGuardrailOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ApplyGuardrailOutput
	if *v == nil {
		sv = &ApplyGuardrailOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "action":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GuardrailAction to be of type string, got %T instead", value)
				}
				sv.Action = types.GuardrailAction(jtv)
			}

		case "assessments":
			if err := awsRestjson1_deserializeDocumentGuardrailAssessmentList(&sv.Assessments, value); err != nil {
				return err
			}

		case "guardrailCoverage":
			if err := awsRestjson1_deserializeDocumentGuardrailCoverage(&sv.GuardrailCoverage, value); err != nil {
				return err
			}

		case "outputs":
			if err := awsRestjson1_deserializeDocumentGuardrailOutputContentList(&sv.Outputs, value); err != nil {
				return err
			}

		case "usage":
			if err := awsRestjson1_deserializeDocumentGuardrailUsage(&sv.Usage, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpConverse struct {
}

func (*awsRestjson1_deserializeOpConverse) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpConverse) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorConverse(response, &metadata)
	}
	output := &ConverseOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentConverseOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	span.End()
	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorConverse(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("ModelErrorException", errorCode):
		return awsRestjson1_deserializeErrorModelErrorException(response, errorBody)

	case strings.EqualFold("ModelNotReadyException", errorCode):
		return awsRestjson1_deserializeErrorModelNotReadyException(response, errorBody)

	case strings.EqualFold("ModelTimeoutException", errorCode):
		return awsRestjson1_deserializeErrorModelTimeoutException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	case strings.EqualFold("ServiceUnavailableException", errorCode):
		return awsRestjson1_deserializeErrorServiceUnavailableException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsRestjson1_deserializeErrorThrottlingException(response, errorBody)

	case strings.EqualFold("ValidationException", errorCode):
		return awsRestjson1_deserializeErrorValidationException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentConverseOutput(v **ConverseOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ConverseOutput
	if *v == nil {
		sv = &ConverseOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "additionalModelResponseFields":
			if err := awsRestjson1_deserializeDocumentDocument(&sv.AdditionalModelResponseFields, value); err != nil {
				return err
			}

		case "metrics":
			if err := awsRestjson1_deserializeDocumentConverseMetrics(&sv.Metrics, value); err != nil {
				return err
			}

		case "output":
			if err := awsRestjson1_deserializeDocumentConverseOutput(&sv.Output, value); err != nil {
				return err
			}

		case "performanceConfig":
			if err := awsRestjson1_deserializeDocumentPerformanceConfiguration(&sv.PerformanceConfig, value); err != nil {
				return err
			}

		case "stopReason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected StopReason to be of type string, got %T instead", value)
				}
				sv.StopReason = types.StopReason(jtv)
			}

		case "trace":
			if err := awsRestjson1_deserializeDocumentConverseTrace(&sv.Trace, value); err != nil {
				return err
			}

		case "usage":
			if err := awsRestjson1_deserializeDocumentTokenUsage(&sv.Usage, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpConverseStream struct {
}

func (*awsRestjson1_deserializeOpConverseStream) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpConverseStream) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorConverseStream(response, &metadata)
	}
	output := &ConverseStreamOutput{}
	out.Result = output

	span.End()
	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorConverseStream(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("ModelErrorException", errorCode):
		return awsRestjson1_deserializeErrorModelErrorException(response, errorBody)

	case strings.EqualFold("ModelNotReadyException", errorCode):
		return awsRestjson1_deserializeErrorModelNotReadyException(response, errorBody)

	case strings.EqualFold("ModelTimeoutException", errorCode):
		return awsRestjson1_deserializeErrorModelTimeoutException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	case strings.EqualFold("ServiceUnavailableException", errorCode):
		return awsRestjson1_deserializeErrorServiceUnavailableException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsRestjson1_deserializeErrorThrottlingException(response, errorBody)

	case strings.EqualFold("ValidationException", errorCode):
		return awsRestjson1_deserializeErrorValidationException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpGetAsyncInvoke struct {
}

func (*awsRestjson1_deserializeOpGetAsyncInvoke) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetAsyncInvoke) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetAsyncInvoke(response, &metadata)
	}
	output := &GetAsyncInvokeOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetAsyncInvokeOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	span.End()
	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetAsyncInvoke(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsRestjson1_deserializeErrorThrottlingException(response, errorBody)

	case strings.EqualFold("ValidationException", errorCode):
		return awsRestjson1_deserializeErrorValidationException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetAsyncInvokeOutput(v **GetAsyncInvokeOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetAsyncInvokeOutput
	if *v == nil {
		sv = &GetAsyncInvokeOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "clientRequestToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AsyncInvokeIdempotencyToken to be of type string, got %T instead", value)
				}
				sv.ClientRequestToken = ptr.String(jtv)
			}

		case "endTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.EndTime = ptr.Time(t)
			}

		case "failureMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AsyncInvokeMessage to be of type string, got %T instead", value)
				}
				sv.FailureMessage = ptr.String(jtv)
			}

		case "invocationArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected InvocationArn to be of type string, got %T instead", value)
				}
				sv.InvocationArn = ptr.String(jtv)
			}

		case "lastModifiedTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.LastModifiedTime = ptr.Time(t)
			}

		case "modelArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AsyncInvokeArn to be of type string, got %T instead", value)
				}
				sv.ModelArn = ptr.String(jtv)
			}

		case "outputDataConfig":
			if err := awsRestjson1_deserializeDocumentAsyncInvokeOutputDataConfig(&sv.OutputDataConfig, value); err != nil {
				return err
			}

		case "status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AsyncInvokeStatus to be of type string, got %T instead", value)
				}
				sv.Status = types.AsyncInvokeStatus(jtv)
			}

		case "submitTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.SubmitTime = ptr.Time(t)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpInvokeModel struct {
}

func (*awsRestjson1_deserializeOpInvokeModel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpInvokeModel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorInvokeModel(response, &metadata)
	}
	output := &InvokeModelOutput{}
	out.Result = output

	err = awsRestjson1_deserializeOpHttpBindingsInvokeModelOutput(output, response)
	if err != nil {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("failed to decode response with invalid Http bindings, %w", err)}
	}

	err = awsRestjson1_deserializeOpDocumentInvokeModelOutput(output, response.Body, response.ContentLength)
	if err != nil {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("failed to deserialize response payload, %w", err)}
	}

	span.End()
	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorInvokeModel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("ModelErrorException", errorCode):
		return awsRestjson1_deserializeErrorModelErrorException(response, errorBody)

	case strings.EqualFold("ModelNotReadyException", errorCode):
		return awsRestjson1_deserializeErrorModelNotReadyException(response, errorBody)

	case strings.EqualFold("ModelTimeoutException", errorCode):
		return awsRestjson1_deserializeErrorModelTimeoutException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	case strings.EqualFold("ServiceQuotaExceededException", errorCode):
		return awsRestjson1_deserializeErrorServiceQuotaExceededException(response, errorBody)

	case strings.EqualFold("ServiceUnavailableException", errorCode):
		return awsRestjson1_deserializeErrorServiceUnavailableException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsRestjson1_deserializeErrorThrottlingException(response, errorBody)

	case strings.EqualFold("ValidationException", errorCode):
		return awsRestjson1_deserializeErrorValidationException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpHttpBindingsInvokeModelOutput(v *InvokeModelOutput, response *smithyhttp.Response) error {
	if v == nil {
		return fmt.Errorf("unsupported deserialization for nil %T", v)
	}

	if headerValues := response.Header.Values("Content-Type"); len(headerValues) != 0 {
		headerValues[0] = strings.TrimSpace(headerValues[0])
		v.ContentType = ptr.String(headerValues[0])
	}

	if headerValues := response.Header.Values("X-Amzn-Bedrock-PerformanceConfig-Latency"); len(headerValues) != 0 {
		headerValues[0] = strings.TrimSpace(headerValues[0])
		v.PerformanceConfigLatency = types.PerformanceConfigLatency(headerValues[0])
	}

	return nil
}
func awsRestjson1_deserializeOpDocumentInvokeModelOutput(v *InvokeModelOutput, body io.ReadCloser, contentLength int64) error {
	if v == nil {
		return fmt.Errorf("unsupported deserialization of nil %T", v)
	}

	var buf bytes.Buffer
	if contentLength > 0 {
		buf.Grow(int(contentLength))
	} else {
		buf.Grow(512)
	}

	_, err := buf.ReadFrom(body)
	if err != nil {
		return err
	}
	if buf.Len() > 0 {
		v.Body = buf.Bytes()
	}
	return nil
}

type awsRestjson1_deserializeOpInvokeModelWithResponseStream struct {
}

func (*awsRestjson1_deserializeOpInvokeModelWithResponseStream) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpInvokeModelWithResponseStream) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorInvokeModelWithResponseStream(response, &metadata)
	}
	output := &InvokeModelWithResponseStreamOutput{}
	out.Result = output

	err = awsRestjson1_deserializeOpHttpBindingsInvokeModelWithResponseStreamOutput(output, response)
	if err != nil {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("failed to decode response with invalid Http bindings, %w", err)}
	}

	span.End()
	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorInvokeModelWithResponseStream(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("ModelErrorException", errorCode):
		return awsRestjson1_deserializeErrorModelErrorException(response, errorBody)

	case strings.EqualFold("ModelNotReadyException", errorCode):
		return awsRestjson1_deserializeErrorModelNotReadyException(response, errorBody)

	case strings.EqualFold("ModelStreamErrorException", errorCode):
		return awsRestjson1_deserializeErrorModelStreamErrorException(response, errorBody)

	case strings.EqualFold("ModelTimeoutException", errorCode):
		return awsRestjson1_deserializeErrorModelTimeoutException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	case strings.EqualFold("ServiceQuotaExceededException", errorCode):
		return awsRestjson1_deserializeErrorServiceQuotaExceededException(response, errorBody)

	case strings.EqualFold("ServiceUnavailableException", errorCode):
		return awsRestjson1_deserializeErrorServiceUnavailableException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsRestjson1_deserializeErrorThrottlingException(response, errorBody)

	case strings.EqualFold("ValidationException", errorCode):
		return awsRestjson1_deserializeErrorValidationException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpHttpBindingsInvokeModelWithResponseStreamOutput(v *InvokeModelWithResponseStreamOutput, response *smithyhttp.Response) error {
	if v == nil {
		return fmt.Errorf("unsupported deserialization for nil %T", v)
	}

	if headerValues := response.Header.Values("X-Amzn-Bedrock-Content-Type"); len(headerValues) != 0 {
		headerValues[0] = strings.TrimSpace(headerValues[0])
		v.ContentType = ptr.String(headerValues[0])
	}

	if headerValues := response.Header.Values("X-Amzn-Bedrock-PerformanceConfig-Latency"); len(headerValues) != 0 {
		headerValues[0] = strings.TrimSpace(headerValues[0])
		v.PerformanceConfigLatency = types.PerformanceConfigLatency(headerValues[0])
	}

	return nil
}

type awsRestjson1_deserializeOpListAsyncInvokes struct {
}

func (*awsRestjson1_deserializeOpListAsyncInvokes) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListAsyncInvokes) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListAsyncInvokes(response, &metadata)
	}
	output := &ListAsyncInvokesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentListAsyncInvokesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	span.End()
	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListAsyncInvokes(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsRestjson1_deserializeErrorThrottlingException(response, errorBody)

	case strings.EqualFold("ValidationException", errorCode):
		return awsRestjson1_deserializeErrorValidationException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListAsyncInvokesOutput(v **ListAsyncInvokesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListAsyncInvokesOutput
	if *v == nil {
		sv = &ListAsyncInvokesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "asyncInvokeSummaries":
			if err := awsRestjson1_deserializeDocumentAsyncInvokeSummaries(&sv.AsyncInvokeSummaries, value); err != nil {
				return err
			}

		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected PaginationToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpStartAsyncInvoke struct {
}

func (*awsRestjson1_deserializeOpStartAsyncInvoke) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpStartAsyncInvoke) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorStartAsyncInvoke(response, &metadata)
	}
	output := &StartAsyncInvokeOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentStartAsyncInvokeOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	span.End()
	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorStartAsyncInvoke(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("ConflictException", errorCode):
		return awsRestjson1_deserializeErrorConflictException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	case strings.EqualFold("ServiceQuotaExceededException", errorCode):
		return awsRestjson1_deserializeErrorServiceQuotaExceededException(response, errorBody)

	case strings.EqualFold("ServiceUnavailableException", errorCode):
		return awsRestjson1_deserializeErrorServiceUnavailableException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsRestjson1_deserializeErrorThrottlingException(response, errorBody)

	case strings.EqualFold("ValidationException", errorCode):
		return awsRestjson1_deserializeErrorValidationException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentStartAsyncInvokeOutput(v **StartAsyncInvokeOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *StartAsyncInvokeOutput
	if *v == nil {
		sv = &StartAsyncInvokeOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "invocationArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected InvocationArn to be of type string, got %T instead", value)
				}
				sv.InvocationArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeEventStreamResponseStream(v *types.ResponseStream, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	eventType := msg.Headers.Get(eventstreamapi.EventTypeHeader)
	if eventType == nil {
		return fmt.Errorf("%s event header not present", eventstreamapi.EventTypeHeader)
	}

	switch {
	case strings.EqualFold("chunk", eventType.String()):
		vv := &types.ResponseStreamMemberChunk{}
		if err := awsRestjson1_deserializeEventMessagePayloadPart(&vv.Value, msg); err != nil {
			return err
		}
		*v = vv
		return nil

	default:
		buffer := bytes.NewBuffer(nil)
		eventstream.NewEncoder().Encode(buffer, *msg)
		*v = &types.UnknownUnionMember{
			Tag:   eventType.String(),
			Value: buffer.Bytes(),
		}
		return nil

	}
}

func awsRestjson1_deserializeEventStreamExceptionResponseStream(msg *eventstream.Message) error {
	exceptionType := msg.Headers.Get(eventstreamapi.ExceptionTypeHeader)
	if exceptionType == nil {
		return fmt.Errorf("%s event header not present", eventstreamapi.ExceptionTypeHeader)
	}

	switch {
	case strings.EqualFold("internalServerException", exceptionType.String()):
		return awsRestjson1_deserializeEventMessageExceptionInternalServerException(msg)

	case strings.EqualFold("modelStreamErrorException", exceptionType.String()):
		return awsRestjson1_deserializeEventMessageExceptionModelStreamErrorException(msg)

	case strings.EqualFold("modelTimeoutException", exceptionType.String()):
		return awsRestjson1_deserializeEventMessageExceptionModelTimeoutException(msg)

	case strings.EqualFold("serviceUnavailableException", exceptionType.String()):
		return awsRestjson1_deserializeEventMessageExceptionServiceUnavailableException(msg)

	case strings.EqualFold("throttlingException", exceptionType.String()):
		return awsRestjson1_deserializeEventMessageExceptionThrottlingException(msg)

	case strings.EqualFold("validationException", exceptionType.String()):
		return awsRestjson1_deserializeEventMessageExceptionValidationException(msg)

	default:
		br := bytes.NewReader(msg.Payload)
		var buff [1024]byte
		ringBuffer := smithyio.NewRingBuffer(buff[:])

		body := io.TeeReader(br, ringBuffer)
		decoder := json.NewDecoder(body)
		decoder.UseNumber()
		code, message, err := restjson.GetErrorInfo(decoder)
		if err != nil {
			return err
		}
		errorCode := "UnknownError"
		errorMessage := errorCode
		if ev := exceptionType.String(); len(ev) > 0 {
			errorCode = ev
		} else if ev := code; len(ev) > 0 {
			errorCode = ev
		}
		if ev := message; len(ev) > 0 {
			errorMessage = ev
		}
		return &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}

	}
}

func awsRestjson1_deserializeEventMessagePayloadPart(v *types.PayloadPart, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	br := bytes.NewReader(msg.Payload)
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(br, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	if err := awsRestjson1_deserializeDocumentPayloadPart(&v, shape); err != nil {
		if err != nil {
			var snapshot bytes.Buffer
			io.Copy(&snapshot, ringBuffer)
			err = &smithy.DeserializationError{
				Err:      fmt.Errorf("failed to decode response body, %w", err),
				Snapshot: snapshot.Bytes(),
			}
			return err
		}

	}
	return nil
}

func awsRestjson1_deserializeEventMessageExceptionInternalServerException(msg *eventstream.Message) error {
	br := bytes.NewReader(msg.Payload)
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(br, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	v := &types.InternalServerException{}
	if err := awsRestjson1_deserializeDocumentInternalServerException(&v, shape); err != nil {
		if err != nil {
			var snapshot bytes.Buffer
			io.Copy(&snapshot, ringBuffer)
			err = &smithy.DeserializationError{
				Err:      fmt.Errorf("failed to decode response body, %w", err),
				Snapshot: snapshot.Bytes(),
			}
			return err
		}

	}
	return v
}

func awsRestjson1_deserializeEventMessageExceptionModelStreamErrorException(msg *eventstream.Message) error {
	br := bytes.NewReader(msg.Payload)
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(br, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	v := &types.ModelStreamErrorException{}
	if err := awsRestjson1_deserializeDocumentModelStreamErrorException(&v, shape); err != nil {
		if err != nil {
			var snapshot bytes.Buffer
			io.Copy(&snapshot, ringBuffer)
			err = &smithy.DeserializationError{
				Err:      fmt.Errorf("failed to decode response body, %w", err),
				Snapshot: snapshot.Bytes(),
			}
			return err
		}

	}
	return v
}

func awsRestjson1_deserializeEventMessageExceptionValidationException(msg *eventstream.Message) error {
	br := bytes.NewReader(msg.Payload)
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(br, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	v := &types.ValidationException{}
	if err := awsRestjson1_deserializeDocumentValidationException(&v, shape); err != nil {
		if err != nil {
			var snapshot bytes.Buffer
			io.Copy(&snapshot, ringBuffer)
			err = &smithy.DeserializationError{
				Err:      fmt.Errorf("failed to decode response body, %w", err),
				Snapshot: snapshot.Bytes(),
			}
			return err
		}

	}
	return v
}

func awsRestjson1_deserializeEventMessageExceptionThrottlingException(msg *eventstream.Message) error {
	br := bytes.NewReader(msg.Payload)
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(br, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	v := &types.ThrottlingException{}
	if err := awsRestjson1_deserializeDocumentThrottlingException(&v, shape); err != nil {
		if err != nil {
			var snapshot bytes.Buffer
			io.Copy(&snapshot, ringBuffer)
			err = &smithy.DeserializationError{
				Err:      fmt.Errorf("failed to decode response body, %w", err),
				Snapshot: snapshot.Bytes(),
			}
			return err
		}

	}
	return v
}

func awsRestjson1_deserializeEventMessageExceptionModelTimeoutException(msg *eventstream.Message) error {
	br := bytes.NewReader(msg.Payload)
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(br, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	v := &types.ModelTimeoutException{}
	if err := awsRestjson1_deserializeDocumentModelTimeoutException(&v, shape); err != nil {
		if err != nil {
			var snapshot bytes.Buffer
			io.Copy(&snapshot, ringBuffer)
			err = &smithy.DeserializationError{
				Err:      fmt.Errorf("failed to decode response body, %w", err),
				Snapshot: snapshot.Bytes(),
			}
			return err
		}

	}
	return v
}

func awsRestjson1_deserializeEventMessageExceptionServiceUnavailableException(msg *eventstream.Message) error {
	br := bytes.NewReader(msg.Payload)
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(br, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	v := &types.ServiceUnavailableException{}
	if err := awsRestjson1_deserializeDocumentServiceUnavailableException(&v, shape); err != nil {
		if err != nil {
			var snapshot bytes.Buffer
			io.Copy(&snapshot, ringBuffer)
			err = &smithy.DeserializationError{
				Err:      fmt.Errorf("failed to decode response body, %w", err),
				Snapshot: snapshot.Bytes(),
			}
			return err
		}

	}
	return v
}

func awsRestjson1_deserializeDocumentInternalServerException(v **types.InternalServerException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InternalServerException
	if *v == nil {
		sv = &types.InternalServerException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonBlankString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentModelStreamErrorException(v **types.ModelStreamErrorException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ModelStreamErrorException
	if *v == nil {
		sv = &types.ModelStreamErrorException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonBlankString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "originalMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonBlankString to be of type string, got %T instead", value)
				}
				sv.OriginalMessage = ptr.String(jtv)
			}

		case "originalStatusCode":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected StatusCode to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.OriginalStatusCode = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentModelTimeoutException(v **types.ModelTimeoutException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ModelTimeoutException
	if *v == nil {
		sv = &types.ModelTimeoutException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonBlankString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentPayloadPart(v **types.PayloadPart, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PayloadPart
	if *v == nil {
		sv = &types.PayloadPart{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "bytes":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected PartBody to be []byte, got %T instead", value)
				}
				dv, err := base64.StdEncoding.DecodeString(jtv)
				if err != nil {
					return fmt.Errorf("failed to base64 decode PartBody, %w", err)
				}
				sv.Bytes = dv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentServiceUnavailableException(v **types.ServiceUnavailableException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ServiceUnavailableException
	if *v == nil {
		sv = &types.ServiceUnavailableException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonBlankString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentThrottlingException(v **types.ThrottlingException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ThrottlingException
	if *v == nil {
		sv = &types.ThrottlingException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonBlankString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentValidationException(v **types.ValidationException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ValidationException
	if *v == nil {
		sv = &types.ValidationException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonBlankString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeEventStreamConverseStreamOutput(v *types.ConverseStreamOutput, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	eventType := msg.Headers.Get(eventstreamapi.EventTypeHeader)
	if eventType == nil {
		return fmt.Errorf("%s event header not present", eventstreamapi.EventTypeHeader)
	}

	switch {
	case strings.EqualFold("contentBlockDelta", eventType.String()):
		vv := &types.ConverseStreamOutputMemberContentBlockDelta{}
		if err := awsRestjson1_deserializeEventMessageContentBlockDeltaEvent(&vv.Value, msg); err != nil {
			return err
		}
		*v = vv
		return nil

	case strings.EqualFold("contentBlockStart", eventType.String()):
		vv := &types.ConverseStreamOutputMemberContentBlockStart{}
		if err := awsRestjson1_deserializeEventMessageContentBlockStartEvent(&vv.Value, msg); err != nil {
			return err
		}
		*v = vv
		return nil

	case strings.EqualFold("contentBlockStop", eventType.String()):
		vv := &types.ConverseStreamOutputMemberContentBlockStop{}
		if err := awsRestjson1_deserializeEventMessageContentBlockStopEvent(&vv.Value, msg); err != nil {
			return err
		}
		*v = vv
		return nil

	case strings.EqualFold("messageStart", eventType.String()):
		vv := &types.ConverseStreamOutputMemberMessageStart{}
		if err := awsRestjson1_deserializeEventMessageMessageStartEvent(&vv.Value, msg); err != nil {
			return err
		}
		*v = vv
		return nil

	case strings.EqualFold("messageStop", eventType.String()):
		vv := &types.ConverseStreamOutputMemberMessageStop{}
		if err := awsRestjson1_deserializeEventMessageMessageStopEvent(&vv.Value, msg); err != nil {
			return err
		}
		*v = vv
		return nil

	case strings.EqualFold("metadata", eventType.String()):
		vv := &types.ConverseStreamOutputMemberMetadata{}
		if err := awsRestjson1_deserializeEventMessageConverseStreamMetadataEvent(&vv.Value, msg); err != nil {
			return err
		}
		*v = vv
		return nil

	default:
		buffer := bytes.NewBuffer(nil)
		eventstream.NewEncoder().Encode(buffer, *msg)
		*v = &types.UnknownUnionMember{
			Tag:   eventType.String(),
			Value: buffer.Bytes(),
		}
		return nil

	}
}

func awsRestjson1_deserializeEventStreamExceptionConverseStreamOutput(msg *eventstream.Message) error {
	exceptionType := msg.Headers.Get(eventstreamapi.ExceptionTypeHeader)
	if exceptionType == nil {
		return fmt.Errorf("%s event header not present", eventstreamapi.ExceptionTypeHeader)
	}

	switch {
	case strings.EqualFold("internalServerException", exceptionType.String()):
		return awsRestjson1_deserializeEventMessageExceptionInternalServerException(msg)

	case strings.EqualFold("modelStreamErrorException", exceptionType.String()):
		return awsRestjson1_deserializeEventMessageExceptionModelStreamErrorException(msg)

	case strings.EqualFold("serviceUnavailableException", exceptionType.String()):
		return awsRestjson1_deserializeEventMessageExceptionServiceUnavailableException(msg)

	case strings.EqualFold("throttlingException", exceptionType.String()):
		return awsRestjson1_deserializeEventMessageExceptionThrottlingException(msg)

	case strings.EqualFold("validationException", exceptionType.String()):
		return awsRestjson1_deserializeEventMessageExceptionValidationException(msg)

	default:
		br := bytes.NewReader(msg.Payload)
		var buff [1024]byte
		ringBuffer := smithyio.NewRingBuffer(buff[:])

		body := io.TeeReader(br, ringBuffer)
		decoder := json.NewDecoder(body)
		decoder.UseNumber()
		code, message, err := restjson.GetErrorInfo(decoder)
		if err != nil {
			return err
		}
		errorCode := "UnknownError"
		errorMessage := errorCode
		if ev := exceptionType.String(); len(ev) > 0 {
			errorCode = ev
		} else if ev := code; len(ev) > 0 {
			errorCode = ev
		}
		if ev := message; len(ev) > 0 {
			errorMessage = ev
		}
		return &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}

	}
}

func awsRestjson1_deserializeEventMessageMessageStartEvent(v *types.MessageStartEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	br := bytes.NewReader(msg.Payload)
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(br, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	if err := awsRestjson1_deserializeDocumentMessageStartEvent(&v, shape); err != nil {
		if err != nil {
			var snapshot bytes.Buffer
			io.Copy(&snapshot, ringBuffer)
			err = &smithy.DeserializationError{
				Err:      fmt.Errorf("failed to decode response body, %w", err),
				Snapshot: snapshot.Bytes(),
			}
			return err
		}

	}
	return nil
}

func awsRestjson1_deserializeEventMessageContentBlockStartEvent(v *types.ContentBlockStartEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	br := bytes.NewReader(msg.Payload)
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(br, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	if err := awsRestjson1_deserializeDocumentContentBlockStartEvent(&v, shape); err != nil {
		if err != nil {
			var snapshot bytes.Buffer
			io.Copy(&snapshot, ringBuffer)
			err = &smithy.DeserializationError{
				Err:      fmt.Errorf("failed to decode response body, %w", err),
				Snapshot: snapshot.Bytes(),
			}
			return err
		}

	}
	return nil
}

func awsRestjson1_deserializeEventMessageContentBlockDeltaEvent(v *types.ContentBlockDeltaEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	br := bytes.NewReader(msg.Payload)
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(br, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	if err := awsRestjson1_deserializeDocumentContentBlockDeltaEvent(&v, shape); err != nil {
		if err != nil {
			var snapshot bytes.Buffer
			io.Copy(&snapshot, ringBuffer)
			err = &smithy.DeserializationError{
				Err:      fmt.Errorf("failed to decode response body, %w", err),
				Snapshot: snapshot.Bytes(),
			}
			return err
		}

	}
	return nil
}

func awsRestjson1_deserializeEventMessageContentBlockStopEvent(v *types.ContentBlockStopEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	br := bytes.NewReader(msg.Payload)
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(br, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	if err := awsRestjson1_deserializeDocumentContentBlockStopEvent(&v, shape); err != nil {
		if err != nil {
			var snapshot bytes.Buffer
			io.Copy(&snapshot, ringBuffer)
			err = &smithy.DeserializationError{
				Err:      fmt.Errorf("failed to decode response body, %w", err),
				Snapshot: snapshot.Bytes(),
			}
			return err
		}

	}
	return nil
}

func awsRestjson1_deserializeEventMessageMessageStopEvent(v *types.MessageStopEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	br := bytes.NewReader(msg.Payload)
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(br, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	if err := awsRestjson1_deserializeDocumentMessageStopEvent(&v, shape); err != nil {
		if err != nil {
			var snapshot bytes.Buffer
			io.Copy(&snapshot, ringBuffer)
			err = &smithy.DeserializationError{
				Err:      fmt.Errorf("failed to decode response body, %w", err),
				Snapshot: snapshot.Bytes(),
			}
			return err
		}

	}
	return nil
}

func awsRestjson1_deserializeEventMessageConverseStreamMetadataEvent(v *types.ConverseStreamMetadataEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	br := bytes.NewReader(msg.Payload)
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(br, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	if err := awsRestjson1_deserializeDocumentConverseStreamMetadataEvent(&v, shape); err != nil {
		if err != nil {
			var snapshot bytes.Buffer
			io.Copy(&snapshot, ringBuffer)
			err = &smithy.DeserializationError{
				Err:      fmt.Errorf("failed to decode response body, %w", err),
				Snapshot: snapshot.Bytes(),
			}
			return err
		}

	}
	return nil
}

func awsRestjson1_deserializeDocumentContentBlockDelta(v *types.ContentBlockDelta, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var uv types.ContentBlockDelta
loop:
	for key, value := range shape {
		if value == nil {
			continue
		}
		switch key {
		case "reasoningContent":
			var mv types.ReasoningContentBlockDelta
			if err := awsRestjson1_deserializeDocumentReasoningContentBlockDelta(&mv, value); err != nil {
				return err
			}
			uv = &types.ContentBlockDeltaMemberReasoningContent{Value: mv}
			break loop

		case "text":
			var mv string
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				mv = jtv
			}
			uv = &types.ContentBlockDeltaMemberText{Value: mv}
			break loop

		case "toolUse":
			var mv types.ToolUseBlockDelta
			destAddr := &mv
			if err := awsRestjson1_deserializeDocumentToolUseBlockDelta(&destAddr, value); err != nil {
				return err
			}
			mv = *destAddr
			uv = &types.ContentBlockDeltaMemberToolUse{Value: mv}
			break loop

		default:
			uv = &types.UnknownUnionMember{Tag: key}
			break loop

		}
	}
	*v = uv
	return nil
}

func awsRestjson1_deserializeDocumentContentBlockDeltaEvent(v **types.ContentBlockDeltaEvent, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ContentBlockDeltaEvent
	if *v == nil {
		sv = &types.ContentBlockDeltaEvent{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "contentBlockIndex":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected NonNegativeInteger to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ContentBlockIndex = ptr.Int32(int32(i64))
			}

		case "delta":
			if err := awsRestjson1_deserializeDocumentContentBlockDelta(&sv.Delta, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentContentBlockStart(v *types.ContentBlockStart, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var uv types.ContentBlockStart
loop:
	for key, value := range shape {
		if value == nil {
			continue
		}
		switch key {
		case "toolUse":
			var mv types.ToolUseBlockStart
			destAddr := &mv
			if err := awsRestjson1_deserializeDocumentToolUseBlockStart(&destAddr, value); err != nil {
				return err
			}
			mv = *destAddr
			uv = &types.ContentBlockStartMemberToolUse{Value: mv}
			break loop

		default:
			uv = &types.UnknownUnionMember{Tag: key}
			break loop

		}
	}
	*v = uv
	return nil
}

func awsRestjson1_deserializeDocumentContentBlockStartEvent(v **types.ContentBlockStartEvent, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ContentBlockStartEvent
	if *v == nil {
		sv = &types.ContentBlockStartEvent{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "contentBlockIndex":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected NonNegativeInteger to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ContentBlockIndex = ptr.Int32(int32(i64))
			}

		case "start":
			if err := awsRestjson1_deserializeDocumentContentBlockStart(&sv.Start, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentContentBlockStopEvent(v **types.ContentBlockStopEvent, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ContentBlockStopEvent
	if *v == nil {
		sv = &types.ContentBlockStopEvent{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "contentBlockIndex":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected NonNegativeInteger to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ContentBlockIndex = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentConverseStreamMetadataEvent(v **types.ConverseStreamMetadataEvent, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ConverseStreamMetadataEvent
	if *v == nil {
		sv = &types.ConverseStreamMetadataEvent{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "metrics":
			if err := awsRestjson1_deserializeDocumentConverseStreamMetrics(&sv.Metrics, value); err != nil {
				return err
			}

		case "performanceConfig":
			if err := awsRestjson1_deserializeDocumentPerformanceConfiguration(&sv.PerformanceConfig, value); err != nil {
				return err
			}

		case "trace":
			if err := awsRestjson1_deserializeDocumentConverseStreamTrace(&sv.Trace, value); err != nil {
				return err
			}

		case "usage":
			if err := awsRestjson1_deserializeDocumentTokenUsage(&sv.Usage, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentConverseStreamMetrics(v **types.ConverseStreamMetrics, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ConverseStreamMetrics
	if *v == nil {
		sv = &types.ConverseStreamMetrics{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "latencyMs":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.LatencyMs = ptr.Int64(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentConverseStreamTrace(v **types.ConverseStreamTrace, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ConverseStreamTrace
	if *v == nil {
		sv = &types.ConverseStreamTrace{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "guardrail":
			if err := awsRestjson1_deserializeDocumentGuardrailTraceAssessment(&sv.Guardrail, value); err != nil {
				return err
			}

		case "promptRouter":
			if err := awsRestjson1_deserializeDocumentPromptRouterTrace(&sv.PromptRouter, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailAssessment(v **types.GuardrailAssessment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailAssessment
	if *v == nil {
		sv = &types.GuardrailAssessment{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "contentPolicy":
			if err := awsRestjson1_deserializeDocumentGuardrailContentPolicyAssessment(&sv.ContentPolicy, value); err != nil {
				return err
			}

		case "contextualGroundingPolicy":
			if err := awsRestjson1_deserializeDocumentGuardrailContextualGroundingPolicyAssessment(&sv.ContextualGroundingPolicy, value); err != nil {
				return err
			}

		case "invocationMetrics":
			if err := awsRestjson1_deserializeDocumentGuardrailInvocationMetrics(&sv.InvocationMetrics, value); err != nil {
				return err
			}

		case "sensitiveInformationPolicy":
			if err := awsRestjson1_deserializeDocumentGuardrailSensitiveInformationPolicyAssessment(&sv.SensitiveInformationPolicy, value); err != nil {
				return err
			}

		case "topicPolicy":
			if err := awsRestjson1_deserializeDocumentGuardrailTopicPolicyAssessment(&sv.TopicPolicy, value); err != nil {
				return err
			}

		case "wordPolicy":
			if err := awsRestjson1_deserializeDocumentGuardrailWordPolicyAssessment(&sv.WordPolicy, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailAssessmentList(v *[]types.GuardrailAssessment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.GuardrailAssessment
	if *v == nil {
		cv = []types.GuardrailAssessment{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.GuardrailAssessment
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentGuardrailAssessment(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailAssessmentListMap(v *map[string][]types.GuardrailAssessment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string][]types.GuardrailAssessment
	if *v == nil {
		mv = map[string][]types.GuardrailAssessment{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal []types.GuardrailAssessment
		mapVar := parsedVal
		if err := awsRestjson1_deserializeDocumentGuardrailAssessmentList(&mapVar, value); err != nil {
			return err
		}
		parsedVal = mapVar
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailAssessmentMap(v *map[string]types.GuardrailAssessment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string]types.GuardrailAssessment
	if *v == nil {
		mv = map[string]types.GuardrailAssessment{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal types.GuardrailAssessment
		mapVar := parsedVal
		destAddr := &mapVar
		if err := awsRestjson1_deserializeDocumentGuardrailAssessment(&destAddr, value); err != nil {
			return err
		}
		parsedVal = *destAddr
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailContentFilter(v **types.GuardrailContentFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailContentFilter
	if *v == nil {
		sv = &types.GuardrailContentFilter{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "action":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GuardrailContentPolicyAction to be of type string, got %T instead", value)
				}
				sv.Action = types.GuardrailContentPolicyAction(jtv)
			}

		case "confidence":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GuardrailContentFilterConfidence to be of type string, got %T instead", value)
				}
				sv.Confidence = types.GuardrailContentFilterConfidence(jtv)
			}

		case "filterStrength":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GuardrailContentFilterStrength to be of type string, got %T instead", value)
				}
				sv.FilterStrength = types.GuardrailContentFilterStrength(jtv)
			}

		case "type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GuardrailContentFilterType to be of type string, got %T instead", value)
				}
				sv.Type = types.GuardrailContentFilterType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailContentFilterList(v *[]types.GuardrailContentFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.GuardrailContentFilter
	if *v == nil {
		cv = []types.GuardrailContentFilter{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.GuardrailContentFilter
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentGuardrailContentFilter(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailContentPolicyAssessment(v **types.GuardrailContentPolicyAssessment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailContentPolicyAssessment
	if *v == nil {
		sv = &types.GuardrailContentPolicyAssessment{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "filters":
			if err := awsRestjson1_deserializeDocumentGuardrailContentFilterList(&sv.Filters, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailContextualGroundingFilter(v **types.GuardrailContextualGroundingFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailContextualGroundingFilter
	if *v == nil {
		sv = &types.GuardrailContextualGroundingFilter{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "action":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GuardrailContextualGroundingPolicyAction to be of type string, got %T instead", value)
				}
				sv.Action = types.GuardrailContextualGroundingPolicyAction(jtv)
			}

		case "score":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Score = ptr.Float64(f64)

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Score = ptr.Float64(f64)

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		case "threshold":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Threshold = ptr.Float64(f64)

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Threshold = ptr.Float64(f64)

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		case "type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GuardrailContextualGroundingFilterType to be of type string, got %T instead", value)
				}
				sv.Type = types.GuardrailContextualGroundingFilterType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailContextualGroundingFilters(v *[]types.GuardrailContextualGroundingFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.GuardrailContextualGroundingFilter
	if *v == nil {
		cv = []types.GuardrailContextualGroundingFilter{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.GuardrailContextualGroundingFilter
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentGuardrailContextualGroundingFilter(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailContextualGroundingPolicyAssessment(v **types.GuardrailContextualGroundingPolicyAssessment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailContextualGroundingPolicyAssessment
	if *v == nil {
		sv = &types.GuardrailContextualGroundingPolicyAssessment{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "filters":
			if err := awsRestjson1_deserializeDocumentGuardrailContextualGroundingFilters(&sv.Filters, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailCoverage(v **types.GuardrailCoverage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailCoverage
	if *v == nil {
		sv = &types.GuardrailCoverage{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "images":
			if err := awsRestjson1_deserializeDocumentGuardrailImageCoverage(&sv.Images, value); err != nil {
				return err
			}

		case "textCharacters":
			if err := awsRestjson1_deserializeDocumentGuardrailTextCharactersCoverage(&sv.TextCharacters, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailCustomWord(v **types.GuardrailCustomWord, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailCustomWord
	if *v == nil {
		sv = &types.GuardrailCustomWord{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "action":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GuardrailWordPolicyAction to be of type string, got %T instead", value)
				}
				sv.Action = types.GuardrailWordPolicyAction(jtv)
			}

		case "match":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Match = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailCustomWordList(v *[]types.GuardrailCustomWord, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.GuardrailCustomWord
	if *v == nil {
		cv = []types.GuardrailCustomWord{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.GuardrailCustomWord
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentGuardrailCustomWord(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailImageCoverage(v **types.GuardrailImageCoverage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailImageCoverage
	if *v == nil {
		sv = &types.GuardrailImageCoverage{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "guarded":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected ImagesGuarded to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Guarded = ptr.Int32(int32(i64))
			}

		case "total":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected ImagesTotal to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Total = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailInvocationMetrics(v **types.GuardrailInvocationMetrics, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailInvocationMetrics
	if *v == nil {
		sv = &types.GuardrailInvocationMetrics{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "guardrailCoverage":
			if err := awsRestjson1_deserializeDocumentGuardrailCoverage(&sv.GuardrailCoverage, value); err != nil {
				return err
			}

		case "guardrailProcessingLatency":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected GuardrailProcessingLatency to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.GuardrailProcessingLatency = ptr.Int64(i64)
			}

		case "usage":
			if err := awsRestjson1_deserializeDocumentGuardrailUsage(&sv.Usage, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailManagedWord(v **types.GuardrailManagedWord, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailManagedWord
	if *v == nil {
		sv = &types.GuardrailManagedWord{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "action":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GuardrailWordPolicyAction to be of type string, got %T instead", value)
				}
				sv.Action = types.GuardrailWordPolicyAction(jtv)
			}

		case "match":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Match = ptr.String(jtv)
			}

		case "type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GuardrailManagedWordType to be of type string, got %T instead", value)
				}
				sv.Type = types.GuardrailManagedWordType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailManagedWordList(v *[]types.GuardrailManagedWord, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.GuardrailManagedWord
	if *v == nil {
		cv = []types.GuardrailManagedWord{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.GuardrailManagedWord
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentGuardrailManagedWord(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailPiiEntityFilter(v **types.GuardrailPiiEntityFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailPiiEntityFilter
	if *v == nil {
		sv = &types.GuardrailPiiEntityFilter{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "action":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GuardrailSensitiveInformationPolicyAction to be of type string, got %T instead", value)
				}
				sv.Action = types.GuardrailSensitiveInformationPolicyAction(jtv)
			}

		case "match":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Match = ptr.String(jtv)
			}

		case "type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GuardrailPiiEntityType to be of type string, got %T instead", value)
				}
				sv.Type = types.GuardrailPiiEntityType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailPiiEntityFilterList(v *[]types.GuardrailPiiEntityFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.GuardrailPiiEntityFilter
	if *v == nil {
		cv = []types.GuardrailPiiEntityFilter{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.GuardrailPiiEntityFilter
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentGuardrailPiiEntityFilter(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailRegexFilter(v **types.GuardrailRegexFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailRegexFilter
	if *v == nil {
		sv = &types.GuardrailRegexFilter{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "action":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GuardrailSensitiveInformationPolicyAction to be of type string, got %T instead", value)
				}
				sv.Action = types.GuardrailSensitiveInformationPolicyAction(jtv)
			}

		case "match":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Match = ptr.String(jtv)
			}

		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "regex":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Regex = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailRegexFilterList(v *[]types.GuardrailRegexFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.GuardrailRegexFilter
	if *v == nil {
		cv = []types.GuardrailRegexFilter{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.GuardrailRegexFilter
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentGuardrailRegexFilter(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailSensitiveInformationPolicyAssessment(v **types.GuardrailSensitiveInformationPolicyAssessment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailSensitiveInformationPolicyAssessment
	if *v == nil {
		sv = &types.GuardrailSensitiveInformationPolicyAssessment{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "piiEntities":
			if err := awsRestjson1_deserializeDocumentGuardrailPiiEntityFilterList(&sv.PiiEntities, value); err != nil {
				return err
			}

		case "regexes":
			if err := awsRestjson1_deserializeDocumentGuardrailRegexFilterList(&sv.Regexes, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailTextCharactersCoverage(v **types.GuardrailTextCharactersCoverage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailTextCharactersCoverage
	if *v == nil {
		sv = &types.GuardrailTextCharactersCoverage{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "guarded":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected TextCharactersGuarded to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Guarded = ptr.Int32(int32(i64))
			}

		case "total":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected TextCharactersTotal to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Total = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailTopic(v **types.GuardrailTopic, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailTopic
	if *v == nil {
		sv = &types.GuardrailTopic{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "action":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GuardrailTopicPolicyAction to be of type string, got %T instead", value)
				}
				sv.Action = types.GuardrailTopicPolicyAction(jtv)
			}

		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GuardrailTopicType to be of type string, got %T instead", value)
				}
				sv.Type = types.GuardrailTopicType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailTopicList(v *[]types.GuardrailTopic, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.GuardrailTopic
	if *v == nil {
		cv = []types.GuardrailTopic{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.GuardrailTopic
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentGuardrailTopic(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailTopicPolicyAssessment(v **types.GuardrailTopicPolicyAssessment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailTopicPolicyAssessment
	if *v == nil {
		sv = &types.GuardrailTopicPolicyAssessment{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "topics":
			if err := awsRestjson1_deserializeDocumentGuardrailTopicList(&sv.Topics, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailTraceAssessment(v **types.GuardrailTraceAssessment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailTraceAssessment
	if *v == nil {
		sv = &types.GuardrailTraceAssessment{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "inputAssessment":
			if err := awsRestjson1_deserializeDocumentGuardrailAssessmentMap(&sv.InputAssessment, value); err != nil {
				return err
			}

		case "modelOutput":
			if err := awsRestjson1_deserializeDocumentModelOutputs(&sv.ModelOutput, value); err != nil {
				return err
			}

		case "outputAssessments":
			if err := awsRestjson1_deserializeDocumentGuardrailAssessmentListMap(&sv.OutputAssessments, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailUsage(v **types.GuardrailUsage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailUsage
	if *v == nil {
		sv = &types.GuardrailUsage{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "contentPolicyUnits":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected GuardrailContentPolicyUnitsProcessed to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ContentPolicyUnits = ptr.Int32(int32(i64))
			}

		case "contextualGroundingPolicyUnits":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected GuardrailContextualGroundingPolicyUnitsProcessed to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ContextualGroundingPolicyUnits = ptr.Int32(int32(i64))
			}

		case "sensitiveInformationPolicyFreeUnits":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected GuardrailSensitiveInformationPolicyFreeUnitsProcessed to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SensitiveInformationPolicyFreeUnits = ptr.Int32(int32(i64))
			}

		case "sensitiveInformationPolicyUnits":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected GuardrailSensitiveInformationPolicyUnitsProcessed to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SensitiveInformationPolicyUnits = ptr.Int32(int32(i64))
			}

		case "topicPolicyUnits":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected GuardrailTopicPolicyUnitsProcessed to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TopicPolicyUnits = ptr.Int32(int32(i64))
			}

		case "wordPolicyUnits":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected GuardrailWordPolicyUnitsProcessed to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.WordPolicyUnits = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailWordPolicyAssessment(v **types.GuardrailWordPolicyAssessment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailWordPolicyAssessment
	if *v == nil {
		sv = &types.GuardrailWordPolicyAssessment{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "customWords":
			if err := awsRestjson1_deserializeDocumentGuardrailCustomWordList(&sv.CustomWords, value); err != nil {
				return err
			}

		case "managedWordLists":
			if err := awsRestjson1_deserializeDocumentGuardrailManagedWordList(&sv.ManagedWordLists, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentMessageStartEvent(v **types.MessageStartEvent, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MessageStartEvent
	if *v == nil {
		sv = &types.MessageStartEvent{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "role":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ConversationRole to be of type string, got %T instead", value)
				}
				sv.Role = types.ConversationRole(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentMessageStopEvent(v **types.MessageStopEvent, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MessageStopEvent
	if *v == nil {
		sv = &types.MessageStopEvent{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "additionalModelResponseFields":
			if err := awsRestjson1_deserializeDocumentDocument(&sv.AdditionalModelResponseFields, value); err != nil {
				return err
			}

		case "stopReason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected StopReason to be of type string, got %T instead", value)
				}
				sv.StopReason = types.StopReason(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentModelOutputs(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected GuardrailOutputText to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentPerformanceConfiguration(v **types.PerformanceConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PerformanceConfiguration
	if *v == nil {
		sv = &types.PerformanceConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "latency":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected PerformanceConfigLatency to be of type string, got %T instead", value)
				}
				sv.Latency = types.PerformanceConfigLatency(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentPromptRouterTrace(v **types.PromptRouterTrace, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PromptRouterTrace
	if *v == nil {
		sv = &types.PromptRouterTrace{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "invokedModelId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected InvokedModelId to be of type string, got %T instead", value)
				}
				sv.InvokedModelId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentReasoningContentBlockDelta(v *types.ReasoningContentBlockDelta, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var uv types.ReasoningContentBlockDelta
loop:
	for key, value := range shape {
		if value == nil {
			continue
		}
		switch key {
		case "redactedContent":
			var mv []byte
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Blob to be []byte, got %T instead", value)
				}
				dv, err := base64.StdEncoding.DecodeString(jtv)
				if err != nil {
					return fmt.Errorf("failed to base64 decode Blob, %w", err)
				}
				mv = dv
			}
			uv = &types.ReasoningContentBlockDeltaMemberRedactedContent{Value: mv}
			break loop

		case "signature":
			var mv string
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				mv = jtv
			}
			uv = &types.ReasoningContentBlockDeltaMemberSignature{Value: mv}
			break loop

		case "text":
			var mv string
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				mv = jtv
			}
			uv = &types.ReasoningContentBlockDeltaMemberText{Value: mv}
			break loop

		default:
			uv = &types.UnknownUnionMember{Tag: key}
			break loop

		}
	}
	*v = uv
	return nil
}

func awsRestjson1_deserializeDocumentTokenUsage(v **types.TokenUsage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TokenUsage
	if *v == nil {
		sv = &types.TokenUsage{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "inputTokens":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InputTokens = ptr.Int32(int32(i64))
			}

		case "outputTokens":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.OutputTokens = ptr.Int32(int32(i64))
			}

		case "totalTokens":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TotalTokens = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentToolUseBlockDelta(v **types.ToolUseBlockDelta, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ToolUseBlockDelta
	if *v == nil {
		sv = &types.ToolUseBlockDelta{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "input":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Input = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentToolUseBlockStart(v **types.ToolUseBlockStart, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ToolUseBlockStart
	if *v == nil {
		sv = &types.ToolUseBlockStart{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ToolName to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "toolUseId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ToolUseId to be of type string, got %T instead", value)
				}
				sv.ToolUseId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentDocument(v *document.Interface, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	*v = internaldocument.NewDocumentUnmarshaler(value)
	return nil
}

func awsRestjson1_deserializeErrorAccessDeniedException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.AccessDeniedException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentAccessDeniedException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorConflictException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ConflictException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentConflictException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorInternalServerException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InternalServerException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentInternalServerException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorModelErrorException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ModelErrorException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentModelErrorException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorModelNotReadyException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ModelNotReadyException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentModelNotReadyException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorModelStreamErrorException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ModelStreamErrorException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentModelStreamErrorException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorModelTimeoutException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ModelTimeoutException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentModelTimeoutException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorResourceNotFoundException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ResourceNotFoundException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentResourceNotFoundException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorServiceQuotaExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ServiceQuotaExceededException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentServiceQuotaExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorServiceUnavailableException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ServiceUnavailableException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentServiceUnavailableException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorThrottlingException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ThrottlingException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentThrottlingException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorValidationException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ValidationException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentValidationException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeDocumentAccessDeniedException(v **types.AccessDeniedException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AccessDeniedException
	if *v == nil {
		sv = &types.AccessDeniedException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonBlankString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAsyncInvokeOutputDataConfig(v *types.AsyncInvokeOutputDataConfig, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var uv types.AsyncInvokeOutputDataConfig
loop:
	for key, value := range shape {
		if value == nil {
			continue
		}
		switch key {
		case "s3OutputDataConfig":
			var mv types.AsyncInvokeS3OutputDataConfig
			destAddr := &mv
			if err := awsRestjson1_deserializeDocumentAsyncInvokeS3OutputDataConfig(&destAddr, value); err != nil {
				return err
			}
			mv = *destAddr
			uv = &types.AsyncInvokeOutputDataConfigMemberS3OutputDataConfig{Value: mv}
			break loop

		default:
			uv = &types.UnknownUnionMember{Tag: key}
			break loop

		}
	}
	*v = uv
	return nil
}

func awsRestjson1_deserializeDocumentAsyncInvokeS3OutputDataConfig(v **types.AsyncInvokeS3OutputDataConfig, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AsyncInvokeS3OutputDataConfig
	if *v == nil {
		sv = &types.AsyncInvokeS3OutputDataConfig{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "bucketOwner":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AccountId to be of type string, got %T instead", value)
				}
				sv.BucketOwner = ptr.String(jtv)
			}

		case "kmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected KmsKeyId to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		case "s3Uri":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected S3Uri to be of type string, got %T instead", value)
				}
				sv.S3Uri = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAsyncInvokeSummaries(v *[]types.AsyncInvokeSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AsyncInvokeSummary
	if *v == nil {
		cv = []types.AsyncInvokeSummary{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AsyncInvokeSummary
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAsyncInvokeSummary(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAsyncInvokeSummary(v **types.AsyncInvokeSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AsyncInvokeSummary
	if *v == nil {
		sv = &types.AsyncInvokeSummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "clientRequestToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AsyncInvokeIdempotencyToken to be of type string, got %T instead", value)
				}
				sv.ClientRequestToken = ptr.String(jtv)
			}

		case "endTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.EndTime = ptr.Time(t)
			}

		case "failureMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AsyncInvokeMessage to be of type string, got %T instead", value)
				}
				sv.FailureMessage = ptr.String(jtv)
			}

		case "invocationArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected InvocationArn to be of type string, got %T instead", value)
				}
				sv.InvocationArn = ptr.String(jtv)
			}

		case "lastModifiedTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.LastModifiedTime = ptr.Time(t)
			}

		case "modelArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AsyncInvokeArn to be of type string, got %T instead", value)
				}
				sv.ModelArn = ptr.String(jtv)
			}

		case "outputDataConfig":
			if err := awsRestjson1_deserializeDocumentAsyncInvokeOutputDataConfig(&sv.OutputDataConfig, value); err != nil {
				return err
			}

		case "status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AsyncInvokeStatus to be of type string, got %T instead", value)
				}
				sv.Status = types.AsyncInvokeStatus(jtv)
			}

		case "submitTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.SubmitTime = ptr.Time(t)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentConflictException(v **types.ConflictException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ConflictException
	if *v == nil {
		sv = &types.ConflictException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonBlankString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentContentBlock(v *types.ContentBlock, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var uv types.ContentBlock
loop:
	for key, value := range shape {
		if value == nil {
			continue
		}
		switch key {
		case "document":
			var mv types.DocumentBlock
			destAddr := &mv
			if err := awsRestjson1_deserializeDocumentDocumentBlock(&destAddr, value); err != nil {
				return err
			}
			mv = *destAddr
			uv = &types.ContentBlockMemberDocument{Value: mv}
			break loop

		case "guardContent":
			var mv types.GuardrailConverseContentBlock
			if err := awsRestjson1_deserializeDocumentGuardrailConverseContentBlock(&mv, value); err != nil {
				return err
			}
			uv = &types.ContentBlockMemberGuardContent{Value: mv}
			break loop

		case "image":
			var mv types.ImageBlock
			destAddr := &mv
			if err := awsRestjson1_deserializeDocumentImageBlock(&destAddr, value); err != nil {
				return err
			}
			mv = *destAddr
			uv = &types.ContentBlockMemberImage{Value: mv}
			break loop

		case "reasoningContent":
			var mv types.ReasoningContentBlock
			if err := awsRestjson1_deserializeDocumentReasoningContentBlock(&mv, value); err != nil {
				return err
			}
			uv = &types.ContentBlockMemberReasoningContent{Value: mv}
			break loop

		case "text":
			var mv string
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				mv = jtv
			}
			uv = &types.ContentBlockMemberText{Value: mv}
			break loop

		case "toolResult":
			var mv types.ToolResultBlock
			destAddr := &mv
			if err := awsRestjson1_deserializeDocumentToolResultBlock(&destAddr, value); err != nil {
				return err
			}
			mv = *destAddr
			uv = &types.ContentBlockMemberToolResult{Value: mv}
			break loop

		case "toolUse":
			var mv types.ToolUseBlock
			destAddr := &mv
			if err := awsRestjson1_deserializeDocumentToolUseBlock(&destAddr, value); err != nil {
				return err
			}
			mv = *destAddr
			uv = &types.ContentBlockMemberToolUse{Value: mv}
			break loop

		case "video":
			var mv types.VideoBlock
			destAddr := &mv
			if err := awsRestjson1_deserializeDocumentVideoBlock(&destAddr, value); err != nil {
				return err
			}
			mv = *destAddr
			uv = &types.ContentBlockMemberVideo{Value: mv}
			break loop

		default:
			uv = &types.UnknownUnionMember{Tag: key}
			break loop

		}
	}
	*v = uv
	return nil
}

func awsRestjson1_deserializeDocumentContentBlocks(v *[]types.ContentBlock, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ContentBlock
	if *v == nil {
		cv = []types.ContentBlock{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ContentBlock
		if err := awsRestjson1_deserializeDocumentContentBlock(&col, value); err != nil {
			return err
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentConverseMetrics(v **types.ConverseMetrics, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ConverseMetrics
	if *v == nil {
		sv = &types.ConverseMetrics{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "latencyMs":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.LatencyMs = ptr.Int64(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentConverseOutput(v *types.ConverseOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var uv types.ConverseOutput
loop:
	for key, value := range shape {
		if value == nil {
			continue
		}
		switch key {
		case "message":
			var mv types.Message
			destAddr := &mv
			if err := awsRestjson1_deserializeDocumentMessage(&destAddr, value); err != nil {
				return err
			}
			mv = *destAddr
			uv = &types.ConverseOutputMemberMessage{Value: mv}
			break loop

		default:
			uv = &types.UnknownUnionMember{Tag: key}
			break loop

		}
	}
	*v = uv
	return nil
}

func awsRestjson1_deserializeDocumentConverseTrace(v **types.ConverseTrace, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ConverseTrace
	if *v == nil {
		sv = &types.ConverseTrace{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "guardrail":
			if err := awsRestjson1_deserializeDocumentGuardrailTraceAssessment(&sv.Guardrail, value); err != nil {
				return err
			}

		case "promptRouter":
			if err := awsRestjson1_deserializeDocumentPromptRouterTrace(&sv.PromptRouter, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentDocumentBlock(v **types.DocumentBlock, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.DocumentBlock
	if *v == nil {
		sv = &types.DocumentBlock{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "format":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DocumentFormat to be of type string, got %T instead", value)
				}
				sv.Format = types.DocumentFormat(jtv)
			}

		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "source":
			if err := awsRestjson1_deserializeDocumentDocumentSource(&sv.Source, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentDocumentSource(v *types.DocumentSource, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var uv types.DocumentSource
loop:
	for key, value := range shape {
		if value == nil {
			continue
		}
		switch key {
		case "bytes":
			var mv []byte
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Blob to be []byte, got %T instead", value)
				}
				dv, err := base64.StdEncoding.DecodeString(jtv)
				if err != nil {
					return fmt.Errorf("failed to base64 decode Blob, %w", err)
				}
				mv = dv
			}
			uv = &types.DocumentSourceMemberBytes{Value: mv}
			break loop

		default:
			uv = &types.UnknownUnionMember{Tag: key}
			break loop

		}
	}
	*v = uv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailConverseContentBlock(v *types.GuardrailConverseContentBlock, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var uv types.GuardrailConverseContentBlock
loop:
	for key, value := range shape {
		if value == nil {
			continue
		}
		switch key {
		case "image":
			var mv types.GuardrailConverseImageBlock
			destAddr := &mv
			if err := awsRestjson1_deserializeDocumentGuardrailConverseImageBlock(&destAddr, value); err != nil {
				return err
			}
			mv = *destAddr
			uv = &types.GuardrailConverseContentBlockMemberImage{Value: mv}
			break loop

		case "text":
			var mv types.GuardrailConverseTextBlock
			destAddr := &mv
			if err := awsRestjson1_deserializeDocumentGuardrailConverseTextBlock(&destAddr, value); err != nil {
				return err
			}
			mv = *destAddr
			uv = &types.GuardrailConverseContentBlockMemberText{Value: mv}
			break loop

		default:
			uv = &types.UnknownUnionMember{Tag: key}
			break loop

		}
	}
	*v = uv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailConverseContentQualifierList(v *[]types.GuardrailConverseContentQualifier, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.GuardrailConverseContentQualifier
	if *v == nil {
		cv = []types.GuardrailConverseContentQualifier{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.GuardrailConverseContentQualifier
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected GuardrailConverseContentQualifier to be of type string, got %T instead", value)
			}
			col = types.GuardrailConverseContentQualifier(jtv)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailConverseImageBlock(v **types.GuardrailConverseImageBlock, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailConverseImageBlock
	if *v == nil {
		sv = &types.GuardrailConverseImageBlock{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "format":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GuardrailConverseImageFormat to be of type string, got %T instead", value)
				}
				sv.Format = types.GuardrailConverseImageFormat(jtv)
			}

		case "source":
			if err := awsRestjson1_deserializeDocumentGuardrailConverseImageSource(&sv.Source, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailConverseImageSource(v *types.GuardrailConverseImageSource, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var uv types.GuardrailConverseImageSource
loop:
	for key, value := range shape {
		if value == nil {
			continue
		}
		switch key {
		case "bytes":
			var mv []byte
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Blob to be []byte, got %T instead", value)
				}
				dv, err := base64.StdEncoding.DecodeString(jtv)
				if err != nil {
					return fmt.Errorf("failed to base64 decode Blob, %w", err)
				}
				mv = dv
			}
			uv = &types.GuardrailConverseImageSourceMemberBytes{Value: mv}
			break loop

		default:
			uv = &types.UnknownUnionMember{Tag: key}
			break loop

		}
	}
	*v = uv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailConverseTextBlock(v **types.GuardrailConverseTextBlock, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailConverseTextBlock
	if *v == nil {
		sv = &types.GuardrailConverseTextBlock{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "qualifiers":
			if err := awsRestjson1_deserializeDocumentGuardrailConverseContentQualifierList(&sv.Qualifiers, value); err != nil {
				return err
			}

		case "text":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Text = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailOutputContent(v **types.GuardrailOutputContent, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GuardrailOutputContent
	if *v == nil {
		sv = &types.GuardrailOutputContent{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "text":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected GuardrailOutputText to be of type string, got %T instead", value)
				}
				sv.Text = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGuardrailOutputContentList(v *[]types.GuardrailOutputContent, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.GuardrailOutputContent
	if *v == nil {
		cv = []types.GuardrailOutputContent{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.GuardrailOutputContent
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentGuardrailOutputContent(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentImageBlock(v **types.ImageBlock, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ImageBlock
	if *v == nil {
		sv = &types.ImageBlock{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "format":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ImageFormat to be of type string, got %T instead", value)
				}
				sv.Format = types.ImageFormat(jtv)
			}

		case "source":
			if err := awsRestjson1_deserializeDocumentImageSource(&sv.Source, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentImageSource(v *types.ImageSource, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var uv types.ImageSource
loop:
	for key, value := range shape {
		if value == nil {
			continue
		}
		switch key {
		case "bytes":
			var mv []byte
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Blob to be []byte, got %T instead", value)
				}
				dv, err := base64.StdEncoding.DecodeString(jtv)
				if err != nil {
					return fmt.Errorf("failed to base64 decode Blob, %w", err)
				}
				mv = dv
			}
			uv = &types.ImageSourceMemberBytes{Value: mv}
			break loop

		default:
			uv = &types.UnknownUnionMember{Tag: key}
			break loop

		}
	}
	*v = uv
	return nil
}

func awsRestjson1_deserializeDocumentMessage(v **types.Message, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Message
	if *v == nil {
		sv = &types.Message{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "content":
			if err := awsRestjson1_deserializeDocumentContentBlocks(&sv.Content, value); err != nil {
				return err
			}

		case "role":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ConversationRole to be of type string, got %T instead", value)
				}
				sv.Role = types.ConversationRole(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentModelErrorException(v **types.ModelErrorException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ModelErrorException
	if *v == nil {
		sv = &types.ModelErrorException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonBlankString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "originalStatusCode":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected StatusCode to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.OriginalStatusCode = ptr.Int32(int32(i64))
			}

		case "resourceName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonBlankString to be of type string, got %T instead", value)
				}
				sv.ResourceName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentModelNotReadyException(v **types.ModelNotReadyException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ModelNotReadyException
	if *v == nil {
		sv = &types.ModelNotReadyException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonBlankString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentReasoningContentBlock(v *types.ReasoningContentBlock, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var uv types.ReasoningContentBlock
loop:
	for key, value := range shape {
		if value == nil {
			continue
		}
		switch key {
		case "reasoningText":
			var mv types.ReasoningTextBlock
			destAddr := &mv
			if err := awsRestjson1_deserializeDocumentReasoningTextBlock(&destAddr, value); err != nil {
				return err
			}
			mv = *destAddr
			uv = &types.ReasoningContentBlockMemberReasoningText{Value: mv}
			break loop

		case "redactedContent":
			var mv []byte
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Blob to be []byte, got %T instead", value)
				}
				dv, err := base64.StdEncoding.DecodeString(jtv)
				if err != nil {
					return fmt.Errorf("failed to base64 decode Blob, %w", err)
				}
				mv = dv
			}
			uv = &types.ReasoningContentBlockMemberRedactedContent{Value: mv}
			break loop

		default:
			uv = &types.UnknownUnionMember{Tag: key}
			break loop

		}
	}
	*v = uv
	return nil
}

func awsRestjson1_deserializeDocumentReasoningTextBlock(v **types.ReasoningTextBlock, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ReasoningTextBlock
	if *v == nil {
		sv = &types.ReasoningTextBlock{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "signature":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Signature = ptr.String(jtv)
			}

		case "text":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				sv.Text = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentResourceNotFoundException(v **types.ResourceNotFoundException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ResourceNotFoundException
	if *v == nil {
		sv = &types.ResourceNotFoundException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonBlankString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentS3Location(v **types.S3Location, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.S3Location
	if *v == nil {
		sv = &types.S3Location{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "bucketOwner":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AccountId to be of type string, got %T instead", value)
				}
				sv.BucketOwner = ptr.String(jtv)
			}

		case "uri":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected S3Uri to be of type string, got %T instead", value)
				}
				sv.Uri = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentServiceQuotaExceededException(v **types.ServiceQuotaExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ServiceQuotaExceededException
	if *v == nil {
		sv = &types.ServiceQuotaExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonBlankString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentToolResultBlock(v **types.ToolResultBlock, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ToolResultBlock
	if *v == nil {
		sv = &types.ToolResultBlock{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "content":
			if err := awsRestjson1_deserializeDocumentToolResultContentBlocks(&sv.Content, value); err != nil {
				return err
			}

		case "status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ToolResultStatus to be of type string, got %T instead", value)
				}
				sv.Status = types.ToolResultStatus(jtv)
			}

		case "toolUseId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ToolUseId to be of type string, got %T instead", value)
				}
				sv.ToolUseId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentToolResultContentBlock(v *types.ToolResultContentBlock, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var uv types.ToolResultContentBlock
loop:
	for key, value := range shape {
		if value == nil {
			continue
		}
		switch key {
		case "document":
			var mv types.DocumentBlock
			destAddr := &mv
			if err := awsRestjson1_deserializeDocumentDocumentBlock(&destAddr, value); err != nil {
				return err
			}
			mv = *destAddr
			uv = &types.ToolResultContentBlockMemberDocument{Value: mv}
			break loop

		case "image":
			var mv types.ImageBlock
			destAddr := &mv
			if err := awsRestjson1_deserializeDocumentImageBlock(&destAddr, value); err != nil {
				return err
			}
			mv = *destAddr
			uv = &types.ToolResultContentBlockMemberImage{Value: mv}
			break loop

		case "json":
			var mv document.Interface
			if err := awsRestjson1_deserializeDocumentDocument(&mv, value); err != nil {
				return err
			}
			uv = &types.ToolResultContentBlockMemberJson{Value: mv}
			break loop

		case "text":
			var mv string
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected String to be of type string, got %T instead", value)
				}
				mv = jtv
			}
			uv = &types.ToolResultContentBlockMemberText{Value: mv}
			break loop

		case "video":
			var mv types.VideoBlock
			destAddr := &mv
			if err := awsRestjson1_deserializeDocumentVideoBlock(&destAddr, value); err != nil {
				return err
			}
			mv = *destAddr
			uv = &types.ToolResultContentBlockMemberVideo{Value: mv}
			break loop

		default:
			uv = &types.UnknownUnionMember{Tag: key}
			break loop

		}
	}
	*v = uv
	return nil
}

func awsRestjson1_deserializeDocumentToolResultContentBlocks(v *[]types.ToolResultContentBlock, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ToolResultContentBlock
	if *v == nil {
		cv = []types.ToolResultContentBlock{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ToolResultContentBlock
		if err := awsRestjson1_deserializeDocumentToolResultContentBlock(&col, value); err != nil {
			return err
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentToolUseBlock(v **types.ToolUseBlock, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ToolUseBlock
	if *v == nil {
		sv = &types.ToolUseBlock{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "input":
			if err := awsRestjson1_deserializeDocumentDocument(&sv.Input, value); err != nil {
				return err
			}

		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ToolName to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "toolUseId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ToolUseId to be of type string, got %T instead", value)
				}
				sv.ToolUseId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentVideoBlock(v **types.VideoBlock, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.VideoBlock
	if *v == nil {
		sv = &types.VideoBlock{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "format":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected VideoFormat to be of type string, got %T instead", value)
				}
				sv.Format = types.VideoFormat(jtv)
			}

		case "source":
			if err := awsRestjson1_deserializeDocumentVideoSource(&sv.Source, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentVideoSource(v *types.VideoSource, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var uv types.VideoSource
loop:
	for key, value := range shape {
		if value == nil {
			continue
		}
		switch key {
		case "bytes":
			var mv []byte
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Blob to be []byte, got %T instead", value)
				}
				dv, err := base64.StdEncoding.DecodeString(jtv)
				if err != nil {
					return fmt.Errorf("failed to base64 decode Blob, %w", err)
				}
				mv = dv
			}
			uv = &types.VideoSourceMemberBytes{Value: mv}
			break loop

		case "s3Location":
			var mv types.S3Location
			destAddr := &mv
			if err := awsRestjson1_deserializeDocumentS3Location(&destAddr, value); err != nil {
				return err
			}
			mv = *destAddr
			uv = &types.VideoSourceMemberS3Location{Value: mv}
			break loop

		default:
			uv = &types.UnknownUnionMember{Tag: key}
			break loop

		}
	}
	*v = uv
	return nil
}
