// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/bedrockruntime/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The model must request at least one tool (no text is generated). For example,
// {"any" : {}} .
type AnyToolChoice struct {
	noSmithyDocumentSerde
}

// Asynchronous invocation output data settings.
//
// The following types satisfy this interface:
//
//	AsyncInvokeOutputDataConfigMemberS3OutputDataConfig
type AsyncInvokeOutputDataConfig interface {
	isAsyncInvokeOutputDataConfig()
}

// A storage location for the output data in an S3 bucket
type AsyncInvokeOutputDataConfigMemberS3OutputDataConfig struct {
	Value AsyncInvokeS3OutputDataConfig

	noSmithyDocumentSerde
}

func (*AsyncInvokeOutputDataConfigMemberS3OutputDataConfig) isAsyncInvokeOutputDataConfig() {}

// Asynchronous invocation output data settings.
type AsyncInvokeS3OutputDataConfig struct {

	// An object URI starting with s3:// .
	//
	// This member is required.
	S3Uri *string

	// If the bucket belongs to another AWS account, specify that account's ID.
	BucketOwner *string

	// A KMS encryption key ID.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// A summary of an asynchronous invocation.
type AsyncInvokeSummary struct {

	// The invocation's ARN.
	//
	// This member is required.
	InvocationArn *string

	// The invoked model's ARN.
	//
	// This member is required.
	ModelArn *string

	// The invocation's output data settings.
	//
	// This member is required.
	OutputDataConfig AsyncInvokeOutputDataConfig

	// When the invocation was submitted.
	//
	// This member is required.
	SubmitTime *time.Time

	// The invocation's idempotency token.
	ClientRequestToken *string

	// When the invocation ended.
	EndTime *time.Time

	// An error message.
	FailureMessage *string

	// When the invocation was last modified.
	LastModifiedTime *time.Time

	// The invocation's status.
	Status AsyncInvokeStatus

	noSmithyDocumentSerde
}

// The Model automatically decides if a tool should be called or whether to
// generate text instead. For example, {"auto" : {}} .
type AutoToolChoice struct {
	noSmithyDocumentSerde
}

// A block of content for a message that you pass to, or receive from, a model
// with the [Converse]or [ConverseStream] API operations.
//
// The following types satisfy this interface:
//
//	ContentBlockMemberDocument
//	ContentBlockMemberGuardContent
//	ContentBlockMemberImage
//	ContentBlockMemberReasoningContent
//	ContentBlockMemberText
//	ContentBlockMemberToolResult
//	ContentBlockMemberToolUse
//	ContentBlockMemberVideo
//
// [Converse]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html
// [ConverseStream]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html
type ContentBlock interface {
	isContentBlock()
}

// A document to include in the message.
type ContentBlockMemberDocument struct {
	Value DocumentBlock

	noSmithyDocumentSerde
}

func (*ContentBlockMemberDocument) isContentBlock() {}

// Contains the content to assess with the guardrail. If you don't specify
// guardContent in a call to the Converse API, the guardrail (if passed in the
// Converse API) assesses the entire message.
//
// For more information, see Use a guardrail with the Converse API in the Amazon
// Bedrock User Guide.
type ContentBlockMemberGuardContent struct {
	Value GuardrailConverseContentBlock

	noSmithyDocumentSerde
}

func (*ContentBlockMemberGuardContent) isContentBlock() {}

// Image to include in the message.
//
// This field is only supported by Anthropic Claude 3 models.
type ContentBlockMemberImage struct {
	Value ImageBlock

	noSmithyDocumentSerde
}

func (*ContentBlockMemberImage) isContentBlock() {}

// Contains content regarding the reasoning that is carried out by the model.
// Reasoning refers to a Chain of Thought (CoT) that the model generates to enhance
// the accuracy of its final response.
type ContentBlockMemberReasoningContent struct {
	Value ReasoningContentBlock

	noSmithyDocumentSerde
}

func (*ContentBlockMemberReasoningContent) isContentBlock() {}

// Text to include in the message.
type ContentBlockMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*ContentBlockMemberText) isContentBlock() {}

// The result for a tool request that a model makes.
type ContentBlockMemberToolResult struct {
	Value ToolResultBlock

	noSmithyDocumentSerde
}

func (*ContentBlockMemberToolResult) isContentBlock() {}

// Information about a tool use request from a model.
type ContentBlockMemberToolUse struct {
	Value ToolUseBlock

	noSmithyDocumentSerde
}

func (*ContentBlockMemberToolUse) isContentBlock() {}

// Video to include in the message.
type ContentBlockMemberVideo struct {
	Value VideoBlock

	noSmithyDocumentSerde
}

func (*ContentBlockMemberVideo) isContentBlock() {}

// A block of content in a streaming response.
//
// The following types satisfy this interface:
//
//	ContentBlockDeltaMemberReasoningContent
//	ContentBlockDeltaMemberText
//	ContentBlockDeltaMemberToolUse
type ContentBlockDelta interface {
	isContentBlockDelta()
}

// Contains content regarding the reasoning that is carried out by the model.
// Reasoning refers to a Chain of Thought (CoT) that the model generates to enhance
// the accuracy of its final response.
type ContentBlockDeltaMemberReasoningContent struct {
	Value ReasoningContentBlockDelta

	noSmithyDocumentSerde
}

func (*ContentBlockDeltaMemberReasoningContent) isContentBlockDelta() {}

// The content text.
type ContentBlockDeltaMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*ContentBlockDeltaMemberText) isContentBlockDelta() {}

// Information about a tool that the model is requesting to use.
type ContentBlockDeltaMemberToolUse struct {
	Value ToolUseBlockDelta

	noSmithyDocumentSerde
}

func (*ContentBlockDeltaMemberToolUse) isContentBlockDelta() {}

// The content block delta event.
type ContentBlockDeltaEvent struct {

	// The block index for a content block delta event.
	//
	// This member is required.
	ContentBlockIndex *int32

	// The delta for a content block delta event.
	//
	// This member is required.
	Delta ContentBlockDelta

	noSmithyDocumentSerde
}

// Content block start information.
//
// The following types satisfy this interface:
//
//	ContentBlockStartMemberToolUse
type ContentBlockStart interface {
	isContentBlockStart()
}

// Information about a tool that the model is requesting to use.
type ContentBlockStartMemberToolUse struct {
	Value ToolUseBlockStart

	noSmithyDocumentSerde
}

func (*ContentBlockStartMemberToolUse) isContentBlockStart() {}

// Content block start event.
type ContentBlockStartEvent struct {

	// The index for a content block start event.
	//
	// This member is required.
	ContentBlockIndex *int32

	// Start information about a content block start event.
	//
	// This member is required.
	Start ContentBlockStart

	noSmithyDocumentSerde
}

// A content block stop event.
type ContentBlockStopEvent struct {

	// The index for a content block.
	//
	// This member is required.
	ContentBlockIndex *int32

	noSmithyDocumentSerde
}

// Metrics for a call to [Converse].
//
// [Converse]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html
type ConverseMetrics struct {

	// The latency of the call to Converse , in milliseconds.
	//
	// This member is required.
	LatencyMs *int64

	noSmithyDocumentSerde
}

// The output from a call to [Converse].
//
// The following types satisfy this interface:
//
//	ConverseOutputMemberMessage
//
// [Converse]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html
type ConverseOutput interface {
	isConverseOutput()
}

// The message that the model generates.
type ConverseOutputMemberMessage struct {
	Value Message

	noSmithyDocumentSerde
}

func (*ConverseOutputMemberMessage) isConverseOutput() {}

// A conversation stream metadata event.
type ConverseStreamMetadataEvent struct {

	// The metrics for the conversation stream metadata event.
	//
	// This member is required.
	Metrics *ConverseStreamMetrics

	// Usage information for the conversation stream event.
	//
	// This member is required.
	Usage *TokenUsage

	// Model performance configuration metadata for the conversation stream event.
	PerformanceConfig *PerformanceConfiguration

	// The trace object in the response from [ConverseStream] that contains information about the
	// guardrail behavior.
	//
	// [ConverseStream]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html
	Trace *ConverseStreamTrace

	noSmithyDocumentSerde
}

// Metrics for the stream.
type ConverseStreamMetrics struct {

	// The latency for the streaming request, in milliseconds.
	//
	// This member is required.
	LatencyMs *int64

	noSmithyDocumentSerde
}

// The messages output stream
//
// The following types satisfy this interface:
//
//	ConverseStreamOutputMemberContentBlockDelta
//	ConverseStreamOutputMemberContentBlockStart
//	ConverseStreamOutputMemberContentBlockStop
//	ConverseStreamOutputMemberMessageStart
//	ConverseStreamOutputMemberMessageStop
//	ConverseStreamOutputMemberMetadata
type ConverseStreamOutput interface {
	isConverseStreamOutput()
}

// The messages output content block delta.
type ConverseStreamOutputMemberContentBlockDelta struct {
	Value ContentBlockDeltaEvent

	noSmithyDocumentSerde
}

func (*ConverseStreamOutputMemberContentBlockDelta) isConverseStreamOutput() {}

// Start information for a content block.
type ConverseStreamOutputMemberContentBlockStart struct {
	Value ContentBlockStartEvent

	noSmithyDocumentSerde
}

func (*ConverseStreamOutputMemberContentBlockStart) isConverseStreamOutput() {}

// Stop information for a content block.
type ConverseStreamOutputMemberContentBlockStop struct {
	Value ContentBlockStopEvent

	noSmithyDocumentSerde
}

func (*ConverseStreamOutputMemberContentBlockStop) isConverseStreamOutput() {}

// Message start information.
type ConverseStreamOutputMemberMessageStart struct {
	Value MessageStartEvent

	noSmithyDocumentSerde
}

func (*ConverseStreamOutputMemberMessageStart) isConverseStreamOutput() {}

// Message stop information.
type ConverseStreamOutputMemberMessageStop struct {
	Value MessageStopEvent

	noSmithyDocumentSerde
}

func (*ConverseStreamOutputMemberMessageStop) isConverseStreamOutput() {}

// Metadata for the converse output stream.
type ConverseStreamOutputMemberMetadata struct {
	Value ConverseStreamMetadataEvent

	noSmithyDocumentSerde
}

func (*ConverseStreamOutputMemberMetadata) isConverseStreamOutput() {}

// The trace object in a response from [ConverseStream]. Currently, you can only trace guardrails.
//
// [ConverseStream]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html
type ConverseStreamTrace struct {

	// The guardrail trace object.
	Guardrail *GuardrailTraceAssessment

	// The request's prompt router.
	PromptRouter *PromptRouterTrace

	noSmithyDocumentSerde
}

// The trace object in a response from [Converse]. Currently, you can only trace guardrails.
//
// [Converse]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html
type ConverseTrace struct {

	// The guardrail trace object.
	Guardrail *GuardrailTraceAssessment

	// The request's prompt router.
	PromptRouter *PromptRouterTrace

	noSmithyDocumentSerde
}

// A document to include in a message.
type DocumentBlock struct {

	// The format of a document, or its extension.
	//
	// This member is required.
	Format DocumentFormat

	// A name for the document. The name can only contain the following characters:
	//
	//   - Alphanumeric characters
	//
	//   - Whitespace characters (no more than one in a row)
	//
	//   - Hyphens
	//
	//   - Parentheses
	//
	//   - Square brackets
	//
	// This field is vulnerable to prompt injections, because the model might
	// inadvertently interpret it as instructions. Therefore, we recommend that you
	// specify a neutral name.
	//
	// This member is required.
	Name *string

	// Contains the content of the document.
	//
	// This member is required.
	Source DocumentSource

	noSmithyDocumentSerde
}

// Contains the content of a document.
//
// The following types satisfy this interface:
//
//	DocumentSourceMemberBytes
type DocumentSource interface {
	isDocumentSource()
}

// The raw bytes for the document. If you use an Amazon Web Services SDK, you
// don't need to encode the bytes in base64.
type DocumentSourceMemberBytes struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*DocumentSourceMemberBytes) isDocumentSource() {}

// A behavior assessment of the guardrail policies used in a call to the Converse
// API.
type GuardrailAssessment struct {

	// The content policy.
	ContentPolicy *GuardrailContentPolicyAssessment

	// The contextual grounding policy used for the guardrail assessment.
	ContextualGroundingPolicy *GuardrailContextualGroundingPolicyAssessment

	// The invocation metrics for the guardrail assessment.
	InvocationMetrics *GuardrailInvocationMetrics

	// The sensitive information policy.
	SensitiveInformationPolicy *GuardrailSensitiveInformationPolicyAssessment

	// The topic policy.
	TopicPolicy *GuardrailTopicPolicyAssessment

	// The word policy.
	WordPolicy *GuardrailWordPolicyAssessment

	noSmithyDocumentSerde
}

// Configuration information for a guardrail that you use with the [Converse] operation.
//
// [Converse]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html
type GuardrailConfiguration struct {

	// The identifier for the guardrail.
	//
	// This member is required.
	GuardrailIdentifier *string

	// The version of the guardrail.
	//
	// This member is required.
	GuardrailVersion *string

	// The trace behavior for the guardrail.
	Trace GuardrailTrace

	noSmithyDocumentSerde
}

// The content block to be evaluated by the guardrail.
//
// The following types satisfy this interface:
//
//	GuardrailContentBlockMemberImage
//	GuardrailContentBlockMemberText
type GuardrailContentBlock interface {
	isGuardrailContentBlock()
}

// Image within guardrail content block to be evaluated by the guardrail.
type GuardrailContentBlockMemberImage struct {
	Value GuardrailImageBlock

	noSmithyDocumentSerde
}

func (*GuardrailContentBlockMemberImage) isGuardrailContentBlock() {}

// Text within content block to be evaluated by the guardrail.
type GuardrailContentBlockMemberText struct {
	Value GuardrailTextBlock

	noSmithyDocumentSerde
}

func (*GuardrailContentBlockMemberText) isGuardrailContentBlock() {}

// The content filter for a guardrail.
type GuardrailContentFilter struct {

	// The guardrail action.
	//
	// This member is required.
	Action GuardrailContentPolicyAction

	// The guardrail confidence.
	//
	// This member is required.
	Confidence GuardrailContentFilterConfidence

	// The guardrail type.
	//
	// This member is required.
	Type GuardrailContentFilterType

	// The filter strength setting for the guardrail content filter.
	FilterStrength GuardrailContentFilterStrength

	noSmithyDocumentSerde
}

// An assessment of a content policy for a guardrail.
type GuardrailContentPolicyAssessment struct {

	// The content policy filters.
	//
	// This member is required.
	Filters []GuardrailContentFilter

	noSmithyDocumentSerde
}

// The details for the guardrails contextual grounding filter.
type GuardrailContextualGroundingFilter struct {

	// The action performed by the guardrails contextual grounding filter.
	//
	// This member is required.
	Action GuardrailContextualGroundingPolicyAction

	// The score generated by contextual grounding filter.
	//
	// This member is required.
	Score *float64

	// The threshold used by contextual grounding filter to determine whether the
	// content is grounded or not.
	//
	// This member is required.
	Threshold *float64

	// The contextual grounding filter type.
	//
	// This member is required.
	Type GuardrailContextualGroundingFilterType

	noSmithyDocumentSerde
}

// The policy assessment details for the guardrails contextual grounding filter.
type GuardrailContextualGroundingPolicyAssessment struct {

	// The filter details for the guardrails contextual grounding filter.
	Filters []GuardrailContextualGroundingFilter

	noSmithyDocumentSerde
}

// A content block for selective guarding with the [Converse] or [ConverseStream] API operations.
//
// The following types satisfy this interface:
//
//	GuardrailConverseContentBlockMemberImage
//	GuardrailConverseContentBlockMemberText
//
// [Converse]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html
// [ConverseStream]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html
type GuardrailConverseContentBlock interface {
	isGuardrailConverseContentBlock()
}

// Image within converse content block to be evaluated by the guardrail.
type GuardrailConverseContentBlockMemberImage struct {
	Value GuardrailConverseImageBlock

	noSmithyDocumentSerde
}

func (*GuardrailConverseContentBlockMemberImage) isGuardrailConverseContentBlock() {}

// The text to guard.
type GuardrailConverseContentBlockMemberText struct {
	Value GuardrailConverseTextBlock

	noSmithyDocumentSerde
}

func (*GuardrailConverseContentBlockMemberText) isGuardrailConverseContentBlock() {}

// An image block that contains images that you want to assess with a guardrail.
type GuardrailConverseImageBlock struct {

	// The format details for the image type of the guardrail converse image block.
	//
	// This member is required.
	Format GuardrailConverseImageFormat

	// The image source (image bytes) of the guardrail converse image block.
	//
	// This member is required.
	Source GuardrailConverseImageSource

	noSmithyDocumentSerde
}

// The image source (image bytes) of the guardrail converse image source.
//
// The following types satisfy this interface:
//
//	GuardrailConverseImageSourceMemberBytes
type GuardrailConverseImageSource interface {
	isGuardrailConverseImageSource()
}

// The raw image bytes for the image.
type GuardrailConverseImageSourceMemberBytes struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*GuardrailConverseImageSourceMemberBytes) isGuardrailConverseImageSource() {}

// A text block that contains text that you want to assess with a guardrail. For
// more information, see GuardrailConverseContentBlock.
type GuardrailConverseTextBlock struct {

	// The text that you want to guard.
	//
	// This member is required.
	Text *string

	// The qualifier details for the guardrails contextual grounding filter.
	Qualifiers []GuardrailConverseContentQualifier

	noSmithyDocumentSerde
}

// The action of the guardrail coverage details.
type GuardrailCoverage struct {

	// The guardrail coverage for images (the number of images that guardrails
	// guarded).
	Images *GuardrailImageCoverage

	// The text characters of the guardrail coverage details.
	TextCharacters *GuardrailTextCharactersCoverage

	noSmithyDocumentSerde
}

// A custom word configured in a guardrail.
type GuardrailCustomWord struct {

	// The action for the custom word.
	//
	// This member is required.
	Action GuardrailWordPolicyAction

	// The match for the custom word.
	//
	// This member is required.
	Match *string

	noSmithyDocumentSerde
}

// Contain an image which user wants guarded. This block is accepted by the
// guardrails independent API.
type GuardrailImageBlock struct {

	// The format details for the file type of the image blocked by the guardrail.
	//
	// This member is required.
	Format GuardrailImageFormat

	// The image source (image bytes) details of the image blocked by the guardrail.
	//
	// This member is required.
	Source GuardrailImageSource

	noSmithyDocumentSerde
}

// The details of the guardrail image coverage.
type GuardrailImageCoverage struct {

	// The count (integer) of images guardrails guarded.
	Guarded *int32

	// Represents the total number of images (integer) that were in the request
	// (guarded and unguarded).
	Total *int32

	noSmithyDocumentSerde
}

// The image source (image bytes) of the guardrail image source. Object used in
// independent api.
//
// The following types satisfy this interface:
//
//	GuardrailImageSourceMemberBytes
type GuardrailImageSource interface {
	isGuardrailImageSource()
}

// The bytes details of the guardrail image source. Object used in independent api.
type GuardrailImageSourceMemberBytes struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*GuardrailImageSourceMemberBytes) isGuardrailImageSource() {}

// The invocation metrics for the guardrail.
type GuardrailInvocationMetrics struct {

	// The coverage details for the guardrail invocation metrics.
	GuardrailCoverage *GuardrailCoverage

	// The processing latency details for the guardrail invocation metrics.
	GuardrailProcessingLatency *int64

	// The usage details for the guardrail invocation metrics.
	Usage *GuardrailUsage

	noSmithyDocumentSerde
}

// A managed word configured in a guardrail.
type GuardrailManagedWord struct {

	// The action for the managed word.
	//
	// This member is required.
	Action GuardrailWordPolicyAction

	// The match for the managed word.
	//
	// This member is required.
	Match *string

	// The type for the managed word.
	//
	// This member is required.
	Type GuardrailManagedWordType

	noSmithyDocumentSerde
}

// The output content produced by the guardrail.
type GuardrailOutputContent struct {

	// The specific text for the output content produced by the guardrail.
	Text *string

	noSmithyDocumentSerde
}

// A Personally Identifiable Information (PII) entity configured in a guardrail.
type GuardrailPiiEntityFilter struct {

	// The PII entity filter action.
	//
	// This member is required.
	Action GuardrailSensitiveInformationPolicyAction

	// The PII entity filter match.
	//
	// This member is required.
	Match *string

	// The PII entity filter type.
	//
	// This member is required.
	Type GuardrailPiiEntityType

	noSmithyDocumentSerde
}

// A Regex filter configured in a guardrail.
type GuardrailRegexFilter struct {

	// The region filter action.
	//
	// This member is required.
	Action GuardrailSensitiveInformationPolicyAction

	// The regesx filter match.
	Match *string

	// The regex filter name.
	Name *string

	// The regex query.
	Regex *string

	noSmithyDocumentSerde
}

// The assessment for aPersonally Identifiable Information (PII) policy.
type GuardrailSensitiveInformationPolicyAssessment struct {

	// The PII entities in the assessment.
	//
	// This member is required.
	PiiEntities []GuardrailPiiEntityFilter

	// The regex queries in the assessment.
	//
	// This member is required.
	Regexes []GuardrailRegexFilter

	noSmithyDocumentSerde
}

// Configuration information for a guardrail that you use with the ConverseStream action.
type GuardrailStreamConfiguration struct {

	// The identifier for the guardrail.
	//
	// This member is required.
	GuardrailIdentifier *string

	// The version of the guardrail.
	//
	// This member is required.
	GuardrailVersion *string

	// The processing mode.
	//
	// The processing mode. For more information, see Configure streaming response
	// behavior in the Amazon Bedrock User Guide.
	StreamProcessingMode GuardrailStreamProcessingMode

	// The trace behavior for the guardrail.
	Trace GuardrailTrace

	noSmithyDocumentSerde
}

// The text block to be evaluated by the guardrail.
type GuardrailTextBlock struct {

	// The input text details to be evaluated by the guardrail.
	//
	// This member is required.
	Text *string

	// The qualifiers describing the text block.
	Qualifiers []GuardrailContentQualifier

	noSmithyDocumentSerde
}

// The guardrail coverage for the text characters.
type GuardrailTextCharactersCoverage struct {

	// The text characters that were guarded by the guardrail coverage.
	Guarded *int32

	// The total text characters by the guardrail coverage.
	Total *int32

	noSmithyDocumentSerde
}

// Information about a topic guardrail.
type GuardrailTopic struct {

	// The action the guardrail should take when it intervenes on a topic.
	//
	// This member is required.
	Action GuardrailTopicPolicyAction

	// The name for the guardrail.
	//
	// This member is required.
	Name *string

	// The type behavior that the guardrail should perform when the model detects the
	// topic.
	//
	// This member is required.
	Type GuardrailTopicType

	noSmithyDocumentSerde
}

// A behavior assessment of a topic policy.
type GuardrailTopicPolicyAssessment struct {

	// The topics in the assessment.
	//
	// This member is required.
	Topics []GuardrailTopic

	noSmithyDocumentSerde
}

// A Top level guardrail trace object. For more information, see ConverseTrace.
type GuardrailTraceAssessment struct {

	// The input assessment.
	InputAssessment map[string]GuardrailAssessment

	// The output from the model.
	ModelOutput []string

	// the output assessments.
	OutputAssessments map[string][]GuardrailAssessment

	noSmithyDocumentSerde
}

// The details on the use of the guardrail.
type GuardrailUsage struct {

	// The content policy units processed by the guardrail.
	//
	// This member is required.
	ContentPolicyUnits *int32

	// The contextual grounding policy units processed by the guardrail.
	//
	// This member is required.
	ContextualGroundingPolicyUnits *int32

	// The sensitive information policy free units processed by the guardrail.
	//
	// This member is required.
	SensitiveInformationPolicyFreeUnits *int32

	// The sensitive information policy units processed by the guardrail.
	//
	// This member is required.
	SensitiveInformationPolicyUnits *int32

	// The topic policy units processed by the guardrail.
	//
	// This member is required.
	TopicPolicyUnits *int32

	// The word policy units processed by the guardrail.
	//
	// This member is required.
	WordPolicyUnits *int32

	noSmithyDocumentSerde
}

// The word policy assessment.
type GuardrailWordPolicyAssessment struct {

	// Custom words in the assessment.
	//
	// This member is required.
	CustomWords []GuardrailCustomWord

	// Managed word lists in the assessment.
	//
	// This member is required.
	ManagedWordLists []GuardrailManagedWord

	noSmithyDocumentSerde
}

// Image content for a message.
type ImageBlock struct {

	// The format of the image.
	//
	// This member is required.
	Format ImageFormat

	// The source for the image.
	//
	// This member is required.
	Source ImageSource

	noSmithyDocumentSerde
}

// The source for an image.
//
// The following types satisfy this interface:
//
//	ImageSourceMemberBytes
type ImageSource interface {
	isImageSource()
}

// The raw image bytes for the image. If you use an AWS SDK, you don't need to
// encode the image bytes in base64.
type ImageSourceMemberBytes struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*ImageSourceMemberBytes) isImageSource() {}

// Base inference parameters to pass to a model in a call to [Converse] or [ConverseStream]. For more
// information, see [Inference parameters for foundation models].
//
// If you need to pass additional parameters that the model supports, use the
// additionalModelRequestFields request field in the call to Converse or
// ConverseStream . For more information, see [Model parameters].
//
// [Inference parameters for foundation models]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
// [Converse]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html
// [ConverseStream]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html
// [Model parameters]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
type InferenceConfiguration struct {

	// The maximum number of tokens to allow in the generated response. The default
	// value is the maximum allowed value for the model that you are using. For more
	// information, see [Inference parameters for foundation models].
	//
	// [Inference parameters for foundation models]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
	MaxTokens *int32

	// A list of stop sequences. A stop sequence is a sequence of characters that
	// causes the model to stop generating the response.
	StopSequences []string

	// The likelihood of the model selecting higher-probability options while
	// generating a response. A lower value makes the model more likely to choose
	// higher-probability options, while a higher value makes the model more likely to
	// choose lower-probability options.
	//
	// The default value is the default value for the model that you are using. For
	// more information, see [Inference parameters for foundation models].
	//
	// [Inference parameters for foundation models]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
	Temperature *float32

	// The percentage of most-likely candidates that the model considers for the next
	// token. For example, if you choose a value of 0.8 for topP , the model selects
	// from the top 80% of the probability distribution of tokens that could be next in
	// the sequence.
	//
	// The default value is the default value for the model that you are using. For
	// more information, see [Inference parameters for foundation models].
	//
	// [Inference parameters for foundation models]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
	TopP *float32

	noSmithyDocumentSerde
}

// A message input, or returned from, a call to [Converse] or [ConverseStream].
//
// [Converse]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html
// [ConverseStream]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html
type Message struct {

	// The message content. Note the following restrictions:
	//
	//   - You can include up to 20 images. Each image's size, height, and width must
	//   be no more than 3.75 MB, 8000 px, and 8000 px, respectively.
	//
	//   - You can include up to five documents. Each document's size must be no more
	//   than 4.5 MB.
	//
	//   - If you include a ContentBlock with a document field in the array, you must
	//   also include a ContentBlock with a text field.
	//
	//   - You can only include images and documents if the role is user .
	//
	// This member is required.
	Content []ContentBlock

	// The role that the message plays in the message.
	//
	// This member is required.
	Role ConversationRole

	noSmithyDocumentSerde
}

// The start of a message.
type MessageStartEvent struct {

	// The role for the message.
	//
	// This member is required.
	Role ConversationRole

	noSmithyDocumentSerde
}

// The stop event for a message.
type MessageStopEvent struct {

	// The reason why the model stopped generating output.
	//
	// This member is required.
	StopReason StopReason

	// The additional model response fields.
	AdditionalModelResponseFields document.Interface

	noSmithyDocumentSerde
}

// Payload content included in the response.
type PayloadPart struct {

	// Base64-encoded bytes of payload data.
	Bytes []byte

	noSmithyDocumentSerde
}

// Performance settings for a model.
type PerformanceConfiguration struct {

	// To use a latency-optimized version of the model, set to optimized .
	Latency PerformanceConfigLatency

	noSmithyDocumentSerde
}

// A prompt router trace.
type PromptRouterTrace struct {

	// The ID of the invoked model.
	InvokedModelId *string

	noSmithyDocumentSerde
}

// Contains a map of variables in a prompt from Prompt management to an object
// containing the values to fill in for them when running model invocation. For
// more information, see [How Prompt management works].
//
// The following types satisfy this interface:
//
//	PromptVariableValuesMemberText
//
// [How Prompt management works]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-how.html
type PromptVariableValues interface {
	isPromptVariableValues()
}

// The text value that the variable maps to.
type PromptVariableValuesMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*PromptVariableValuesMemberText) isPromptVariableValues() {}

// Contains content regarding the reasoning that is carried out by the model with
// respect to the content in the content block. Reasoning refers to a Chain of
// Thought (CoT) that the model generates to enhance the accuracy of its final
// response.
//
// The following types satisfy this interface:
//
//	ReasoningContentBlockMemberReasoningText
//	ReasoningContentBlockMemberRedactedContent
type ReasoningContentBlock interface {
	isReasoningContentBlock()
}

// The reasoning that the model used to return the output.
type ReasoningContentBlockMemberReasoningText struct {
	Value ReasoningTextBlock

	noSmithyDocumentSerde
}

func (*ReasoningContentBlockMemberReasoningText) isReasoningContentBlock() {}

// The content in the reasoning that was encrypted by the model provider for
// safety reasons. The encryption doesn't affect the quality of responses.
type ReasoningContentBlockMemberRedactedContent struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*ReasoningContentBlockMemberRedactedContent) isReasoningContentBlock() {}

// Contains content regarding the reasoning that is carried out by the model with
// respect to the content in the content block. Reasoning refers to a Chain of
// Thought (CoT) that the model generates to enhance the accuracy of its final
// response.
//
// The following types satisfy this interface:
//
//	ReasoningContentBlockDeltaMemberRedactedContent
//	ReasoningContentBlockDeltaMemberSignature
//	ReasoningContentBlockDeltaMemberText
type ReasoningContentBlockDelta interface {
	isReasoningContentBlockDelta()
}

// The content in the reasoning that was encrypted by the model provider for
// safety reasons. The encryption doesn't affect the quality of responses.
type ReasoningContentBlockDeltaMemberRedactedContent struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*ReasoningContentBlockDeltaMemberRedactedContent) isReasoningContentBlockDelta() {}

// A token that verifies that the reasoning text was generated by the model. If
// you pass a reasoning block back to the API in a multi-turn conversation, include
// the text and its signature unmodified.
type ReasoningContentBlockDeltaMemberSignature struct {
	Value string

	noSmithyDocumentSerde
}

func (*ReasoningContentBlockDeltaMemberSignature) isReasoningContentBlockDelta() {}

// The reasoning that the model used to return the output.
type ReasoningContentBlockDeltaMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*ReasoningContentBlockDeltaMemberText) isReasoningContentBlockDelta() {}

// Contains the reasoning that the model used to return the output.
type ReasoningTextBlock struct {

	// The reasoning that the model used to return the output.
	//
	// This member is required.
	Text *string

	// A token that verifies that the reasoning text was generated by the model. If
	// you pass a reasoning block back to the API in a multi-turn conversation, include
	// the text and its signature unmodified.
	Signature *string

	noSmithyDocumentSerde
}

// Definition of content in the response stream.
//
// The following types satisfy this interface:
//
//	ResponseStreamMemberChunk
type ResponseStream interface {
	isResponseStream()
}

// Content included in the response.
type ResponseStreamMemberChunk struct {
	Value PayloadPart

	noSmithyDocumentSerde
}

func (*ResponseStreamMemberChunk) isResponseStream() {}

// A storage location in an S3 bucket.
type S3Location struct {

	// An object URI starting with s3:// .
	//
	// This member is required.
	Uri *string

	// If the bucket belongs to another AWS account, specify that account's ID.
	BucketOwner *string

	noSmithyDocumentSerde
}

// The model must request a specific tool. For example, {"tool" : {"name" : "Your
// tool name"}} .
//
// This field is only supported by Anthropic Claude 3 models.
type SpecificToolChoice struct {

	// The name of the tool that the model must request.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// A system content block.
//
// The following types satisfy this interface:
//
//	SystemContentBlockMemberGuardContent
//	SystemContentBlockMemberText
type SystemContentBlock interface {
	isSystemContentBlock()
}

// A content block to assess with the guardrail. Use with the [Converse] or [ConverseStream] API operations.
//
// For more information, see Use a guardrail with the Converse API in the Amazon
// Bedrock User Guide.
//
// [Converse]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html
// [ConverseStream]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html
type SystemContentBlockMemberGuardContent struct {
	Value GuardrailConverseContentBlock

	noSmithyDocumentSerde
}

func (*SystemContentBlockMemberGuardContent) isSystemContentBlock() {}

// A system prompt for the model.
type SystemContentBlockMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*SystemContentBlockMemberText) isSystemContentBlock() {}

// A tag.
type Tag struct {

	// The tag's key.
	//
	// This member is required.
	Key *string

	// The tag's value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The tokens used in a message API inference call.
type TokenUsage struct {

	// The number of tokens sent in the request to the model.
	//
	// This member is required.
	InputTokens *int32

	// The number of tokens that the model generated for the request.
	//
	// This member is required.
	OutputTokens *int32

	// The total of input tokens and tokens generated by the model.
	//
	// This member is required.
	TotalTokens *int32

	noSmithyDocumentSerde
}

// Information about a tool that you can use with the Converse API. For more
// information, see [Tool use (function calling)]in the Amazon Bedrock User Guide.
//
// The following types satisfy this interface:
//
//	ToolMemberToolSpec
//
// [Tool use (function calling)]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type Tool interface {
	isTool()
}

// The specfication for the tool.
type ToolMemberToolSpec struct {
	Value ToolSpecification

	noSmithyDocumentSerde
}

func (*ToolMemberToolSpec) isTool() {}

// Determines which tools the model should request in a call to Converse or
// ConverseStream . ToolChoice is only supported by Anthropic Claude 3 models and
// by Mistral AI Mistral Large.
//
// The following types satisfy this interface:
//
//	ToolChoiceMemberAny
//	ToolChoiceMemberAuto
//	ToolChoiceMemberTool
type ToolChoice interface {
	isToolChoice()
}

// The model must request at least one tool (no text is generated).
type ToolChoiceMemberAny struct {
	Value AnyToolChoice

	noSmithyDocumentSerde
}

func (*ToolChoiceMemberAny) isToolChoice() {}

// (Default). The Model automatically decides if a tool should be called or
// whether to generate text instead.
type ToolChoiceMemberAuto struct {
	Value AutoToolChoice

	noSmithyDocumentSerde
}

func (*ToolChoiceMemberAuto) isToolChoice() {}

// The Model must request the specified tool. Only supported by Anthropic Claude 3
// models.
type ToolChoiceMemberTool struct {
	Value SpecificToolChoice

	noSmithyDocumentSerde
}

func (*ToolChoiceMemberTool) isToolChoice() {}

// Configuration information for the tools that you pass to a model. For more
// information, see [Tool use (function calling)]in the Amazon Bedrock User Guide.
//
// [Tool use (function calling)]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type ToolConfiguration struct {

	// An array of tools that you want to pass to a model.
	//
	// This member is required.
	Tools []Tool

	// If supported by model, forces the model to request a tool.
	ToolChoice ToolChoice

	noSmithyDocumentSerde
}

// The schema for the tool. The top level schema type must be object .
//
// The following types satisfy this interface:
//
//	ToolInputSchemaMemberJson
type ToolInputSchema interface {
	isToolInputSchema()
}

// The JSON schema for the tool. For more information, see [JSON Schema Reference].
//
// [JSON Schema Reference]: https://json-schema.org/understanding-json-schema/reference
type ToolInputSchemaMemberJson struct {
	Value document.Interface

	noSmithyDocumentSerde
}

func (*ToolInputSchemaMemberJson) isToolInputSchema() {}

// A tool result block that contains the results for a tool request that the model
// previously made.
type ToolResultBlock struct {

	// The content for tool result content block.
	//
	// This member is required.
	Content []ToolResultContentBlock

	// The ID of the tool request that this is the result for.
	//
	// This member is required.
	ToolUseId *string

	// The status for the tool result content block.
	//
	// This field is only supported Anthropic Claude 3 models.
	Status ToolResultStatus

	noSmithyDocumentSerde
}

// The tool result content block.
//
// The following types satisfy this interface:
//
//	ToolResultContentBlockMemberDocument
//	ToolResultContentBlockMemberImage
//	ToolResultContentBlockMemberJson
//	ToolResultContentBlockMemberText
//	ToolResultContentBlockMemberVideo
type ToolResultContentBlock interface {
	isToolResultContentBlock()
}

// A tool result that is a document.
type ToolResultContentBlockMemberDocument struct {
	Value DocumentBlock

	noSmithyDocumentSerde
}

func (*ToolResultContentBlockMemberDocument) isToolResultContentBlock() {}

// A tool result that is an image.
//
// This field is only supported by Anthropic Claude 3 models.
type ToolResultContentBlockMemberImage struct {
	Value ImageBlock

	noSmithyDocumentSerde
}

func (*ToolResultContentBlockMemberImage) isToolResultContentBlock() {}

// A tool result that is JSON format data.
type ToolResultContentBlockMemberJson struct {
	Value document.Interface

	noSmithyDocumentSerde
}

func (*ToolResultContentBlockMemberJson) isToolResultContentBlock() {}

// A tool result that is text.
type ToolResultContentBlockMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*ToolResultContentBlockMemberText) isToolResultContentBlock() {}

// A tool result that is video.
type ToolResultContentBlockMemberVideo struct {
	Value VideoBlock

	noSmithyDocumentSerde
}

func (*ToolResultContentBlockMemberVideo) isToolResultContentBlock() {}

// The specification for the tool.
type ToolSpecification struct {

	// The input schema for the tool in JSON format.
	//
	// This member is required.
	InputSchema ToolInputSchema

	// The name for the tool.
	//
	// This member is required.
	Name *string

	// The description for the tool.
	Description *string

	noSmithyDocumentSerde
}

// A tool use content block. Contains information about a tool that the model is
// requesting be run., The model uses the result from the tool to generate a
// response.
type ToolUseBlock struct {

	// The input to pass to the tool.
	//
	// This member is required.
	Input document.Interface

	// The name of the tool that the model wants to use.
	//
	// This member is required.
	Name *string

	// The ID for the tool request.
	//
	// This member is required.
	ToolUseId *string

	noSmithyDocumentSerde
}

// The delta for a tool use block.
type ToolUseBlockDelta struct {

	// The input for a requested tool.
	//
	// This member is required.
	Input *string

	noSmithyDocumentSerde
}

// The start of a tool use block.
type ToolUseBlockStart struct {

	// The name of the tool that the model is requesting to use.
	//
	// This member is required.
	Name *string

	// The ID for the tool request.
	//
	// This member is required.
	ToolUseId *string

	noSmithyDocumentSerde
}

// A video block.
type VideoBlock struct {

	// The block's format.
	//
	// This member is required.
	Format VideoFormat

	// The block's source.
	//
	// This member is required.
	Source VideoSource

	noSmithyDocumentSerde
}

// A video source. You can upload a smaller video as a base64-encoded string as
// long as the encoded file is less than 25MB. You can also transfer videos up to
// 1GB in size from an S3 bucket.
//
// The following types satisfy this interface:
//
//	VideoSourceMemberBytes
//	VideoSourceMemberS3Location
type VideoSource interface {
	isVideoSource()
}

// Video content encoded in base64.
type VideoSourceMemberBytes struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*VideoSourceMemberBytes) isVideoSource() {}

// The location of a video object in an S3 bucket.
type VideoSourceMemberS3Location struct {
	Value S3Location

	noSmithyDocumentSerde
}

func (*VideoSourceMemberS3Location) isVideoSource() {}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAsyncInvokeOutputDataConfig()   {}
func (*UnknownUnionMember) isContentBlock()                  {}
func (*UnknownUnionMember) isContentBlockDelta()             {}
func (*UnknownUnionMember) isContentBlockStart()             {}
func (*UnknownUnionMember) isConverseOutput()                {}
func (*UnknownUnionMember) isConverseStreamOutput()          {}
func (*UnknownUnionMember) isDocumentSource()                {}
func (*UnknownUnionMember) isGuardrailContentBlock()         {}
func (*UnknownUnionMember) isGuardrailConverseContentBlock() {}
func (*UnknownUnionMember) isGuardrailConverseImageSource()  {}
func (*UnknownUnionMember) isGuardrailImageSource()          {}
func (*UnknownUnionMember) isImageSource()                   {}
func (*UnknownUnionMember) isPromptVariableValues()          {}
func (*UnknownUnionMember) isReasoningContentBlock()         {}
func (*UnknownUnionMember) isReasoningContentBlockDelta()    {}
func (*UnknownUnionMember) isResponseStream()                {}
func (*UnknownUnionMember) isSystemContentBlock()            {}
func (*UnknownUnionMember) isTool()                          {}
func (*UnknownUnionMember) isToolChoice()                    {}
func (*UnknownUnionMember) isToolInputSchema()               {}
func (*UnknownUnionMember) isToolResultContentBlock()        {}
func (*UnknownUnionMember) isVideoSource()                   {}
