// Code generated by smithy-go-codegen DO NOT EDIT.

package billing

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/billing/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the billing views available for a given time period.
//
// Every Amazon Web Services account has a unique PRIMARY billing view that
// represents the billing data available by default. Accounts that use Billing
// Conductor also have BILLING_GROUP billing views representing pro forma costs
// associated with each created billing group.
func (c *Client) ListBillingViews(ctx context.Context, params *ListBillingViewsInput, optFns ...func(*Options)) (*ListBillingViewsOutput, error) {
	if params == nil {
		params = &ListBillingViewsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListBillingViews", params, optFns, c.addOperationListBillingViewsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListBillingViewsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListBillingViewsInput struct {

	//  The time range for the billing views listed. PRIMARY billing view is always
	// listed. BILLING_GROUP billing views are listed for time ranges when the
	// associated billing group resource in Billing Conductor is active. The time range
	// must be within one calendar month.
	ActiveTimeRange *types.ActiveTimeRange

	// The Amazon Resource Name (ARN) that can be used to uniquely identify the
	// billing view.
	Arns []string

	// The type of billing view.
	BillingViewTypes []types.BillingViewType

	// The maximum number of billing views to retrieve. Default is 100.
	MaxResults *int32

	// The pagination token that is used on subsequent calls to list billing views.
	NextToken *string

	//  The list of owners of the billing view.
	OwnerAccountId *string

	noSmithyDocumentSerde
}

type ListBillingViewsOutput struct {

	// A list of BillingViewListElement retrieved.
	//
	// This member is required.
	BillingViews []types.BillingViewListElement

	// The pagination token to use on subsequent calls to list billing views.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListBillingViewsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListBillingViews{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListBillingViews{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListBillingViews"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListBillingViewsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListBillingViews(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListBillingViewsPaginatorOptions is the paginator options for ListBillingViews
type ListBillingViewsPaginatorOptions struct {
	// The maximum number of billing views to retrieve. Default is 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListBillingViewsPaginator is a paginator for ListBillingViews
type ListBillingViewsPaginator struct {
	options   ListBillingViewsPaginatorOptions
	client    ListBillingViewsAPIClient
	params    *ListBillingViewsInput
	nextToken *string
	firstPage bool
}

// NewListBillingViewsPaginator returns a new ListBillingViewsPaginator
func NewListBillingViewsPaginator(client ListBillingViewsAPIClient, params *ListBillingViewsInput, optFns ...func(*ListBillingViewsPaginatorOptions)) *ListBillingViewsPaginator {
	if params == nil {
		params = &ListBillingViewsInput{}
	}

	options := ListBillingViewsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListBillingViewsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListBillingViewsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListBillingViews page.
func (p *ListBillingViewsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListBillingViewsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListBillingViews(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListBillingViewsAPIClient is a client that implements the ListBillingViews
// operation.
type ListBillingViewsAPIClient interface {
	ListBillingViews(context.Context, *ListBillingViewsInput, ...func(*Options)) (*ListBillingViewsOutput, error)
}

var _ ListBillingViewsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListBillingViews(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListBillingViews",
	}
}
