// Code generated by smithy-go-codegen DO NOT EDIT.

package chimesdkidentity

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/chimesdkidentity/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all the AppInstanceUserEndpoints created under a single AppInstanceUser .
func (c *Client) ListAppInstanceUserEndpoints(ctx context.Context, params *ListAppInstanceUserEndpointsInput, optFns ...func(*Options)) (*ListAppInstanceUserEndpointsOutput, error) {
	if params == nil {
		params = &ListAppInstanceUserEndpointsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAppInstanceUserEndpoints", params, optFns, c.addOperationListAppInstanceUserEndpointsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAppInstanceUserEndpointsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAppInstanceUserEndpointsInput struct {

	// The ARN of the AppInstanceUser .
	//
	// This member is required.
	AppInstanceUserArn *string

	// The maximum number of endpoints that you want to return.
	MaxResults *int32

	// The token passed by previous API calls until all requested endpoints are
	// returned.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAppInstanceUserEndpointsOutput struct {

	// The information for each requested AppInstanceUserEndpoint .
	AppInstanceUserEndpoints []types.AppInstanceUserEndpointSummary

	// The token passed by previous API calls until all requested endpoints are
	// returned.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAppInstanceUserEndpointsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAppInstanceUserEndpoints{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAppInstanceUserEndpoints{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAppInstanceUserEndpoints"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListAppInstanceUserEndpointsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAppInstanceUserEndpoints(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAppInstanceUserEndpointsPaginatorOptions is the paginator options for
// ListAppInstanceUserEndpoints
type ListAppInstanceUserEndpointsPaginatorOptions struct {
	// The maximum number of endpoints that you want to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAppInstanceUserEndpointsPaginator is a paginator for
// ListAppInstanceUserEndpoints
type ListAppInstanceUserEndpointsPaginator struct {
	options   ListAppInstanceUserEndpointsPaginatorOptions
	client    ListAppInstanceUserEndpointsAPIClient
	params    *ListAppInstanceUserEndpointsInput
	nextToken *string
	firstPage bool
}

// NewListAppInstanceUserEndpointsPaginator returns a new
// ListAppInstanceUserEndpointsPaginator
func NewListAppInstanceUserEndpointsPaginator(client ListAppInstanceUserEndpointsAPIClient, params *ListAppInstanceUserEndpointsInput, optFns ...func(*ListAppInstanceUserEndpointsPaginatorOptions)) *ListAppInstanceUserEndpointsPaginator {
	if params == nil {
		params = &ListAppInstanceUserEndpointsInput{}
	}

	options := ListAppInstanceUserEndpointsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAppInstanceUserEndpointsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAppInstanceUserEndpointsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAppInstanceUserEndpoints page.
func (p *ListAppInstanceUserEndpointsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAppInstanceUserEndpointsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAppInstanceUserEndpoints(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAppInstanceUserEndpointsAPIClient is a client that implements the
// ListAppInstanceUserEndpoints operation.
type ListAppInstanceUserEndpointsAPIClient interface {
	ListAppInstanceUserEndpoints(context.Context, *ListAppInstanceUserEndpointsInput, ...func(*Options)) (*ListAppInstanceUserEndpointsOutput, error)
}

var _ ListAppInstanceUserEndpointsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAppInstanceUserEndpoints(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAppInstanceUserEndpoints",
	}
}
