// Code generated by smithy-go-codegen DO NOT EDIT.

package chimesdkmessaging

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/chimesdkmessaging/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all channel memberships in a channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the
// AppInstanceUser or AppInstanceBot that makes the API call as the value in the
// header.
//
// If you want to list the channels to which a specific app instance user belongs,
// see the [ListChannelMembershipsForAppInstanceUser]API.
//
// [ListChannelMembershipsForAppInstanceUser]: https://docs.aws.amazon.com/chime/latest/APIReference/API_messaging-chime_ListChannelMembershipsForAppInstanceUser.html
func (c *Client) ListChannelMemberships(ctx context.Context, params *ListChannelMembershipsInput, optFns ...func(*Options)) (*ListChannelMembershipsOutput, error) {
	if params == nil {
		params = &ListChannelMembershipsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListChannelMemberships", params, optFns, c.addOperationListChannelMembershipsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListChannelMembershipsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListChannelMembershipsInput struct {

	// The maximum number of channel memberships that you want returned.
	//
	// This member is required.
	ChannelArn *string

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// This member is required.
	ChimeBearer *string

	// The maximum number of channel memberships that you want returned.
	MaxResults *int32

	// The token passed by previous API calls until all requested channel memberships
	// are returned.
	NextToken *string

	// The ID of the SubChannel in the request.
	//
	// Only required when listing a user's memberships in a particular sub-channel of
	// an elastic channel.
	SubChannelId *string

	// The membership type of a user, DEFAULT or HIDDEN . Default members are returned
	// as part of ListChannelMemberships if no type is specified. Hidden members are
	// only returned if the type filter in ListChannelMemberships equals HIDDEN .
	Type types.ChannelMembershipType

	noSmithyDocumentSerde
}

type ListChannelMembershipsOutput struct {

	// The ARN of the channel.
	ChannelArn *string

	// The information for the requested channel memberships.
	ChannelMemberships []types.ChannelMembershipSummary

	// The token passed by previous API calls until all requested channel memberships
	// are returned.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListChannelMembershipsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListChannelMemberships{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListChannelMemberships{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListChannelMemberships"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListChannelMembershipsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListChannelMemberships(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListChannelMembershipsPaginatorOptions is the paginator options for
// ListChannelMemberships
type ListChannelMembershipsPaginatorOptions struct {
	// The maximum number of channel memberships that you want returned.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListChannelMembershipsPaginator is a paginator for ListChannelMemberships
type ListChannelMembershipsPaginator struct {
	options   ListChannelMembershipsPaginatorOptions
	client    ListChannelMembershipsAPIClient
	params    *ListChannelMembershipsInput
	nextToken *string
	firstPage bool
}

// NewListChannelMembershipsPaginator returns a new ListChannelMembershipsPaginator
func NewListChannelMembershipsPaginator(client ListChannelMembershipsAPIClient, params *ListChannelMembershipsInput, optFns ...func(*ListChannelMembershipsPaginatorOptions)) *ListChannelMembershipsPaginator {
	if params == nil {
		params = &ListChannelMembershipsInput{}
	}

	options := ListChannelMembershipsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListChannelMembershipsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListChannelMembershipsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListChannelMemberships page.
func (p *ListChannelMembershipsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListChannelMembershipsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListChannelMemberships(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListChannelMembershipsAPIClient is a client that implements the
// ListChannelMemberships operation.
type ListChannelMembershipsAPIClient interface {
	ListChannelMemberships(context.Context, *ListChannelMembershipsInput, ...func(*Options)) (*ListChannelMembershipsOutput, error)
}

var _ ListChannelMembershipsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListChannelMemberships(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListChannelMemberships",
	}
}
