// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanroomsml

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanroomsml/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns information about a trained model inference job.
func (c *Client) GetTrainedModelInferenceJob(ctx context.Context, params *GetTrainedModelInferenceJobInput, optFns ...func(*Options)) (*GetTrainedModelInferenceJobOutput, error) {
	if params == nil {
		params = &GetTrainedModelInferenceJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetTrainedModelInferenceJob", params, optFns, c.addOperationGetTrainedModelInferenceJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetTrainedModelInferenceJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetTrainedModelInferenceJobInput struct {

	// Provides the membership ID of the membership that contains the trained model
	// inference job that you are interested in.
	//
	// This member is required.
	MembershipIdentifier *string

	// Provides the Amazon Resource Name (ARN) of the trained model inference job that
	// you are interested in.
	//
	// This member is required.
	TrainedModelInferenceJobArn *string

	noSmithyDocumentSerde
}

type GetTrainedModelInferenceJobOutput struct {

	// The time at which the trained model inference job was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The data source that was used for the trained model inference job.
	//
	// This member is required.
	DataSource *types.ModelInferenceDataSource

	// The membership ID of the membership that contains the trained model inference
	// job.
	//
	// This member is required.
	MembershipIdentifier *string

	// The name of the trained model inference job.
	//
	// This member is required.
	Name *string

	// The output configuration information for the trained model inference job.
	//
	// This member is required.
	OutputConfiguration *types.InferenceOutputConfiguration

	// The resource configuration information for the trained model inference job.
	//
	// This member is required.
	ResourceConfig *types.InferenceResourceConfig

	// The status of the trained model inference job.
	//
	// This member is required.
	Status types.TrainedModelInferenceJobStatus

	// The Amazon Resource Name (ARN) for the trained model that was used for the
	// trained model inference job.
	//
	// This member is required.
	TrainedModelArn *string

	// The Amazon Resource Name (ARN) of the trained model inference job.
	//
	// This member is required.
	TrainedModelInferenceJobArn *string

	// The most recent time at which the trained model inference job was updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The Amazon Resource Name (ARN) of the configured model algorithm association
	// that was used for the trained model inference job.
	ConfiguredModelAlgorithmAssociationArn *string

	// The execution parameters for the model inference job container.
	ContainerExecutionParameters *types.InferenceContainerExecutionParameters

	// The description of the trained model inference job.
	Description *string

	// The environment variables to set in the Docker container.
	Environment map[string]string

	// Information about the training container image.
	InferenceContainerImageDigest *string

	// The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and
	// decrypt customer-owned data in the ML inference job and associated data.
	KmsKeyArn *string

	// The logs status for the trained model inference job.
	LogsStatus types.LogsStatus

	// Details about the logs status for the trained model inference job.
	LogsStatusDetails *string

	// The metrics status for the trained model inference job.
	MetricsStatus types.MetricsStatus

	// Details about the metrics status for the trained model inference job.
	MetricsStatusDetails *string

	// Details about the status of a resource.
	StatusDetails *types.StatusDetails

	// The optional metadata that you applied to the resource to help you categorize
	// and organize them. Each tag consists of a key and an optional value, both of
	// which you define.
	//
	// The following basic restrictions apply to tags:
	//
	//   - Maximum number of tags per resource - 50.
	//
	//   - For each resource, each tag key must be unique, and each tag key can have
	//   only one value.
	//
	//   - Maximum key length - 128 Unicode characters in UTF-8.
	//
	//   - Maximum value length - 256 Unicode characters in UTF-8.
	//
	//   - If your tagging schema is used across multiple services and resources,
	//   remember that other services may have restrictions on allowed characters.
	//   Generally allowed characters are: letters, numbers, and spaces representable in
	//   UTF-8, and the following characters: + - = . _ : / @.
	//
	//   - Tag keys and values are case sensitive.
	//
	//   - Do not use aws:, AWS:, or any upper or lowercase combination of such as a
	//   prefix for keys as it is reserved for AWS use. You cannot edit or delete tag
	//   keys with this prefix. Values can have this prefix. If a tag value has aws as
	//   its prefix but the key does not, then Clean Rooms ML considers it to be a user
	//   tag and will count against the limit of 50 tags. Tags with only the key prefix
	//   of aws do not count against your tags per resource limit.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetTrainedModelInferenceJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetTrainedModelInferenceJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetTrainedModelInferenceJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetTrainedModelInferenceJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetTrainedModelInferenceJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetTrainedModelInferenceJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetTrainedModelInferenceJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetTrainedModelInferenceJob",
	}
}
