// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanroomsml

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanroomsml/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of configured model algorithm associations.
func (c *Client) ListConfiguredModelAlgorithmAssociations(ctx context.Context, params *ListConfiguredModelAlgorithmAssociationsInput, optFns ...func(*Options)) (*ListConfiguredModelAlgorithmAssociationsOutput, error) {
	if params == nil {
		params = &ListConfiguredModelAlgorithmAssociationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListConfiguredModelAlgorithmAssociations", params, optFns, c.addOperationListConfiguredModelAlgorithmAssociationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListConfiguredModelAlgorithmAssociationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListConfiguredModelAlgorithmAssociationsInput struct {

	// The membership ID of the member that created the configured model algorithm
	// associations you are interested in.
	//
	// This member is required.
	MembershipIdentifier *string

	// The maximum size of the results that is returned per call.
	MaxResults *int32

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListConfiguredModelAlgorithmAssociationsOutput struct {

	// The list of configured model algorithm associations.
	//
	// This member is required.
	ConfiguredModelAlgorithmAssociations []types.ConfiguredModelAlgorithmAssociationSummary

	// The token value used to access the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListConfiguredModelAlgorithmAssociationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListConfiguredModelAlgorithmAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListConfiguredModelAlgorithmAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListConfiguredModelAlgorithmAssociations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListConfiguredModelAlgorithmAssociationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListConfiguredModelAlgorithmAssociations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListConfiguredModelAlgorithmAssociationsPaginatorOptions is the paginator
// options for ListConfiguredModelAlgorithmAssociations
type ListConfiguredModelAlgorithmAssociationsPaginatorOptions struct {
	// The maximum size of the results that is returned per call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListConfiguredModelAlgorithmAssociationsPaginator is a paginator for
// ListConfiguredModelAlgorithmAssociations
type ListConfiguredModelAlgorithmAssociationsPaginator struct {
	options   ListConfiguredModelAlgorithmAssociationsPaginatorOptions
	client    ListConfiguredModelAlgorithmAssociationsAPIClient
	params    *ListConfiguredModelAlgorithmAssociationsInput
	nextToken *string
	firstPage bool
}

// NewListConfiguredModelAlgorithmAssociationsPaginator returns a new
// ListConfiguredModelAlgorithmAssociationsPaginator
func NewListConfiguredModelAlgorithmAssociationsPaginator(client ListConfiguredModelAlgorithmAssociationsAPIClient, params *ListConfiguredModelAlgorithmAssociationsInput, optFns ...func(*ListConfiguredModelAlgorithmAssociationsPaginatorOptions)) *ListConfiguredModelAlgorithmAssociationsPaginator {
	if params == nil {
		params = &ListConfiguredModelAlgorithmAssociationsInput{}
	}

	options := ListConfiguredModelAlgorithmAssociationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListConfiguredModelAlgorithmAssociationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListConfiguredModelAlgorithmAssociationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListConfiguredModelAlgorithmAssociations page.
func (p *ListConfiguredModelAlgorithmAssociationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListConfiguredModelAlgorithmAssociationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListConfiguredModelAlgorithmAssociations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListConfiguredModelAlgorithmAssociationsAPIClient is a client that implements
// the ListConfiguredModelAlgorithmAssociations operation.
type ListConfiguredModelAlgorithmAssociationsAPIClient interface {
	ListConfiguredModelAlgorithmAssociations(context.Context, *ListConfiguredModelAlgorithmAssociationsInput, ...func(*Options)) (*ListConfiguredModelAlgorithmAssociationsOutput, error)
}

var _ ListConfiguredModelAlgorithmAssociationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListConfiguredModelAlgorithmAssociations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListConfiguredModelAlgorithmAssociations",
	}
}
