// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudtrail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Generates a query from a natural language prompt. This operation uses
//
// generative artificial intelligence (generative AI) to produce a ready-to-use SQL
// query from the prompt.
//
// The prompt can be a question or a statement about the event data in your event
// data store. For example, you can enter prompts like "What are my top errors in
// the past month?" and “Give me a list of users that used SNS.”
//
// The prompt must be in English. For information about limitations, permissions,
// and supported Regions, see [Create CloudTrail Lake queries from natural language prompts]in the CloudTrail user guide.
//
// Do not include any personally identifying, confidential, or sensitive
// information in your prompts.
//
// This feature uses generative AI large language models (LLMs); we recommend
// double-checking the LLM response.
//
// [Create CloudTrail Lake queries from natural language prompts]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-query-generator.html
func (c *Client) GenerateQuery(ctx context.Context, params *GenerateQueryInput, optFns ...func(*Options)) (*GenerateQueryOutput, error) {
	if params == nil {
		params = &GenerateQueryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GenerateQuery", params, optFns, c.addOperationGenerateQueryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GenerateQueryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GenerateQueryInput struct {

	//  The ARN (or ID suffix of the ARN) of the event data store that you want to
	// query. You can only specify one event data store.
	//
	// This member is required.
	EventDataStores []string

	//  The prompt that you want to use to generate the query. The prompt must be in
	// English. For example prompts, see [Example prompts]in the CloudTrail user guide.
	//
	// [Example prompts]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-query-generator.html#lake-query-generator-examples
	//
	// This member is required.
	Prompt *string

	noSmithyDocumentSerde
}

type GenerateQueryOutput struct {

	//  The account ID of the event data store owner.
	EventDataStoreOwnerAccountId *string

	//  An alias that identifies the prompt. When you run the StartQuery operation,
	// you can pass in either the QueryAlias or QueryStatement parameter.
	QueryAlias *string

	//  The SQL query statement generated from the prompt.
	QueryStatement *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGenerateQueryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGenerateQuery{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGenerateQuery{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GenerateQuery"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGenerateQueryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGenerateQuery(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGenerateQuery(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GenerateQuery",
	}
}
