// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Advanced event selectors let you create fine-grained selectors for CloudTrail
// management, data, and network activity events. They help you control costs by
// logging only those events that are important to you. For more information about
// configuring advanced event selectors, see the [Logging data events], [Logging network activity events], and [Logging management events] topics in the CloudTrail
// User Guide.
//
// You cannot apply both event selectors and advanced event selectors to a trail.
//
// For information about configurable advanced event selector fields, see [AdvancedEventSelector] in the
// CloudTrail API Reference.
//
// [Logging network activity events]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html
// [AdvancedEventSelector]: https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedEventSelector.html
// [Logging management events]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html
// [Logging data events]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html
type AdvancedEventSelector struct {

	// Contains all selector statements in an advanced event selector.
	//
	// This member is required.
	FieldSelectors []AdvancedFieldSelector

	// An optional, descriptive name for an advanced event selector, such as "Log data
	// events for only two S3 buckets".
	Name *string

	noSmithyDocumentSerde
}

// A single selector statement in an advanced event selector.
type AdvancedFieldSelector struct {

	//  A field in a CloudTrail event record on which to filter events to be logged.
	// For event data stores for CloudTrail Insights events, Config configuration
	// items, Audit Manager evidence, or events outside of Amazon Web Services, the
	// field is used only for selecting events as filtering is not supported.
	//
	// For more information, see [AdvancedFieldSelector] in the CloudTrail API Reference.
	//
	// Selectors don't support the use of wildcards like * . To match multiple values
	// with a single condition, you may use StartsWith , EndsWith , NotStartsWith , or
	// NotEndsWith to explicitly match the beginning or end of the event field.
	//
	// [AdvancedFieldSelector]: https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedFieldSelector.html
	//
	// This member is required.
	Field *string

	// An operator that includes events that match the last few characters of the
	// event record field specified as the value of Field .
	EndsWith []string

	//  An operator that includes events that match the exact value of the event
	// record field specified as the value of Field . This is the only valid operator
	// that you can use with the readOnly , eventCategory , and resources.type fields.
	Equals []string

	//  An operator that excludes events that match the last few characters of the
	// event record field specified as the value of Field .
	NotEndsWith []string

	//  An operator that excludes events that match the exact value of the event
	// record field specified as the value of Field .
	NotEquals []string

	//  An operator that excludes events that match the first few characters of the
	// event record field specified as the value of Field .
	NotStartsWith []string

	// An operator that includes events that match the first few characters of the
	// event record field specified as the value of Field .
	StartsWith []string

	noSmithyDocumentSerde
}

// Contains information about a returned CloudTrail channel.
type Channel struct {

	// The Amazon Resource Name (ARN) of a channel.
	ChannelArn *string

	//  The name of the CloudTrail channel. For service-linked channels, the name is
	// aws-service-channel/service-name/custom-suffix where service-name represents
	// the name of the Amazon Web Services service that created the channel and
	// custom-suffix represents the suffix created by the Amazon Web Services service.
	Name *string

	noSmithyDocumentSerde
}

// Provides information about a CloudTrail Lake dashboard.
type DashboardDetail struct {

	//  The ARN for the dashboard.
	DashboardArn *string

	//  The type of dashboard.
	Type DashboardType

	noSmithyDocumentSerde
}

// You can configure the DataResource in an EventSelector to log data events for
// the following three resource types:
//
//   - AWS::DynamoDB::Table
//
//   - AWS::Lambda::Function
//
//   - AWS::S3::Object
//
// To log data events for all other resource types including objects stored in [directory buckets],
// you must use [AdvancedEventSelectors]. You must also use AdvancedEventSelectors if you want to filter
// on the eventName field.
//
// Configure the DataResource to specify the resource type and resource ARNs for
// which you want to log data events.
//
// The total number of allowed data resources is 250. This number can be
// distributed between 1 and 5 event selectors, but the total cannot exceed 250
// across all selectors for the trail.
//
// The following example demonstrates how logging works when you configure logging
// of all data events for a general purpose bucket named amzn-s3-demo-bucket1 . In
// this example, the CloudTrail user specified an empty prefix, and the option to
// log both Read and Write data events.
//
//   - A user uploads an image file to amzn-s3-demo-bucket1 .
//
//   - The PutObject API operation is an Amazon S3 object-level API. It is recorded
//     as a data event in CloudTrail. Because the CloudTrail user specified an S3
//     bucket with an empty prefix, events that occur on any object in that bucket are
//     logged. The trail processes and logs the event.
//
//   - A user uploads an object to an Amazon S3 bucket named
//     arn:aws:s3:::amzn-s3-demo-bucket1 .
//
//   - The PutObject API operation occurred for an object in an S3 bucket that the
//     CloudTrail user didn't specify for the trail. The trail doesn’t log the event.
//
// The following example demonstrates how logging works when you configure logging
// of Lambda data events for a Lambda function named MyLambdaFunction, but not for
// all Lambda functions.
//
//   - A user runs a script that includes a call to the MyLambdaFunction function
//     and the MyOtherLambdaFunction function.
//
//   - The Invoke API operation on MyLambdaFunction is an Lambda API. It is
//     recorded as a data event in CloudTrail. Because the CloudTrail user specified
//     logging data events for MyLambdaFunction, any invocations of that function are
//     logged. The trail processes and logs the event.
//
//   - The Invoke API operation on MyOtherLambdaFunction is an Lambda API. Because
//     the CloudTrail user did not specify logging data events for all Lambda
//     functions, the Invoke operation for MyOtherLambdaFunction does not match the
//     function specified for the trail. The trail doesn’t log the event.
//
// [AdvancedEventSelectors]: https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedEventSelector.html
// [directory buckets]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html
type DataResource struct {

	// The resource type in which you want to log data events. You can specify the
	// following basic event selector resource types:
	//
	//   - AWS::DynamoDB::Table
	//
	//   - AWS::Lambda::Function
	//
	//   - AWS::S3::Object
	//
	// Additional resource types are available through advanced event selectors. For
	// more information, see [AdvancedEventSelector].
	//
	// [AdvancedEventSelector]: https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedEventSelector.html
	Type *string

	// An array of Amazon Resource Name (ARN) strings or partial ARN strings for the
	// specified resource type.
	//
	//   - To log data events for all objects in all S3 buckets in your Amazon Web
	//   Services account, specify the prefix as arn:aws:s3 .
	//
	// This also enables logging of data event activity performed by any user or role
	//   in your Amazon Web Services account, even if that activity is performed on a
	//   bucket that belongs to another Amazon Web Services account.
	//
	//   - To log data events for all objects in an S3 bucket, specify the bucket and
	//   an empty object prefix such as arn:aws:s3:::amzn-s3-demo-bucket1/ . The trail
	//   logs data events for all objects in this S3 bucket.
	//
	//   - To log data events for specific objects, specify the S3 bucket and object
	//   prefix such as arn:aws:s3:::amzn-s3-demo-bucket1/example-images . The trail
	//   logs data events for objects in this S3 bucket that match the prefix.
	//
	//   - To log data events for all Lambda functions in your Amazon Web Services
	//   account, specify the prefix as arn:aws:lambda .
	//
	// This also enables logging of Invoke activity performed by any user or role in
	//   your Amazon Web Services account, even if that activity is performed on a
	//   function that belongs to another Amazon Web Services account.
	//
	//   - To log data events for a specific Lambda function, specify the function ARN.
	//
	// Lambda function ARNs are exact. For example, if you specify a function ARN
	//   arn:aws:lambda:us-west-2:111111111111:function:helloworld, data events will only
	//   be logged for arn:aws:lambda:us-west-2:111111111111:function:helloworld. They
	//   will not be logged for
	//   arn:aws:lambda:us-west-2:111111111111:function:helloworld2.
	//
	//   - To log data events for all DynamoDB tables in your Amazon Web Services
	//   account, specify the prefix as arn:aws:dynamodb .
	Values []string

	noSmithyDocumentSerde
}

// Contains information about the destination receiving events.
type Destination struct {

	//  For channels used for a CloudTrail Lake integration, the location is the ARN
	// of an event data store that receives events from a channel. For service-linked
	// channels, the location is the name of the Amazon Web Services service.
	//
	// This member is required.
	Location *string

	// The type of destination for events arriving from a channel. For channels used
	// for a CloudTrail Lake integration, the value is EVENT_DATA_STORE . For
	// service-linked channels, the value is AWS_SERVICE .
	//
	// This member is required.
	Type DestinationType

	noSmithyDocumentSerde
}

// Contains information about an event that was returned by a lookup request. The
// result includes a representation of a CloudTrail event.
type Event struct {

	// The Amazon Web Services access key ID that was used to sign the request. If the
	// request was made with temporary security credentials, this is the access key ID
	// of the temporary credentials.
	AccessKeyId *string

	// A JSON string that contains a representation of the event returned.
	CloudTrailEvent *string

	// The CloudTrail ID of the event returned.
	EventId *string

	// The name of the event returned.
	EventName *string

	// The Amazon Web Services service to which the request was made.
	EventSource *string

	// The date and time of the event returned.
	EventTime *time.Time

	// Information about whether the event is a write event or a read event.
	ReadOnly *string

	// A list of resources referenced by the event returned.
	Resources []Resource

	// A user name or role name of the requester that called the API in the event
	// returned.
	Username *string

	noSmithyDocumentSerde
}

// A storage lake of event data against which you can run complex SQL-based
// queries. An event data store can include events that you have logged on your
// account. To select events for an event data store, use [advanced event selectors].
//
// [advanced event selectors]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-concepts.html#adv-event-selectors
type EventDataStore struct {

	// The advanced event selectors that were used to select events for the data store.
	//
	// Deprecated: AdvancedEventSelectors is no longer returned by ListEventDataStores
	AdvancedEventSelectors []AdvancedEventSelector

	// The timestamp of the event data store's creation.
	//
	// Deprecated: CreatedTimestamp is no longer returned by ListEventDataStores
	CreatedTimestamp *time.Time

	// The ARN of the event data store.
	EventDataStoreArn *string

	// Indicates whether the event data store includes events from all Regions, or
	// only from the Region in which it was created.
	//
	// Deprecated: MultiRegionEnabled is no longer returned by ListEventDataStores
	MultiRegionEnabled *bool

	// The name of the event data store.
	Name *string

	// Indicates that an event data store is collecting logged events for an
	// organization.
	//
	// Deprecated: OrganizationEnabled is no longer returned by ListEventDataStores
	OrganizationEnabled *bool

	// The retention period, in days.
	//
	// Deprecated: RetentionPeriod is no longer returned by ListEventDataStores
	RetentionPeriod *int32

	// The status of an event data store.
	//
	// Deprecated: Status is no longer returned by ListEventDataStores
	Status EventDataStoreStatus

	// Indicates whether the event data store is protected from termination.
	//
	// Deprecated: TerminationProtectionEnabled is no longer returned by
	// ListEventDataStores
	TerminationProtectionEnabled *bool

	// The timestamp showing when an event data store was updated, if applicable.
	// UpdatedTimestamp is always either the same or newer than the time shown in
	// CreatedTimestamp .
	//
	// Deprecated: UpdatedTimestamp is no longer returned by ListEventDataStores
	UpdatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// Use event selectors to further specify the management and data event settings
// for your trail. By default, trails created without specific event selectors will
// be configured to log all read and write management events, and no data events.
// When an event occurs in your account, CloudTrail evaluates the event selector
// for all trails. For each trail, if the event matches any event selector, the
// trail processes and logs the event. If the event doesn't match any event
// selector, the trail doesn't log the event.
//
// You can configure up to five event selectors for a trail.
//
// You cannot apply both event selectors and advanced event selectors to a trail.
type EventSelector struct {

	// CloudTrail supports data event logging for Amazon S3 objects in standard S3
	// buckets, Lambda functions, and Amazon DynamoDB tables with basic event
	// selectors. You can specify up to 250 resources for an individual event selector,
	// but the total number of data resources cannot exceed 250 across all event
	// selectors in a trail. This limit does not apply if you configure resource
	// logging for all data events.
	//
	// For more information, see [Data Events] and [Limits in CloudTrail] in the CloudTrail User Guide.
	//
	// To log data events for all other resource types including objects stored in [directory buckets],
	// you must use [AdvancedEventSelectors]. You must also use AdvancedEventSelectors if you want to filter
	// on the eventName field.
	//
	// [Data Events]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html
	// [Limits in CloudTrail]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html
	// [AdvancedEventSelectors]: https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedEventSelector.html
	// [directory buckets]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html
	DataResources []DataResource

	// An optional list of service event sources from which you do not want management
	// events to be logged on your trail. In this release, the list can be empty
	// (disables the filter), or it can filter out Key Management Service or Amazon RDS
	// Data API events by containing kms.amazonaws.com or rdsdata.amazonaws.com . By
	// default, ExcludeManagementEventSources is empty, and KMS and Amazon RDS Data
	// API events are logged to your trail. You can exclude management event sources
	// only in Regions that support the event source.
	ExcludeManagementEventSources []string

	// Specify if you want your event selector to include management events for your
	// trail.
	//
	// For more information, see [Management Events] in the CloudTrail User Guide.
	//
	// By default, the value is true .
	//
	// The first copy of management events is free. You are charged for additional
	// copies of management events that you are logging on any subsequent trail in the
	// same Region. For more information about CloudTrail pricing, see [CloudTrail Pricing].
	//
	// [CloudTrail Pricing]: http://aws.amazon.com/cloudtrail/pricing/
	// [Management Events]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html
	IncludeManagementEvents *bool

	// Specify if you want your trail to log read-only events, write-only events, or
	// all. For example, the EC2 GetConsoleOutput is a read-only API operation and
	// RunInstances is a write-only API operation.
	//
	// By default, the value is All .
	ReadWriteType ReadWriteType

	noSmithyDocumentSerde
}

// Provides information about an import failure.
type ImportFailureListItem struct {

	//  Provides the reason the import failed.
	ErrorMessage *string

	//  The type of import error.
	ErrorType *string

	//  When the import was last updated.
	LastUpdatedTime *time.Time

	//  The location of the failure in the S3 bucket.
	Location *string

	//  The status of the import.
	Status ImportFailureStatus

	noSmithyDocumentSerde
}

// Contains information about an import that was returned by a lookup request.
type ImportsListItem struct {

	//  The timestamp of the import's creation.
	CreatedTimestamp *time.Time

	//  The ARN of the destination event data store.
	Destinations []string

	//  The ID of the import.
	ImportId *string

	//  The status of the import.
	ImportStatus ImportStatus

	//  The timestamp of the import's last update.
	UpdatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// The import source.
type ImportSource struct {

	//  The source S3 bucket.
	//
	// This member is required.
	S3 *S3ImportSource

	noSmithyDocumentSerde
}

//	Provides statistics for the specified ImportID . CloudTrail does not update
//
// import statistics in real-time. Returned values for parameters such as
// EventsCompleted may be lower than the actual value, because CloudTrail updates
// statistics incrementally over the course of the import.
type ImportStatistics struct {

	//  The number of trail events imported into the event data store.
	EventsCompleted *int64

	//  The number of failed entries.
	FailedEntries *int64

	// The number of log files that completed import.
	FilesCompleted *int64

	//  The number of S3 prefixes that completed import.
	PrefixesCompleted *int64

	//  The number of S3 prefixes found for the import.
	PrefixesFound *int64

	noSmithyDocumentSerde
}

// A table showing information about the most recent successful and failed
// attempts to ingest events.
type IngestionStatus struct {

	// The event ID of the most recent attempt to ingest events.
	LatestIngestionAttemptEventID *string

	// The time stamp of the most recent attempt to ingest events on the channel.
	LatestIngestionAttemptTime *time.Time

	// The error code for the most recent failure to ingest events.
	LatestIngestionErrorCode *string

	// The event ID of the most recent successful ingestion of events.
	LatestIngestionSuccessEventID *string

	// The time stamp of the most recent successful ingestion of events for the
	// channel.
	LatestIngestionSuccessTime *time.Time

	noSmithyDocumentSerde
}

// A JSON string that contains a list of Insights types that are logged on a trail
// or event data store.
type InsightSelector struct {

	// The type of Insights events to log on a trail or event data store.
	// ApiCallRateInsight and ApiErrorRateInsight are valid Insight types.
	//
	// The ApiCallRateInsight Insights type analyzes write-only management API calls
	// that are aggregated per minute against a baseline API call volume.
	//
	// The ApiErrorRateInsight Insights type analyzes management API calls that result
	// in error codes. The error is shown if the API call is unsuccessful.
	InsightType InsightType

	noSmithyDocumentSerde
}

// Specifies an attribute and value that filter the events returned.
type LookupAttribute struct {

	// Specifies an attribute on which to filter the events returned.
	//
	// This member is required.
	AttributeKey LookupAttributeKey

	// Specifies a value for the specified AttributeKey .
	//
	// The maximum length for the AttributeValue is 2000 characters. The following
	// characters (' _ ', ' ', ' , ', ' \\n ') count as two characters towards the 2000
	// character limit.
	//
	// This member is required.
	AttributeValue *string

	noSmithyDocumentSerde
}

// Contains information about a partition key for an event data store.
type PartitionKey struct {

	// The name of the partition key.
	//
	// This member is required.
	Name *string

	// The data type of the partition key. For example, bigint or string .
	//
	// This member is required.
	Type *string

	noSmithyDocumentSerde
}

// Contains information about a returned public key.
type PublicKey struct {

	// The fingerprint of the public key.
	Fingerprint *string

	// The ending time of validity of the public key.
	ValidityEndTime *time.Time

	// The starting time of validity of the public key.
	ValidityStartTime *time.Time

	// The DER encoded public key value in PKCS#1 format.
	Value []byte

	noSmithyDocumentSerde
}

// A SQL string of criteria about events that you want to collect in an event data
// store.
type Query struct {

	// The creation time of a query.
	CreationTime *time.Time

	// The ID of a query.
	QueryId *string

	// The status of the query. This can be QUEUED , RUNNING , FINISHED , FAILED ,
	// TIMED_OUT , or CANCELLED .
	QueryStatus QueryStatus

	noSmithyDocumentSerde
}

// Metadata about a query, such as the number of results.
type QueryStatistics struct {

	// The total bytes that the query scanned in the event data store. This value
	// matches the number of bytes for which your account is billed for the query,
	// unless the query is still running.
	BytesScanned *int64

	// The number of results returned.
	ResultsCount *int32

	// The total number of results returned by a query.
	TotalResultsCount *int32

	noSmithyDocumentSerde
}

// Gets metadata about a query, including the number of events that were matched,
// the total number of events scanned, the query run time in milliseconds, and the
// query's creation time.
type QueryStatisticsForDescribeQuery struct {

	// The total bytes that the query scanned in the event data store. This value
	// matches the number of bytes for which your account is billed for the query,
	// unless the query is still running.
	BytesScanned *int64

	// The creation time of the query.
	CreationTime *time.Time

	// The number of events that matched a query.
	EventsMatched *int64

	// The number of events that the query scanned in the event data store.
	EventsScanned *int64

	// The query's run time, in milliseconds.
	ExecutionTimeInMillis *int32

	noSmithyDocumentSerde
}

// The schedule for a dashboard refresh.
type RefreshSchedule struct {

	//  The frequency at which you want the dashboard refreshed.
	Frequency *RefreshScheduleFrequency

	//  Specifies whether the refresh schedule is enabled. Set the value to ENABLED to
	// enable the refresh schedule, or to DISABLED to turn off the refresh schedule.
	Status RefreshScheduleStatus

	//  The time of day in UTC to run the schedule; for hourly only refer to minutes;
	// default is 00:00.
	TimeOfDay *string

	noSmithyDocumentSerde
}

//	Specifies the frequency for a dashboard refresh schedule.
//
// For a custom dashboard, you can schedule a refresh for every 1, 6, 12, or 24
// hours, or every day.
type RefreshScheduleFrequency struct {

	//  The unit to use for the refresh.
	//
	// For custom dashboards, the unit can be HOURS or DAYS .
	//
	// For the Highlights dashboard, the Unit must be HOURS .
	Unit RefreshScheduleFrequencyUnit

	//  The value for the refresh schedule.
	//
	// For custom dashboards, the following values are valid when the unit is HOURS : 1
	// , 6 , 12 , 24
	//
	// For custom dashboards, the only valid value when the unit is DAYS is 1 .
	//
	// For the Highlights dashboard, the Value must be 6 .
	Value *int32

	noSmithyDocumentSerde
}

// Contains information about a widget on a CloudTrail Lake dashboard.
type RequestWidget struct {

	//  The query statement for the widget. For custom dashboard widgets, you can
	// query across multiple event data stores as long as all event data stores exist
	// in your account.
	//
	// When a query uses ? with eventTime , ? must be surrounded by single quotes as
	// follows: '?' .
	//
	// This member is required.
	QueryStatement *string

	//  The view properties for the widget. For more information about view
	// properties, see [View properties for widgets]in the CloudTrail User Guide.
	//
	// [View properties for widgets]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-widget-properties.html
	//
	// This member is required.
	ViewProperties map[string]string

	//  The optional query parameters. The following query parameters are valid:
	// $StartTime$ , $EndTime$ , and $Period$ .
	QueryParameters []string

	noSmithyDocumentSerde
}

// Specifies the type and name of a resource referenced by an event.
type Resource struct {

	// The name of the resource referenced by the event returned. These are
	// user-created names whose values will depend on the environment. For example, the
	// resource name might be "auto-scaling-test-group" for an Auto Scaling Group or
	// "i-1234567" for an EC2 Instance.
	ResourceName *string

	// The type of a resource referenced by the event returned. When the resource type
	// cannot be determined, null is returned. Some examples of resource types are:
	// Instance for EC2, Trail for CloudTrail, DBInstance for Amazon RDS, and AccessKey
	// for IAM. To learn more about how to look up and filter events by the resource
	// types supported for a service, see [Filtering CloudTrail Events].
	//
	// [Filtering CloudTrail Events]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/view-cloudtrail-events-console.html#filtering-cloudtrail-events
	ResourceType *string

	noSmithyDocumentSerde
}

// A resource tag.
type ResourceTag struct {

	// Specifies the ARN of the resource.
	ResourceId *string

	// A list of tags.
	TagsList []Tag

	noSmithyDocumentSerde
}

// The settings for the source S3 bucket.
type S3ImportSource struct {

	//  The IAM ARN role used to access the source S3 bucket.
	//
	// This member is required.
	S3BucketAccessRoleArn *string

	//  The Region associated with the source S3 bucket.
	//
	// This member is required.
	S3BucketRegion *string

	//  The URI for the source S3 bucket.
	//
	// This member is required.
	S3LocationUri *string

	noSmithyDocumentSerde
}

// A search result returned by the SearchSampleQueries operation.
type SearchSampleQueriesSearchResult struct {

	//  A longer description of a sample query.
	Description *string

	//  The name of a sample query.
	Name *string

	//  A value between 0 and 1 indicating the similarity between the search phrase
	// and result.
	Relevance float32

	//  The SQL code of the sample query.
	SQL *string

	noSmithyDocumentSerde
}

// Contains configuration information about the channel.
type SourceConfig struct {

	//  The advanced event selectors that are configured for the channel.
	AdvancedEventSelectors []AdvancedEventSelector

	//  Specifies whether the channel applies to a single Region or to all Regions.
	ApplyToAllRegions *bool

	noSmithyDocumentSerde
}

// A custom key-value pair associated with a resource such as a CloudTrail trail,
// event data store, dashboard, or channel.
type Tag struct {

	// The key in a key-value pair. The key must be must be no longer than 128 Unicode
	// characters. The key must be unique for the resource to which it applies.
	//
	// This member is required.
	Key *string

	// The value in a key-value pair of a tag. The value must be no longer than 256
	// Unicode characters.
	Value *string

	noSmithyDocumentSerde
}

// The settings for a trail.
type Trail struct {

	// Specifies an Amazon Resource Name (ARN), a unique identifier that represents
	// the log group to which CloudTrail logs will be delivered.
	CloudWatchLogsLogGroupArn *string

	// Specifies the role for the CloudWatch Logs endpoint to assume to write to a
	// user's log group.
	CloudWatchLogsRoleArn *string

	// Specifies if the trail has custom event selectors.
	HasCustomEventSelectors *bool

	// Specifies whether a trail has insight types specified in an InsightSelector
	// list.
	HasInsightSelectors *bool

	// The Region in which the trail was created.
	HomeRegion *string

	// Set to True to include Amazon Web Services API calls from Amazon Web Services
	// global services such as IAM. Otherwise, False.
	IncludeGlobalServiceEvents *bool

	// Specifies whether the trail exists only in one Region or exists in all Regions.
	IsMultiRegionTrail *bool

	// Specifies whether the trail is an organization trail.
	IsOrganizationTrail *bool

	// Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The
	// value is a fully specified ARN to a KMS key in the following format.
	//
	//     arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
	KmsKeyId *string

	// Specifies whether log file validation is enabled.
	LogFileValidationEnabled *bool

	// Name of the trail set by calling CreateTrail. The maximum length is 128 characters.
	Name *string

	// Name of the Amazon S3 bucket into which CloudTrail delivers your trail files.
	// See [Amazon S3 Bucket naming rules].
	//
	// [Amazon S3 Bucket naming rules]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html
	S3BucketName *string

	// Specifies the Amazon S3 key prefix that comes after the name of the bucket you
	// have designated for log file delivery. For more information, see [Finding Your CloudTrail Log Files]. The maximum
	// length is 200 characters.
	//
	// [Finding Your CloudTrail Log Files]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/get-and-view-cloudtrail-log-files.html#cloudtrail-find-log-files
	S3KeyPrefix *string

	// Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send
	// notifications when log files are delivered. The following is the format of a
	// topic ARN.
	//
	//     arn:aws:sns:us-east-2:123456789012:MyTopic
	SnsTopicARN *string

	// This field is no longer in use. Use SnsTopicARN .
	//
	// Deprecated: This member has been deprecated.
	SnsTopicName *string

	// Specifies the ARN of the trail. The following is the format of a trail ARN.
	//
	//     arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	TrailARN *string

	noSmithyDocumentSerde
}

// Information about a CloudTrail trail, including the trail's name, home Region,
// and Amazon Resource Name (ARN).
type TrailInfo struct {

	// The Amazon Web Services Region in which a trail was created.
	HomeRegion *string

	// The name of a trail.
	Name *string

	// The ARN of a trail.
	TrailARN *string

	noSmithyDocumentSerde
}

// A widget on a CloudTrail Lake dashboard.
type Widget struct {

	// The query alias used to identify the query for the widget.
	QueryAlias *string

	//  The query parameters for the widget.
	QueryParameters []string

	//  The SQL query statement for the widget.
	QueryStatement *string

	//  The view properties for the widget. For more information about view
	// properties, see [View properties for widgets]in the CloudTrail User Guide..
	//
	// [View properties for widgets]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-widget-properties.html
	ViewProperties map[string]string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
