// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudwatch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudwatch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the anomaly detection models that you have created in your account. For
// single metric anomaly detectors, you can list all of the models in your account
// or filter the results to only the models that are related to a certain
// namespace, metric name, or metric dimension. For metric math anomaly detectors,
// you can list them by adding METRIC_MATH to the AnomalyDetectorTypes array. This
// will return all metric math anomaly detectors in your account.
func (c *Client) DescribeAnomalyDetectors(ctx context.Context, params *DescribeAnomalyDetectorsInput, optFns ...func(*Options)) (*DescribeAnomalyDetectorsOutput, error) {
	if params == nil {
		params = &DescribeAnomalyDetectorsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeAnomalyDetectors", params, optFns, c.addOperationDescribeAnomalyDetectorsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeAnomalyDetectorsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeAnomalyDetectorsInput struct {

	// The anomaly detector types to request when using DescribeAnomalyDetectorsInput .
	// If empty, defaults to SINGLE_METRIC .
	AnomalyDetectorTypes []types.AnomalyDetectorType

	// Limits the results to only the anomaly detection models that are associated
	// with the specified metric dimensions. If there are multiple metrics that have
	// these dimensions and have anomaly detection models associated, they're all
	// returned.
	Dimensions []types.Dimension

	// The maximum number of results to return in one operation. The maximum value
	// that you can specify is 100.
	//
	// To retrieve the remaining results, make another call with the returned NextToken
	// value.
	MaxResults *int32

	// Limits the results to only the anomaly detection models that are associated
	// with the specified metric name. If there are multiple metrics with this name in
	// different namespaces that have anomaly detection models, they're all returned.
	MetricName *string

	// Limits the results to only the anomaly detection models that are associated
	// with the specified namespace.
	Namespace *string

	// Use the token returned by the previous operation to request the next page of
	// results.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeAnomalyDetectorsOutput struct {

	// The list of anomaly detection models returned by the operation.
	AnomalyDetectors []types.AnomalyDetector

	// A token that you can use in a subsequent operation to retrieve the next set of
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeAnomalyDetectorsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpDescribeAnomalyDetectors{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpDescribeAnomalyDetectors{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeAnomalyDetectors"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeAnomalyDetectorsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeAnomalyDetectors(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// DescribeAnomalyDetectorsPaginatorOptions is the paginator options for
// DescribeAnomalyDetectors
type DescribeAnomalyDetectorsPaginatorOptions struct {
	// The maximum number of results to return in one operation. The maximum value
	// that you can specify is 100.
	//
	// To retrieve the remaining results, make another call with the returned NextToken
	// value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeAnomalyDetectorsPaginator is a paginator for DescribeAnomalyDetectors
type DescribeAnomalyDetectorsPaginator struct {
	options   DescribeAnomalyDetectorsPaginatorOptions
	client    DescribeAnomalyDetectorsAPIClient
	params    *DescribeAnomalyDetectorsInput
	nextToken *string
	firstPage bool
}

// NewDescribeAnomalyDetectorsPaginator returns a new
// DescribeAnomalyDetectorsPaginator
func NewDescribeAnomalyDetectorsPaginator(client DescribeAnomalyDetectorsAPIClient, params *DescribeAnomalyDetectorsInput, optFns ...func(*DescribeAnomalyDetectorsPaginatorOptions)) *DescribeAnomalyDetectorsPaginator {
	if params == nil {
		params = &DescribeAnomalyDetectorsInput{}
	}

	options := DescribeAnomalyDetectorsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeAnomalyDetectorsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeAnomalyDetectorsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeAnomalyDetectors page.
func (p *DescribeAnomalyDetectorsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeAnomalyDetectorsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeAnomalyDetectors(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeAnomalyDetectorsAPIClient is a client that implements the
// DescribeAnomalyDetectors operation.
type DescribeAnomalyDetectorsAPIClient interface {
	DescribeAnomalyDetectors(context.Context, *DescribeAnomalyDetectorsInput, ...func(*Options)) (*DescribeAnomalyDetectorsOutput, error)
}

var _ DescribeAnomalyDetectorsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeAnomalyDetectors(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeAnomalyDetectors",
	}
}
