// Code generated by smithy-go-codegen DO NOT EDIT.

package codebuild

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/codebuild/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// For an existing CodeBuild build project that has its source code stored in a
// GitHub or Bitbucket repository, enables CodeBuild to start rebuilding the source
// code every time a code change is pushed to the repository.
//
// If you enable webhooks for an CodeBuild project, and the project is used as a
// build step in CodePipeline, then two identical builds are created for each
// commit. One build is triggered through webhooks, and one through CodePipeline.
// Because billing is on a per-build basis, you are billed for both builds.
// Therefore, if you are using CodePipeline, we recommend that you disable webhooks
// in CodeBuild. In the CodeBuild console, clear the Webhook box. For more
// information, see step 5 in [Change a Build Project's Settings].
//
// [Change a Build Project's Settings]: https://docs.aws.amazon.com/codebuild/latest/userguide/change-project.html#change-project-console
func (c *Client) CreateWebhook(ctx context.Context, params *CreateWebhookInput, optFns ...func(*Options)) (*CreateWebhookOutput, error) {
	if params == nil {
		params = &CreateWebhookInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateWebhook", params, optFns, c.addOperationCreateWebhookMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateWebhookOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateWebhookInput struct {

	// The name of the CodeBuild project.
	//
	// This member is required.
	ProjectName *string

	// A regular expression used to determine which repository branches are built when
	// a webhook is triggered. If the name of a branch matches the regular expression,
	// then it is built. If branchFilter is empty, then all branches are built.
	//
	// It is recommended that you use filterGroups instead of branchFilter .
	BranchFilter *string

	// Specifies the type of build this webhook will trigger.
	//
	// RUNNER_BUILDKITE_BUILD is only available for NO_SOURCE source type projects
	// configured for Buildkite runner builds. For more information about
	// CodeBuild-hosted Buildkite runner builds, see [Tutorial: Configure a CodeBuild-hosted Buildkite runner]in the CodeBuild user guide.
	//
	// [Tutorial: Configure a CodeBuild-hosted Buildkite runner]: https://docs.aws.amazon.com/codebuild/latest/userguide/sample-runner-buildkite.html
	BuildType types.WebhookBuildType

	// An array of arrays of WebhookFilter objects used to determine which webhooks
	// are triggered. At least one WebhookFilter in the array must specify EVENT as
	// its type .
	//
	// For a build to be triggered, at least one filter group in the filterGroups
	// array must pass. For a filter group to pass, each of its filters must pass.
	FilterGroups [][]types.WebhookFilter

	// If manualCreation is true, CodeBuild doesn't create a webhook in GitHub and
	// instead returns payloadUrl and secret values for the webhook. The payloadUrl
	// and secret values in the output can be used to manually create a webhook within
	// GitHub.
	//
	// manualCreation is only available for GitHub webhooks.
	ManualCreation *bool

	// The scope configuration for global or organization webhooks.
	//
	// Global or organization webhooks are only available for GitHub and Github
	// Enterprise webhooks.
	ScopeConfiguration *types.ScopeConfiguration

	noSmithyDocumentSerde
}

type CreateWebhookOutput struct {

	// Information about a webhook that connects repository events to a build project
	// in CodeBuild.
	Webhook *types.Webhook

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateWebhookMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateWebhook{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateWebhook{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateWebhook"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateWebhookValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateWebhook(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateWebhook(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateWebhook",
	}
}
