// Code generated by smithy-go-codegen DO NOT EDIT.

package codepipeline

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/codepipeline/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"path"
)

type awsAwsjson11_serializeOpAcknowledgeJob struct {
}

func (*awsAwsjson11_serializeOpAcknowledgeJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAcknowledgeJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AcknowledgeJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.AcknowledgeJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAcknowledgeJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAcknowledgeThirdPartyJob struct {
}

func (*awsAwsjson11_serializeOpAcknowledgeThirdPartyJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAcknowledgeThirdPartyJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AcknowledgeThirdPartyJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.AcknowledgeThirdPartyJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAcknowledgeThirdPartyJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateCustomActionType struct {
}

func (*awsAwsjson11_serializeOpCreateCustomActionType) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateCustomActionType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCustomActionTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.CreateCustomActionType")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateCustomActionTypeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreatePipeline struct {
}

func (*awsAwsjson11_serializeOpCreatePipeline) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreatePipeline) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePipelineInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.CreatePipeline")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreatePipelineInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteCustomActionType struct {
}

func (*awsAwsjson11_serializeOpDeleteCustomActionType) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteCustomActionType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCustomActionTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.DeleteCustomActionType")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteCustomActionTypeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeletePipeline struct {
}

func (*awsAwsjson11_serializeOpDeletePipeline) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeletePipeline) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePipelineInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.DeletePipeline")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeletePipelineInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteWebhook struct {
}

func (*awsAwsjson11_serializeOpDeleteWebhook) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteWebhook) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteWebhookInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.DeleteWebhook")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteWebhookInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeregisterWebhookWithThirdParty struct {
}

func (*awsAwsjson11_serializeOpDeregisterWebhookWithThirdParty) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeregisterWebhookWithThirdParty) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeregisterWebhookWithThirdPartyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.DeregisterWebhookWithThirdParty")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeregisterWebhookWithThirdPartyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDisableStageTransition struct {
}

func (*awsAwsjson11_serializeOpDisableStageTransition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDisableStageTransition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableStageTransitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.DisableStageTransition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDisableStageTransitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpEnableStageTransition struct {
}

func (*awsAwsjson11_serializeOpEnableStageTransition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpEnableStageTransition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableStageTransitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.EnableStageTransition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentEnableStageTransitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetActionType struct {
}

func (*awsAwsjson11_serializeOpGetActionType) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetActionType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetActionTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.GetActionType")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetActionTypeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetJobDetails struct {
}

func (*awsAwsjson11_serializeOpGetJobDetails) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetJobDetails) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetJobDetailsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.GetJobDetails")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetJobDetailsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetPipeline struct {
}

func (*awsAwsjson11_serializeOpGetPipeline) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetPipeline) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPipelineInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.GetPipeline")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetPipelineInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetPipelineExecution struct {
}

func (*awsAwsjson11_serializeOpGetPipelineExecution) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetPipelineExecution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPipelineExecutionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.GetPipelineExecution")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetPipelineExecutionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetPipelineState struct {
}

func (*awsAwsjson11_serializeOpGetPipelineState) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetPipelineState) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPipelineStateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.GetPipelineState")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetPipelineStateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetThirdPartyJobDetails struct {
}

func (*awsAwsjson11_serializeOpGetThirdPartyJobDetails) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetThirdPartyJobDetails) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetThirdPartyJobDetailsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.GetThirdPartyJobDetails")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetThirdPartyJobDetailsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListActionExecutions struct {
}

func (*awsAwsjson11_serializeOpListActionExecutions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListActionExecutions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListActionExecutionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.ListActionExecutions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListActionExecutionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListActionTypes struct {
}

func (*awsAwsjson11_serializeOpListActionTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListActionTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListActionTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.ListActionTypes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListActionTypesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListPipelineExecutions struct {
}

func (*awsAwsjson11_serializeOpListPipelineExecutions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListPipelineExecutions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPipelineExecutionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.ListPipelineExecutions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListPipelineExecutionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListPipelines struct {
}

func (*awsAwsjson11_serializeOpListPipelines) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListPipelines) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPipelinesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.ListPipelines")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListPipelinesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListRuleExecutions struct {
}

func (*awsAwsjson11_serializeOpListRuleExecutions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListRuleExecutions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRuleExecutionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.ListRuleExecutions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListRuleExecutionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListRuleTypes struct {
}

func (*awsAwsjson11_serializeOpListRuleTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListRuleTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRuleTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.ListRuleTypes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListRuleTypesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListTagsForResource struct {
}

func (*awsAwsjson11_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.ListTagsForResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListWebhooks struct {
}

func (*awsAwsjson11_serializeOpListWebhooks) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListWebhooks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListWebhooksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.ListWebhooks")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListWebhooksInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpOverrideStageCondition struct {
}

func (*awsAwsjson11_serializeOpOverrideStageCondition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpOverrideStageCondition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*OverrideStageConditionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.OverrideStageCondition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentOverrideStageConditionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPollForJobs struct {
}

func (*awsAwsjson11_serializeOpPollForJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPollForJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PollForJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.PollForJobs")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPollForJobsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPollForThirdPartyJobs struct {
}

func (*awsAwsjson11_serializeOpPollForThirdPartyJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPollForThirdPartyJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PollForThirdPartyJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.PollForThirdPartyJobs")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPollForThirdPartyJobsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutActionRevision struct {
}

func (*awsAwsjson11_serializeOpPutActionRevision) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutActionRevision) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutActionRevisionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.PutActionRevision")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutActionRevisionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutApprovalResult struct {
}

func (*awsAwsjson11_serializeOpPutApprovalResult) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutApprovalResult) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutApprovalResultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.PutApprovalResult")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutApprovalResultInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutJobFailureResult struct {
}

func (*awsAwsjson11_serializeOpPutJobFailureResult) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutJobFailureResult) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutJobFailureResultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.PutJobFailureResult")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutJobFailureResultInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutJobSuccessResult struct {
}

func (*awsAwsjson11_serializeOpPutJobSuccessResult) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutJobSuccessResult) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutJobSuccessResultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.PutJobSuccessResult")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutJobSuccessResultInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutThirdPartyJobFailureResult struct {
}

func (*awsAwsjson11_serializeOpPutThirdPartyJobFailureResult) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutThirdPartyJobFailureResult) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutThirdPartyJobFailureResultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.PutThirdPartyJobFailureResult")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutThirdPartyJobFailureResultInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutThirdPartyJobSuccessResult struct {
}

func (*awsAwsjson11_serializeOpPutThirdPartyJobSuccessResult) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutThirdPartyJobSuccessResult) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutThirdPartyJobSuccessResultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.PutThirdPartyJobSuccessResult")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutThirdPartyJobSuccessResultInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutWebhook struct {
}

func (*awsAwsjson11_serializeOpPutWebhook) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutWebhook) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutWebhookInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.PutWebhook")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutWebhookInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRegisterWebhookWithThirdParty struct {
}

func (*awsAwsjson11_serializeOpRegisterWebhookWithThirdParty) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRegisterWebhookWithThirdParty) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterWebhookWithThirdPartyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.RegisterWebhookWithThirdParty")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRegisterWebhookWithThirdPartyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRetryStageExecution struct {
}

func (*awsAwsjson11_serializeOpRetryStageExecution) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRetryStageExecution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RetryStageExecutionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.RetryStageExecution")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRetryStageExecutionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRollbackStage struct {
}

func (*awsAwsjson11_serializeOpRollbackStage) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRollbackStage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RollbackStageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.RollbackStage")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRollbackStageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartPipelineExecution struct {
}

func (*awsAwsjson11_serializeOpStartPipelineExecution) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartPipelineExecution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartPipelineExecutionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.StartPipelineExecution")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartPipelineExecutionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStopPipelineExecution struct {
}

func (*awsAwsjson11_serializeOpStopPipelineExecution) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStopPipelineExecution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopPipelineExecutionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.StopPipelineExecution")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStopPipelineExecutionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpTagResource struct {
}

func (*awsAwsjson11_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.TagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUntagResource struct {
}

func (*awsAwsjson11_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.UntagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateActionType struct {
}

func (*awsAwsjson11_serializeOpUpdateActionType) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateActionType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateActionTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.UpdateActionType")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateActionTypeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdatePipeline struct {
}

func (*awsAwsjson11_serializeOpUpdatePipeline) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdatePipeline) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePipelineInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("CodePipeline_20150709.UpdatePipeline")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdatePipelineInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsAwsjson11_serializeDocumentActionConfigurationMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentActionConfigurationProperty(v *types.ActionConfigurationProperty, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	{
		ok := object.Key("key")
		ok.Boolean(v.Key)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Queryable {
		ok := object.Key("queryable")
		ok.Boolean(v.Queryable)
	}

	{
		ok := object.Key("required")
		ok.Boolean(v.Required)
	}

	{
		ok := object.Key("secret")
		ok.Boolean(v.Secret)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentActionConfigurationPropertyList(v []types.ActionConfigurationProperty, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentActionConfigurationProperty(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentActionDeclaration(v *types.ActionDeclaration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionTypeId != nil {
		ok := object.Key("actionTypeId")
		if err := awsAwsjson11_serializeDocumentActionTypeId(v.ActionTypeId, ok); err != nil {
			return err
		}
	}

	if v.Commands != nil {
		ok := object.Key("commands")
		if err := awsAwsjson11_serializeDocumentCommandList(v.Commands, ok); err != nil {
			return err
		}
	}

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsAwsjson11_serializeDocumentActionConfigurationMap(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.EnvironmentVariables != nil {
		ok := object.Key("environmentVariables")
		if err := awsAwsjson11_serializeDocumentEnvironmentVariableList(v.EnvironmentVariables, ok); err != nil {
			return err
		}
	}

	if v.InputArtifacts != nil {
		ok := object.Key("inputArtifacts")
		if err := awsAwsjson11_serializeDocumentInputArtifactList(v.InputArtifacts, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Namespace != nil {
		ok := object.Key("namespace")
		ok.String(*v.Namespace)
	}

	if v.OutputArtifacts != nil {
		ok := object.Key("outputArtifacts")
		if err := awsAwsjson11_serializeDocumentOutputArtifactList(v.OutputArtifacts, ok); err != nil {
			return err
		}
	}

	if v.OutputVariables != nil {
		ok := object.Key("outputVariables")
		if err := awsAwsjson11_serializeDocumentOutputVariableList(v.OutputVariables, ok); err != nil {
			return err
		}
	}

	if v.Region != nil {
		ok := object.Key("region")
		ok.String(*v.Region)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.RunOrder != nil {
		ok := object.Key("runOrder")
		ok.Integer(*v.RunOrder)
	}

	if v.TimeoutInMinutes != nil {
		ok := object.Key("timeoutInMinutes")
		ok.Integer(*v.TimeoutInMinutes)
	}

	return nil
}

func awsAwsjson11_serializeDocumentActionExecutionFilter(v *types.ActionExecutionFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LatestInPipelineExecution != nil {
		ok := object.Key("latestInPipelineExecution")
		if err := awsAwsjson11_serializeDocumentLatestInPipelineExecutionFilter(v.LatestInPipelineExecution, ok); err != nil {
			return err
		}
	}

	if v.PipelineExecutionId != nil {
		ok := object.Key("pipelineExecutionId")
		ok.String(*v.PipelineExecutionId)
	}

	return nil
}

func awsAwsjson11_serializeDocumentActionRevision(v *types.ActionRevision, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Created != nil {
		ok := object.Key("created")
		ok.Double(smithytime.FormatEpochSeconds(*v.Created))
	}

	if v.RevisionChangeId != nil {
		ok := object.Key("revisionChangeId")
		ok.String(*v.RevisionChangeId)
	}

	if v.RevisionId != nil {
		ok := object.Key("revisionId")
		ok.String(*v.RevisionId)
	}

	return nil
}

func awsAwsjson11_serializeDocumentActionTypeArtifactDetails(v *types.ActionTypeArtifactDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("maximumCount")
		ok.Integer(v.MaximumCount)
	}

	{
		ok := object.Key("minimumCount")
		ok.Integer(v.MinimumCount)
	}

	return nil
}

func awsAwsjson11_serializeDocumentActionTypeDeclaration(v *types.ActionTypeDeclaration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Executor != nil {
		ok := object.Key("executor")
		if err := awsAwsjson11_serializeDocumentActionTypeExecutor(v.Executor, ok); err != nil {
			return err
		}
	}

	if v.Id != nil {
		ok := object.Key("id")
		if err := awsAwsjson11_serializeDocumentActionTypeIdentifier(v.Id, ok); err != nil {
			return err
		}
	}

	if v.InputArtifactDetails != nil {
		ok := object.Key("inputArtifactDetails")
		if err := awsAwsjson11_serializeDocumentActionTypeArtifactDetails(v.InputArtifactDetails, ok); err != nil {
			return err
		}
	}

	if v.OutputArtifactDetails != nil {
		ok := object.Key("outputArtifactDetails")
		if err := awsAwsjson11_serializeDocumentActionTypeArtifactDetails(v.OutputArtifactDetails, ok); err != nil {
			return err
		}
	}

	if v.Permissions != nil {
		ok := object.Key("permissions")
		if err := awsAwsjson11_serializeDocumentActionTypePermissions(v.Permissions, ok); err != nil {
			return err
		}
	}

	if v.Properties != nil {
		ok := object.Key("properties")
		if err := awsAwsjson11_serializeDocumentActionTypeProperties(v.Properties, ok); err != nil {
			return err
		}
	}

	if v.Urls != nil {
		ok := object.Key("urls")
		if err := awsAwsjson11_serializeDocumentActionTypeUrls(v.Urls, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentActionTypeExecutor(v *types.ActionTypeExecutor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsAwsjson11_serializeDocumentExecutorConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.JobTimeout != nil {
		ok := object.Key("jobTimeout")
		ok.Integer(*v.JobTimeout)
	}

	if v.PolicyStatementsTemplate != nil {
		ok := object.Key("policyStatementsTemplate")
		ok.String(*v.PolicyStatementsTemplate)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentActionTypeId(v *types.ActionTypeId, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Category) > 0 {
		ok := object.Key("category")
		ok.String(string(v.Category))
	}

	if len(v.Owner) > 0 {
		ok := object.Key("owner")
		ok.String(string(v.Owner))
	}

	if v.Provider != nil {
		ok := object.Key("provider")
		ok.String(*v.Provider)
	}

	if v.Version != nil {
		ok := object.Key("version")
		ok.String(*v.Version)
	}

	return nil
}

func awsAwsjson11_serializeDocumentActionTypeIdentifier(v *types.ActionTypeIdentifier, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Category) > 0 {
		ok := object.Key("category")
		ok.String(string(v.Category))
	}

	if v.Owner != nil {
		ok := object.Key("owner")
		ok.String(*v.Owner)
	}

	if v.Provider != nil {
		ok := object.Key("provider")
		ok.String(*v.Provider)
	}

	if v.Version != nil {
		ok := object.Key("version")
		ok.String(*v.Version)
	}

	return nil
}

func awsAwsjson11_serializeDocumentActionTypePermissions(v *types.ActionTypePermissions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedAccounts != nil {
		ok := object.Key("allowedAccounts")
		if err := awsAwsjson11_serializeDocumentAllowedAccounts(v.AllowedAccounts, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentActionTypeProperties(v []types.ActionTypeProperty, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentActionTypeProperty(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentActionTypeProperty(v *types.ActionTypeProperty, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	{
		ok := object.Key("key")
		ok.Boolean(v.Key)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	{
		ok := object.Key("noEcho")
		ok.Boolean(v.NoEcho)
	}

	{
		ok := object.Key("optional")
		ok.Boolean(v.Optional)
	}

	if v.Queryable {
		ok := object.Key("queryable")
		ok.Boolean(v.Queryable)
	}

	return nil
}

func awsAwsjson11_serializeDocumentActionTypeSettings(v *types.ActionTypeSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EntityUrlTemplate != nil {
		ok := object.Key("entityUrlTemplate")
		ok.String(*v.EntityUrlTemplate)
	}

	if v.ExecutionUrlTemplate != nil {
		ok := object.Key("executionUrlTemplate")
		ok.String(*v.ExecutionUrlTemplate)
	}

	if v.RevisionUrlTemplate != nil {
		ok := object.Key("revisionUrlTemplate")
		ok.String(*v.RevisionUrlTemplate)
	}

	if v.ThirdPartyConfigurationUrl != nil {
		ok := object.Key("thirdPartyConfigurationUrl")
		ok.String(*v.ThirdPartyConfigurationUrl)
	}

	return nil
}

func awsAwsjson11_serializeDocumentActionTypeUrls(v *types.ActionTypeUrls, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfigurationUrl != nil {
		ok := object.Key("configurationUrl")
		ok.String(*v.ConfigurationUrl)
	}

	if v.EntityUrlTemplate != nil {
		ok := object.Key("entityUrlTemplate")
		ok.String(*v.EntityUrlTemplate)
	}

	if v.ExecutionUrlTemplate != nil {
		ok := object.Key("executionUrlTemplate")
		ok.String(*v.ExecutionUrlTemplate)
	}

	if v.RevisionUrlTemplate != nil {
		ok := object.Key("revisionUrlTemplate")
		ok.String(*v.RevisionUrlTemplate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAllowedAccounts(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentApprovalResult(v *types.ApprovalResult, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	if v.Summary != nil {
		ok := object.Key("summary")
		ok.String(*v.Summary)
	}

	return nil
}

func awsAwsjson11_serializeDocumentArtifactDetails(v *types.ArtifactDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("maximumCount")
		ok.Integer(v.MaximumCount)
	}

	{
		ok := object.Key("minimumCount")
		ok.Integer(v.MinimumCount)
	}

	return nil
}

func awsAwsjson11_serializeDocumentArtifactStore(v *types.ArtifactStore, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncryptionKey != nil {
		ok := object.Key("encryptionKey")
		if err := awsAwsjson11_serializeDocumentEncryptionKey(v.EncryptionKey, ok); err != nil {
			return err
		}
	}

	if v.Location != nil {
		ok := object.Key("location")
		ok.String(*v.Location)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentArtifactStoreMap(v map[string]types.ArtifactStore, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsAwsjson11_serializeDocumentArtifactStore(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentBeforeEntryConditions(v *types.BeforeEntryConditions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Conditions != nil {
		ok := object.Key("conditions")
		if err := awsAwsjson11_serializeDocumentConditionList(v.Conditions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentBlockerDeclaration(v *types.BlockerDeclaration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentCommandList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentCondition(v *types.Condition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Result) > 0 {
		ok := object.Key("result")
		ok.String(string(v.Result))
	}

	if v.Rules != nil {
		ok := object.Key("rules")
		if err := awsAwsjson11_serializeDocumentRuleDeclarationList(v.Rules, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentConditionList(v []types.Condition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentCondition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentCurrentRevision(v *types.CurrentRevision, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChangeIdentifier != nil {
		ok := object.Key("changeIdentifier")
		ok.String(*v.ChangeIdentifier)
	}

	if v.Created != nil {
		ok := object.Key("created")
		ok.Double(smithytime.FormatEpochSeconds(*v.Created))
	}

	if v.Revision != nil {
		ok := object.Key("revision")
		ok.String(*v.Revision)
	}

	if v.RevisionSummary != nil {
		ok := object.Key("revisionSummary")
		ok.String(*v.RevisionSummary)
	}

	return nil
}

func awsAwsjson11_serializeDocumentEncryptionKey(v *types.EncryptionKey, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentEnvironmentVariable(v *types.EnvironmentVariable, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentEnvironmentVariableList(v []types.EnvironmentVariable, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentEnvironmentVariable(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentExecutionDetails(v *types.ExecutionDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExternalExecutionId != nil {
		ok := object.Key("externalExecutionId")
		ok.String(*v.ExternalExecutionId)
	}

	if v.PercentComplete != nil {
		ok := object.Key("percentComplete")
		ok.Integer(*v.PercentComplete)
	}

	if v.Summary != nil {
		ok := object.Key("summary")
		ok.String(*v.Summary)
	}

	return nil
}

func awsAwsjson11_serializeDocumentExecutorConfiguration(v *types.ExecutorConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobWorkerExecutorConfiguration != nil {
		ok := object.Key("jobWorkerExecutorConfiguration")
		if err := awsAwsjson11_serializeDocumentJobWorkerExecutorConfiguration(v.JobWorkerExecutorConfiguration, ok); err != nil {
			return err
		}
	}

	if v.LambdaExecutorConfiguration != nil {
		ok := object.Key("lambdaExecutorConfiguration")
		if err := awsAwsjson11_serializeDocumentLambdaExecutorConfiguration(v.LambdaExecutorConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentFailureConditions(v *types.FailureConditions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Conditions != nil {
		ok := object.Key("conditions")
		if err := awsAwsjson11_serializeDocumentConditionList(v.Conditions, ok); err != nil {
			return err
		}
	}

	if len(v.Result) > 0 {
		ok := object.Key("result")
		ok.String(string(v.Result))
	}

	if v.RetryConfiguration != nil {
		ok := object.Key("retryConfiguration")
		if err := awsAwsjson11_serializeDocumentRetryConfiguration(v.RetryConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentFailureDetails(v *types.FailureDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExternalExecutionId != nil {
		ok := object.Key("externalExecutionId")
		ok.String(*v.ExternalExecutionId)
	}

	if v.Message != nil {
		ok := object.Key("message")
		ok.String(*v.Message)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentFilePathList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentGitBranchFilterCriteria(v *types.GitBranchFilterCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Excludes != nil {
		ok := object.Key("excludes")
		if err := awsAwsjson11_serializeDocumentGitBranchPatternList(v.Excludes, ok); err != nil {
			return err
		}
	}

	if v.Includes != nil {
		ok := object.Key("includes")
		if err := awsAwsjson11_serializeDocumentGitBranchPatternList(v.Includes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentGitBranchPatternList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentGitConfiguration(v *types.GitConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PullRequest != nil {
		ok := object.Key("pullRequest")
		if err := awsAwsjson11_serializeDocumentGitPullRequestFilterList(v.PullRequest, ok); err != nil {
			return err
		}
	}

	if v.Push != nil {
		ok := object.Key("push")
		if err := awsAwsjson11_serializeDocumentGitPushFilterList(v.Push, ok); err != nil {
			return err
		}
	}

	if v.SourceActionName != nil {
		ok := object.Key("sourceActionName")
		ok.String(*v.SourceActionName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentGitFilePathFilterCriteria(v *types.GitFilePathFilterCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Excludes != nil {
		ok := object.Key("excludes")
		if err := awsAwsjson11_serializeDocumentGitFilePathPatternList(v.Excludes, ok); err != nil {
			return err
		}
	}

	if v.Includes != nil {
		ok := object.Key("includes")
		if err := awsAwsjson11_serializeDocumentGitFilePathPatternList(v.Includes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentGitFilePathPatternList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentGitPullRequestEventTypeList(v []types.GitPullRequestEventType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentGitPullRequestFilter(v *types.GitPullRequestFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Branches != nil {
		ok := object.Key("branches")
		if err := awsAwsjson11_serializeDocumentGitBranchFilterCriteria(v.Branches, ok); err != nil {
			return err
		}
	}

	if v.Events != nil {
		ok := object.Key("events")
		if err := awsAwsjson11_serializeDocumentGitPullRequestEventTypeList(v.Events, ok); err != nil {
			return err
		}
	}

	if v.FilePaths != nil {
		ok := object.Key("filePaths")
		if err := awsAwsjson11_serializeDocumentGitFilePathFilterCriteria(v.FilePaths, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentGitPullRequestFilterList(v []types.GitPullRequestFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentGitPullRequestFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentGitPushFilter(v *types.GitPushFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Branches != nil {
		ok := object.Key("branches")
		if err := awsAwsjson11_serializeDocumentGitBranchFilterCriteria(v.Branches, ok); err != nil {
			return err
		}
	}

	if v.FilePaths != nil {
		ok := object.Key("filePaths")
		if err := awsAwsjson11_serializeDocumentGitFilePathFilterCriteria(v.FilePaths, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson11_serializeDocumentGitTagFilterCriteria(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentGitPushFilterList(v []types.GitPushFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentGitPushFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentGitTagFilterCriteria(v *types.GitTagFilterCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Excludes != nil {
		ok := object.Key("excludes")
		if err := awsAwsjson11_serializeDocumentGitTagPatternList(v.Excludes, ok); err != nil {
			return err
		}
	}

	if v.Includes != nil {
		ok := object.Key("includes")
		if err := awsAwsjson11_serializeDocumentGitTagPatternList(v.Includes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentGitTagPatternList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentInputArtifact(v *types.InputArtifact, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputArtifactList(v []types.InputArtifact, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentInputArtifact(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentJobWorkerExecutorConfiguration(v *types.JobWorkerExecutorConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PollingAccounts != nil {
		ok := object.Key("pollingAccounts")
		if err := awsAwsjson11_serializeDocumentPollingAccountList(v.PollingAccounts, ok); err != nil {
			return err
		}
	}

	if v.PollingServicePrincipals != nil {
		ok := object.Key("pollingServicePrincipals")
		if err := awsAwsjson11_serializeDocumentPollingServicePrincipalList(v.PollingServicePrincipals, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentLambdaExecutorConfiguration(v *types.LambdaExecutorConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LambdaFunctionArn != nil {
		ok := object.Key("lambdaFunctionArn")
		ok.String(*v.LambdaFunctionArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentLatestInPipelineExecutionFilter(v *types.LatestInPipelineExecutionFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PipelineExecutionId != nil {
		ok := object.Key("pipelineExecutionId")
		ok.String(*v.PipelineExecutionId)
	}

	if len(v.StartTimeRange) > 0 {
		ok := object.Key("startTimeRange")
		ok.String(string(v.StartTimeRange))
	}

	return nil
}

func awsAwsjson11_serializeDocumentOutputArtifact(v *types.OutputArtifact, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Files != nil {
		ok := object.Key("files")
		if err := awsAwsjson11_serializeDocumentFilePathList(v.Files, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOutputArtifactList(v []types.OutputArtifact, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentOutputArtifact(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentOutputVariableList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentOutputVariablesMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentPipelineDeclaration(v *types.PipelineDeclaration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ArtifactStore != nil {
		ok := object.Key("artifactStore")
		if err := awsAwsjson11_serializeDocumentArtifactStore(v.ArtifactStore, ok); err != nil {
			return err
		}
	}

	if v.ArtifactStores != nil {
		ok := object.Key("artifactStores")
		if err := awsAwsjson11_serializeDocumentArtifactStoreMap(v.ArtifactStores, ok); err != nil {
			return err
		}
	}

	if len(v.ExecutionMode) > 0 {
		ok := object.Key("executionMode")
		ok.String(string(v.ExecutionMode))
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.PipelineType) > 0 {
		ok := object.Key("pipelineType")
		ok.String(string(v.PipelineType))
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Stages != nil {
		ok := object.Key("stages")
		if err := awsAwsjson11_serializeDocumentPipelineStageDeclarationList(v.Stages, ok); err != nil {
			return err
		}
	}

	if v.Triggers != nil {
		ok := object.Key("triggers")
		if err := awsAwsjson11_serializeDocumentPipelineTriggerDeclarationList(v.Triggers, ok); err != nil {
			return err
		}
	}

	if v.Variables != nil {
		ok := object.Key("variables")
		if err := awsAwsjson11_serializeDocumentPipelineVariableDeclarationList(v.Variables, ok); err != nil {
			return err
		}
	}

	if v.Version != nil {
		ok := object.Key("version")
		ok.Integer(*v.Version)
	}

	return nil
}

func awsAwsjson11_serializeDocumentPipelineExecutionFilter(v *types.PipelineExecutionFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SucceededInStage != nil {
		ok := object.Key("succeededInStage")
		if err := awsAwsjson11_serializeDocumentSucceededInStageFilter(v.SucceededInStage, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentPipelineStageDeclarationList(v []types.StageDeclaration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentStageDeclaration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentPipelineTriggerDeclaration(v *types.PipelineTriggerDeclaration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GitConfiguration != nil {
		ok := object.Key("gitConfiguration")
		if err := awsAwsjson11_serializeDocumentGitConfiguration(v.GitConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.ProviderType) > 0 {
		ok := object.Key("providerType")
		ok.String(string(v.ProviderType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentPipelineTriggerDeclarationList(v []types.PipelineTriggerDeclaration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPipelineTriggerDeclaration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentPipelineVariable(v *types.PipelineVariable, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentPipelineVariableDeclaration(v *types.PipelineVariableDeclaration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultValue != nil {
		ok := object.Key("defaultValue")
		ok.String(*v.DefaultValue)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentPipelineVariableDeclarationList(v []types.PipelineVariableDeclaration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPipelineVariableDeclaration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentPipelineVariableList(v []types.PipelineVariable, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPipelineVariable(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentPollingAccountList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentPollingServicePrincipalList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentQueryParamMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentRetryConfiguration(v *types.RetryConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.RetryMode) > 0 {
		ok := object.Key("retryMode")
		ok.String(string(v.RetryMode))
	}

	return nil
}

func awsAwsjson11_serializeDocumentRuleConfigurationMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentRuleDeclaration(v *types.RuleDeclaration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Commands != nil {
		ok := object.Key("commands")
		if err := awsAwsjson11_serializeDocumentCommandList(v.Commands, ok); err != nil {
			return err
		}
	}

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsAwsjson11_serializeDocumentRuleConfigurationMap(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.InputArtifacts != nil {
		ok := object.Key("inputArtifacts")
		if err := awsAwsjson11_serializeDocumentInputArtifactList(v.InputArtifacts, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Region != nil {
		ok := object.Key("region")
		ok.String(*v.Region)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.RuleTypeId != nil {
		ok := object.Key("ruleTypeId")
		if err := awsAwsjson11_serializeDocumentRuleTypeId(v.RuleTypeId, ok); err != nil {
			return err
		}
	}

	if v.TimeoutInMinutes != nil {
		ok := object.Key("timeoutInMinutes")
		ok.Integer(*v.TimeoutInMinutes)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRuleDeclarationList(v []types.RuleDeclaration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentRuleDeclaration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentRuleExecutionFilter(v *types.RuleExecutionFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LatestInPipelineExecution != nil {
		ok := object.Key("latestInPipelineExecution")
		if err := awsAwsjson11_serializeDocumentLatestInPipelineExecutionFilter(v.LatestInPipelineExecution, ok); err != nil {
			return err
		}
	}

	if v.PipelineExecutionId != nil {
		ok := object.Key("pipelineExecutionId")
		ok.String(*v.PipelineExecutionId)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRuleTypeId(v *types.RuleTypeId, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Category) > 0 {
		ok := object.Key("category")
		ok.String(string(v.Category))
	}

	if len(v.Owner) > 0 {
		ok := object.Key("owner")
		ok.String(string(v.Owner))
	}

	if v.Provider != nil {
		ok := object.Key("provider")
		ok.String(*v.Provider)
	}

	if v.Version != nil {
		ok := object.Key("version")
		ok.String(*v.Version)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSourceRevisionOverride(v *types.SourceRevisionOverride, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionName != nil {
		ok := object.Key("actionName")
		ok.String(*v.ActionName)
	}

	if len(v.RevisionType) > 0 {
		ok := object.Key("revisionType")
		ok.String(string(v.RevisionType))
	}

	if v.RevisionValue != nil {
		ok := object.Key("revisionValue")
		ok.String(*v.RevisionValue)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSourceRevisionOverrideList(v []types.SourceRevisionOverride, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentSourceRevisionOverride(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentStageActionDeclarationList(v []types.ActionDeclaration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentActionDeclaration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentStageBlockerDeclarationList(v []types.BlockerDeclaration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentBlockerDeclaration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentStageDeclaration(v *types.StageDeclaration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("actions")
		if err := awsAwsjson11_serializeDocumentStageActionDeclarationList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.BeforeEntry != nil {
		ok := object.Key("beforeEntry")
		if err := awsAwsjson11_serializeDocumentBeforeEntryConditions(v.BeforeEntry, ok); err != nil {
			return err
		}
	}

	if v.Blockers != nil {
		ok := object.Key("blockers")
		if err := awsAwsjson11_serializeDocumentStageBlockerDeclarationList(v.Blockers, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.OnFailure != nil {
		ok := object.Key("onFailure")
		if err := awsAwsjson11_serializeDocumentFailureConditions(v.OnFailure, ok); err != nil {
			return err
		}
	}

	if v.OnSuccess != nil {
		ok := object.Key("onSuccess")
		if err := awsAwsjson11_serializeDocumentSuccessConditions(v.OnSuccess, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSucceededInStageFilter(v *types.SucceededInStageFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StageName != nil {
		ok := object.Key("stageName")
		ok.String(*v.StageName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSuccessConditions(v *types.SuccessConditions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Conditions != nil {
		ok := object.Key("conditions")
		if err := awsAwsjson11_serializeDocumentConditionList(v.Conditions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentWebhookAuthConfiguration(v *types.WebhookAuthConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedIPRange != nil {
		ok := object.Key("AllowedIPRange")
		ok.String(*v.AllowedIPRange)
	}

	if v.SecretToken != nil {
		ok := object.Key("SecretToken")
		ok.String(*v.SecretToken)
	}

	return nil
}

func awsAwsjson11_serializeDocumentWebhookDefinition(v *types.WebhookDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Authentication) > 0 {
		ok := object.Key("authentication")
		ok.String(string(v.Authentication))
	}

	if v.AuthenticationConfiguration != nil {
		ok := object.Key("authenticationConfiguration")
		if err := awsAwsjson11_serializeDocumentWebhookAuthConfiguration(v.AuthenticationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsAwsjson11_serializeDocumentWebhookFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.TargetAction != nil {
		ok := object.Key("targetAction")
		ok.String(*v.TargetAction)
	}

	if v.TargetPipeline != nil {
		ok := object.Key("targetPipeline")
		ok.String(*v.TargetPipeline)
	}

	return nil
}

func awsAwsjson11_serializeDocumentWebhookFilterRule(v *types.WebhookFilterRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JsonPath != nil {
		ok := object.Key("jsonPath")
		ok.String(*v.JsonPath)
	}

	if v.MatchEquals != nil {
		ok := object.Key("matchEquals")
		ok.String(*v.MatchEquals)
	}

	return nil
}

func awsAwsjson11_serializeDocumentWebhookFilters(v []types.WebhookFilterRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentWebhookFilterRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeOpDocumentAcknowledgeJobInput(v *AcknowledgeJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("jobId")
		ok.String(*v.JobId)
	}

	if v.Nonce != nil {
		ok := object.Key("nonce")
		ok.String(*v.Nonce)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAcknowledgeThirdPartyJobInput(v *AcknowledgeThirdPartyJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.JobId != nil {
		ok := object.Key("jobId")
		ok.String(*v.JobId)
	}

	if v.Nonce != nil {
		ok := object.Key("nonce")
		ok.String(*v.Nonce)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateCustomActionTypeInput(v *CreateCustomActionTypeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Category) > 0 {
		ok := object.Key("category")
		ok.String(string(v.Category))
	}

	if v.ConfigurationProperties != nil {
		ok := object.Key("configurationProperties")
		if err := awsAwsjson11_serializeDocumentActionConfigurationPropertyList(v.ConfigurationProperties, ok); err != nil {
			return err
		}
	}

	if v.InputArtifactDetails != nil {
		ok := object.Key("inputArtifactDetails")
		if err := awsAwsjson11_serializeDocumentArtifactDetails(v.InputArtifactDetails, ok); err != nil {
			return err
		}
	}

	if v.OutputArtifactDetails != nil {
		ok := object.Key("outputArtifactDetails")
		if err := awsAwsjson11_serializeDocumentArtifactDetails(v.OutputArtifactDetails, ok); err != nil {
			return err
		}
	}

	if v.Provider != nil {
		ok := object.Key("provider")
		ok.String(*v.Provider)
	}

	if v.Settings != nil {
		ok := object.Key("settings")
		if err := awsAwsjson11_serializeDocumentActionTypeSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Version != nil {
		ok := object.Key("version")
		ok.String(*v.Version)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreatePipelineInput(v *CreatePipelineInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Pipeline != nil {
		ok := object.Key("pipeline")
		if err := awsAwsjson11_serializeDocumentPipelineDeclaration(v.Pipeline, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteCustomActionTypeInput(v *DeleteCustomActionTypeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Category) > 0 {
		ok := object.Key("category")
		ok.String(string(v.Category))
	}

	if v.Provider != nil {
		ok := object.Key("provider")
		ok.String(*v.Provider)
	}

	if v.Version != nil {
		ok := object.Key("version")
		ok.String(*v.Version)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeletePipelineInput(v *DeletePipelineInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteWebhookInput(v *DeleteWebhookInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeregisterWebhookWithThirdPartyInput(v *DeregisterWebhookWithThirdPartyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WebhookName != nil {
		ok := object.Key("webhookName")
		ok.String(*v.WebhookName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDisableStageTransitionInput(v *DisableStageTransitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PipelineName != nil {
		ok := object.Key("pipelineName")
		ok.String(*v.PipelineName)
	}

	if v.Reason != nil {
		ok := object.Key("reason")
		ok.String(*v.Reason)
	}

	if v.StageName != nil {
		ok := object.Key("stageName")
		ok.String(*v.StageName)
	}

	if len(v.TransitionType) > 0 {
		ok := object.Key("transitionType")
		ok.String(string(v.TransitionType))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentEnableStageTransitionInput(v *EnableStageTransitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PipelineName != nil {
		ok := object.Key("pipelineName")
		ok.String(*v.PipelineName)
	}

	if v.StageName != nil {
		ok := object.Key("stageName")
		ok.String(*v.StageName)
	}

	if len(v.TransitionType) > 0 {
		ok := object.Key("transitionType")
		ok.String(string(v.TransitionType))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetActionTypeInput(v *GetActionTypeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Category) > 0 {
		ok := object.Key("category")
		ok.String(string(v.Category))
	}

	if v.Owner != nil {
		ok := object.Key("owner")
		ok.String(*v.Owner)
	}

	if v.Provider != nil {
		ok := object.Key("provider")
		ok.String(*v.Provider)
	}

	if v.Version != nil {
		ok := object.Key("version")
		ok.String(*v.Version)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetJobDetailsInput(v *GetJobDetailsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("jobId")
		ok.String(*v.JobId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetPipelineExecutionInput(v *GetPipelineExecutionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PipelineExecutionId != nil {
		ok := object.Key("pipelineExecutionId")
		ok.String(*v.PipelineExecutionId)
	}

	if v.PipelineName != nil {
		ok := object.Key("pipelineName")
		ok.String(*v.PipelineName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetPipelineInput(v *GetPipelineInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Version != nil {
		ok := object.Key("version")
		ok.Integer(*v.Version)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetPipelineStateInput(v *GetPipelineStateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetThirdPartyJobDetailsInput(v *GetThirdPartyJobDetailsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.JobId != nil {
		ok := object.Key("jobId")
		ok.String(*v.JobId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListActionExecutionsInput(v *ListActionExecutionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filter != nil {
		ok := object.Key("filter")
		if err := awsAwsjson11_serializeDocumentActionExecutionFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.PipelineName != nil {
		ok := object.Key("pipelineName")
		ok.String(*v.PipelineName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListActionTypesInput(v *ListActionTypesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ActionOwnerFilter) > 0 {
		ok := object.Key("actionOwnerFilter")
		ok.String(string(v.ActionOwnerFilter))
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.RegionFilter != nil {
		ok := object.Key("regionFilter")
		ok.String(*v.RegionFilter)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListPipelineExecutionsInput(v *ListPipelineExecutionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filter != nil {
		ok := object.Key("filter")
		if err := awsAwsjson11_serializeDocumentPipelineExecutionFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.PipelineName != nil {
		ok := object.Key("pipelineName")
		ok.String(*v.PipelineName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListPipelinesInput(v *ListPipelinesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListRuleExecutionsInput(v *ListRuleExecutionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filter != nil {
		ok := object.Key("filter")
		if err := awsAwsjson11_serializeDocumentRuleExecutionFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.PipelineName != nil {
		ok := object.Key("pipelineName")
		ok.String(*v.PipelineName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListRuleTypesInput(v *ListRuleTypesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RegionFilter != nil {
		ok := object.Key("regionFilter")
		ok.String(*v.RegionFilter)
	}

	if len(v.RuleOwnerFilter) > 0 {
		ok := object.Key("ruleOwnerFilter")
		ok.String(string(v.RuleOwnerFilter))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.ResourceArn != nil {
		ok := object.Key("resourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListWebhooksInput(v *ListWebhooksInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentOverrideStageConditionInput(v *OverrideStageConditionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ConditionType) > 0 {
		ok := object.Key("conditionType")
		ok.String(string(v.ConditionType))
	}

	if v.PipelineExecutionId != nil {
		ok := object.Key("pipelineExecutionId")
		ok.String(*v.PipelineExecutionId)
	}

	if v.PipelineName != nil {
		ok := object.Key("pipelineName")
		ok.String(*v.PipelineName)
	}

	if v.StageName != nil {
		ok := object.Key("stageName")
		ok.String(*v.StageName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPollForJobsInput(v *PollForJobsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionTypeId != nil {
		ok := object.Key("actionTypeId")
		if err := awsAwsjson11_serializeDocumentActionTypeId(v.ActionTypeId, ok); err != nil {
			return err
		}
	}

	if v.MaxBatchSize != nil {
		ok := object.Key("maxBatchSize")
		ok.Integer(*v.MaxBatchSize)
	}

	if v.QueryParam != nil {
		ok := object.Key("queryParam")
		if err := awsAwsjson11_serializeDocumentQueryParamMap(v.QueryParam, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPollForThirdPartyJobsInput(v *PollForThirdPartyJobsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionTypeId != nil {
		ok := object.Key("actionTypeId")
		if err := awsAwsjson11_serializeDocumentActionTypeId(v.ActionTypeId, ok); err != nil {
			return err
		}
	}

	if v.MaxBatchSize != nil {
		ok := object.Key("maxBatchSize")
		ok.Integer(*v.MaxBatchSize)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutActionRevisionInput(v *PutActionRevisionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionName != nil {
		ok := object.Key("actionName")
		ok.String(*v.ActionName)
	}

	if v.ActionRevision != nil {
		ok := object.Key("actionRevision")
		if err := awsAwsjson11_serializeDocumentActionRevision(v.ActionRevision, ok); err != nil {
			return err
		}
	}

	if v.PipelineName != nil {
		ok := object.Key("pipelineName")
		ok.String(*v.PipelineName)
	}

	if v.StageName != nil {
		ok := object.Key("stageName")
		ok.String(*v.StageName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutApprovalResultInput(v *PutApprovalResultInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionName != nil {
		ok := object.Key("actionName")
		ok.String(*v.ActionName)
	}

	if v.PipelineName != nil {
		ok := object.Key("pipelineName")
		ok.String(*v.PipelineName)
	}

	if v.Result != nil {
		ok := object.Key("result")
		if err := awsAwsjson11_serializeDocumentApprovalResult(v.Result, ok); err != nil {
			return err
		}
	}

	if v.StageName != nil {
		ok := object.Key("stageName")
		ok.String(*v.StageName)
	}

	if v.Token != nil {
		ok := object.Key("token")
		ok.String(*v.Token)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutJobFailureResultInput(v *PutJobFailureResultInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FailureDetails != nil {
		ok := object.Key("failureDetails")
		if err := awsAwsjson11_serializeDocumentFailureDetails(v.FailureDetails, ok); err != nil {
			return err
		}
	}

	if v.JobId != nil {
		ok := object.Key("jobId")
		ok.String(*v.JobId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutJobSuccessResultInput(v *PutJobSuccessResultInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContinuationToken != nil {
		ok := object.Key("continuationToken")
		ok.String(*v.ContinuationToken)
	}

	if v.CurrentRevision != nil {
		ok := object.Key("currentRevision")
		if err := awsAwsjson11_serializeDocumentCurrentRevision(v.CurrentRevision, ok); err != nil {
			return err
		}
	}

	if v.ExecutionDetails != nil {
		ok := object.Key("executionDetails")
		if err := awsAwsjson11_serializeDocumentExecutionDetails(v.ExecutionDetails, ok); err != nil {
			return err
		}
	}

	if v.JobId != nil {
		ok := object.Key("jobId")
		ok.String(*v.JobId)
	}

	if v.OutputVariables != nil {
		ok := object.Key("outputVariables")
		if err := awsAwsjson11_serializeDocumentOutputVariablesMap(v.OutputVariables, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutThirdPartyJobFailureResultInput(v *PutThirdPartyJobFailureResultInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.FailureDetails != nil {
		ok := object.Key("failureDetails")
		if err := awsAwsjson11_serializeDocumentFailureDetails(v.FailureDetails, ok); err != nil {
			return err
		}
	}

	if v.JobId != nil {
		ok := object.Key("jobId")
		ok.String(*v.JobId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutThirdPartyJobSuccessResultInput(v *PutThirdPartyJobSuccessResultInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.ContinuationToken != nil {
		ok := object.Key("continuationToken")
		ok.String(*v.ContinuationToken)
	}

	if v.CurrentRevision != nil {
		ok := object.Key("currentRevision")
		if err := awsAwsjson11_serializeDocumentCurrentRevision(v.CurrentRevision, ok); err != nil {
			return err
		}
	}

	if v.ExecutionDetails != nil {
		ok := object.Key("executionDetails")
		if err := awsAwsjson11_serializeDocumentExecutionDetails(v.ExecutionDetails, ok); err != nil {
			return err
		}
	}

	if v.JobId != nil {
		ok := object.Key("jobId")
		ok.String(*v.JobId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutWebhookInput(v *PutWebhookInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Webhook != nil {
		ok := object.Key("webhook")
		if err := awsAwsjson11_serializeDocumentWebhookDefinition(v.Webhook, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRegisterWebhookWithThirdPartyInput(v *RegisterWebhookWithThirdPartyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WebhookName != nil {
		ok := object.Key("webhookName")
		ok.String(*v.WebhookName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRetryStageExecutionInput(v *RetryStageExecutionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PipelineExecutionId != nil {
		ok := object.Key("pipelineExecutionId")
		ok.String(*v.PipelineExecutionId)
	}

	if v.PipelineName != nil {
		ok := object.Key("pipelineName")
		ok.String(*v.PipelineName)
	}

	if len(v.RetryMode) > 0 {
		ok := object.Key("retryMode")
		ok.String(string(v.RetryMode))
	}

	if v.StageName != nil {
		ok := object.Key("stageName")
		ok.String(*v.StageName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRollbackStageInput(v *RollbackStageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PipelineName != nil {
		ok := object.Key("pipelineName")
		ok.String(*v.PipelineName)
	}

	if v.StageName != nil {
		ok := object.Key("stageName")
		ok.String(*v.StageName)
	}

	if v.TargetPipelineExecutionId != nil {
		ok := object.Key("targetPipelineExecutionId")
		ok.String(*v.TargetPipelineExecutionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartPipelineExecutionInput(v *StartPipelineExecutionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.SourceRevisions != nil {
		ok := object.Key("sourceRevisions")
		if err := awsAwsjson11_serializeDocumentSourceRevisionOverrideList(v.SourceRevisions, ok); err != nil {
			return err
		}
	}

	if v.Variables != nil {
		ok := object.Key("variables")
		if err := awsAwsjson11_serializeDocumentPipelineVariableList(v.Variables, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStopPipelineExecutionInput(v *StopPipelineExecutionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Abandon {
		ok := object.Key("abandon")
		ok.Boolean(v.Abandon)
	}

	if v.PipelineExecutionId != nil {
		ok := object.Key("pipelineExecutionId")
		ok.String(*v.PipelineExecutionId)
	}

	if v.PipelineName != nil {
		ok := object.Key("pipelineName")
		ok.String(*v.PipelineName)
	}

	if v.Reason != nil {
		ok := object.Key("reason")
		ok.String(*v.Reason)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("resourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("resourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.TagKeys != nil {
		ok := object.Key("tagKeys")
		if err := awsAwsjson11_serializeDocumentTagKeyList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateActionTypeInput(v *UpdateActionTypeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionType != nil {
		ok := object.Key("actionType")
		if err := awsAwsjson11_serializeDocumentActionTypeDeclaration(v.ActionType, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdatePipelineInput(v *UpdatePipelineInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Pipeline != nil {
		ok := object.Key("pipeline")
		if err := awsAwsjson11_serializeDocumentPipelineDeclaration(v.Pipeline, ok); err != nil {
			return err
		}
	}

	return nil
}
