// Code generated by smithy-go-codegen DO NOT EDIT.

package cognitoidentity

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentity/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns credentials for the provided identity ID. Any provided logins will be
// validated against supported login providers. If the token is for
// cognito-identity.amazonaws.com, it will be passed through to AWS Security Token
// Service with the appropriate role for the token.
//
// This is a public API. You do not need any credentials to call this API.
func (c *Client) GetCredentialsForIdentity(ctx context.Context, params *GetCredentialsForIdentityInput, optFns ...func(*Options)) (*GetCredentialsForIdentityOutput, error) {
	if params == nil {
		params = &GetCredentialsForIdentityInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCredentialsForIdentity", params, optFns, c.addOperationGetCredentialsForIdentityMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCredentialsForIdentityOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Input to the GetCredentialsForIdentity action.
type GetCredentialsForIdentityInput struct {

	// A unique identifier in the format REGION:GUID.
	//
	// This member is required.
	IdentityId *string

	// The Amazon Resource Name (ARN) of the role to be assumed when multiple roles
	// were received in the token from the identity provider. For example, a SAML-based
	// identity provider. This parameter is optional for identity providers that do not
	// support role customization.
	CustomRoleArn *string

	// A set of optional name-value pairs that map provider names to provider tokens.
	// The name-value pair will follow the syntax "provider_name":
	// "provider_user_identifier".
	//
	// Logins should not be specified when trying to get credentials for an
	// unauthenticated identity.
	//
	// The Logins parameter is required when using identities associated with external
	// identity providers such as Facebook. For examples of Logins maps, see the code
	// examples in the [External Identity Providers]section of the Amazon Cognito Developer Guide.
	//
	// [External Identity Providers]: https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html
	Logins map[string]string

	noSmithyDocumentSerde
}

// Returned in response to a successful GetCredentialsForIdentity operation.
type GetCredentialsForIdentityOutput struct {

	// Credentials for the provided identity ID.
	Credentials *types.Credentials

	// A unique identifier in the format REGION:GUID.
	IdentityId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCredentialsForIdentityMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetCredentialsForIdentity{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetCredentialsForIdentity{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCredentialsForIdentity"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetCredentialsForIdentityValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCredentialsForIdentity(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetCredentialsForIdentity(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCredentialsForIdentity",
	}
}
