// Code generated by smithy-go-codegen DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider/document"
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new set of branding settings for a user pool style and associates it
// with an app client. This operation is the programmatic option for the creation
// of a new style in the branding designer.
//
// Provides values for UI customization in a Settings JSON object and image files
// in an Assets array. To send the JSON object Document type parameter in Settings
// , you might need to update to the most recent version of your Amazon Web
// Services SDK. To create a new style with default settings, set
// UseCognitoProvidedValues to true and don't provide values for any other options.
//
// This operation has a 2-megabyte request-size limit and include the CSS settings
// and image assets for your app client. Your branding settings might exceed 2MB in
// size. Amazon Cognito doesn't require that you pass all parameters in one request
// and preserves existing style settings that you don't specify. If your request is
// larger than 2MB, separate it into multiple requests, each with a size smaller
// than the limit.
//
// As a best practice, modify the output of [DescribeManagedLoginBrandingByClient] into the request parameters for this
// operation. To get all settings, set ReturnMergedResources to true . For more
// information, see [API and SDK operations for managed login branding].
//
// Amazon Cognito evaluates Identity and Access Management (IAM) policies in
// requests for this API operation. For this operation, you must use IAM
// credentials to authorize requests, and you must grant yourself the corresponding
// IAM permission in a policy.
//
// # Learn more
//
// [Signing Amazon Web Services API Requests]
//
// [Using the Amazon Cognito user pools API and user pool endpoints]
//
// [Using the Amazon Cognito user pools API and user pool endpoints]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html
// [DescribeManagedLoginBrandingByClient]: https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeManagedLoginBrandingByClient.html
// [API and SDK operations for managed login branding]: https://docs.aws.amazon.com/cognito/latest/developerguide/managed-login-brandingdesigner.html#branding-designer-api
// [Signing Amazon Web Services API Requests]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html
func (c *Client) CreateManagedLoginBranding(ctx context.Context, params *CreateManagedLoginBrandingInput, optFns ...func(*Options)) (*CreateManagedLoginBrandingOutput, error) {
	if params == nil {
		params = &CreateManagedLoginBrandingInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateManagedLoginBranding", params, optFns, c.addOperationCreateManagedLoginBrandingMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateManagedLoginBrandingOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateManagedLoginBrandingInput struct {

	// The app client that you want to create the branding style for. Each style is
	// permanently linked to an app client. To change the style for an app client,
	// delete the existing style with [DeleteManagedLoginBranding]and create a new one.
	//
	// [DeleteManagedLoginBranding]: https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteManagedLoginBranding.html
	//
	// This member is required.
	ClientId *string

	// The ID of the user pool where you want to create a new branding style.
	//
	// This member is required.
	UserPoolId *string

	// An array of image files that you want to apply to roles like backgrounds,
	// logos, and icons. Each object must also indicate whether it is for dark mode,
	// light mode, or browser-adaptive mode.
	Assets []types.AssetType

	// A JSON file, encoded as a Document type, with the the settings that you want to
	// apply to your style.
	Settings document.Interface

	// When true, applies the default branding style options. These default options
	// are managed by Amazon Cognito. You can modify them later in the branding
	// designer.
	//
	// When you specify true for this option, you must also omit values for Settings
	// and Assets in the request.
	UseCognitoProvidedValues bool

	noSmithyDocumentSerde
}

type CreateManagedLoginBrandingOutput struct {

	// The details of the branding style that you created.
	ManagedLoginBranding *types.ManagedLoginBrandingType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateManagedLoginBrandingMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateManagedLoginBranding{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateManagedLoginBranding{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateManagedLoginBranding"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateManagedLoginBrandingValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateManagedLoginBranding(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateManagedLoginBranding(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateManagedLoginBranding",
	}
}
