// Code generated by smithy-go-codegen DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the authentication options for the currently signed-in user. Returns the
// following:
//
//   - The user's multi-factor authentication (MFA) preferences.
//
//   - The user's options in the USER_AUTH flow that they can select in a
//     SELECT_CHALLENGE response or request in a PREFERRED_CHALLENGE request.
func (c *Client) GetUserAuthFactors(ctx context.Context, params *GetUserAuthFactorsInput, optFns ...func(*Options)) (*GetUserAuthFactorsOutput, error) {
	if params == nil {
		params = &GetUserAuthFactorsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetUserAuthFactors", params, optFns, c.addOperationGetUserAuthFactorsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetUserAuthFactorsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetUserAuthFactorsInput struct {

	// A valid access token that Amazon Cognito issued to the user whose
	// authentication factors you want to view.
	//
	// This member is required.
	AccessToken *string

	noSmithyDocumentSerde
}

type GetUserAuthFactorsOutput struct {

	// The username of the currently sign-in user.
	//
	// This member is required.
	Username *string

	// The authentication types that are available to the user with USER_AUTH sign-in.
	ConfiguredUserAuthFactors []types.AuthFactorType

	// The user's preferred MFA setting.
	PreferredMfaSetting *string

	// The MFA options that are activated for the user. The possible values in this
	// list are SMS_MFA , EMAIL_OTP , and SOFTWARE_TOKEN_MFA .
	UserMFASettingList []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetUserAuthFactorsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetUserAuthFactors{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetUserAuthFactors{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetUserAuthFactors"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetUserAuthFactorsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetUserAuthFactors(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetUserAuthFactors(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetUserAuthFactors",
	}
}
