// Code generated by smithy-go-codegen DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// A user pool domain hosts managed login, an authorization server and web server
// for authentication in your application. This operation updates the branding
// version for user pool domains between 1 for hosted UI (classic) and 2 for
// managed login. It also updates the SSL certificate for user pool custom domains.
//
// Changes to the domain branding version take up to one minute to take effect for
// a prefix domain and up to five minutes for a custom domain.
//
// This operation doesn't change the name of your user pool domain. To change your
// domain, delete it with DeleteUserPoolDomain and create a new domain with
// CreateUserPoolDomain .
//
// You can pass the ARN of a new Certificate Manager certificate in this request.
// Typically, ACM certificates automatically renew and you user pool can continue
// to use the same ARN. But if you generate a new certificate for your custom
// domain name, replace the original configuration with the new ARN in this
// request.
//
// ACM certificates for custom domains must be in the US East (N. Virginia) Amazon
// Web Services Region. After you submit your request, Amazon Cognito requires up
// to 1 hour to distribute your new certificate to your custom domain.
//
// For more information about adding a custom domain to your user pool, see [Configuring a user pool domain].
//
// Amazon Cognito evaluates Identity and Access Management (IAM) policies in
// requests for this API operation. For this operation, you must use IAM
// credentials to authorize requests, and you must grant yourself the corresponding
// IAM permission in a policy.
//
// # Learn more
//
// [Signing Amazon Web Services API Requests]
//
// [Using the Amazon Cognito user pools API and user pool endpoints]
//
// [Using the Amazon Cognito user pools API and user pool endpoints]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html
// [Configuring a user pool domain]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html
// [Signing Amazon Web Services API Requests]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html
func (c *Client) UpdateUserPoolDomain(ctx context.Context, params *UpdateUserPoolDomainInput, optFns ...func(*Options)) (*UpdateUserPoolDomainOutput, error) {
	if params == nil {
		params = &UpdateUserPoolDomainInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateUserPoolDomain", params, optFns, c.addOperationUpdateUserPoolDomainMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateUserPoolDomainOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The UpdateUserPoolDomain request input.
type UpdateUserPoolDomainInput struct {

	// The domain name for the custom domain that hosts the sign-up and sign-in pages
	// for your application. One example might be auth.example.com .
	//
	// This string can include only lowercase letters, numbers, and hyphens. Don't use
	// a hyphen for the first or last character. Use periods to separate subdomain
	// names.
	//
	// This member is required.
	Domain *string

	// The ID of the user pool that is associated with the custom domain whose
	// certificate you're updating.
	//
	// This member is required.
	UserPoolId *string

	// The configuration for a custom domain that hosts the sign-up and sign-in pages
	// for your application. Use this object to specify an SSL certificate that is
	// managed by ACM.
	//
	// When you create a custom domain, the passkey RP ID defaults to the custom
	// domain. If you had a prefix domain active, this will cause passkey integration
	// for your prefix domain to stop working due to a mismatch in RP ID. To keep the
	// prefix domain passkey integration working, you can explicitly set RP ID to the
	// prefix domain. Update the RP ID in a [SetUserPoolMfaConfig]request.
	//
	// [SetUserPoolMfaConfig]: https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserPoolMfaConfig.html
	CustomDomainConfig *types.CustomDomainConfigType

	// A version number that indicates the state of managed login for your domain.
	// Version 1 is hosted UI (classic). Version 2 is the newer managed login with the
	// branding designer. For more information, see [Managed login].
	//
	// [Managed login]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html
	ManagedLoginVersion *int32

	noSmithyDocumentSerde
}

// The UpdateUserPoolDomain response output.
type UpdateUserPoolDomainOutput struct {

	// The Amazon CloudFront endpoint that Amazon Cognito set up when you added the
	// custom domain to your user pool.
	CloudFrontDomain *string

	// A version number that indicates the state of managed login for your domain.
	// Version 1 is hosted UI (classic). Version 2 is the newer managed login with the
	// branding designer. For more information, see [Managed login].
	//
	// [Managed login]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html
	ManagedLoginVersion *int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateUserPoolDomainMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateUserPoolDomain{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateUserPoolDomain{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateUserPoolDomain"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateUserPoolDomainValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateUserPoolDomain(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateUserPoolDomain(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateUserPoolDomain",
	}
}
