// Code generated by smithy-go-codegen DO NOT EDIT.

package comprehend

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/comprehend/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Starts an asynchronous topic detection job. Use the DescribeTopicDetectionJob
// operation to track the status of a job.
func (c *Client) StartTopicsDetectionJob(ctx context.Context, params *StartTopicsDetectionJobInput, optFns ...func(*Options)) (*StartTopicsDetectionJobOutput, error) {
	if params == nil {
		params = &StartTopicsDetectionJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartTopicsDetectionJob", params, optFns, c.addOperationStartTopicsDetectionJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartTopicsDetectionJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartTopicsDetectionJobInput struct {

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data. For more information, see [Role-based permissions].
	//
	// [Role-based permissions]: https://docs.aws.amazon.com/comprehend/latest/dg/security_iam_id-based-policy-examples.html#auth-role-permissions
	//
	// This member is required.
	DataAccessRoleArn *string

	// Specifies the format and location of the input data for the job.
	//
	// This member is required.
	InputDataConfig *types.InputDataConfig

	// Specifies where to send the output files. The output is a compressed archive
	// with two files, topic-terms.csv that lists the terms associated with each
	// topic, and doc-topics.csv that lists the documents associated with each topic
	//
	// This member is required.
	OutputDataConfig *types.OutputDataConfig

	// A unique identifier for the request. If you do not set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string

	// The identifier of the job.
	JobName *string

	// The number of topics to detect.
	NumberOfTopics *int32

	// Tags to associate with the topics detection job. A tag is a key-value pair that
	// adds metadata to a resource used by Amazon Comprehend. For example, a tag with
	// "Sales" as the key might be added to a resource to indicate its use by the sales
	// department.
	Tags []types.Tag

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML compute
	// instance(s) that process the analysis job. The VolumeKmsKeyId can be either of
	// the following formats:
	//
	//   - KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//   - Amazon Resource Name (ARN) of a KMS Key:
	//   "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for your topic detection job. For more
	// information, see [Amazon VPC].
	//
	// [Amazon VPC]: https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html
	VpcConfig *types.VpcConfig

	noSmithyDocumentSerde
}

type StartTopicsDetectionJobOutput struct {

	// The Amazon Resource Name (ARN) of the topics detection job. It is a unique,
	// fully qualified identifier for the job. It includes the Amazon Web Services
	// account, Amazon Web Services Region, and the job ID. The format of the ARN is as
	// follows:
	//
	//     arn::comprehend:::topics-detection-job/
	//
	// The following is an example job ARN:
	//
	//     arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string

	// The identifier generated for the job. To get the status of the job, use this
	// identifier with the DescribeTopicDetectionJob operation.
	JobId *string

	// The status of the job:
	//
	//   - SUBMITTED - The job has been received and is queued for processing.
	//
	//   - IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//   - COMPLETED - The job was successfully completed and the output is available.
	//
	//   - FAILED - The job did not complete. To get details, use the
	//   DescribeTopicDetectionJob operation.
	JobStatus types.JobStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartTopicsDetectionJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpStartTopicsDetectionJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpStartTopicsDetectionJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartTopicsDetectionJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartTopicsDetectionJobMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartTopicsDetectionJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartTopicsDetectionJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartTopicsDetectionJob struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartTopicsDetectionJob) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartTopicsDetectionJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartTopicsDetectionJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartTopicsDetectionJobInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartTopicsDetectionJobMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartTopicsDetectionJob{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartTopicsDetectionJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartTopicsDetectionJob",
	}
}
