// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Describes the enrollment status of an organization's member accounts in Compute
// Optimizer.
type AccountEnrollmentStatus struct {

	// The Amazon Web Services account ID.
	AccountId *string

	// The Unix epoch timestamp, in seconds, of when the account enrollment status was
	// last updated.
	LastUpdatedTimestamp *time.Time

	// The account enrollment status.
	Status Status

	// The reason for the account enrollment status.
	//
	// For example, an account might show a status of Pending because member accounts
	// of an organization require more time to be enrolled in the service.
	StatusReason *string

	noSmithyDocumentSerde
}

// Describes the configuration of an EC2 Auto Scaling group.
type AutoScalingGroupConfiguration struct {

	//  Describes the allocation strategy that the EC2 Auto Scaling group uses. This
	// field is only available for EC2 Auto Scaling groups with mixed instance types.
	AllocationStrategy AllocationStrategy

	// The desired capacity, or number of instances, for the EC2 Auto Scaling group.
	DesiredCapacity int32

	//  Describes the projected percentage reduction in instance hours after adopting
	// the recommended configuration. This field is only available for EC2 Auto Scaling
	// groups with scaling policies.
	EstimatedInstanceHourReductionPercentage *float64

	// The instance type for the EC2 Auto Scaling group.
	InstanceType *string

	// The maximum size, or maximum number of instances, for the EC2 Auto Scaling
	// group.
	MaxSize int32

	// The minimum size, or minimum number of instances, for the EC2 Auto Scaling
	// group.
	MinSize int32

	//  List the instance types within an EC2 Auto Scaling group that has mixed
	// instance types.
	MixedInstanceTypes []string

	//  Describes whether the EC2 Auto Scaling group has a single instance type or a
	// mixed instance type configuration.
	Type AsgType

	noSmithyDocumentSerde
}

//	An object that describes the estimated monthly savings possible by adopting
//
// Compute Optimizer’s Auto Scaling group recommendations. This is based on the
// Savings Plans and Reserved Instances discounts.
type AutoScalingGroupEstimatedMonthlySavings struct {

	//  The currency of the estimated monthly savings.
	Currency Currency

	//  The value of the estimated monthly savings.
	Value float64

	noSmithyDocumentSerde
}

// Describes an Auto Scaling group recommendation.
type AutoScalingGroupRecommendation struct {

	// The Amazon Web Services account ID of the Auto Scaling group.
	AccountId *string

	// The Amazon Resource Name (ARN) of the Auto Scaling group.
	AutoScalingGroupArn *string

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string

	// An array of objects that describe the current configuration of the Auto Scaling
	// group.
	CurrentConfiguration *AutoScalingGroupConfiguration

	//  Describes the GPU accelerator settings for the current instance type of the
	// Auto Scaling group.
	CurrentInstanceGpuInfo *GpuInfo

	// The risk of the current Auto Scaling group not meeting the performance needs of
	// its workloads. The higher the risk, the more likely the current Auto Scaling
	// group configuration has insufficient capacity and cannot meet workload
	// requirements.
	CurrentPerformanceRisk CurrentPerformanceRisk

	// An object that describes the effective recommendation preferences for the Auto
	// Scaling group.
	EffectiveRecommendationPreferences *EffectiveRecommendationPreferences

	// The finding classification of the Auto Scaling group.
	//
	// Findings for Auto Scaling groups include:
	//
	//   - NotOptimized —An Auto Scaling group is considered not optimized when Compute
	//   Optimizer identifies a recommendation that can provide better performance for
	//   your workload.
	//
	//   - Optimized —An Auto Scaling group is considered optimized when Compute
	//   Optimizer determines that the group is correctly provisioned to run your
	//   workload based on the chosen instance type. For optimized resources, Compute
	//   Optimizer might recommend a new generation instance type.
	Finding Finding

	// The applications that might be running on the instances in the Auto Scaling
	// group as inferred by Compute Optimizer.
	//
	// Compute Optimizer can infer if one of the following applications might be
	// running on the instances:
	//
	//   - AmazonEmr - Infers that Amazon EMR might be running on the instances.
	//
	//   - ApacheCassandra - Infers that Apache Cassandra might be running on the
	//   instances.
	//
	//   - ApacheHadoop - Infers that Apache Hadoop might be running on the instances.
	//
	//   - Memcached - Infers that Memcached might be running on the instances.
	//
	//   - NGINX - Infers that NGINX might be running on the instances.
	//
	//   - PostgreSql - Infers that PostgreSQL might be running on the instances.
	//
	//   - Redis - Infers that Redis might be running on the instances.
	//
	//   - Kafka - Infers that Kafka might be running on the instance.
	//
	//   - SQLServer - Infers that SQLServer might be running on the instance.
	InferredWorkloadTypes []InferredWorkloadType

	// The timestamp of when the Auto Scaling group recommendation was last generated.
	LastRefreshTimestamp *time.Time

	// The number of days for which utilization metrics were analyzed for the Auto
	// Scaling group.
	LookBackPeriodInDays float64

	// An array of objects that describe the recommendation options for the Auto
	// Scaling group.
	RecommendationOptions []AutoScalingGroupRecommendationOption

	// An array of objects that describe the utilization metrics of the Auto Scaling
	// group.
	UtilizationMetrics []UtilizationMetric

	noSmithyDocumentSerde
}

// Describes a recommendation option for an Auto Scaling group.
type AutoScalingGroupRecommendationOption struct {

	// An array of objects that describe an Auto Scaling group configuration.
	Configuration *AutoScalingGroupConfiguration

	//  Describes the GPU accelerator settings for the recommended instance type of
	// the Auto Scaling group.
	InstanceGpuInfo *GpuInfo

	// The level of effort required to migrate from the current instance type to the
	// recommended instance type.
	//
	// For example, the migration effort is Low if Amazon EMR is the inferred workload
	// type and an Amazon Web Services Graviton instance type is recommended. The
	// migration effort is Medium if a workload type couldn't be inferred but an
	// Amazon Web Services Graviton instance type is recommended. The migration effort
	// is VeryLow if both the current and recommended instance types are of the same
	// CPU architecture.
	MigrationEffort MigrationEffort

	// The performance risk of the Auto Scaling group configuration recommendation.
	//
	// Performance risk indicates the likelihood of the recommended instance type not
	// meeting the resource needs of your workload. Compute Optimizer calculates an
	// individual performance risk score for each specification of the recommended
	// instance, including CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk
	// IOPS, network throughput, and network PPS. The performance risk of the
	// recommended instance is calculated as the maximum performance risk score across
	// the analyzed resource specifications.
	//
	// The value ranges from 0 - 4 , with 0 meaning that the recommended resource is
	// predicted to always provide enough hardware capability. The higher the
	// performance risk is, the more likely you should validate whether the
	// recommendation will meet the performance requirements of your workload before
	// migrating your resource.
	PerformanceRisk float64

	// An array of objects that describe the projected utilization metrics of the Auto
	// Scaling group recommendation option.
	//
	// The Cpu and Memory metrics are the only projected utilization metrics returned.
	// Additionally, the Memory metric is returned only for resources that have the
	// unified CloudWatch agent installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent].
	//
	// [Enabling Memory Utilization with the CloudWatch Agent]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent
	ProjectedUtilizationMetrics []UtilizationMetric

	// The rank of the Auto Scaling group recommendation option.
	//
	// The top recommendation option is ranked as 1 .
	Rank int32

	// An object that describes the savings opportunity for the Auto Scaling group
	// recommendation option. Savings opportunity includes the estimated monthly
	// savings amount and percentage.
	SavingsOpportunity *SavingsOpportunity

	//  An object that describes the savings opportunity for the Auto Scaling group
	// recommendation option that includes Savings Plans and Reserved Instances
	// discounts. Savings opportunity includes the estimated monthly savings and
	// percentage.
	SavingsOpportunityAfterDiscounts *AutoScalingGroupSavingsOpportunityAfterDiscounts

	noSmithyDocumentSerde
}

//	Describes the savings opportunity for Auto Scaling group recommendations after
//
// applying the Savings Plans and Reserved Instances discounts.
//
// Savings opportunity represents the estimated monthly savings you can achieve by
// implementing Compute Optimizer recommendations.
type AutoScalingGroupSavingsOpportunityAfterDiscounts struct {

	//  An object that describes the estimated monthly savings possible by adopting
	// Compute Optimizer’s Auto Scaling group recommendations. This is based on the
	// Savings Plans and Reserved Instances pricing discounts.
	EstimatedMonthlySavings *AutoScalingGroupEstimatedMonthlySavings

	//  The estimated monthly savings possible as a percentage of monthly cost after
	// applying the Savings Plans and Reserved Instances discounts. This saving can be
	// achieved by adopting Compute Optimizer’s Auto Scaling group recommendations.
	SavingsOpportunityPercentage float64

	noSmithyDocumentSerde
}

//	Describes the container configurations within the tasks of your Amazon ECS
//
// service.
type ContainerConfiguration struct {

	//  The name of the container.
	ContainerName *string

	//  The number of CPU units reserved for the container.
	Cpu *int32

	//  The memory size configurations for the container.
	MemorySizeConfiguration *MemorySizeConfiguration

	noSmithyDocumentSerde
}

//	The CPU and memory recommendations for a container within the tasks of your
//
// Amazon ECS service.
type ContainerRecommendation struct {

	//  The name of the container.
	ContainerName *string

	//  The recommended number of CPU units reserved for the container.
	Cpu *int32

	//  The recommended memory size configurations for the container.
	MemorySizeConfiguration *MemorySizeConfiguration

	noSmithyDocumentSerde
}

// Describes the performance risk ratings for a given resource type.
//
// Resources with a high or medium rating are at risk of not meeting the
// performance needs of their workloads, while resources with a low rating are
// performing well in their workloads.
type CurrentPerformanceRiskRatings struct {

	// A count of the applicable resource types with a high performance risk rating.
	High int64

	// A count of the applicable resource types with a low performance risk rating.
	Low int64

	// A count of the applicable resource types with a medium performance risk rating.
	Medium int64

	// A count of the applicable resource types with a very low performance risk
	// rating.
	VeryLow int64

	noSmithyDocumentSerde
}

//	Defines the various metric parameters that can be customized, such as
//
// threshold and headroom.
type CustomizableMetricParameters struct {

	//  The headroom value in percentage used for the specified metric parameter.
	//
	// The following lists the valid values for CPU and memory utilization.
	//
	//   - CPU utilization: PERCENT_30 | PERCENT_20 | PERCENT_0
	//
	//   - Memory utilization: PERCENT_30 | PERCENT_20 | PERCENT_10
	Headroom CustomizableMetricHeadroom

	//  The threshold value used for the specified metric parameter.
	//
	// You can only specify the threshold value for CPU utilization.
	Threshold CustomizableMetricThreshold

	noSmithyDocumentSerde
}

// The configuration of the recommended RDS storage.
type DBStorageConfiguration struct {

	//  The size of the RDS storage in gigabytes (GB).
	AllocatedStorage int32

	//  The provisioned IOPs of the RDS storage.
	Iops *int32

	//  The maximum limit in gibibytes (GiB) to which Amazon RDS can automatically
	// scale the storage of the RDS instance.
	MaxAllocatedStorage *int32

	//  The storage throughput of the RDS storage.
	StorageThroughput *int32

	//  The type of RDS storage.
	StorageType *string

	noSmithyDocumentSerde
}

// Describes the effective recommendation preferences for Amazon EBS volumes.
type EBSEffectiveRecommendationPreferences struct {

	//  Describes the savings estimation mode preference applied for calculating
	// savings opportunity for Amazon EBS volumes.
	SavingsEstimationMode *EBSSavingsEstimationMode

	noSmithyDocumentSerde
}

//	An object that describes the estimated monthly savings possible by adopting
//
// Compute Optimizer’s Amazon EBS volume recommendations. This includes any
// applicable discounts.
type EBSEstimatedMonthlySavings struct {

	//  The currency of the estimated monthly savings.
	Currency Currency

	//  The value of the estimated monthly savings.
	Value float64

	noSmithyDocumentSerde
}

// Describes a filter that returns a more specific list of Amazon Elastic Block
// Store (Amazon EBS) volume recommendations. Use this filter with the GetEBSVolumeRecommendationsaction.
//
// You can use LambdaFunctionRecommendationFilter with the GetLambdaFunctionRecommendations action, JobFilter with
// the DescribeRecommendationExportJobsaction, and Filter with the GetAutoScalingGroupRecommendations and GetEC2InstanceRecommendations actions.
type EBSFilter struct {

	// The name of the filter.
	//
	// Specify Finding to return recommendations with a specific finding
	// classification (for example, NotOptimized ).
	//
	// You can filter your Amazon EBS volume recommendations by tag:key and tag-key
	// tags.
	//
	// A tag:key is a key and value combination of a tag assigned to your Amazon EBS
	// volume recommendations. Use the tag key in the filter name and the tag value as
	// the filter value. For example, to find all Amazon EBS volume recommendations
	// that have a tag with the key of Owner and the value of TeamA , specify tag:Owner
	// for the filter name and TeamA for the filter value.
	//
	// A tag-key is the key of a tag assigned to your Amazon EBS volume
	// recommendations. Use this filter to find all of your Amazon EBS volume
	// recommendations that have a tag with a specific key. This doesn’t consider the
	// tag value. For example, you can find your Amazon EBS volume recommendations with
	// a tag key value of Owner or without any tag keys assigned.
	Name EBSFilterName

	// The value of the filter.
	//
	// The valid values are Optimized , or NotOptimized .
	Values []string

	noSmithyDocumentSerde
}

//	Describes the savings estimation mode used for calculating savings opportunity
//
// for Amazon EBS volumes.
type EBSSavingsEstimationMode struct {

	//  Describes the source for calculating the savings opportunity for Amazon EBS
	// volumes.
	Source EBSSavingsEstimationModeSource

	noSmithyDocumentSerde
}

//	Describes the savings opportunity for Amazon EBS volume recommendations after
//
// applying specific discounts.
type EBSSavingsOpportunityAfterDiscounts struct {

	//  The estimated monthly savings possible as a percentage of monthly cost by
	// adopting Compute Optimizer’s Amazon EBS volume recommendations. This saving
	// includes any applicable discounts.
	EstimatedMonthlySavings *EBSEstimatedMonthlySavings

	//  The estimated monthly savings possible as a percentage of monthly cost after
	// applying the specific discounts. This saving can be achieved by adopting Compute
	// Optimizer’s Amazon EBS volume recommendations.
	SavingsOpportunityPercentage float64

	noSmithyDocumentSerde
}

// Describes a utilization metric of an Amazon Elastic Block Store (Amazon EBS)
// volume.
//
// Compare the utilization metric data of your resource against its projected
// utilization metric data to determine the performance difference between your
// current resource and the recommended option.
type EBSUtilizationMetric struct {

	// The name of the utilization metric.
	//
	// The following utilization metrics are available:
	//
	//   - VolumeReadOpsPerSecond - The completed read operations per second from the
	//   volume in a specified period of time.
	//
	// Unit: Count
	//
	//   - VolumeWriteOpsPerSecond - The completed write operations per second to the
	//   volume in a specified period of time.
	//
	// Unit: Count
	//
	//   - VolumeReadBytesPerSecond - The bytes read per second from the volume in a
	//   specified period of time.
	//
	// Unit: Bytes
	//
	//   - VolumeWriteBytesPerSecond - The bytes written to the volume in a specified
	//   period of time.
	//
	// Unit: Bytes
	Name EBSMetricName

	// The statistic of the utilization metric.
	//
	// The Compute Optimizer API, Command Line Interface (CLI), and SDKs return
	// utilization metrics using only the Maximum statistic, which is the highest
	// value observed during the specified period.
	//
	// The Compute Optimizer console displays graphs for some utilization metrics
	// using the Average statistic, which is the value of Sum / SampleCount during the
	// specified period. For more information, see [Viewing resource recommendations]in the Compute Optimizer User
	// Guide. You can also get averaged utilization metric data for your resources
	// using Amazon CloudWatch. For more information, see the [Amazon CloudWatch User Guide].
	//
	// [Viewing resource recommendations]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html
	// [Amazon CloudWatch User Guide]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html
	Statistic MetricStatistic

	// The value of the utilization metric.
	Value float64

	noSmithyDocumentSerde
}

// Describes the effective recommendation preferences for Amazon ECS services.
type ECSEffectiveRecommendationPreferences struct {

	//  Describes the savings estimation mode preference applied for calculating
	// savings opportunity for Amazon ECS services.
	SavingsEstimationMode *ECSSavingsEstimationMode

	noSmithyDocumentSerde
}

//	Describes the estimated monthly savings possible for Amazon ECS services by
//
// adopting Compute Optimizer recommendations. This is based on Amazon ECS service
// pricing after applying Savings Plans discounts.
type ECSEstimatedMonthlySavings struct {

	//  The currency of the estimated monthly savings.
	Currency Currency

	//  The value of the estimated monthly savings for Amazon ECS services.
	Value float64

	noSmithyDocumentSerde
}

//	Describes the savings estimation mode used for calculating savings opportunity
//
// for Amazon ECS services.
type ECSSavingsEstimationMode struct {

	//  Describes the source for calculating the savings opportunity for Amazon ECS
	// services.
	Source ECSSavingsEstimationModeSource

	noSmithyDocumentSerde
}

//	Describes the savings opportunity for Amazon ECS service recommendations after
//
// applying Savings Plans discounts.
//
// Savings opportunity represents the estimated monthly savings after applying
// Savings Plans discounts. You can achieve this by implementing a given Compute
// Optimizer recommendation.
type ECSSavingsOpportunityAfterDiscounts struct {

	//  The estimated monthly savings possible by adopting Compute Optimizer’s Amazon
	// ECS service recommendations. This includes any applicable Savings Plans
	// discounts.
	EstimatedMonthlySavings *ECSEstimatedMonthlySavings

	//  The estimated monthly savings possible as a percentage of monthly cost by
	// adopting Compute Optimizer’s Amazon ECS service recommendations. This includes
	// any applicable Savings Plans discounts.
	SavingsOpportunityPercentage float64

	noSmithyDocumentSerde
}

//	Describes the projected metrics of an Amazon ECS service recommendation
//
// option.
//
// To determine the performance difference between your current Amazon ECS service
// and the recommended option, compare the metric data of your service against its
// projected metric data.
type ECSServiceProjectedMetric struct {

	//  The lower bound values for the projected metric.
	LowerBoundValues []float64

	//  The name of the projected metric.
	//
	// The following metrics are available:
	//
	//   - Cpu — The percentage of allocated compute units that are currently in use on
	//   the service tasks.
	//
	//   - Memory — The percentage of memory that's currently in use on the service
	//   tasks.
	Name ECSServiceMetricName

	//  The timestamps of the projected metric.
	Timestamps []time.Time

	//  The upper bound values for the projected metric.
	UpperBoundValues []float64

	noSmithyDocumentSerde
}

//	Describes the projected utilization metrics of an Amazon ECS service
//
// recommendation option.
//
// To determine the performance difference between your current Amazon ECS service
// and the recommended option, compare the utilization metric data of your service
// against its projected utilization metric data.
type ECSServiceProjectedUtilizationMetric struct {

	//  The lower bound values for the projected utilization metrics.
	LowerBoundValue float64

	//  The name of the projected utilization metric.
	//
	// The following utilization metrics are available:
	//
	//   - Cpu — The percentage of allocated compute units that are currently in use on
	//   the service tasks.
	//
	//   - Memory — The percentage of memory that's currently in use on the service
	//   tasks.
	Name ECSServiceMetricName

	// The statistic of the projected utilization metric.
	//
	// The Compute Optimizer API, Command Line Interface (CLI), and SDKs return
	// utilization metrics using only the Maximum statistic, which is the highest
	// value observed during the specified period.
	//
	// The Compute Optimizer console displays graphs for some utilization metrics
	// using the Average statistic, which is the value of Sum / SampleCount during the
	// specified period. For more information, see [Viewing resource recommendations]in the Compute Optimizer User
	// Guide. You can also get averaged utilization metric data for your resources
	// using Amazon CloudWatch. For more information, see the [Amazon CloudWatch User Guide].
	//
	// [Viewing resource recommendations]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html
	// [Amazon CloudWatch User Guide]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html
	Statistic ECSServiceMetricStatistic

	//  The upper bound values for the projected utilization metrics.
	UpperBoundValue float64

	noSmithyDocumentSerde
}

// Describes an Amazon ECS service recommendation.
type ECSServiceRecommendation struct {

	//  The Amazon Web Services account ID of the Amazon ECS service.
	AccountId *string

	//  The risk of the current Amazon ECS service not meeting the performance needs
	// of its workloads. The higher the risk, the more likely the current service can't
	// meet the performance requirements of its workload.
	CurrentPerformanceRisk CurrentPerformanceRisk

	//  The configuration of the current Amazon ECS service.
	CurrentServiceConfiguration *ServiceConfiguration

	//  Describes the effective recommendation preferences for Amazon ECS services.
	EffectiveRecommendationPreferences *ECSEffectiveRecommendationPreferences

	//  The finding classification of an Amazon ECS service.
	//
	// Findings for Amazon ECS services include:
	//
	//   - Underprovisioned — When Compute Optimizer detects that there’s not enough
	//   memory or CPU, an Amazon ECS service is considered under-provisioned. An
	//   under-provisioned service might result in poor application performance.
	//
	//   - Overprovisioned — When Compute Optimizer detects that there’s excessive
	//   memory or CPU, an Amazon ECS service is considered over-provisioned. An
	//   over-provisioned service might result in additional infrastructure costs.
	//
	//   - Optimized — When both the CPU and memory of your Amazon ECS service meet the
	//   performance requirements of your workload, the service is considered optimized.
	Finding ECSServiceRecommendationFinding

	//  The reason for the finding classification of an Amazon ECS service.
	//
	// Finding reason codes for Amazon ECS services include:
	//
	//   - CPUUnderprovisioned — The service CPU configuration can be sized up to
	//   enhance the performance of your workload. This is identified by analyzing the
	//   CPUUtilization metric of the current service during the look-back period.
	//
	//   - CPUOverprovisioned — The service CPU configuration can be sized down while
	//   still meeting the performance requirements of your workload. This is identified
	//   by analyzing the CPUUtilization metric of the current service during the
	//   look-back period.
	//
	//   - MemoryUnderprovisioned — The service memory configuration can be sized up to
	//   enhance the performance of your workload. This is identified by analyzing the
	//   MemoryUtilization metric of the current service during the look-back period.
	//
	//   - MemoryOverprovisioned — The service memory configuration can be sized down
	//   while still meeting the performance requirements of your workload. This is
	//   identified by analyzing the MemoryUtilization metric of the current service
	//   during the look-back period.
	FindingReasonCodes []ECSServiceRecommendationFindingReasonCode

	//  The timestamp of when the Amazon ECS service recommendation was last
	// generated.
	LastRefreshTimestamp *time.Time

	//  The launch type the Amazon ECS service is using.
	//
	// Compute Optimizer only supports the Fargate launch type.
	LaunchType ECSServiceLaunchType

	//  The number of days the Amazon ECS service utilization metrics were analyzed.
	LookbackPeriodInDays float64

	//  The Amazon Resource Name (ARN) of the current Amazon ECS service.
	//
	// The following is the format of the ARN:
	//
	//     arn:aws:ecs:region:aws_account_id:service/cluster-name/service-name
	ServiceArn *string

	//  An array of objects that describe the recommendation options for the Amazon
	// ECS service.
	ServiceRecommendationOptions []ECSServiceRecommendationOption

	//  A list of tags assigned to your Amazon ECS service recommendations.
	Tags []Tag

	//  An array of objects that describe the utilization metrics of the Amazon ECS
	// service.
	UtilizationMetrics []ECSServiceUtilizationMetric

	noSmithyDocumentSerde
}

//	Describes a filter that returns a more specific list of Amazon ECS service
//
// recommendations. Use this filter with the GetECSServiceRecommendationsaction.
type ECSServiceRecommendationFilter struct {

	//  The name of the filter.
	//
	// Specify Finding to return recommendations with a specific finding
	// classification.
	//
	// Specify FindingReasonCode to return recommendations with a specific finding
	// reason code.
	//
	// You can filter your Amazon ECS service recommendations by tag:key and tag-key
	// tags.
	//
	// A tag:key is a key and value combination of a tag assigned to your Amazon ECS
	// service recommendations. Use the tag key in the filter name and the tag value as
	// the filter value. For example, to find all Amazon ECS service recommendations
	// that have a tag with the key of Owner and the value of TeamA , specify tag:Owner
	// for the filter name and TeamA for the filter value.
	//
	// A tag-key is the key of a tag assigned to your Amazon ECS service
	// recommendations. Use this filter to find all of your Amazon ECS service
	// recommendations that have a tag with a specific key. This doesn’t consider the
	// tag value. For example, you can find your Amazon ECS service recommendations
	// with a tag key value of Owner or without any tag keys assigned.
	Name ECSServiceRecommendationFilterName

	//  The value of the filter.
	//
	// The valid values for this parameter are as follows:
	//
	//   - If you specify the name parameter as Finding , specify Optimized ,
	//   Underprovisioned , or Overprovisioned .
	//
	//   - If you specify the name parameter as FindingReasonCode , specify
	//   CPUUnderprovisioned , CPUOverprovisioned , MemoryUnderprovisioned , or
	//   MemoryOverprovisioned .
	Values []string

	noSmithyDocumentSerde
}

// Describes the recommendation options for an Amazon ECS service.
type ECSServiceRecommendationOption struct {

	//  The CPU and memory size recommendations for the containers within the task of
	// your Amazon ECS service.
	ContainerRecommendations []ContainerRecommendation

	//  The CPU size of the Amazon ECS service recommendation option.
	Cpu *int32

	//  The memory size of the Amazon ECS service recommendation option.
	Memory *int32

	//  An array of objects that describe the projected utilization metrics of the
	// Amazon ECS service recommendation option.
	ProjectedUtilizationMetrics []ECSServiceProjectedUtilizationMetric

	// Describes the savings opportunity for recommendations of a given resource type
	// or for the recommendation option of an individual resource.
	//
	// Savings opportunity represents the estimated monthly savings you can achieve by
	// implementing a given Compute Optimizer recommendation.
	//
	// Savings opportunity data requires that you opt in to Cost Explorer, as well as
	// activate Receive Amazon EC2 resource recommendations in the Cost Explorer
	// preferences page. That creates a connection between Cost Explorer and Compute
	// Optimizer. With this connection, Cost Explorer generates savings estimates
	// considering the price of existing resources, the price of recommended resources,
	// and historical usage data. Estimated monthly savings reflects the projected
	// dollar savings associated with each of the recommendations generated. For more
	// information, see [Enabling Cost Explorer]and [Optimizing your cost with Rightsizing Recommendations] in the Cost Management User Guide.
	//
	// [Optimizing your cost with Rightsizing Recommendations]: https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html
	// [Enabling Cost Explorer]: https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html
	SavingsOpportunity *SavingsOpportunity

	//  Describes the savings opportunity for Amazon ECS service recommendations or
	// for the recommendation option.
	//
	// Savings opportunity represents the estimated monthly savings after applying
	// Savings Plans discounts. You can achieve this by implementing a given Compute
	// Optimizer recommendation.
	SavingsOpportunityAfterDiscounts *ECSSavingsOpportunityAfterDiscounts

	noSmithyDocumentSerde
}

//	Describes the projected metrics of an Amazon ECS service recommendation
//
// option.
//
// To determine the performance difference between your current Amazon ECS service
// and the recommended option, compare the metric data of your service against its
// projected metric data.
type ECSServiceRecommendedOptionProjectedMetric struct {

	//  An array of objects that describe the projected metric.
	ProjectedMetrics []ECSServiceProjectedMetric

	//  The recommended CPU size for the Amazon ECS service.
	RecommendedCpuUnits int32

	//  The recommended memory size for the Amazon ECS service.
	RecommendedMemorySize int32

	noSmithyDocumentSerde
}

//	Describes the utilization metric of an Amazon ECS service.
//
// To determine the performance difference between your current Amazon ECS service
// and the recommended option, compare the utilization metric data of your service
// against its projected utilization metric data.
type ECSServiceUtilizationMetric struct {

	//  The name of the utilization metric.
	//
	// The following utilization metrics are available:
	//
	//   - Cpu — The amount of CPU capacity that's used in the service.
	//
	//   - Memory — The amount of memory that's used in the service.
	Name ECSServiceMetricName

	// The statistic of the utilization metric.
	//
	// The Compute Optimizer API, Command Line Interface (CLI), and SDKs return
	// utilization metrics using only the Maximum statistic, which is the highest
	// value observed during the specified period.
	//
	// The Compute Optimizer console displays graphs for some utilization metrics
	// using the Average statistic, which is the value of Sum / SampleCount during the
	// specified period. For more information, see [Viewing resource recommendations]in the Compute Optimizer User
	// Guide. You can also get averaged utilization metric data for your resources
	// using Amazon CloudWatch. For more information, see the [Amazon CloudWatch User Guide].
	//
	// [Viewing resource recommendations]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html
	// [Amazon CloudWatch User Guide]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html
	Statistic ECSServiceMetricStatistic

	//  The value of the utilization metric.
	Value float64

	noSmithyDocumentSerde
}

//	Describes the effective preferred resources that Compute Optimizer considers
//
// as rightsizing recommendation candidates.
//
// Compute Optimizer only supports Amazon EC2 instance types.
type EffectivePreferredResource struct {

	//  The expanded version of your preferred resource's include list.
	EffectiveIncludeList []string

	//  The list of preferred resources values that you want excluded from rightsizing
	// recommendation candidates.
	ExcludeList []string

	//  The list of preferred resource values that you want considered as rightsizing
	// recommendation candidates.
	IncludeList []string

	//  The name of the preferred resource list.
	Name PreferredResourceName

	noSmithyDocumentSerde
}

// Describes the effective recommendation preferences for a resource.
type EffectiveRecommendationPreferences struct {

	// Describes the CPU vendor and architecture for an instance or Auto Scaling group
	// recommendations.
	//
	// For example, when you specify AWS_ARM64 with:
	//
	//   - A GetEC2InstanceRecommendationsor GetAutoScalingGroupRecommendationsrequest, Compute Optimizer returns recommendations that consist of
	//   Graviton instance types only.
	//
	//   - A GetEC2RecommendationProjectedMetricsrequest, Compute Optimizer returns projected utilization metrics for
	//   Graviton instance type recommendations only.
	//
	//   - A ExportEC2InstanceRecommendationsor ExportAutoScalingGroupRecommendationsrequest, Compute Optimizer exports recommendations that consist of
	//   Graviton instance types only.
	CpuVendorArchitectures []CpuVendorArchitecture

	// Describes the activation status of the enhanced infrastructure metrics
	// preference.
	//
	// A status of Active confirms that the preference is applied in the latest
	// recommendation refresh, and a status of Inactive confirms that it's not yet
	// applied to recommendations.
	//
	// For more information, see [Enhanced infrastructure metrics] in the Compute Optimizer User Guide.
	//
	// [Enhanced infrastructure metrics]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html
	EnhancedInfrastructureMetrics EnhancedInfrastructureMetrics

	//  An object that describes the external metrics recommendation preference.
	//
	// If the preference is applied in the latest recommendation refresh, an object
	// with a valid source value appears in the response. If the preference isn't
	// applied to the recommendations already, then this object doesn't appear in the
	// response.
	ExternalMetricsPreference *ExternalMetricsPreference

	// Describes the activation status of the inferred workload types preference.
	//
	// A status of Active confirms that the preference is applied in the latest
	// recommendation refresh. A status of Inactive confirms that it's not yet applied
	// to recommendations.
	InferredWorkloadTypes InferredWorkloadTypesPreference

	//  The number of days the utilization metrics of the Amazon Web Services resource
	// are analyzed.
	LookBackPeriod LookBackPeriodPreference

	//  The resource type values that are considered as candidates when generating
	// rightsizing recommendations.
	PreferredResources []EffectivePreferredResource

	//  Describes the savings estimation mode applied for calculating savings
	// opportunity for a resource.
	SavingsEstimationMode *InstanceSavingsEstimationMode

	//  The resource’s CPU and memory utilization preferences, such as threshold and
	// headroom, that are used to generate rightsizing recommendations.
	//
	// This preference is only available for the Amazon EC2 instance resource type.
	UtilizationPreferences []UtilizationPreference

	noSmithyDocumentSerde
}

// Describes a filter that returns a more specific list of account enrollment
// statuses. Use this filter with the GetEnrollmentStatusesForOrganizationaction.
type EnrollmentFilter struct {

	// The name of the filter.
	//
	// Specify Status to return accounts with a specific enrollment status (for
	// example, Active ).
	Name EnrollmentFilterName

	// The value of the filter.
	//
	// The valid values are Active , Inactive , Pending , and Failed .
	Values []string

	noSmithyDocumentSerde
}

// Describes the estimated monthly savings amount possible, based on On-Demand
// instance pricing, by adopting Compute Optimizer recommendations for a given
// resource.
//
// For more information, see [Estimated monthly savings and savings opportunities] in the Compute Optimizer User Guide.
//
// [Estimated monthly savings and savings opportunities]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/view-ec2-recommendations.html#ec2-savings-calculation
type EstimatedMonthlySavings struct {

	// The currency of the estimated monthly savings.
	Currency Currency

	// The value of the estimated monthly savings.
	Value float64

	noSmithyDocumentSerde
}

// Describes the destination of the recommendations export and metadata files.
type ExportDestination struct {

	// An object that describes the destination Amazon Simple Storage Service (Amazon
	// S3) bucket name and object keys of a recommendations export file, and its
	// associated metadata file.
	S3 *S3Destination

	noSmithyDocumentSerde
}

//	Describes the external metrics preferences for EC2 rightsizing
//
// recommendations.
type ExternalMetricsPreference struct {

	//  Contains the source options for external metrics preferences.
	Source ExternalMetricsSource

	noSmithyDocumentSerde
}

//	Describes Compute Optimizer's integration status with your chosen external
//
// metric provider. For example, Datadog.
type ExternalMetricStatus struct {

	//  The status code for Compute Optimizer's integration with an external metrics
	// provider.
	StatusCode ExternalMetricStatusCode

	//  The reason for Compute Optimizer's integration status with your external
	// metric provider.
	StatusReason *string

	noSmithyDocumentSerde
}

// Describes a filter that returns a more specific list of recommendations. Use
// this filter with the GetAutoScalingGroupRecommendationsand GetEC2InstanceRecommendations actions.
//
// You can use EBSFilter with the GetEBSVolumeRecommendations action, LambdaFunctionRecommendationFilter with
// the GetLambdaFunctionRecommendationsaction, and JobFilter with the DescribeRecommendationExportJobs action.
type Filter struct {

	// The name of the filter.
	//
	// Specify Finding to return recommendations with a specific finding
	// classification. For example, Underprovisioned .
	//
	// Specify RecommendationSourceType to return recommendations of a specific
	// resource type. For example, Ec2Instance .
	//
	// Specify FindingReasonCodes to return recommendations with a specific finding
	// reason code. For example, CPUUnderprovisioned .
	//
	// Specify InferredWorkloadTypes to return recommendations of a specific inferred
	// workload. For example, Redis .
	//
	// You can filter your EC2 instance recommendations by tag:key and tag-key tags.
	//
	// A tag:key is a key and value combination of a tag assigned to your
	// recommendations. Use the tag key in the filter name and the tag value as the
	// filter value. For example, to find all recommendations that have a tag with the
	// key of Owner and the value of TeamA , specify tag:Owner for the filter name and
	// TeamA for the filter value.
	//
	// A tag-key is the key of a tag assigned to your recommendations. Use this filter
	// to find all of your recommendations that have a tag with a specific key. This
	// doesn’t consider the tag value. For example, you can find your recommendations
	// with a tag key value of Owner or without any tag keys assigned.
	Name FilterName

	// The value of the filter.
	//
	// The valid values for this parameter are as follows, depending on what you
	// specify for the name parameter and the resource type that you wish to filter
	// results for:
	//
	//   - Specify Optimized or NotOptimized if you specify the name parameter as
	//   Finding and you want to filter results for Auto Scaling groups.
	//
	//   - Specify Underprovisioned , Overprovisioned , or Optimized if you specify the
	//   name parameter as Finding and you want to filter results for EC2 instances.
	//
	//   - Specify Ec2Instance or AutoScalingGroup if you specify the name parameter as
	//   RecommendationSourceType .
	//
	//   - Specify one of the following options if you specify the name parameter as
	//   FindingReasonCodes :
	//
	//   - CPUOverprovisioned — The instance’s CPU configuration can be sized down
	//   while still meeting the performance requirements of your workload.
	//
	//   - CPUUnderprovisioned — The instance’s CPU configuration doesn't meet the
	//   performance requirements of your workload and there is an alternative instance
	//   type that provides better CPU performance.
	//
	//   - MemoryOverprovisioned — The instance’s memory configuration can be sized
	//   down while still meeting the performance requirements of your workload.
	//
	//   - MemoryUnderprovisioned — The instance’s memory configuration doesn't meet
	//   the performance requirements of your workload and there is an alternative
	//   instance type that provides better memory performance.
	//
	//   - EBSThroughputOverprovisioned — The instance’s EBS throughput configuration
	//   can be sized down while still meeting the performance requirements of your
	//   workload.
	//
	//   - EBSThroughputUnderprovisioned — The instance’s EBS throughput configuration
	//   doesn't meet the performance requirements of your workload and there is an
	//   alternative instance type that provides better EBS throughput performance.
	//
	//   - EBSIOPSOverprovisioned — The instance’s EBS IOPS configuration can be sized
	//   down while still meeting the performance requirements of your workload.
	//
	//   - EBSIOPSUnderprovisioned — The instance’s EBS IOPS configuration doesn't meet
	//   the performance requirements of your workload and there is an alternative
	//   instance type that provides better EBS IOPS performance.
	//
	//   - NetworkBandwidthOverprovisioned — The instance’s network bandwidth
	//   configuration can be sized down while still meeting the performance requirements
	//   of your workload.
	//
	//   - NetworkBandwidthUnderprovisioned — The instance’s network bandwidth
	//   configuration doesn't meet the performance requirements of your workload and
	//   there is an alternative instance type that provides better network bandwidth
	//   performance. This finding reason happens when the NetworkIn or NetworkOut
	//   performance of an instance is impacted.
	//
	//   - NetworkPPSOverprovisioned — The instance’s network PPS (packets per second)
	//   configuration can be sized down while still meeting the performance requirements
	//   of your workload.
	//
	//   - NetworkPPSUnderprovisioned — The instance’s network PPS (packets per second)
	//   configuration doesn't meet the performance requirements of your workload and
	//   there is an alternative instance type that provides better network PPS
	//   performance.
	//
	//   - DiskIOPSOverprovisioned — The instance’s disk IOPS configuration can be
	//   sized down while still meeting the performance requirements of your workload.
	//
	//   - DiskIOPSUnderprovisioned — The instance’s disk IOPS configuration doesn't
	//   meet the performance requirements of your workload and there is an alternative
	//   instance type that provides better disk IOPS performance.
	//
	//   - DiskThroughputOverprovisioned — The instance’s disk throughput configuration
	//   can be sized down while still meeting the performance requirements of your
	//   workload.
	//
	//   - DiskThroughputUnderprovisioned — The instance’s disk throughput
	//   configuration doesn't meet the performance requirements of your workload and
	//   there is an alternative instance type that provides better disk throughput
	//   performance.
	Values []string

	noSmithyDocumentSerde
}

// Describes an error experienced when getting recommendations.
//
// For example, an error is returned if you request recommendations for an
// unsupported Auto Scaling group, or if you request recommendations for an
// instance of an unsupported instance family.
type GetRecommendationError struct {

	// The error code.
	Code *string

	// The ID of the error.
	Identifier *string

	// The message, or reason, for the error.
	Message *string

	noSmithyDocumentSerde
}

// Describes the GPU accelerators for the instance type.
type Gpu struct {

	//  The number of GPUs for the instance type.
	GpuCount int32

	//  The total size of the memory for the GPU accelerators for the instance type,
	// in MiB.
	GpuMemorySizeInMiB int32

	noSmithyDocumentSerde
}

// Describes the GPU accelerator settings for the instance type.
type GpuInfo struct {

	//  Describes the GPU accelerators for the instance type.
	Gpus []Gpu

	noSmithyDocumentSerde
}

// Describes the estimated monthly savings possible for idle resources by adopting
// Compute Optimizer recommendations.
type IdleEstimatedMonthlySavings struct {

	// The currency of the estimated monthly savings.
	Currency Currency

	// The value of the estimated monthly savings for Idle resources.
	Value float64

	noSmithyDocumentSerde
}

// Describes an Idle resource recommendation.
type IdleRecommendation struct {

	// The Amazon Web Services account ID of the idle resource.
	AccountId *string

	// The finding classification of an idle resource.
	Finding IdleFinding

	// A summary of the findings for the resource.
	FindingDescription *string

	// The timestamp of when the idle resource recommendation was last generated.
	LastRefreshTimestamp *time.Time

	// The number of days the idle resource utilization metrics were analyzed.
	LookBackPeriodInDays float64

	// The ARN of the current idle resource.
	ResourceArn *string

	// The unique identifier for the resource.
	ResourceId *string

	// The type of resource that is idle.
	ResourceType IdleRecommendationResourceType

	// The savings opportunity for the idle resource.
	SavingsOpportunity *IdleSavingsOpportunity

	// The savings opportunity for the idle resource after any applying discounts.
	SavingsOpportunityAfterDiscounts *IdleSavingsOpportunityAfterDiscounts

	// A list of tags assigned to your idle resource recommendations.
	Tags []Tag

	// An array of objects that describe the utilization metrics of the idle resource.
	UtilizationMetrics []IdleUtilizationMetric

	noSmithyDocumentSerde
}

// Returns of list of resources that doesn't have idle recommendations.
type IdleRecommendationError struct {

	// The error code.
	Code *string

	// The ID of the error.
	Identifier *string

	// The error message.
	Message *string

	// The type of resource associated with the error.
	ResourceType IdleRecommendationResourceType

	noSmithyDocumentSerde
}

// Describes a filter that returns a more specific list of idle resource
// recommendations.
type IdleRecommendationFilter struct {

	//  The name of the filter.
	//
	// Specify Finding to return recommendations with a specific finding
	// classification.
	//
	// You can filter your idle resource recommendations by tag:key and tag-key tags.
	//
	// A tag:key is a key and value combination of a tag assigned to your idle
	// resource recommendations. Use the tag key in the filter name and the tag value
	// as the filter value. For example, to find all idle resource service
	// recommendations that have a tag with the key of Owner and the value of TeamA ,
	// specify tag:Owner for the filter name and TeamA for the filter value.
	//
	// A tag-key is the key of a tag assigned to your idle resource recommendations.
	// Use this filter to find all of your idle resource recommendations that have a
	// tag with a specific key. This doesn’t consider the tag value. For example, you
	// can find your idle resource service recommendations with a tag key value of
	// Owner or without any tag keys assigned.
	Name IdleRecommendationFilterName

	// The value of the filter.
	Values []string

	noSmithyDocumentSerde
}

// Describes the savings opportunity for idle resource recommendations.
type IdleSavingsOpportunity struct {

	// The estimated monthly savings possible by adopting Compute Optimizer's idle
	// resource recommendations.
	EstimatedMonthlySavings *IdleEstimatedMonthlySavings

	// The estimated monthly savings possible as a percentage of monthly cost by
	// adopting Compute Optimizer's idle resource recommendations.
	SavingsOpportunityPercentage float64

	noSmithyDocumentSerde
}

// Describes the savings opportunity for idle resource recommendations after
// applying discounts.
//
// Savings opportunity represents the estimated monthly savings after applying
// discounts. You can achieve this by implementing a given Compute Optimizer
// recommendation.
type IdleSavingsOpportunityAfterDiscounts struct {

	// The estimated monthly savings possible by adopting Compute Optimizer's idle
	// resource recommendations. This includes any applicable discounts.
	EstimatedMonthlySavings *IdleEstimatedMonthlySavings

	// The estimated monthly savings possible as a percentage of monthly cost by
	// adopting Compute Optimizer's idle resource recommendations. This includes any
	// applicable discounts.
	SavingsOpportunityPercentage float64

	noSmithyDocumentSerde
}

// Describes the findings summary of the idle resources.
type IdleSummary struct {

	// The name of the finding group for the idle resources.
	Name IdleFinding

	// The count of idle resources in the finding group.
	Value float64

	noSmithyDocumentSerde
}

// Describes the utilization metric of an idle resource.
type IdleUtilizationMetric struct {

	// The name of the utilization metric.
	Name IdleMetricName

	//  The statistic of the utilization metric.
	//
	// The Compute Optimizer API, Command Line Interface (CLI), and SDKs return
	// utilization metrics using only the Maximum statistic, which is the highest
	// value observed during the specified period.
	//
	// The Compute Optimizer console displays graphs for some utilization metrics
	// using the Average statistic, which is the value of Sum / SampleCount during the
	// specified period. For more information, see [Viewing resource recommendations]in the Compute Optimizer User
	// Guide. You can also get averaged utilization metric data for your resources
	// using Amazon CloudWatch. For more information, see the [Amazon CloudWatch User Guide].
	//
	// [Viewing resource recommendations]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html
	// [Amazon CloudWatch User Guide]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html
	Statistic MetricStatistic

	// The value of the utilization metric.
	Value float64

	noSmithyDocumentSerde
}

//	The estimated monthly savings after you adjust the configurations of your
//
// instances running on the inferred workload types to the recommended
// configurations. If the inferredWorkloadTypes list contains multiple entries,
// then the savings are the sum of the monthly savings from instances that run the
// exact combination of the inferred workload types.
type InferredWorkloadSaving struct {

	// An object that describes the estimated monthly savings amount possible by
	// adopting Compute Optimizer recommendations for a given resource. This is based
	// on the On-Demand instance pricing.
	EstimatedMonthlySavings *EstimatedMonthlySavings

	// The applications that might be running on the instance as inferred by Compute
	// Optimizer.
	//
	// Compute Optimizer can infer if one of the following applications might be
	// running on the instance:
	//
	//   - AmazonEmr - Infers that Amazon EMR might be running on the instance.
	//
	//   - ApacheCassandra - Infers that Apache Cassandra might be running on the
	//   instance.
	//
	//   - ApacheHadoop - Infers that Apache Hadoop might be running on the instance.
	//
	//   - Memcached - Infers that Memcached might be running on the instance.
	//
	//   - NGINX - Infers that NGINX might be running on the instance.
	//
	//   - PostgreSql - Infers that PostgreSQL might be running on the instance.
	//
	//   - Redis - Infers that Redis might be running on the instance.
	//
	//   - Kafka - Infers that Kafka might be running on the instance.
	//
	//   - SQLServer - Infers that SQLServer might be running on the instance.
	InferredWorkloadTypes []InferredWorkloadType

	noSmithyDocumentSerde
}

//	An object that describes the estimated monthly savings possible by adopting
//
// Compute Optimizer’s Amazon EC2 instance recommendations. This is based on the
// Savings Plans and Reserved Instances pricing discounts.
type InstanceEstimatedMonthlySavings struct {

	//  The currency of the estimated monthly savings.
	Currency Currency

	//  The value of the estimated monthly savings.
	Value float64

	noSmithyDocumentSerde
}

// Describes an Amazon EC2 instance recommendation.
type InstanceRecommendation struct {

	// The Amazon Web Services account ID of the instance.
	AccountId *string

	//  Describes the GPU accelerator settings for the current instance type.
	CurrentInstanceGpuInfo *GpuInfo

	// The instance type of the current instance.
	CurrentInstanceType *string

	// The risk of the current instance not meeting the performance needs of its
	// workloads. The higher the risk, the more likely the current instance cannot meet
	// the performance requirements of its workload.
	CurrentPerformanceRisk CurrentPerformanceRisk

	// An object that describes the effective recommendation preferences for the
	// instance.
	EffectiveRecommendationPreferences *EffectiveRecommendationPreferences

	//  An object that describes Compute Optimizer's integration status with your
	// external metrics provider.
	ExternalMetricStatus *ExternalMetricStatus

	// The finding classification of the instance.
	//
	// Findings for instances include:
	//
	//   - Underprovisioned —An instance is considered under-provisioned when at least
	//   one specification of your instance, such as CPU, memory, or network, does not
	//   meet the performance requirements of your workload. Under-provisioned instances
	//   may lead to poor application performance.
	//
	//   - Overprovisioned —An instance is considered over-provisioned when at least
	//   one specification of your instance, such as CPU, memory, or network, can be
	//   sized down while still meeting the performance requirements of your workload,
	//   and no specification is under-provisioned. Over-provisioned instances may lead
	//   to unnecessary infrastructure cost.
	//
	//   - Optimized —An instance is considered optimized when all specifications of
	//   your instance, such as CPU, memory, and network, meet the performance
	//   requirements of your workload and is not over provisioned. For optimized
	//   resources, Compute Optimizer might recommend a new generation instance type.
	//
	// The valid values in your API responses appear as OVER_PROVISIONED,
	// UNDER_PROVISIONED, or OPTIMIZED.
	Finding Finding

	// The reason for the finding classification of the instance.
	//
	// Finding reason codes for instances include:
	//
	//   - CPUOverprovisioned — The instance’s CPU configuration can be sized down
	//   while still meeting the performance requirements of your workload. This is
	//   identified by analyzing the CPUUtilization metric of the current instance
	//   during the look-back period.
	//
	//   - CPUUnderprovisioned — The instance’s CPU configuration doesn't meet the
	//   performance requirements of your workload and there is an alternative instance
	//   type that provides better CPU performance. This is identified by analyzing the
	//   CPUUtilization metric of the current instance during the look-back period.
	//
	//   - MemoryOverprovisioned — The instance’s memory configuration can be sized
	//   down while still meeting the performance requirements of your workload. This is
	//   identified by analyzing the memory utilization metric of the current instance
	//   during the look-back period.
	//
	//   - MemoryUnderprovisioned — The instance’s memory configuration doesn't meet
	//   the performance requirements of your workload and there is an alternative
	//   instance type that provides better memory performance. This is identified by
	//   analyzing the memory utilization metric of the current instance during the
	//   look-back period.
	//
	// Memory utilization is analyzed only for resources that have the unified
	//   CloudWatch agent installed on them. For more information, see [Enabling memory utilization with the Amazon CloudWatch Agent]in the Compute
	//   Optimizer User Guide. On Linux instances, Compute Optimizer analyses the
	//   mem_used_percent metric in the CWAgent namespace, or the legacy
	//   MemoryUtilization metric in the System/Linux namespace. On Windows instances,
	//   Compute Optimizer analyses the Memory % Committed Bytes In Use metric in the
	//   CWAgent namespace.
	//
	//   - EBSThroughputOverprovisioned — The instance’s EBS throughput configuration
	//   can be sized down while still meeting the performance requirements of your
	//   workload. This is identified by analyzing the VolumeReadBytes and
	//   VolumeWriteBytes metrics of EBS volumes attached to the current instance
	//   during the look-back period.
	//
	//   - EBSThroughputUnderprovisioned — The instance’s EBS throughput configuration
	//   doesn't meet the performance requirements of your workload and there is an
	//   alternative instance type that provides better EBS throughput performance. This
	//   is identified by analyzing the VolumeReadBytes and VolumeWriteBytes metrics of
	//   EBS volumes attached to the current instance during the look-back period.
	//
	//   - EBSIOPSOverprovisioned — The instance’s EBS IOPS configuration can be sized
	//   down while still meeting the performance requirements of your workload. This is
	//   identified by analyzing the VolumeReadOps and VolumeWriteOps metric of EBS
	//   volumes attached to the current instance during the look-back period.
	//
	//   - EBSIOPSUnderprovisioned — The instance’s EBS IOPS configuration doesn't meet
	//   the performance requirements of your workload and there is an alternative
	//   instance type that provides better EBS IOPS performance. This is identified by
	//   analyzing the VolumeReadOps and VolumeWriteOps metric of EBS volumes attached
	//   to the current instance during the look-back period.
	//
	//   - NetworkBandwidthOverprovisioned — The instance’s network bandwidth
	//   configuration can be sized down while still meeting the performance requirements
	//   of your workload. This is identified by analyzing the NetworkIn and NetworkOut
	//   metrics of the current instance during the look-back period.
	//
	//   - NetworkBandwidthUnderprovisioned — The instance’s network bandwidth
	//   configuration doesn't meet the performance requirements of your workload and
	//   there is an alternative instance type that provides better network bandwidth
	//   performance. This is identified by analyzing the NetworkIn and NetworkOut
	//   metrics of the current instance during the look-back period. This finding reason
	//   happens when the NetworkIn or NetworkOut performance of an instance is
	//   impacted.
	//
	//   - NetworkPPSOverprovisioned — The instance’s network PPS (packets per second)
	//   configuration can be sized down while still meeting the performance requirements
	//   of your workload. This is identified by analyzing the NetworkPacketsIn and
	//   NetworkPacketsIn metrics of the current instance during the look-back period.
	//
	//   - NetworkPPSUnderprovisioned — The instance’s network PPS (packets per second)
	//   configuration doesn't meet the performance requirements of your workload and
	//   there is an alternative instance type that provides better network PPS
	//   performance. This is identified by analyzing the NetworkPacketsIn and
	//   NetworkPacketsIn metrics of the current instance during the look-back period.
	//
	//   - DiskIOPSOverprovisioned — The instance’s disk IOPS configuration can be
	//   sized down while still meeting the performance requirements of your workload.
	//   This is identified by analyzing the DiskReadOps and DiskWriteOps metrics of
	//   the current instance during the look-back period.
	//
	//   - DiskIOPSUnderprovisioned — The instance’s disk IOPS configuration doesn't
	//   meet the performance requirements of your workload and there is an alternative
	//   instance type that provides better disk IOPS performance. This is identified by
	//   analyzing the DiskReadOps and DiskWriteOps metrics of the current instance
	//   during the look-back period.
	//
	//   - DiskThroughputOverprovisioned — The instance’s disk throughput configuration
	//   can be sized down while still meeting the performance requirements of your
	//   workload. This is identified by analyzing the DiskReadBytes and DiskWriteBytes
	//   metrics of the current instance during the look-back period.
	//
	//   - DiskThroughputUnderprovisioned — The instance’s disk throughput
	//   configuration doesn't meet the performance requirements of your workload and
	//   there is an alternative instance type that provides better disk throughput
	//   performance. This is identified by analyzing the DiskReadBytes and
	//   DiskWriteBytes metrics of the current instance during the look-back period.
	//
	// For more information about instance metrics, see [List the available CloudWatch metrics for your instances] in the Amazon Elastic Compute
	// Cloud User Guide. For more information about EBS volume metrics, see [Amazon CloudWatch metrics for Amazon EBS]in the
	// Amazon Elastic Compute Cloud User Guide.
	//
	// [Enabling memory utilization with the Amazon CloudWatch Agent]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent
	// [Amazon CloudWatch metrics for Amazon EBS]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html
	// [List the available CloudWatch metrics for your instances]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html
	FindingReasonCodes []InstanceRecommendationFindingReasonCode

	//  Describes if an Amazon EC2 instance is idle.
	Idle InstanceIdle

	// The applications that might be running on the instance as inferred by Compute
	// Optimizer.
	//
	// Compute Optimizer can infer if one of the following applications might be
	// running on the instance:
	//
	//   - AmazonEmr - Infers that Amazon EMR might be running on the instance.
	//
	//   - ApacheCassandra - Infers that Apache Cassandra might be running on the
	//   instance.
	//
	//   - ApacheHadoop - Infers that Apache Hadoop might be running on the instance.
	//
	//   - Memcached - Infers that Memcached might be running on the instance.
	//
	//   - NGINX - Infers that NGINX might be running on the instance.
	//
	//   - PostgreSql - Infers that PostgreSQL might be running on the instance.
	//
	//   - Redis - Infers that Redis might be running on the instance.
	//
	//   - Kafka - Infers that Kafka might be running on the instance.
	//
	//   - SQLServer - Infers that SQLServer might be running on the instance.
	InferredWorkloadTypes []InferredWorkloadType

	// The Amazon Resource Name (ARN) of the current instance.
	InstanceArn *string

	// The name of the current instance.
	InstanceName *string

	//  The state of the instance when the recommendation was generated.
	InstanceState InstanceState

	// The timestamp of when the instance recommendation was last generated.
	LastRefreshTimestamp *time.Time

	// The number of days for which utilization metrics were analyzed for the instance.
	LookBackPeriodInDays float64

	// An array of objects that describe the recommendation options for the instance.
	RecommendationOptions []InstanceRecommendationOption

	// An array of objects that describe the source resource of the recommendation.
	RecommendationSources []RecommendationSource

	//  A list of tags assigned to your Amazon EC2 instance recommendations.
	Tags []Tag

	// An array of objects that describe the utilization metrics of the instance.
	UtilizationMetrics []UtilizationMetric

	noSmithyDocumentSerde
}

// Describes a recommendation option for an Amazon EC2 instance.
type InstanceRecommendationOption struct {

	//  Describes the GPU accelerator settings for the recommended instance type.
	InstanceGpuInfo *GpuInfo

	// The instance type of the instance recommendation.
	InstanceType *string

	// The level of effort required to migrate from the current instance type to the
	// recommended instance type.
	//
	// For example, the migration effort is Low if Amazon EMR is the inferred workload
	// type and an Amazon Web Services Graviton instance type is recommended. The
	// migration effort is Medium if a workload type couldn't be inferred but an
	// Amazon Web Services Graviton instance type is recommended. The migration effort
	// is VeryLow if both the current and recommended instance types are of the same
	// CPU architecture.
	MigrationEffort MigrationEffort

	// The performance risk of the instance recommendation option.
	//
	// Performance risk indicates the likelihood of the recommended instance type not
	// meeting the resource needs of your workload. Compute Optimizer calculates an
	// individual performance risk score for each specification of the recommended
	// instance, including CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk
	// IOPS, network throughput, and network PPS. The performance risk of the
	// recommended instance is calculated as the maximum performance risk score across
	// the analyzed resource specifications.
	//
	// The value ranges from 0 - 4 , with 0 meaning that the recommended resource is
	// predicted to always provide enough hardware capability. The higher the
	// performance risk is, the more likely you should validate whether the
	// recommendation will meet the performance requirements of your workload before
	// migrating your resource.
	PerformanceRisk float64

	// Describes the configuration differences between the current instance and the
	// recommended instance type. You should consider the configuration differences
	// before migrating your workloads from the current instance to the recommended
	// instance type. The [Change the instance type guide for Linux]and [Change the instance type guide for Windows] provide general guidance for getting started with an
	// instance migration.
	//
	// Platform differences include:
	//
	//   - Hypervisor — The hypervisor of the recommended instance type is different
	//   than that of the current instance. For example, the recommended instance type
	//   uses a Nitro hypervisor and the current instance uses a Xen hypervisor. The
	//   differences that you should consider between these hypervisors are covered in
	//   the [Nitro Hypervisor]section of the Amazon EC2 frequently asked questions. For more
	//   information, see [Instances built on the Nitro System]in the Amazon EC2 User Guide for Linux, or [Instances built on the Nitro System]in the Amazon EC2
	//   User Guide for Windows.
	//
	//   - NetworkInterface — The network interface of the recommended instance type is
	//   different than that of the current instance. For example, the recommended
	//   instance type supports enhanced networking and the current instance might not.
	//   To enable enhanced networking for the recommended instance type, you must
	//   install the Elastic Network Adapter (ENA) driver or the Intel 82599 Virtual
	//   Function driver. For more information, see [Networking and storage features]and [Enhanced networking on Linux]in the Amazon EC2 User Guide
	//   for Linux, or [Networking and storage features]and [Enhanced networking on Windows]in the Amazon EC2 User Guide for Windows.
	//
	//   - StorageInterface — The storage interface of the recommended instance type is
	//   different than that of the current instance. For example, the recommended
	//   instance type uses an NVMe storage interface and the current instance does not.
	//   To access NVMe volumes for the recommended instance type, you will need to
	//   install or upgrade the NVMe driver. For more information, see [Networking and storage features]and [Amazon EBS and NVMe on Linux instances]in the
	//   Amazon EC2 User Guide for Linux, or [Networking and storage features]and [Amazon EBS and NVMe on Windows instances]in the Amazon EC2 User Guide for
	//   Windows.
	//
	//   - InstanceStoreAvailability — The recommended instance type does not support
	//   instance store volumes and the current instance does. Before migrating, you
	//   might need to back up the data on your instance store volumes if you want to
	//   preserve them. For more information, see [How do I back up an instance store volume on my Amazon EC2 instance to Amazon EBS?]in the Amazon Web Services Premium
	//   Support Knowledge Base. For more information, see [Networking and storage features]and [Amazon EC2 instance store]in the Amazon EC2 User
	//   Guide for Linux, or see [Networking and storage features]and [Amazon EC2 instance store]in the Amazon EC2 User Guide for Windows.
	//
	//   - VirtualizationType — The recommended instance type uses the hardware virtual
	//   machine (HVM) virtualization type and the current instance uses the paravirtual
	//   (PV) virtualization type. For more information about the differences between
	//   these virtualization types, see [Linux AMI virtualization types]in the Amazon EC2 User Guide for Linux, or [Windows AMI virtualization types]in
	//   the Amazon EC2 User Guide for Windows.
	//
	//   - Architecture — The CPU architecture between the recommended instance type
	//   and the current instance is different. For example, the recommended instance
	//   type might use an Arm CPU architecture and the current instance type might use a
	//   different one, such as x86. Before migrating, you should consider recompiling
	//   the software on your instance for the new architecture. Alternatively, you might
	//   switch to an Amazon Machine Image (AMI) that supports the new architecture. For
	//   more information about the CPU architecture for each instance type, see [Amazon EC2 Instance Types].
	//
	// [Enhanced networking on Linux]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/enhanced-networking.html
	// [Amazon EBS and NVMe on Linux instances]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nvme-ebs-volumes.html
	// [How do I back up an instance store volume on my Amazon EC2 instance to Amazon EBS?]: https://aws.amazon.com/premiumsupport/knowledge-center/back-up-instance-store-ebs/
	// [Enhanced networking on Windows]: https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/enhanced-networking.html
	// [Instances built on the Nitro System]: https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#ec2-nitro-instances
	// [Networking and storage features]: https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage
	// [Change the instance type guide for Windows]: https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-resize.html
	// [Linux AMI virtualization types]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/virtualization_types.html
	// [Amazon EC2 instance store]: https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/InstanceStorage.html
	// [Nitro Hypervisor]: http://aws.amazon.com/ec2/faqs/#Nitro_Hypervisor
	// [Amazon EC2 Instance Types]: http://aws.amazon.com/ec2/instance-types/
	// [Amazon EBS and NVMe on Windows instances]: https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/nvme-ebs-volumes.html
	// [Windows AMI virtualization types]: https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/windows-ami-version-history.html#virtualization-types
	// [Change the instance type guide for Linux]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-resize.html
	PlatformDifferences []PlatformDifference

	// An array of objects that describe the projected utilization metrics of the
	// instance recommendation option.
	//
	// The Cpu and Memory metrics are the only projected utilization metrics returned.
	// Additionally, the Memory metric is returned only for resources that have the
	// unified CloudWatch agent installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent].
	//
	// [Enabling Memory Utilization with the CloudWatch Agent]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent
	ProjectedUtilizationMetrics []UtilizationMetric

	// The rank of the instance recommendation option.
	//
	// The top recommendation option is ranked as 1 .
	Rank int32

	// An object that describes the savings opportunity for the instance
	// recommendation option. Savings opportunity includes the estimated monthly
	// savings amount and percentage.
	SavingsOpportunity *SavingsOpportunity

	//  An object that describes the savings opportunity for the instance
	// recommendation option that includes Savings Plans and Reserved Instances
	// discounts. Savings opportunity includes the estimated monthly savings and
	// percentage.
	SavingsOpportunityAfterDiscounts *InstanceSavingsOpportunityAfterDiscounts

	noSmithyDocumentSerde
}

//	Describes the savings estimation mode used for calculating savings opportunity
//
// for Amazon EC2 instances.
type InstanceSavingsEstimationMode struct {

	//  Describes the source for calculating the savings opportunity for Amazon EC2
	// instances.
	Source InstanceSavingsEstimationModeSource

	noSmithyDocumentSerde
}

//	Describes the savings opportunity for instance recommendations after applying
//
// the Savings Plans and Reserved Instances discounts.
//
// Savings opportunity after discounts represents the estimated monthly savings
// you can achieve by implementing Compute Optimizer recommendations.
type InstanceSavingsOpportunityAfterDiscounts struct {

	//  An object that describes the estimated monthly savings possible by adopting
	// Compute Optimizer’s Amazon EC2 instance recommendations. This is based on
	// pricing after applying the Savings Plans and Reserved Instances discounts.
	EstimatedMonthlySavings *InstanceEstimatedMonthlySavings

	//  The estimated monthly savings possible as a percentage of monthly cost after
	// applying the Savings Plans and Reserved Instances discounts. This saving can be
	// achieved by adopting Compute Optimizer’s EC2 instance recommendations.
	SavingsOpportunityPercentage float64

	noSmithyDocumentSerde
}

// Describes a filter that returns a more specific list of recommendation export
// jobs. Use this filter with the DescribeRecommendationExportJobsaction.
//
// You can use EBSFilter with the GetEBSVolumeRecommendations action, LambdaFunctionRecommendationFilter with
// the GetLambdaFunctionRecommendationsaction, and Filter with the GetAutoScalingGroupRecommendations and GetEC2InstanceRecommendations actions.
type JobFilter struct {

	// The name of the filter.
	//
	// Specify ResourceType to return export jobs of a specific resource type (for
	// example, Ec2Instance ).
	//
	// Specify JobStatus to return export jobs with a specific status (e.g, Complete ).
	Name JobFilterName

	// The value of the filter.
	//
	// The valid values for this parameter are as follows, depending on what you
	// specify for the name parameter:
	//
	//   - Specify Ec2Instance or AutoScalingGroup if you specify the name parameter as
	//   ResourceType . There is no filter for EBS volumes because volume
	//   recommendations cannot be exported at this time.
	//
	//   - Specify Queued , InProgress , Complete , or Failed if you specify the name
	//   parameter as JobStatus .
	Values []string

	noSmithyDocumentSerde
}

// Describes the effective recommendation preferences for Lambda functions.
type LambdaEffectiveRecommendationPreferences struct {

	//  Describes the savings estimation mode applied for calculating savings
	// opportunity for Lambda functions.
	SavingsEstimationMode *LambdaSavingsEstimationMode

	noSmithyDocumentSerde
}

//	Describes the estimated monthly savings possible for Lambda functions by
//
// adopting Compute Optimizer recommendations. This is based on Lambda functions
// pricing after applying Savings Plans discounts.
type LambdaEstimatedMonthlySavings struct {

	//  The currency of the estimated monthly savings.
	Currency Currency

	//  The value of the estimated monthly savings.
	Value float64

	noSmithyDocumentSerde
}

// Describes a projected utilization metric of an Lambda function recommendation
// option.
type LambdaFunctionMemoryProjectedMetric struct {

	// The name of the projected utilization metric.
	Name LambdaFunctionMemoryMetricName

	// The statistic of the projected utilization metric.
	Statistic LambdaFunctionMemoryMetricStatistic

	// The values of the projected utilization metrics.
	Value float64

	noSmithyDocumentSerde
}

// Describes a recommendation option for an Lambda function.
type LambdaFunctionMemoryRecommendationOption struct {

	// The memory size, in MB, of the function recommendation option.
	MemorySize int32

	// An array of objects that describe the projected utilization metrics of the
	// function recommendation option.
	ProjectedUtilizationMetrics []LambdaFunctionMemoryProjectedMetric

	// The rank of the function recommendation option.
	//
	// The top recommendation option is ranked as 1 .
	Rank int32

	// An object that describes the savings opportunity for the Lambda function
	// recommendation option. Savings opportunity includes the estimated monthly
	// savings amount and percentage.
	SavingsOpportunity *SavingsOpportunity

	//  An object that describes the savings opportunity for the Lambda recommendation
	// option which includes Saving Plans discounts. Savings opportunity includes the
	// estimated monthly savings and percentage.
	SavingsOpportunityAfterDiscounts *LambdaSavingsOpportunityAfterDiscounts

	noSmithyDocumentSerde
}

// Describes an Lambda function recommendation.
type LambdaFunctionRecommendation struct {

	// The Amazon Web Services account ID of the function.
	AccountId *string

	// The amount of memory, in MB, that's allocated to the current function.
	CurrentMemorySize int32

	// The risk of the current Lambda function not meeting the performance needs of
	// its workloads. The higher the risk, the more likely the current Lambda function
	// requires more memory.
	CurrentPerformanceRisk CurrentPerformanceRisk

	//  Describes the effective recommendation preferences for Lambda functions.
	EffectiveRecommendationPreferences *LambdaEffectiveRecommendationPreferences

	// The finding classification of the function.
	//
	// Findings for functions include:
	//
	//   - Optimized — The function is correctly provisioned to run your workload based
	//   on its current configuration and its utilization history. This finding
	//   classification does not include finding reason codes.
	//
	//   - NotOptimized — The function is performing at a higher level
	//   (over-provisioned) or at a lower level (under-provisioned) than required for
	//   your workload because its current configuration is not optimal. Over-provisioned
	//   resources might lead to unnecessary infrastructure cost, and under-provisioned
	//   resources might lead to poor application performance. This finding
	//   classification can include the MemoryUnderprovisioned and
	//   MemoryUnderprovisioned finding reason codes.
	//
	//   - Unavailable — Compute Optimizer was unable to generate a recommendation for
	//   the function. This could be because the function has not accumulated sufficient
	//   metric data, or the function does not qualify for a recommendation. This finding
	//   classification can include the InsufficientData and Inconclusive finding
	//   reason codes.
	//
	// Functions with a finding of unavailable are not returned unless you specify the
	//   filter parameter with a value of Unavailable in your
	//   GetLambdaFunctionRecommendations request.
	Finding LambdaFunctionRecommendationFinding

	// The reason for the finding classification of the function.
	//
	// Functions that have a finding classification of Optimized don't have a finding
	// reason code.
	//
	// Finding reason codes for functions include:
	//
	//   - MemoryOverprovisioned — The function is over-provisioned when its memory
	//   configuration can be sized down while still meeting the performance requirements
	//   of your workload. An over-provisioned function might lead to unnecessary
	//   infrastructure cost. This finding reason code is part of the NotOptimized
	//   finding classification.
	//
	//   - MemoryUnderprovisioned — The function is under-provisioned when its memory
	//   configuration doesn't meet the performance requirements of the workload. An
	//   under-provisioned function might lead to poor application performance. This
	//   finding reason code is part of the NotOptimized finding classification.
	//
	//   - InsufficientData — The function does not have sufficient metric data for
	//   Compute Optimizer to generate a recommendation. For more information, see the [Supported resources and requirements]
	//   in the Compute Optimizer User Guide. This finding reason code is part of the
	//   Unavailable finding classification.
	//
	//   - Inconclusive — The function does not qualify for a recommendation because
	//   Compute Optimizer cannot generate a recommendation with a high degree of
	//   confidence. This finding reason code is part of the Unavailable finding
	//   classification.
	//
	// [Supported resources and requirements]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html
	FindingReasonCodes []LambdaFunctionRecommendationFindingReasonCode

	// The Amazon Resource Name (ARN) of the current function.
	FunctionArn *string

	// The version number of the current function.
	FunctionVersion *string

	// The timestamp of when the function recommendation was last generated.
	LastRefreshTimestamp *time.Time

	// The number of days for which utilization metrics were analyzed for the function.
	LookbackPeriodInDays float64

	// An array of objects that describe the memory configuration recommendation
	// options for the function.
	MemorySizeRecommendationOptions []LambdaFunctionMemoryRecommendationOption

	// The number of times your function code was applied during the look-back period.
	NumberOfInvocations int64

	//  A list of tags assigned to your Lambda function recommendations.
	Tags []Tag

	// An array of objects that describe the utilization metrics of the function.
	UtilizationMetrics []LambdaFunctionUtilizationMetric

	noSmithyDocumentSerde
}

// Describes a filter that returns a more specific list of Lambda function
// recommendations. Use this filter with the GetLambdaFunctionRecommendationsaction.
//
// You can use EBSFilter with the GetEBSVolumeRecommendations action, JobFilter with the DescribeRecommendationExportJobs action, and Filter
// with the GetAutoScalingGroupRecommendationsand GetEC2InstanceRecommendations actions.
type LambdaFunctionRecommendationFilter struct {

	// The name of the filter.
	//
	// Specify Finding to return recommendations with a specific finding
	// classification (for example, NotOptimized ).
	//
	// Specify FindingReasonCode to return recommendations with a specific finding
	// reason code (for example, MemoryUnderprovisioned ).
	//
	// You can filter your Lambda function recommendations by tag:key and tag-key tags.
	//
	// A tag:key is a key and value combination of a tag assigned to your Lambda
	// function recommendations. Use the tag key in the filter name and the tag value
	// as the filter value. For example, to find all Lambda function recommendations
	// that have a tag with the key of Owner and the value of TeamA , specify tag:Owner
	// for the filter name and TeamA for the filter value.
	//
	// A tag-key is the key of a tag assigned to your Lambda function recommendations.
	// Use this filter to find all of your Lambda function recommendations that have a
	// tag with a specific key. This doesn’t consider the tag value. For example, you
	// can find your Lambda function recommendations with a tag key value of Owner or
	// without any tag keys assigned.
	Name LambdaFunctionRecommendationFilterName

	// The value of the filter.
	//
	// The valid values for this parameter are as follows, depending on what you
	// specify for the name parameter:
	//
	//   - Specify Optimized , NotOptimized , or Unavailable if you specify the name
	//   parameter as Finding .
	//
	//   - Specify MemoryOverprovisioned , MemoryUnderprovisioned , InsufficientData ,
	//   or Inconclusive if you specify the name parameter as FindingReasonCode .
	Values []string

	noSmithyDocumentSerde
}

// Describes a utilization metric of an Lambda function.
type LambdaFunctionUtilizationMetric struct {

	// The name of the utilization metric.
	//
	// The following utilization metrics are available:
	//
	//   - Duration - The amount of time that your function code spends processing an
	//   event.
	//
	//   - Memory - The amount of memory used per invocation.
	Name LambdaFunctionMetricName

	// The statistic of the utilization metric.
	//
	// The Compute Optimizer API, Command Line Interface (CLI), and SDKs return
	// utilization metrics using only the Maximum statistic, which is the highest
	// value observed during the specified period.
	//
	// The Compute Optimizer console displays graphs for some utilization metrics
	// using the Average statistic, which is the value of Sum / SampleCount during the
	// specified period. For more information, see [Viewing resource recommendations]in the Compute Optimizer User
	// Guide. You can also get averaged utilization metric data for your resources
	// using Amazon CloudWatch. For more information, see the [Amazon CloudWatch User Guide].
	//
	// [Viewing resource recommendations]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html
	// [Amazon CloudWatch User Guide]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html
	Statistic LambdaFunctionMetricStatistic

	// The value of the utilization metric.
	Value float64

	noSmithyDocumentSerde
}

//	Describes the savings estimation used for calculating savings opportunity for
//
// Lambda functions.
type LambdaSavingsEstimationMode struct {

	//  Describes the source for calculation of savings opportunity for Lambda
	// functions.
	Source LambdaSavingsEstimationModeSource

	noSmithyDocumentSerde
}

//	Describes the savings opportunity for Lambda functions recommendations after
//
// applying Savings Plans discounts.
//
// Savings opportunity represents the estimated monthly savings after applying
// Savings Plans discounts. You can achieve this by implementing a given Compute
// Optimizer recommendation.
type LambdaSavingsOpportunityAfterDiscounts struct {

	//  The estimated monthly savings possible by adopting Compute Optimizer’s Lambda
	// function recommendations. This includes any applicable Savings Plans discounts.
	EstimatedMonthlySavings *LambdaEstimatedMonthlySavings

	//  The estimated monthly savings possible as a percentage of monthly cost by
	// adopting Compute Optimizer’s Lambda function recommendations. This includes any
	// applicable Savings Plans discounts.
	SavingsOpportunityPercentage float64

	noSmithyDocumentSerde
}

// Describes the configuration of a license for an Amazon EC2 instance.
type LicenseConfiguration struct {

	//  The instance type used in the license.
	InstanceType *string

	//  The edition of the license for the application that runs on the instance.
	LicenseEdition LicenseEdition

	//  The license type associated with the instance.
	LicenseModel LicenseModel

	//  The name of the license for the application that runs on the instance.
	LicenseName LicenseName

	//  The version of the license for the application that runs on the instance.
	LicenseVersion *string

	//  The list of metric sources required to generate recommendations for commercial
	// software licenses.
	MetricsSource []MetricSource

	//  The current number of cores associated with the instance.
	NumberOfCores int32

	//  The operating system of the instance.
	OperatingSystem *string

	noSmithyDocumentSerde
}

// Describes a license recommendation for an EC2 instance.
type LicenseRecommendation struct {

	//  The Amazon Web Services account ID of the license.
	AccountId *string

	//  An object that describes the current configuration of an instance that runs on
	// a license.
	CurrentLicenseConfiguration *LicenseConfiguration

	//  The finding classification for an instance that runs on a license.
	//
	// Findings include:
	//
	//   - InsufficentMetrics — When Compute Optimizer detects that your CloudWatch
	//   Application Insights isn't enabled or is enabled with insufficient permissions.
	//
	//   - NotOptimized — When Compute Optimizer detects that your EC2 infrastructure
	//   isn't using any of the SQL server license features you're paying for, a license
	//   is considered not optimized.
	//
	//   - Optimized — When Compute Optimizer detects that all specifications of your
	//   license meet the performance requirements of your workload.
	Finding LicenseFinding

	//  The reason for the finding classification for an instance that runs on a
	// license.
	//
	// Finding reason codes include:
	//
	//   - Optimized — All specifications of your license meet the performance
	//   requirements of your workload.
	//
	//   - LicenseOverprovisioned — A license is considered over-provisioned when your
	//   license can be downgraded while still meeting the performance requirements of
	//   your workload.
	//
	//   - InvalidCloudwatchApplicationInsights — CloudWatch Application Insights isn't
	//   configured properly.
	//
	//   - CloudwatchApplicationInsightsError — There is a CloudWatch Application
	//   Insights error.
	FindingReasonCodes []LicenseFindingReasonCode

	//  The timestamp of when the license recommendation was last generated.
	LastRefreshTimestamp *time.Time

	//  An array of objects that describe the license recommendation options.
	LicenseRecommendationOptions []LicenseRecommendationOption

	//  The number of days for which utilization metrics were analyzed for an instance
	// that runs on a license.
	LookbackPeriodInDays float64

	//  The ARN that identifies the Amazon EC2 instance.
	ResourceArn *string

	//  A list of tags assigned to an EC2 instance.
	Tags []Tag

	noSmithyDocumentSerde
}

//	Describes a filter that returns a more specific list of license
//
// recommendations. Use this filter with the GetLicenseRecommendation action.
type LicenseRecommendationFilter struct {

	// The name of the filter.
	//
	// Specify Finding to return recommendations with a specific finding
	// classification.
	//
	// Specify FindingReasonCode to return recommendations with a specific finding
	// reason code.
	//
	// You can filter your license recommendations by tag:key and tag-key tags.
	//
	// A tag:key is a key and value combination of a tag assigned to your license
	// recommendations. Use the tag key in the filter name and the tag value as the
	// filter value. For example, to find all license recommendations that have a tag
	// with the key of Owner and the value of TeamA , specify tag:Owner for the filter
	// name and TeamA for the filter value.
	//
	// A tag-key is the key of a tag assigned to your license recommendations. Use
	// this filter to find all of your license recommendations that have a tag with a
	// specific key. This doesn’t consider the tag value. For example, you can find
	// your license recommendations with a tag key value of Owner or without any tag
	// keys assigned.
	Name LicenseRecommendationFilterName

	// The value of the filter.
	//
	// The valid values for this parameter are as follows, depending on what you
	// specify for the name parameter:
	//
	//   - If you specify the name parameter as Finding , then specify Optimized ,
	//   NotOptimized , or InsufficentMetrics .
	//
	//   - If you specify the name parameter as FindingReasonCode , then specify
	//   Optimized , LicenseOverprovisioned , InvalidCloudwatchApplicationInsights , or
	//   CloudwatchApplicationInsightsError .
	Values []string

	noSmithyDocumentSerde
}

// Describes the recommendation options for licenses.
type LicenseRecommendationOption struct {

	//  The recommended edition of the license for the application that runs on the
	// instance.
	LicenseEdition LicenseEdition

	//  The recommended license type associated with the instance.
	LicenseModel LicenseModel

	//  The operating system of a license recommendation option.
	OperatingSystem *string

	//  The rank of the license recommendation option.
	//
	// The top recommendation option is ranked as 1 .
	Rank int32

	// Describes the savings opportunity for recommendations of a given resource type
	// or for the recommendation option of an individual resource.
	//
	// Savings opportunity represents the estimated monthly savings you can achieve by
	// implementing a given Compute Optimizer recommendation.
	//
	// Savings opportunity data requires that you opt in to Cost Explorer, as well as
	// activate Receive Amazon EC2 resource recommendations in the Cost Explorer
	// preferences page. That creates a connection between Cost Explorer and Compute
	// Optimizer. With this connection, Cost Explorer generates savings estimates
	// considering the price of existing resources, the price of recommended resources,
	// and historical usage data. Estimated monthly savings reflects the projected
	// dollar savings associated with each of the recommendations generated. For more
	// information, see [Enabling Cost Explorer]and [Optimizing your cost with Rightsizing Recommendations] in the Cost Management User Guide.
	//
	// [Optimizing your cost with Rightsizing Recommendations]: https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html
	// [Enabling Cost Explorer]: https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html
	SavingsOpportunity *SavingsOpportunity

	noSmithyDocumentSerde
}

// The memory size configurations of a container.
type MemorySizeConfiguration struct {

	//  The amount of memory in the container.
	Memory *int32

	//  The limit of memory reserve for the container.
	MemoryReservation *int32

	noSmithyDocumentSerde
}

//	The list of metric sources required to generate recommendations for commercial
//
// software licenses.
type MetricSource struct {

	//  The name of the metric source provider.
	Provider MetricSourceProvider

	//  The ARN of the metric source provider.
	ProviderArn *string

	noSmithyDocumentSerde
}

// Describes how the recommendations are ordered.
type OrderBy struct {

	// The dimension values to sort the recommendations.
	Dimension Dimension

	// The order to sort the recommendations.
	Order Order

	noSmithyDocumentSerde
}

//	The preference to control which resource type values are considered when
//
// generating rightsizing recommendations. You can specify this preference as a
// combination of include and exclude lists. You must specify either an includeList
// or excludeList . If the preference is an empty set of resource type values, an
// error occurs. For more information, see [Rightsizing recommendation preferences]in the Compute Optimizer User Guide.
//
//   - This preference is only available for the Amazon EC2 instance and Auto
//     Scaling group resource types.
//
//   - Compute Optimizer only supports the customization of Ec2InstanceTypes .
//
// [Rightsizing recommendation preferences]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/rightsizing-preferences.html
type PreferredResource struct {

	//  The preferred resource type values to exclude from the recommendation
	// candidates. If this isn’t specified, all supported resources are included by
	// default. You can specify up to 1000 values in this list.
	ExcludeList []string

	//  The preferred resource type values to include in the recommendation
	// candidates. You can specify the exact resource type value, such as m5.large, or
	// use wild card expressions, such as m5. If this isn’t specified, all supported
	// resources are included by default. You can specify up to 1000 values in this
	// list.
	IncludeList []string

	//  The type of preferred resource to customize.
	//
	// Compute Optimizer only supports the customization of Ec2InstanceTypes .
	Name PreferredResourceName

	noSmithyDocumentSerde
}

// Describes a projected utilization metric of a recommendation option, such as an
// Amazon EC2 instance. This represents the projected utilization of a
// recommendation option had you used that resource during the analyzed period.
//
// Compare the utilization metric data of your resource against its projected
// utilization metric data to determine the performance difference between your
// current resource and the recommended option.
//
// The Cpu , Memory , GPU , and GPU_MEMORY metrics are the only projected
// utilization metrics returned when you run the GetEC2RecommendationProjectedMetricsaction. Additionally, these
// metrics are only returned for resources with the unified CloudWatch agent
// installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent]and [Enabling NVIDIA GPU utilization with the CloudWatch Agent].
//
// [Enabling Memory Utilization with the CloudWatch Agent]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent
// [Enabling NVIDIA GPU utilization with the CloudWatch Agent]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#nvidia-cw-agent
type ProjectedMetric struct {

	// The name of the projected utilization metric.
	//
	// The following projected utilization metrics are returned:
	//
	//   - Cpu - The projected percentage of allocated EC2 compute units that would be
	//   in use on the recommendation option had you used that resource during the
	//   analyzed period. This metric identifies the processing power required to run an
	//   application on the recommendation option.
	//
	// Depending on the instance type, tools in your operating system can show a lower
	//   percentage than CloudWatch when the instance is not allocated a full processor
	//   core.
	//
	//   - Memory - The percentage of memory that would be in use on the recommendation
	//   option had you used that resource during the analyzed period. This metric
	//   identifies the amount of memory required to run an application on the
	//   recommendation option.
	//
	// Units: Percent
	//
	// The Memory metric is only returned for resources with the unified CloudWatch
	//   agent installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent].
	//
	//   - GPU - The projected percentage of allocated GPUs if you adjust your
	//   configurations to Compute Optimizer's recommendation option.
	//
	//   - GPU_MEMORY - The projected percentage of total GPU memory if you adjust your
	//   configurations to Compute Optimizer's recommendation option.
	//
	// The GPU and GPU_MEMORY metrics are only returned for resources with the unified
	//   CloudWatch Agent installed on them. For more information, see [Enabling NVIDIA GPU utilization with the CloudWatch Agent].
	//
	// [Enabling Memory Utilization with the CloudWatch Agent]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent
	// [Enabling NVIDIA GPU utilization with the CloudWatch Agent]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#nvidia-cw-agent
	Name MetricName

	// The timestamps of the projected utilization metric.
	Timestamps []time.Time

	// The values of the projected utilization metrics.
	Values []float64

	noSmithyDocumentSerde
}

//	Describes the projected metrics of an Amazon RDS recommendation option.
//
// To determine the performance difference between your current Amazon RDS and the
// recommended option, compare the metric data of your service against its
// projected metric data.
type RDSDatabaseProjectedMetric struct {

	//  The name of the projected metric.
	Name RDSDBMetricName

	//  The timestamps of the projected metric.
	Timestamps []time.Time

	//  The values for the projected metric.
	Values []float64

	noSmithyDocumentSerde
}

//	Describes the projected metrics of an Amazon RDS recommendation option.
//
// To determine the performance difference between your current Amazon RDS and the
// recommended option, compare the metric data of your service against its
// projected metric data.
type RDSDatabaseRecommendedOptionProjectedMetric struct {

	//  An array of objects that describe the projected metric.
	ProjectedMetrics []RDSDatabaseProjectedMetric

	//  The rank identifier of the RDS instance recommendation option.
	Rank int32

	//  The recommended DB instance class for the Amazon RDS.
	RecommendedDBInstanceClass *string

	noSmithyDocumentSerde
}

// Describes the recommendation options for an Amazon RDS instance.
type RDSDBInstanceRecommendationOption struct {

	//  Describes the DB instance class recommendation option for your Amazon RDS
	// instance.
	DbInstanceClass *string

	//  The performance risk of the RDS instance recommendation option.
	PerformanceRisk float64

	//  An array of objects that describe the projected utilization metrics of the RDS
	// instance recommendation option.
	ProjectedUtilizationMetrics []RDSDBUtilizationMetric

	//  The rank identifier of the RDS instance recommendation option.
	Rank int32

	// Describes the savings opportunity for recommendations of a given resource type
	// or for the recommendation option of an individual resource.
	//
	// Savings opportunity represents the estimated monthly savings you can achieve by
	// implementing a given Compute Optimizer recommendation.
	//
	// Savings opportunity data requires that you opt in to Cost Explorer, as well as
	// activate Receive Amazon EC2 resource recommendations in the Cost Explorer
	// preferences page. That creates a connection between Cost Explorer and Compute
	// Optimizer. With this connection, Cost Explorer generates savings estimates
	// considering the price of existing resources, the price of recommended resources,
	// and historical usage data. Estimated monthly savings reflects the projected
	// dollar savings associated with each of the recommendations generated. For more
	// information, see [Enabling Cost Explorer]and [Optimizing your cost with Rightsizing Recommendations] in the Cost Management User Guide.
	//
	// [Optimizing your cost with Rightsizing Recommendations]: https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html
	// [Enabling Cost Explorer]: https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html
	SavingsOpportunity *SavingsOpportunity

	//  Describes the savings opportunity for Amazon RDS recommendations or for the
	// recommendation option.
	//
	// Savings opportunity represents the estimated monthly savings after applying
	// Savings Plans discounts. You can achieve this by implementing a given Compute
	// Optimizer recommendation.
	SavingsOpportunityAfterDiscounts *RDSInstanceSavingsOpportunityAfterDiscounts

	noSmithyDocumentSerde
}

// Describes an Amazon RDS recommendation.
type RDSDBRecommendation struct {

	//  The Amazon Web Services account ID of the Amazon RDS.
	AccountId *string

	//  The DB instance class of the current RDS instance.
	CurrentDBInstanceClass *string

	// The performance risk for the current DB instance.
	CurrentInstancePerformanceRisk RDSCurrentInstancePerformanceRisk

	//  The configuration of the current RDS storage.
	CurrentStorageConfiguration *DBStorageConfiguration

	// The identifier for DB cluster.
	DbClusterIdentifier *string

	//  Describes the effective recommendation preferences for Amazon RDS.
	EffectiveRecommendationPreferences *RDSEffectiveRecommendationPreferences

	//  The engine of the RDS instance.
	Engine *string

	//  The database engine version.
	EngineVersion *string

	//  This indicates if the RDS instance is idle or not.
	Idle Idle

	//  The finding classification of an Amazon RDS instance.
	//
	// Findings for Amazon RDS instance include:
	//
	//   - Underprovisioned — When Compute Optimizer detects that there’s not enough
	//   resource specifications, an Amazon RDS is considered under-provisioned.
	//
	//   - Overprovisioned — When Compute Optimizer detects that there’s excessive
	//   resource specifications, an Amazon RDS is considered over-provisioned.
	//
	//   - Optimized — When the specifications of your Amazon RDS instance meet the
	//   performance requirements of your workload, the service is considered optimized.
	InstanceFinding RDSInstanceFinding

	//  The reason for the finding classification of an Amazon RDS instance.
	InstanceFindingReasonCodes []RDSInstanceFindingReasonCode

	//  An array of objects that describe the recommendation options for the Amazon
	// RDS instance.
	InstanceRecommendationOptions []RDSDBInstanceRecommendationOption

	//  The timestamp of when the Amazon RDS recommendation was last generated.
	LastRefreshTimestamp *time.Time

	//  The number of days the Amazon RDS utilization metrics were analyzed.
	LookbackPeriodInDays float64

	// The promotion tier for the Aurora instance.
	PromotionTier *int32

	//  The ARN of the current Amazon RDS.
	//
	// The following is the format of the ARN:
	//
	//     arn:aws:rds:{region}:{accountId}:db:{resourceName}
	ResourceArn *string

	//  The finding classification of Amazon RDS storage.
	//
	// Findings for Amazon RDS instance include:
	//
	//   - Underprovisioned — When Compute Optimizer detects that there’s not enough
	//   storage, an Amazon RDS is considered under-provisioned.
	//
	//   - Overprovisioned — When Compute Optimizer detects that there’s excessive
	//   storage, an Amazon RDS is considered over-provisioned.
	//
	//   - Optimized — When the storage of your Amazon RDS meet the performance
	//   requirements of your workload, the service is considered optimized.
	StorageFinding RDSStorageFinding

	//  The reason for the finding classification of Amazon RDS storage.
	StorageFindingReasonCodes []RDSStorageFindingReasonCode

	//  An array of objects that describe the recommendation options for Amazon RDS
	// storage.
	StorageRecommendationOptions []RDSDBStorageRecommendationOption

	//  A list of tags assigned to your Amazon RDS recommendations.
	Tags []Tag

	//  An array of objects that describe the utilization metrics of the Amazon RDS.
	UtilizationMetrics []RDSDBUtilizationMetric

	noSmithyDocumentSerde
}

//	Describes a filter that returns a more specific list of Amazon RDS
//
// recommendations. Use this filter with the GetECSServiceRecommendationsaction.
type RDSDBRecommendationFilter struct {

	//  The name of the filter.
	//
	// Specify Finding to return recommendations with a specific finding
	// classification.
	//
	// You can filter your Amazon RDS recommendations by tag:key and tag-key tags.
	//
	// A tag:key is a key and value combination of a tag assigned to your Amazon RDS
	// recommendations. Use the tag key in the filter name and the tag value as the
	// filter value. For example, to find all Amazon RDS service recommendations that
	// have a tag with the key of Owner and the value of TeamA , specify tag:Owner for
	// the filter name and TeamA for the filter value.
	//
	// A tag-key is the key of a tag assigned to your Amazon RDS recommendations. Use
	// this filter to find all of your Amazon RDS recommendations that have a tag with
	// a specific key. This doesn’t consider the tag value. For example, you can find
	// your Amazon RDS service recommendations with a tag key value of Owner or
	// without any tag keys assigned.
	Name RDSDBRecommendationFilterName

	//  The value of the filter.
	Values []string

	noSmithyDocumentSerde
}

// Describes the recommendation options for Amazon RDS storage.
type RDSDBStorageRecommendationOption struct {

	//  The rank identifier of the RDS storage recommendation option.
	Rank int32

	// Describes the savings opportunity for recommendations of a given resource type
	// or for the recommendation option of an individual resource.
	//
	// Savings opportunity represents the estimated monthly savings you can achieve by
	// implementing a given Compute Optimizer recommendation.
	//
	// Savings opportunity data requires that you opt in to Cost Explorer, as well as
	// activate Receive Amazon EC2 resource recommendations in the Cost Explorer
	// preferences page. That creates a connection between Cost Explorer and Compute
	// Optimizer. With this connection, Cost Explorer generates savings estimates
	// considering the price of existing resources, the price of recommended resources,
	// and historical usage data. Estimated monthly savings reflects the projected
	// dollar savings associated with each of the recommendations generated. For more
	// information, see [Enabling Cost Explorer]and [Optimizing your cost with Rightsizing Recommendations] in the Cost Management User Guide.
	//
	// [Optimizing your cost with Rightsizing Recommendations]: https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html
	// [Enabling Cost Explorer]: https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html
	SavingsOpportunity *SavingsOpportunity

	//  Describes the savings opportunity for Amazon RDS storage recommendations or
	// for the recommendation option.
	//
	// Savings opportunity represents the estimated monthly savings after applying
	// Savings Plans discounts. You can achieve this by implementing a given Compute
	// Optimizer recommendation.
	SavingsOpportunityAfterDiscounts *RDSStorageSavingsOpportunityAfterDiscounts

	//  The recommended storage configuration.
	StorageConfiguration *DBStorageConfiguration

	noSmithyDocumentSerde
}

//	Describes the utilization metric of an Amazon RDS.
//
// To determine the performance difference between your current Amazon RDS and the
// recommended option, compare the utilization metric data of your service against
// its projected utilization metric data.
type RDSDBUtilizationMetric struct {

	//  The name of the utilization metric.
	Name RDSDBMetricName

	//  The statistic of the utilization metric.
	//
	// The Compute Optimizer API, Command Line Interface (CLI), and SDKs return
	// utilization metrics using only the Maximum statistic, which is the highest
	// value observed during the specified period.
	//
	// The Compute Optimizer console displays graphs for some utilization metrics
	// using the Average statistic, which is the value of Sum / SampleCount during the
	// specified period. For more information, see [Viewing resource recommendations]in the Compute Optimizer User
	// Guide. You can also get averaged utilization metric data for your resources
	// using Amazon CloudWatch. For more information, see the [Amazon CloudWatch User Guide].
	//
	// [Viewing resource recommendations]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html
	// [Amazon CloudWatch User Guide]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html
	Statistic RDSDBMetricStatistic

	//  The value of the utilization metric.
	Value float64

	noSmithyDocumentSerde
}

// Describes the effective recommendation preferences for Amazon RDS.
type RDSEffectiveRecommendationPreferences struct {

	//  Describes the CPU vendor and architecture for Amazon RDS recommendations.
	CpuVendorArchitectures []CpuVendorArchitecture

	// Describes the activation status of the enhanced infrastructure metrics
	// preference.
	//
	// A status of Active confirms that the preference is applied in the latest
	// recommendation refresh, and a status of Inactive confirms that it's not yet
	// applied to recommendations.
	//
	// For more information, see [Enhanced infrastructure metrics] in the Compute Optimizer User Guide.
	//
	// [Enhanced infrastructure metrics]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html
	EnhancedInfrastructureMetrics EnhancedInfrastructureMetrics

	//  The number of days the utilization metrics of the Amazon RDS are analyzed.
	LookBackPeriod LookBackPeriodPreference

	//  Describes the savings estimation mode preference applied for calculating
	// savings opportunity for Amazon RDS.
	SavingsEstimationMode *RDSSavingsEstimationMode

	noSmithyDocumentSerde
}

//	Describes the estimated monthly savings possible for Amazon RDS instances by
//
// adopting Compute Optimizer recommendations. This is based on Amazon RDS pricing
// after applying Savings Plans discounts.
type RDSInstanceEstimatedMonthlySavings struct {

	//  The currency of the estimated monthly savings.
	Currency Currency

	//  The value of the estimated monthly savings for Amazon RDS instances.
	Value float64

	noSmithyDocumentSerde
}

//	Describes the savings opportunity for Amazon RDS instance recommendations
//
// after applying Savings Plans discounts.
//
// Savings opportunity represents the estimated monthly savings after applying
// Savings Plans discounts. You can achieve this by implementing a given Compute
// Optimizer recommendation.
type RDSInstanceSavingsOpportunityAfterDiscounts struct {

	//  The estimated monthly savings possible by adopting Compute Optimizer’s Amazon
	// RDS instance recommendations. This includes any applicable Savings Plans
	// discounts.
	EstimatedMonthlySavings *RDSInstanceEstimatedMonthlySavings

	//  The estimated monthly savings possible as a percentage of monthly cost by
	// adopting Compute Optimizer’s Amazon RDS instance recommendations. This includes
	// any applicable Savings Plans discounts.
	SavingsOpportunityPercentage float64

	noSmithyDocumentSerde
}

//	Describes the savings estimation mode used for calculating savings opportunity
//
// for Amazon RDS.
type RDSSavingsEstimationMode struct {

	//  Describes the source for calculating the savings opportunity for Amazon RDS.
	Source RDSSavingsEstimationModeSource

	noSmithyDocumentSerde
}

//	Describes the estimated monthly savings possible for Amazon RDS storage by
//
// adopting Compute Optimizer recommendations. This is based on Amazon RDS pricing
// after applying Savings Plans discounts.
type RDSStorageEstimatedMonthlySavings struct {

	//  The currency of the estimated monthly savings.
	Currency Currency

	//  The value of the estimated monthly savings for Amazon RDS storage.
	Value float64

	noSmithyDocumentSerde
}

//	Describes the savings opportunity for Amazon RDS storage recommendations after
//
// applying Savings Plans discounts.
//
// Savings opportunity represents the estimated monthly savings after applying
// Savings Plans discounts. You can achieve this by implementing a given Compute
// Optimizer recommendation.
type RDSStorageSavingsOpportunityAfterDiscounts struct {

	//  The estimated monthly savings possible by adopting Compute Optimizer’s Amazon
	// RDS storage recommendations. This includes any applicable Savings Plans
	// discounts.
	EstimatedMonthlySavings *RDSStorageEstimatedMonthlySavings

	//  The estimated monthly savings possible as a percentage of monthly cost by
	// adopting Compute Optimizer’s Amazon RDS storage recommendations. This includes
	// any applicable Savings Plans discounts.
	SavingsOpportunityPercentage float64

	noSmithyDocumentSerde
}

// A summary of a finding reason code.
type ReasonCodeSummary struct {

	// The name of the finding reason code.
	Name FindingReasonCode

	// The value of the finding reason code summary.
	Value float64

	noSmithyDocumentSerde
}

// Describes a recommendation export job.
//
// Use the DescribeRecommendationExportJobs action to view your recommendation export jobs.
//
// Use the ExportAutoScalingGroupRecommendations or ExportEC2InstanceRecommendations actions to request an export of your recommendations.
type RecommendationExportJob struct {

	// The timestamp of when the export job was created.
	CreationTimestamp *time.Time

	// An object that describes the destination of the export file.
	Destination *ExportDestination

	// The reason for an export job failure.
	FailureReason *string

	// The identification number of the export job.
	JobId *string

	// The timestamp of when the export job was last updated.
	LastUpdatedTimestamp *time.Time

	// The resource type of the exported recommendations.
	ResourceType ResourceType

	// The status of the export job.
	Status JobStatus

	noSmithyDocumentSerde
}

// Describes the recommendation preferences to return in the response of a GetAutoScalingGroupRecommendations, GetEC2InstanceRecommendations, GetEC2RecommendationProjectedMetrics, GetRDSDatabaseRecommendations,
// and GetRDSDatabaseRecommendationProjectedMetricsrequest.
type RecommendationPreferences struct {

	// Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto
	// Scaling group recommendations.
	//
	// For example, when you specify AWS_ARM64 with:
	//
	//   - A GetEC2InstanceRecommendationsor GetAutoScalingGroupRecommendationsrequest, Compute Optimizer returns recommendations that consist of
	//   Graviton instance types only.
	//
	//   - A GetEC2RecommendationProjectedMetricsrequest, Compute Optimizer returns projected utilization metrics for
	//   Graviton instance type recommendations only.
	//
	//   - A ExportEC2InstanceRecommendationsor ExportAutoScalingGroupRecommendationsrequest, Compute Optimizer exports recommendations that consist of
	//   Graviton instance types only.
	CpuVendorArchitectures []CpuVendorArchitecture

	noSmithyDocumentSerde
}

// Describes a recommendation preference.
type RecommendationPreferencesDetail struct {

	// The status of the enhanced infrastructure metrics recommendation preference.
	//
	// When the recommendations page is refreshed, a status of Active confirms that
	// the preference is applied to the recommendations, and a status of Inactive
	// confirms that the preference isn't yet applied to recommendations.
	//
	// For more information, see [Enhanced infrastructure metrics] in the Compute Optimizer User Guide.
	//
	// [Enhanced infrastructure metrics]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html
	EnhancedInfrastructureMetrics EnhancedInfrastructureMetrics

	//  An object that describes the external metrics recommendation preference.
	//
	// If the preference is applied in the latest recommendation refresh, an object
	// with a valid source value appears in the response. If the preference isn't
	// applied to the recommendations already, then this object doesn't appear in the
	// response.
	ExternalMetricsPreference *ExternalMetricsPreference

	// The status of the inferred workload types recommendation preference.
	//
	// When the recommendations page is refreshed, a status of Active confirms that
	// the preference is applied to the recommendations, and a status of Inactive
	// confirms that the preference isn't yet applied to recommendations.
	InferredWorkloadTypes InferredWorkloadTypesPreference

	//  The preference to control the number of days the utilization metrics of the
	// Amazon Web Services resource are analyzed. If the preference isn’t set, this
	// object is null.
	LookBackPeriod LookBackPeriodPreference

	//  The preference to control which resource type values are considered when
	// generating rightsizing recommendations. This object resolves any wildcard
	// expressions and returns the effective list of candidate resource type values. If
	// the preference isn’t set, this object is null.
	PreferredResources []EffectivePreferredResource

	// The target resource type of the recommendation preference to create.
	//
	// The Ec2Instance option encompasses standalone instances and instances that are
	// part of Auto Scaling groups. The AutoScalingGroup option encompasses only
	// instances that are part of an Auto Scaling group.
	ResourceType ResourceType

	//  Describes the savings estimation mode used for calculating savings
	// opportunity.
	//
	// Only the account manager or delegated administrator of your organization can
	// activate this preference.
	SavingsEstimationMode SavingsEstimationMode

	// An object that describes the scope of the recommendation preference.
	//
	// Recommendation preferences can be created at the organization level (for
	// management accounts of an organization only), account level, and resource level.
	// For more information, see [Activating enhanced infrastructure metrics]in the Compute Optimizer User Guide.
	//
	// [Activating enhanced infrastructure metrics]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html
	Scope *Scope

	//  The preference to control the resource’s CPU utilization threshold, CPU
	// utilization headroom, and memory utilization headroom. If the preference isn’t
	// set, this object is null.
	//
	// This preference is only available for the Amazon EC2 instance resource type.
	UtilizationPreferences []UtilizationPreference

	noSmithyDocumentSerde
}

// Describes the source of a recommendation, such as an Amazon EC2 instance or
// Auto Scaling group.
type RecommendationSource struct {

	// The Amazon Resource Name (ARN) of the recommendation source.
	RecommendationSourceArn *string

	// The resource type of the recommendation source.
	RecommendationSourceType RecommendationSourceType

	noSmithyDocumentSerde
}

// A summary of a recommendation.
type RecommendationSummary struct {

	// The Amazon Web Services account ID of the recommendation summary.
	AccountId *string

	// Describes the savings opportunity for recommendations of a given resource type
	// or for the recommendation option of an individual resource.
	//
	// Savings opportunity represents the estimated monthly savings you can achieve by
	// implementing a given Compute Optimizer recommendation.
	//
	// Savings opportunity data requires that you opt in to Cost Explorer, as well as
	// activate Receive Amazon EC2 resource recommendations in the Cost Explorer
	// preferences page. That creates a connection between Cost Explorer and Compute
	// Optimizer. With this connection, Cost Explorer generates savings estimates
	// considering the price of existing resources, the price of recommended resources,
	// and historical usage data. Estimated monthly savings reflects the projected
	// dollar savings associated with each of the recommendations generated. For more
	// information, see [Enabling Cost Explorer]and [Optimizing your cost with Rightsizing Recommendations] in the Cost Management User Guide.
	//
	// [Optimizing your cost with Rightsizing Recommendations]: https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html
	// [Enabling Cost Explorer]: https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html
	AggregatedSavingsOpportunity *SavingsOpportunity

	// An object that describes the performance risk ratings for a given resource type.
	CurrentPerformanceRiskRatings *CurrentPerformanceRiskRatings

	// Describes the savings opportunity for recommendations of a given resource type
	// or for the recommendation option of an individual resource.
	//
	// Savings opportunity represents the estimated monthly savings you can achieve by
	// implementing a given Compute Optimizer recommendation.
	//
	// Savings opportunity data requires that you opt in to Cost Explorer, as well as
	// activate Receive Amazon EC2 resource recommendations in the Cost Explorer
	// preferences page. That creates a connection between Cost Explorer and Compute
	// Optimizer. With this connection, Cost Explorer generates savings estimates
	// considering the price of existing resources, the price of recommended resources,
	// and historical usage data. Estimated monthly savings reflects the projected
	// dollar savings associated with each of the recommendations generated. For more
	// information, see [Enabling Cost Explorer]and [Optimizing your cost with Rightsizing Recommendations] in the Cost Management User Guide.
	//
	// [Optimizing your cost with Rightsizing Recommendations]: https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html
	// [Enabling Cost Explorer]: https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html
	IdleSavingsOpportunity *SavingsOpportunity

	//  Describes the findings summary of the idle resources.
	IdleSummaries []IdleSummary

	//  An array of objects that describes the estimated monthly saving amounts for
	// the instances running on the specified inferredWorkloadTypes . The array
	// contains the top five savings opportunites for the instances that run inferred
	// workload types.
	InferredWorkloadSavings []InferredWorkloadSaving

	// The resource type that the recommendation summary applies to.
	RecommendationResourceType RecommendationSourceType

	// An object that describes the savings opportunity for a given resource type.
	// Savings opportunity includes the estimated monthly savings amount and
	// percentage.
	SavingsOpportunity *SavingsOpportunity

	// An array of objects that describe a recommendation summary.
	Summaries []Summary

	noSmithyDocumentSerde
}

// Describes a projected utilization metric of a recommendation option.
//
// The Cpu and Memory metrics are the only projected utilization metrics returned
// when you run the GetEC2RecommendationProjectedMetricsaction. Additionally, the Memory metric is returned only for
// resources that have the unified CloudWatch agent installed on them. For more
// information, see [Enabling Memory Utilization with the CloudWatch Agent].
//
// [Enabling Memory Utilization with the CloudWatch Agent]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent
type RecommendedOptionProjectedMetric struct {

	// An array of objects that describe a projected utilization metric.
	ProjectedMetrics []ProjectedMetric

	// The rank of the recommendation option projected metric.
	//
	// The top recommendation option is ranked as 1 .
	//
	// The projected metric rank correlates to the recommendation option rank. For
	// example, the projected metric ranked as 1 is related to the recommendation
	// option that is also ranked as 1 in the same response.
	Rank int32

	// The recommended instance type.
	RecommendedInstanceType *string

	noSmithyDocumentSerde
}

// Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name
// and object keys of a recommendations export file, and its associated metadata
// file.
type S3Destination struct {

	// The name of the Amazon S3 bucket used as the destination of an export file.
	Bucket *string

	// The Amazon S3 bucket key of an export file.
	//
	// The key uniquely identifies the object, or export file, in the S3 bucket.
	Key *string

	// The Amazon S3 bucket key of a metadata file.
	//
	// The key uniquely identifies the object, or metadata file, in the S3 bucket.
	MetadataKey *string

	noSmithyDocumentSerde
}

// Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name
// and key prefix for a recommendations export job.
//
// You must create the destination Amazon S3 bucket for your recommendations
// export before you create the export job. Compute Optimizer does not create the
// S3 bucket for you. After you create the S3 bucket, ensure that it has the
// required permission policy to allow Compute Optimizer to write the export file
// to it. If you plan to specify an object prefix when you create the export job,
// you must include the object prefix in the policy that you add to the S3 bucket.
// For more information, see [Amazon S3 Bucket Policy for Compute Optimizer]in the Compute Optimizer User Guide.
//
// [Amazon S3 Bucket Policy for Compute Optimizer]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html
type S3DestinationConfig struct {

	// The name of the Amazon S3 bucket to use as the destination for an export job.
	Bucket *string

	// The Amazon S3 bucket prefix for an export job.
	KeyPrefix *string

	noSmithyDocumentSerde
}

// Describes the savings opportunity for recommendations of a given resource type
// or for the recommendation option of an individual resource.
//
// Savings opportunity represents the estimated monthly savings you can achieve by
// implementing a given Compute Optimizer recommendation.
//
// Savings opportunity data requires that you opt in to Cost Explorer, as well as
// activate Receive Amazon EC2 resource recommendations in the Cost Explorer
// preferences page. That creates a connection between Cost Explorer and Compute
// Optimizer. With this connection, Cost Explorer generates savings estimates
// considering the price of existing resources, the price of recommended resources,
// and historical usage data. Estimated monthly savings reflects the projected
// dollar savings associated with each of the recommendations generated. For more
// information, see [Enabling Cost Explorer]and [Optimizing your cost with Rightsizing Recommendations] in the Cost Management User Guide.
//
// [Optimizing your cost with Rightsizing Recommendations]: https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html
// [Enabling Cost Explorer]: https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html
type SavingsOpportunity struct {

	// An object that describes the estimated monthly savings amount possible by
	// adopting Compute Optimizer recommendations for a given resource. This is based
	// on the On-Demand instance pricing..
	EstimatedMonthlySavings *EstimatedMonthlySavings

	// The estimated monthly savings possible as a percentage of monthly cost by
	// adopting Compute Optimizer recommendations for a given resource.
	SavingsOpportunityPercentage float64

	noSmithyDocumentSerde
}

// Describes the scope of a recommendation preference.
//
// Recommendation preferences can be created at the organization level (for
// management accounts of an organization only), account level, and resource level.
// For more information, see [Activating enhanced infrastructure metrics]in the Compute Optimizer User Guide.
//
// You cannot create recommendation preferences for Auto Scaling groups at the
// organization and account levels. You can create recommendation preferences for
// Auto Scaling groups only at the resource level by specifying a scope name of
// ResourceArn and a scope value of the Auto Scaling group Amazon Resource Name
// (ARN). This will configure the preference for all instances that are part of the
// specified Auto Scaling group. You also cannot create recommendation preferences
// at the resource level for instances that are part of an Auto Scaling group. You
// can create recommendation preferences at the resource level only for standalone
// instances.
//
// [Activating enhanced infrastructure metrics]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html
type Scope struct {

	// The name of the scope.
	//
	// The following scopes are possible:
	//
	//   - Organization - Specifies that the recommendation preference applies at the
	//   organization level, for all member accounts of an organization.
	//
	//   - AccountId - Specifies that the recommendation preference applies at the
	//   account level, for all resources of a given resource type in an account.
	//
	//   - ResourceArn - Specifies that the recommendation preference applies at the
	//   individual resource level.
	Name ScopeName

	// The value of the scope.
	//
	// If you specified the name of the scope as:
	//
	//   - Organization - The value must be ALL_ACCOUNTS .
	//
	//   - AccountId - The value must be a 12-digit Amazon Web Services account ID.
	//
	//   - ResourceArn - The value must be the Amazon Resource Name (ARN) of an EC2
	//   instance or an Auto Scaling group.
	//
	// Only EC2 instance and Auto Scaling group ARNs are currently supported.
	Value *string

	noSmithyDocumentSerde
}

// The Amazon ECS service configurations used for recommendations.
type ServiceConfiguration struct {

	//  Describes the Auto Scaling configuration methods for an Amazon ECS service.
	// This affects the generated recommendations. For example, if Auto Scaling is
	// configured on a service’s CPU, then Compute Optimizer doesn’t generate CPU size
	// recommendations.
	//
	// The Auto Scaling configuration methods include:
	//
	//   - TARGET_TRACKING_SCALING_CPU — If the Amazon ECS service is configured to use
	//   target scaling on CPU, Compute Optimizer doesn't generate CPU recommendations.
	//
	//   - TARGET_TRACKING_SCALING_MEMORY — If the Amazon ECS service is configured to
	//   use target scaling on memory, Compute Optimizer doesn't generate memory
	//   recommendations.
	//
	// For more information about step scaling and target scaling, see [Step scaling policies for Application Auto Scaling] and [Target tracking scaling policies for Application Auto Scaling] in the
	// Application Auto Scaling User Guide.
	//
	// [Step scaling policies for Application Auto Scaling]: https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html
	// [Target tracking scaling policies for Application Auto Scaling]: https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html
	AutoScalingConfiguration AutoScalingConfiguration

	//  The container configurations within a task of an Amazon ECS service.
	ContainerConfigurations []ContainerConfiguration

	//  The number of CPU units used by the tasks in the Amazon ECS service.
	Cpu *int32

	//  The amount of memory used by the tasks in the Amazon ECS service.
	Memory *int32

	//  The task definition ARN used by the tasks in the Amazon ECS service.
	TaskDefinitionArn *string

	noSmithyDocumentSerde
}

// The summary of a recommendation.
type Summary struct {

	// The finding classification of the recommendation.
	Name Finding

	// An array of objects that summarize a finding reason code.
	ReasonCodeSummaries []ReasonCodeSummary

	// The value of the recommendation summary.
	Value float64

	noSmithyDocumentSerde
}

// A list of tag key and value pairs that you define.
type Tag struct {

	//  One part of a key-value pair that makes up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	Key *string

	//  One part of a key-value pair that make up a tag. A value acts as a descriptor
	// within a tag category (key). The value can be empty or null.
	Value *string

	noSmithyDocumentSerde
}

// Describes a utilization metric of a resource, such as an Amazon EC2 instance.
//
// Compare the utilization metric data of your resource against its projected
// utilization metric data to determine the performance difference between your
// current resource and the recommended option.
type UtilizationMetric struct {

	// The name of the utilization metric.
	//
	// The following utilization metrics are available:
	//
	//   - Cpu - The percentage of allocated EC2 compute units that are currently in
	//   use on the instance. This metric identifies the processing power required to run
	//   an application on the instance.
	//
	// Depending on the instance type, tools in your operating system can show a lower
	//   percentage than CloudWatch when the instance is not allocated a full processor
	//   core.
	//
	// Units: Percent
	//
	//   - Memory - The percentage of memory that is currently in use on the instance.
	//   This metric identifies the amount of memory required to run an application on
	//   the instance.
	//
	// Units: Percent
	//
	// The Memory metric is returned only for resources that have the unified
	//   CloudWatch agent installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent].
	//
	//   - GPU - The percentage of allocated GPUs that currently run on the instance.
	//
	//   - GPU_MEMORY - The percentage of total GPU memory that currently runs on the
	//   instance.
	//
	// The GPU and GPU_MEMORY metrics are only returned for resources with the unified
	//   CloudWatch Agent installed on them. For more information, see [Enabling NVIDIA GPU utilization with the CloudWatch Agent].
	//
	//   - EBS_READ_OPS_PER_SECOND - The completed read operations from all EBS volumes
	//   attached to the instance in a specified period of time.
	//
	// Unit: Count
	//
	//   - EBS_WRITE_OPS_PER_SECOND - The completed write operations to all EBS volumes
	//   attached to the instance in a specified period of time.
	//
	// Unit: Count
	//
	//   - EBS_READ_BYTES_PER_SECOND - The bytes read from all EBS volumes attached to
	//   the instance in a specified period of time.
	//
	// Unit: Bytes
	//
	//   - EBS_WRITE_BYTES_PER_SECOND - The bytes written to all EBS volumes attached
	//   to the instance in a specified period of time.
	//
	// Unit: Bytes
	//
	//   - DISK_READ_OPS_PER_SECOND - The completed read operations from all instance
	//   store volumes available to the instance in a specified period of time.
	//
	// If there are no instance store volumes, either the value is 0 or the metric is
	//   not reported.
	//
	//   - DISK_WRITE_OPS_PER_SECOND - The completed write operations from all instance
	//   store volumes available to the instance in a specified period of time.
	//
	// If there are no instance store volumes, either the value is 0 or the metric is
	//   not reported.
	//
	//   - DISK_READ_BYTES_PER_SECOND - The bytes read from all instance store volumes
	//   available to the instance. This metric is used to determine the volume of the
	//   data the application reads from the disk of the instance. This can be used to
	//   determine the speed of the application.
	//
	// If there are no instance store volumes, either the value is 0 or the metric is
	//   not reported.
	//
	//   - DISK_WRITE_BYTES_PER_SECOND - The bytes written to all instance store
	//   volumes available to the instance. This metric is used to determine the volume
	//   of the data the application writes onto the disk of the instance. This can be
	//   used to determine the speed of the application.
	//
	// If there are no instance store volumes, either the value is 0 or the metric is
	//   not reported.
	//
	//   - NETWORK_IN_BYTES_PER_SECOND - The number of bytes received by the instance
	//   on all network interfaces. This metric identifies the volume of incoming network
	//   traffic to a single instance.
	//
	//   - NETWORK_OUT_BYTES_PER_SECOND - The number of bytes sent out by the instance
	//   on all network interfaces. This metric identifies the volume of outgoing network
	//   traffic from a single instance.
	//
	//   - NETWORK_PACKETS_IN_PER_SECOND - The number of packets received by the
	//   instance on all network interfaces. This metric identifies the volume of
	//   incoming traffic in terms of the number of packets on a single instance.
	//
	//   - NETWORK_PACKETS_OUT_PER_SECOND - The number of packets sent out by the
	//   instance on all network interfaces. This metric identifies the volume of
	//   outgoing traffic in terms of the number of packets on a single instance.
	//
	// [Enabling Memory Utilization with the CloudWatch Agent]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent
	// [Enabling NVIDIA GPU utilization with the CloudWatch Agent]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#nvidia-cw-agent
	Name MetricName

	// The statistic of the utilization metric.
	//
	// The Compute Optimizer API, Command Line Interface (CLI), and SDKs return
	// utilization metrics using only the Maximum statistic, which is the highest
	// value observed during the specified period.
	//
	// The Compute Optimizer console displays graphs for some utilization metrics
	// using the Average statistic, which is the value of Sum / SampleCount during the
	// specified period. For more information, see [Viewing resource recommendations]in the Compute Optimizer User
	// Guide. You can also get averaged utilization metric data for your resources
	// using Amazon CloudWatch. For more information, see the [Amazon CloudWatch User Guide].
	//
	// [Viewing resource recommendations]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html
	// [Amazon CloudWatch User Guide]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html
	Statistic MetricStatistic

	// The value of the utilization metric.
	Value float64

	noSmithyDocumentSerde
}

//	The preference to control the resource’s CPU utilization threshold, CPU
//
// utilization headroom, and memory utilization headroom.
//
// This preference is only available for the Amazon EC2 instance resource type.
type UtilizationPreference struct {

	//  The name of the resource utilization metric name to customize.
	MetricName CustomizableMetricName

	//  The parameters to set when customizing the resource utilization thresholds.
	MetricParameters *CustomizableMetricParameters

	noSmithyDocumentSerde
}

// Describes the configuration of an Amazon Elastic Block Store (Amazon EBS)
// volume.
type VolumeConfiguration struct {

	//  Contains the image used to boot the instance during launch.
	RootVolume *bool

	// The baseline IOPS of the volume.
	VolumeBaselineIOPS int32

	// The baseline throughput of the volume.
	VolumeBaselineThroughput int32

	// The burst IOPS of the volume.
	VolumeBurstIOPS int32

	// The burst throughput of the volume.
	VolumeBurstThroughput int32

	// The size of the volume, in GiB.
	VolumeSize int32

	// The volume type.
	//
	// The volume types can be the following:
	//
	//   - General Purpose SSD gp2 and gp3
	//
	//   - Provisioned IOPS SSD io1 , io2 , and io2 Block Express
	//
	//   - Throughput Optimized HDD st1
	//
	//   - Cold HDD sc1
	//
	//   - Magnetic volumes standard
	VolumeType *string

	noSmithyDocumentSerde
}

// Describes an Amazon Elastic Block Store (Amazon EBS) volume recommendation.
type VolumeRecommendation struct {

	// The Amazon Web Services account ID of the volume.
	AccountId *string

	// An array of objects that describe the current configuration of the volume.
	CurrentConfiguration *VolumeConfiguration

	// The risk of the current EBS volume not meeting the performance needs of its
	// workloads. The higher the risk, the more likely the current EBS volume doesn't
	// have sufficient capacity.
	CurrentPerformanceRisk CurrentPerformanceRisk

	//  Describes the effective recommendation preferences for Amazon EBS volume.
	EffectiveRecommendationPreferences *EBSEffectiveRecommendationPreferences

	// The finding classification of the volume.
	//
	// Findings for volumes include:
	//
	//   - NotOptimized —A volume is considered not optimized when Compute Optimizer
	//   identifies a recommendation that can provide better performance for your
	//   workload.
	//
	//   - Optimized —An volume is considered optimized when Compute Optimizer
	//   determines that the volume is correctly provisioned to run your workload based
	//   on the chosen volume type. For optimized resources, Compute Optimizer might
	//   recommend a new generation volume type.
	Finding EBSFinding

	// The timestamp of when the volume recommendation was last generated.
	LastRefreshTimestamp *time.Time

	// The number of days for which utilization metrics were analyzed for the volume.
	LookBackPeriodInDays float64

	//  A list of tags assigned to your Amazon EBS volume recommendations.
	Tags []Tag

	// An array of objects that describe the utilization metrics of the volume.
	UtilizationMetrics []EBSUtilizationMetric

	// The Amazon Resource Name (ARN) of the current volume.
	VolumeArn *string

	// An array of objects that describe the recommendation options for the volume.
	VolumeRecommendationOptions []VolumeRecommendationOption

	noSmithyDocumentSerde
}

// Describes a recommendation option for an Amazon Elastic Block Store (Amazon
// EBS) instance.
type VolumeRecommendationOption struct {

	// An array of objects that describe a volume configuration.
	Configuration *VolumeConfiguration

	// The performance risk of the volume recommendation option.
	//
	// Performance risk is the likelihood of the recommended volume type meeting the
	// performance requirement of your workload.
	//
	// The value ranges from 0 - 4 , with 0 meaning that the recommended resource is
	// predicted to always provide enough hardware capability. The higher the
	// performance risk is, the more likely you should validate whether the
	// recommendation will meet the performance requirements of your workload before
	// migrating your resource.
	PerformanceRisk float64

	// The rank of the volume recommendation option.
	//
	// The top recommendation option is ranked as 1 .
	Rank int32

	// An object that describes the savings opportunity for the EBS volume
	// recommendation option. Savings opportunity includes the estimated monthly
	// savings amount and percentage.
	SavingsOpportunity *SavingsOpportunity

	//  An object that describes the savings opportunity for the Amazon EBS volume
	// recommendation option with specific discounts. Savings opportunity includes the
	// estimated monthly savings and percentage.
	SavingsOpportunityAfterDiscounts *EBSSavingsOpportunityAfterDiscounts

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
