// Code generated by smithy-go-codegen DO NOT EDIT.

package configservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Deletes an existing service-linked configuration recorder.
//
// This operation does not delete the configuration information that was
// previously recorded. You will be able to access the previously recorded
// information by using the [GetResourceConfigHistory]operation, but you will not be able to access this
// information in the Config console until you have created a new service-linked
// configuration recorder for the same service.
//
// # The recording scope determines if you receive configuration items
//
// The recording scope is set by the service that is linked to the configuration
// recorder and determines whether you receive configuration items (CIs) in the
// delivery channel. If the recording scope is internal, you will not receive CIs
// in the delivery channel.
//
// [GetResourceConfigHistory]: https://docs.aws.amazon.com/config/latest/APIReference/API_GetResourceConfigHistory.html
func (c *Client) DeleteServiceLinkedConfigurationRecorder(ctx context.Context, params *DeleteServiceLinkedConfigurationRecorderInput, optFns ...func(*Options)) (*DeleteServiceLinkedConfigurationRecorderOutput, error) {
	if params == nil {
		params = &DeleteServiceLinkedConfigurationRecorderInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteServiceLinkedConfigurationRecorder", params, optFns, c.addOperationDeleteServiceLinkedConfigurationRecorderMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteServiceLinkedConfigurationRecorderOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteServiceLinkedConfigurationRecorderInput struct {

	// The service principal of the Amazon Web Services service for the service-linked
	// configuration recorder that you want to delete.
	//
	// This member is required.
	ServicePrincipal *string

	noSmithyDocumentSerde
}

type DeleteServiceLinkedConfigurationRecorderOutput struct {

	// The Amazon Resource Name (ARN) of the specified configuration recorder.
	//
	// This member is required.
	Arn *string

	// The name of the specified configuration recorder.
	//
	// This member is required.
	Name *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteServiceLinkedConfigurationRecorderMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDeleteServiceLinkedConfigurationRecorder{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDeleteServiceLinkedConfigurationRecorder{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DeleteServiceLinkedConfigurationRecorder"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDeleteServiceLinkedConfigurationRecorderValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteServiceLinkedConfigurationRecorder(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteServiceLinkedConfigurationRecorder(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DeleteServiceLinkedConfigurationRecorder",
	}
}
