// Code generated by smithy-go-codegen DO NOT EDIT.

package configservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/configservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the number of compliant and noncompliant rules for one or more accounts
// and regions in an aggregator.
//
// The results can return an empty result page, but if you have a nextToken, the
// results are displayed on the next page.
func (c *Client) GetAggregateConfigRuleComplianceSummary(ctx context.Context, params *GetAggregateConfigRuleComplianceSummaryInput, optFns ...func(*Options)) (*GetAggregateConfigRuleComplianceSummaryOutput, error) {
	if params == nil {
		params = &GetAggregateConfigRuleComplianceSummaryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAggregateConfigRuleComplianceSummary", params, optFns, c.addOperationGetAggregateConfigRuleComplianceSummaryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAggregateConfigRuleComplianceSummaryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAggregateConfigRuleComplianceSummaryInput struct {

	// The name of the configuration aggregator.
	//
	// This member is required.
	ConfigurationAggregatorName *string

	// Filters the results based on the ConfigRuleComplianceSummaryFilters object.
	Filters *types.ConfigRuleComplianceSummaryFilters

	// Groups the result based on ACCOUNT_ID or AWS_REGION.
	GroupByKey types.ConfigRuleComplianceSummaryGroupKey

	// The maximum number of evaluation results returned on each page. The default is
	// 1000. You cannot specify a number greater than 1000. If you specify 0, Config
	// uses the default.
	Limit int32

	// The nextToken string returned on a previous page that you use to get the next
	// page of results in a paginated response.
	NextToken *string

	noSmithyDocumentSerde
}

type GetAggregateConfigRuleComplianceSummaryOutput struct {

	// Returns a list of AggregateComplianceCounts object.
	AggregateComplianceCounts []types.AggregateComplianceCount

	// Groups the result based on ACCOUNT_ID or AWS_REGION.
	GroupByKey *string

	// The nextToken string returned on a previous page that you use to get the next
	// page of results in a paginated response.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAggregateConfigRuleComplianceSummaryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetAggregateConfigRuleComplianceSummary{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetAggregateConfigRuleComplianceSummary{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAggregateConfigRuleComplianceSummary"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetAggregateConfigRuleComplianceSummaryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAggregateConfigRuleComplianceSummary(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// GetAggregateConfigRuleComplianceSummaryPaginatorOptions is the paginator
// options for GetAggregateConfigRuleComplianceSummary
type GetAggregateConfigRuleComplianceSummaryPaginatorOptions struct {
	// The maximum number of evaluation results returned on each page. The default is
	// 1000. You cannot specify a number greater than 1000. If you specify 0, Config
	// uses the default.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetAggregateConfigRuleComplianceSummaryPaginator is a paginator for
// GetAggregateConfigRuleComplianceSummary
type GetAggregateConfigRuleComplianceSummaryPaginator struct {
	options   GetAggregateConfigRuleComplianceSummaryPaginatorOptions
	client    GetAggregateConfigRuleComplianceSummaryAPIClient
	params    *GetAggregateConfigRuleComplianceSummaryInput
	nextToken *string
	firstPage bool
}

// NewGetAggregateConfigRuleComplianceSummaryPaginator returns a new
// GetAggregateConfigRuleComplianceSummaryPaginator
func NewGetAggregateConfigRuleComplianceSummaryPaginator(client GetAggregateConfigRuleComplianceSummaryAPIClient, params *GetAggregateConfigRuleComplianceSummaryInput, optFns ...func(*GetAggregateConfigRuleComplianceSummaryPaginatorOptions)) *GetAggregateConfigRuleComplianceSummaryPaginator {
	if params == nil {
		params = &GetAggregateConfigRuleComplianceSummaryInput{}
	}

	options := GetAggregateConfigRuleComplianceSummaryPaginatorOptions{}
	if params.Limit != 0 {
		options.Limit = params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetAggregateConfigRuleComplianceSummaryPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetAggregateConfigRuleComplianceSummaryPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetAggregateConfigRuleComplianceSummary page.
func (p *GetAggregateConfigRuleComplianceSummaryPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetAggregateConfigRuleComplianceSummaryOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.Limit = p.options.Limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetAggregateConfigRuleComplianceSummary(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetAggregateConfigRuleComplianceSummaryAPIClient is a client that implements
// the GetAggregateConfigRuleComplianceSummary operation.
type GetAggregateConfigRuleComplianceSummaryAPIClient interface {
	GetAggregateConfigRuleComplianceSummary(context.Context, *GetAggregateConfigRuleComplianceSummaryInput, ...func(*Options)) (*GetAggregateConfigRuleComplianceSummaryOutput, error)
}

var _ GetAggregateConfigRuleComplianceSummaryAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetAggregateConfigRuleComplianceSummary(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAggregateConfigRuleComplianceSummary",
	}
}
