// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Allows you to retrieve metadata about multiple attached files on an associated
// resource. Each attached file provided in the input list must be associated with
// the input AssociatedResourceArn.
func (c *Client) BatchGetAttachedFileMetadata(ctx context.Context, params *BatchGetAttachedFileMetadataInput, optFns ...func(*Options)) (*BatchGetAttachedFileMetadataOutput, error) {
	if params == nil {
		params = &BatchGetAttachedFileMetadataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchGetAttachedFileMetadata", params, optFns, c.addOperationBatchGetAttachedFileMetadataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchGetAttachedFileMetadataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchGetAttachedFileMetadataInput struct {

	// The resource to which the attached file is (being) uploaded to. The supported
	// resources are [Cases]and [Email].
	//
	// This value must be a valid ARN.
	//
	// [Email]: https://docs.aws.amazon.com/connect/latest/adminguide/setup-email-channel.html
	// [Cases]: https://docs.aws.amazon.com/connect/latest/adminguide/cases.html
	//
	// This member is required.
	AssociatedResourceArn *string

	// The unique identifiers of the attached file resource.
	//
	// This member is required.
	FileIds []string

	// The unique identifier of the Connect instance.
	//
	// This member is required.
	InstanceId *string

	noSmithyDocumentSerde
}

type BatchGetAttachedFileMetadataOutput struct {

	// List of errors of attached files that could not be retrieved.
	Errors []types.AttachedFileError

	// List of attached files that were successfully retrieved.
	Files []types.AttachedFile

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchGetAttachedFileMetadataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpBatchGetAttachedFileMetadata{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpBatchGetAttachedFileMetadata{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchGetAttachedFileMetadata"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpBatchGetAttachedFileMetadataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchGetAttachedFileMetadata(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchGetAttachedFileMetadata(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchGetAttachedFileMetadata",
	}
}
