// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Places an inbound in-app, web, or video call to a contact, and then initiates
// the flow. It performs the actions in the flow that are specified (in
// ContactFlowId) and present in the Amazon Connect instance (specified as
// InstanceId).
func (c *Client) StartWebRTCContact(ctx context.Context, params *StartWebRTCContactInput, optFns ...func(*Options)) (*StartWebRTCContactOutput, error) {
	if params == nil {
		params = &StartWebRTCContactInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartWebRTCContact", params, optFns, c.addOperationStartWebRTCContactMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartWebRTCContactOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartWebRTCContactInput struct {

	// The identifier of the flow for the call. To see the ContactFlowId in the Amazon
	// Connect admin website, on the navigation menu go to Routing, Flows. Choose the
	// flow. On the flow page, under the name of the flow, choose Show additional flow
	// information. The ContactFlowId is the last part of the ARN, shown here in bold:
	//
	// arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/846ec553-a005-41c0-8341-xxxxxxxxxxxx
	//
	// This member is required.
	ContactFlowId *string

	// The identifier of the Amazon Connect instance. You can [find the instance ID] in the Amazon Resource
	// Name (ARN) of the instance.
	//
	// [find the instance ID]: https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html
	//
	// This member is required.
	InstanceId *string

	// The customer's details.
	//
	// This member is required.
	ParticipantDetails *types.ParticipantDetails

	// Information about the video sharing capabilities of the participants (customer,
	// agent).
	AllowedCapabilities *types.AllowedCapabilities

	// A custom key-value pair using an attribute map. The attributes are standard
	// Amazon Connect attributes, and can be accessed in flows just like any other
	// contact attributes.
	//
	// There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact.
	// Attribute keys can include only alphanumeric, -, and _ characters.
	Attributes map[string]string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see [Making retries safe with idempotent APIs].
	//
	// The token is valid for 7 days after creation. If a contact is already started,
	// the contact ID is returned.
	//
	// [Making retries safe with idempotent APIs]: https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/
	ClientToken *string

	// A description of the task that is shown to an agent in the Contact Control
	// Panel (CCP).
	Description *string

	// A formatted URL that is shown to an agent in the Contact Control Panel (CCP).
	// Tasks can have the following reference types at the time of creation: URL |
	// NUMBER | STRING | DATE | EMAIL . ATTACHMENT is not a supported reference type
	// during task creation.
	References map[string]types.Reference

	// The unique identifier for an Amazon Connect contact. This identifier is related
	// to the contact starting.
	RelatedContactId *string

	noSmithyDocumentSerde
}

type StartWebRTCContactOutput struct {

	// Information required for the client application (mobile application or website)
	// to connect to the call.
	ConnectionData *types.ConnectionData

	// The identifier of the contact in this instance of Amazon Connect.
	ContactId *string

	// The identifier for a contact participant. The ParticipantId for a contact
	// participant is the same throughout the contact lifecycle.
	ParticipantId *string

	// The token used by the contact participant to call the [CreateParticipantConnection] API. The participant
	// token is valid for the lifetime of a contact participant.
	//
	// [CreateParticipantConnection]: https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html
	ParticipantToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartWebRTCContactMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartWebRTCContact{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartWebRTCContact{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartWebRTCContact"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartWebRTCContactMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartWebRTCContactValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartWebRTCContact(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartWebRTCContact struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartWebRTCContact) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartWebRTCContact) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartWebRTCContactInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartWebRTCContactInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartWebRTCContactMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartWebRTCContact{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartWebRTCContact(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartWebRTCContact",
	}
}
