// Code generated by smithy-go-codegen DO NOT EDIT.

package connectcampaignsv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connectcampaignsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Takes in a list of profile outbound requests to be placed as part of an
// outbound campaign. This API is idempotent.
func (c *Client) PutProfileOutboundRequestBatch(ctx context.Context, params *PutProfileOutboundRequestBatchInput, optFns ...func(*Options)) (*PutProfileOutboundRequestBatchOutput, error) {
	if params == nil {
		params = &PutProfileOutboundRequestBatchInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutProfileOutboundRequestBatch", params, optFns, c.addOperationPutProfileOutboundRequestBatchMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutProfileOutboundRequestBatchOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The request for PutProfileOutboundRequestBatch API
type PutProfileOutboundRequestBatchInput struct {

	// Identifier representing a Campaign
	//
	// This member is required.
	Id *string

	// List of profile outbound requests
	//
	// This member is required.
	ProfileOutboundRequests []types.ProfileOutboundRequest

	noSmithyDocumentSerde
}

// The response for PutProfileOutboundRequestBatch API
type PutProfileOutboundRequestBatchOutput struct {

	// List of failed profile outbound requests
	FailedRequests []types.FailedProfileOutboundRequest

	// List of successful profile outbound requests
	SuccessfulRequests []types.SuccessfulProfileOutboundRequest

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutProfileOutboundRequestBatchMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutProfileOutboundRequestBatch{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutProfileOutboundRequestBatch{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutProfileOutboundRequestBatch"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpPutProfileOutboundRequestBatchValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutProfileOutboundRequestBatch(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutProfileOutboundRequestBatch(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutProfileOutboundRequestBatch",
	}
}
