// Code generated by smithy-go-codegen DO NOT EDIT.

package controlcatalog

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/controlcatalog/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns details about a specific control, most notably a list of Amazon Web
// Services Regions where this control is supported. Input a value for the
// ControlArn parameter, in ARN form. GetControl accepts controltower or
// controlcatalog control ARNs as input. Returns a controlcatalog ARN format.
//
// In the API response, controls that have the value GLOBAL in the Scope field do
// not show the DeployableRegions field, because it does not apply. Controls that
// have the value REGIONAL in the Scope field return a value for the
// DeployableRegions field, as shown in the example.
func (c *Client) GetControl(ctx context.Context, params *GetControlInput, optFns ...func(*Options)) (*GetControlOutput, error) {
	if params == nil {
		params = &GetControlInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetControl", params, optFns, c.addOperationGetControlMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetControlOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetControlInput struct {

	// The Amazon Resource Name (ARN) of the control. It has one of the following
	// formats:
	//
	// Global format
	//
	//     arn:{PARTITION}:controlcatalog:::control/{CONTROL_CATALOG_OPAQUE_ID}
	//
	// Or Regional format
	//
	//     arn:{PARTITION}:controltower:{REGION}::control/{CONTROL_TOWER_OPAQUE_ID}
	//
	// Here is a more general pattern that covers Amazon Web Services Control Tower
	// and Control Catalog ARNs:
	//
	//     ^arn:(aws(?:[-a-z]*)?):(controlcatalog|controltower):[a-zA-Z0-9-]*::control/[0-9a-zA-Z_\\-]+$
	//
	// This member is required.
	ControlArn *string

	noSmithyDocumentSerde
}

type GetControlOutput struct {

	// The Amazon Resource Name (ARN) of the control.
	//
	// This member is required.
	Arn *string

	// A term that identifies the control's functional behavior. One of Preventive ,
	// Detective , Proactive
	//
	// This member is required.
	Behavior types.ControlBehavior

	// A description of what the control does.
	//
	// This member is required.
	Description *string

	// The display name of the control.
	//
	// This member is required.
	Name *string

	// Returns information about the control, including the scope of the control, if
	// enabled, and the Regions in which the control currently is available for
	// deployment. For more information about scope, see [Global services].
	//
	// If you are applying controls through an Amazon Web Services Control Tower
	// landing zone environment, remember that the values returned in the
	// RegionConfiguration API operation are not related to the governed Regions in
	// your landing zone. For example, if you are governing Regions A , B ,and C while
	// the control is available in Regions A , B , C , and D , you'd see a response
	// with DeployableRegions of A , B , C , and D for a control with REGIONAL scope,
	// even though you may not intend to deploy the control in Region D , because you
	// do not govern it through your landing zone.
	//
	// [Global services]: https://docs.aws.amazon.com/whitepapers/latest/aws-fault-isolation-boundaries/global-services.html
	//
	// This member is required.
	RegionConfiguration *types.RegionConfiguration

	// Returns information about the control, as an ImplementationDetails object that
	// shows the underlying implementation type for a control.
	Implementation *types.ImplementationDetails

	// Returns an array of ControlParameter objects that specify the parameters a
	// control supports. An empty list is returned for controls that don’t support
	// parameters.
	Parameters []types.ControlParameter

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetControlMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetControl{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetControl{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetControl"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetControlValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetControl(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetControl(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetControl",
	}
}
