// Code generated by smithy-go-codegen DO NOT EDIT.

package costexplorer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/costexplorer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a commitment purchase analysis result based on the AnalysisId .
func (c *Client) GetCommitmentPurchaseAnalysis(ctx context.Context, params *GetCommitmentPurchaseAnalysisInput, optFns ...func(*Options)) (*GetCommitmentPurchaseAnalysisOutput, error) {
	if params == nil {
		params = &GetCommitmentPurchaseAnalysisInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCommitmentPurchaseAnalysis", params, optFns, c.addOperationGetCommitmentPurchaseAnalysisMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCommitmentPurchaseAnalysisOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCommitmentPurchaseAnalysisInput struct {

	// The analysis ID that's associated with the commitment purchase analysis.
	//
	// This member is required.
	AnalysisId *string

	noSmithyDocumentSerde
}

type GetCommitmentPurchaseAnalysisOutput struct {

	// The analysis ID that's associated with the commitment purchase analysis.
	//
	// This member is required.
	AnalysisId *string

	// The start time of the analysis.
	//
	// This member is required.
	AnalysisStartedTime *string

	// The status of the analysis.
	//
	// This member is required.
	AnalysisStatus types.AnalysisStatus

	// The configuration for the commitment purchase analysis.
	//
	// This member is required.
	CommitmentPurchaseAnalysisConfiguration *types.CommitmentPurchaseAnalysisConfiguration

	// The estimated time for when the analysis will complete.
	//
	// This member is required.
	EstimatedCompletionTime *string

	// The completion time of the analysis.
	AnalysisCompletionTime *string

	// Details about the analysis.
	AnalysisDetails *types.AnalysisDetails

	// The error code used for the analysis.
	ErrorCode types.ErrorCode

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCommitmentPurchaseAnalysisMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetCommitmentPurchaseAnalysis{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetCommitmentPurchaseAnalysis{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCommitmentPurchaseAnalysis"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetCommitmentPurchaseAnalysisValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCommitmentPurchaseAnalysis(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetCommitmentPurchaseAnalysis(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCommitmentPurchaseAnalysis",
	}
}
