// Code generated by smithy-go-codegen DO NOT EDIT.

package costoptimizationhub

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/costoptimizationhub/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns both the current and recommended resource configuration and the
// estimated cost impact for a recommendation.
//
// The recommendationId is only valid for up to a maximum of 24 hours as
// recommendations are refreshed daily. To retrieve the recommendationId , use the
// ListRecommendations API.
func (c *Client) GetRecommendation(ctx context.Context, params *GetRecommendationInput, optFns ...func(*Options)) (*GetRecommendationOutput, error) {
	if params == nil {
		params = &GetRecommendationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetRecommendation", params, optFns, c.addOperationGetRecommendationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetRecommendationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetRecommendationInput struct {

	// The ID for the recommendation.
	//
	// This member is required.
	RecommendationId *string

	noSmithyDocumentSerde
}

type GetRecommendationOutput struct {

	// The account that the recommendation is for.
	AccountId *string

	// The type of action you can take by adopting the recommendation.
	ActionType types.ActionType

	// The lookback period used to calculate cost impact for a recommendation.
	CostCalculationLookbackPeriodInDays *int32

	// The currency code used for the recommendation.
	CurrencyCode *string

	// The details for the resource.
	CurrentResourceDetails types.ResourceDetails

	// The type of resource.
	CurrentResourceType types.ResourceType

	// The estimated monthly cost of the current resource. For Reserved Instances and
	// Savings Plans, it refers to the cost for eligible usage.
	EstimatedMonthlyCost *float64

	// The estimated monthly savings amount for the recommendation.
	EstimatedMonthlySavings *float64

	// The estimated savings amount over the lookback period used to calculate cost
	// impact for a recommendation.
	EstimatedSavingsOverCostCalculationLookbackPeriod *float64

	// The estimated savings percentage relative to the total cost over the cost
	// calculation lookback period.
	EstimatedSavingsPercentage *float64

	// The effort required to implement the recommendation.
	ImplementationEffort types.ImplementationEffort

	// The time when the recommendation was last generated.
	LastRefreshTimestamp *time.Time

	// The ID for the recommendation.
	RecommendationId *string

	// The lookback period that's used to generate the recommendation.
	RecommendationLookbackPeriodInDays *int32

	// The details about the recommended resource.
	RecommendedResourceDetails types.ResourceDetails

	// The resource type of the recommendation.
	RecommendedResourceType types.ResourceType

	// The Amazon Web Services Region of the resource.
	Region *string

	// The Amazon Resource Name (ARN) of the resource.
	ResourceArn *string

	// The unique identifier for the resource. This is the same as the Amazon Resource
	// Name (ARN), if available.
	ResourceId *string

	// Whether or not implementing the recommendation requires a restart.
	RestartNeeded *bool

	// Whether or not implementing the recommendation can be rolled back.
	RollbackPossible *bool

	// The source of the recommendation.
	Source types.Source

	// A list of tags associated with the resource for which the recommendation exists.
	Tags []types.Tag

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetRecommendationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetRecommendation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetRecommendation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetRecommendation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetRecommendationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetRecommendation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetRecommendation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetRecommendation",
	}
}
