// Code generated by smithy-go-codegen DO NOT EDIT.

package customerprofiles

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/customerprofiles/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieve the latest status of a segment snapshot.
func (c *Client) GetSegmentSnapshot(ctx context.Context, params *GetSegmentSnapshotInput, optFns ...func(*Options)) (*GetSegmentSnapshotOutput, error) {
	if params == nil {
		params = &GetSegmentSnapshotInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetSegmentSnapshot", params, optFns, c.addOperationGetSegmentSnapshotMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetSegmentSnapshotOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetSegmentSnapshotInput struct {

	// The unique identifier of the domain.
	//
	// This member is required.
	DomainName *string

	// The unique name of the segment definition.
	//
	// This member is required.
	SegmentDefinitionName *string

	// The unique identifier of the segment snapshot.
	//
	// This member is required.
	SnapshotId *string

	noSmithyDocumentSerde
}

type GetSegmentSnapshotOutput struct {

	// The format in which the segment will be exported.
	//
	// This member is required.
	DataFormat types.DataFormat

	// The unique identifier of the segment snapshot.
	//
	// This member is required.
	SnapshotId *string

	// The status of the asynchronous job for exporting the segment snapshot.
	//
	// This member is required.
	Status types.SegmentSnapshotStatus

	// The destination to which the segment will be exported. This field must be
	// provided if the request is not submitted from the Amazon Connect Admin Website.
	DestinationUri *string

	// The Amazon Resource Name (ARN) of the KMS key used to encrypt the exported
	// segment.
	EncryptionKey *string

	// The Amazon Resource Name (ARN) of the IAM role that allows Customer Profiles
	// service principal to assume the role for conducting KMS and S3 operations.
	RoleArn *string

	// The status message of the asynchronous job for exporting the segment snapshot.
	StatusMessage *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetSegmentSnapshotMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetSegmentSnapshot{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetSegmentSnapshot{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetSegmentSnapshot"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetSegmentSnapshotValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetSegmentSnapshot(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetSegmentSnapshot(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetSegmentSnapshot",
	}
}
