// Code generated by smithy-go-codegen DO NOT EDIT.

package databrew

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/databrew/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Deletes one or more versions of a recipe at a time.
//
// The entire request will be rejected if:
//
//   - The recipe does not exist.
//
//   - There is an invalid version identifier in the list of versions.
//
//   - The version list is empty.
//
//   - The version list size exceeds 50.
//
//   - The version list contains duplicate entries.
//
// The request will complete successfully, but with partial failures, if:
//
//   - A version does not exist.
//
//   - A version is being used by a job.
//
//   - You specify LATEST_WORKING , but it's being used by a project.
//
//   - The version fails to be deleted.
//
// The LATEST_WORKING version will only be deleted if the recipe has no other
// versions. If you try to delete LATEST_WORKING while other versions exist (or if
// they can't be deleted), then LATEST_WORKING will be listed as partial failure
// in the response.
func (c *Client) BatchDeleteRecipeVersion(ctx context.Context, params *BatchDeleteRecipeVersionInput, optFns ...func(*Options)) (*BatchDeleteRecipeVersionOutput, error) {
	if params == nil {
		params = &BatchDeleteRecipeVersionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchDeleteRecipeVersion", params, optFns, c.addOperationBatchDeleteRecipeVersionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchDeleteRecipeVersionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchDeleteRecipeVersionInput struct {

	// The name of the recipe whose versions are to be deleted.
	//
	// This member is required.
	Name *string

	// An array of version identifiers, for the recipe versions to be deleted. You can
	// specify numeric versions ( X.Y ) or LATEST_WORKING . LATEST_PUBLISHED is not
	// supported.
	//
	// This member is required.
	RecipeVersions []string

	noSmithyDocumentSerde
}

type BatchDeleteRecipeVersionOutput struct {

	// The name of the recipe that was modified.
	//
	// This member is required.
	Name *string

	// Errors, if any, that occurred while attempting to delete the recipe versions.
	Errors []types.RecipeVersionErrorDetail

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchDeleteRecipeVersionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpBatchDeleteRecipeVersion{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpBatchDeleteRecipeVersion{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchDeleteRecipeVersion"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpBatchDeleteRecipeVersionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchDeleteRecipeVersion(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchDeleteRecipeVersion(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchDeleteRecipeVersion",
	}
}
