// Code generated by smithy-go-codegen DO NOT EDIT.

package datasync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datasync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a transfer location for an Amazon S3 bucket. DataSync can use this
// location as a source or destination for transferring data.
//
// Before you begin, make sure that you read the following topics:
//
// [Storage class considerations with Amazon S3 locations]
//
// [Evaluating S3 request costs when using DataSync]
//
// For more information, see [Configuring transfers with Amazon S3].
//
// [Storage class considerations with Amazon S3 locations]: https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes
// [Configuring transfers with Amazon S3]: https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html
// [Evaluating S3 request costs when using DataSync]: https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests
func (c *Client) CreateLocationS3(ctx context.Context, params *CreateLocationS3Input, optFns ...func(*Options)) (*CreateLocationS3Output, error) {
	if params == nil {
		params = &CreateLocationS3Input{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateLocationS3", params, optFns, c.addOperationCreateLocationS3Middlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateLocationS3Output)
	out.ResultMetadata = metadata
	return out, nil
}

// CreateLocationS3Request
type CreateLocationS3Input struct {

	// Specifies the ARN of the S3 bucket that you want to use as a location. (When
	// creating your DataSync task later, you specify whether this location is a
	// transfer source or destination.)
	//
	// If your S3 bucket is located on an Outposts resource, you must specify an
	// Amazon S3 access point. For more information, see [Managing data access with Amazon S3 access points]in the Amazon S3 User Guide.
	//
	// [Managing data access with Amazon S3 access points]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html
	//
	// This member is required.
	S3BucketArn *string

	// Specifies the Amazon Resource Name (ARN) of the Identity and Access Management
	// (IAM) role that DataSync uses to access your S3 bucket.
	//
	// For more information, see [Providing DataSync access to S3 buckets].
	//
	// [Providing DataSync access to S3 buckets]: https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-access
	//
	// This member is required.
	S3Config *types.S3Config

	// (Amazon S3 on Outposts only) Specifies the Amazon Resource Name (ARN) of the
	// DataSync agent on your Outpost.
	//
	// For more information, see [Deploy your DataSync agent on Outposts].
	//
	// [Deploy your DataSync agent on Outposts]: https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent
	AgentArns []string

	// Specifies the storage class that you want your objects to use when Amazon S3 is
	// a transfer destination.
	//
	// For buckets in Amazon Web Services Regions, the storage class defaults to
	// STANDARD . For buckets on Outposts, the storage class defaults to OUTPOSTS .
	//
	// For more information, see [Storage class considerations with Amazon S3 transfers].
	//
	// [Storage class considerations with Amazon S3 transfers]: https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes
	S3StorageClass types.S3StorageClass

	// Specifies a prefix in the S3 bucket that DataSync reads from or writes to
	// (depending on whether the bucket is a source or destination location).
	//
	// DataSync can't transfer objects with a prefix that begins with a slash ( / ) or
	// includes // , /./ , or /../ patterns. For example:
	//
	//   - /photos
	//
	//   - photos//2006/January
	//
	//   - photos/./2006/February
	//
	//   - photos/../2006/March
	Subdirectory *string

	// Specifies labels that help you categorize, filter, and search for your Amazon
	// Web Services resources. We recommend creating at least a name tag for your
	// transfer location.
	Tags []types.TagListEntry

	noSmithyDocumentSerde
}

// CreateLocationS3Response
type CreateLocationS3Output struct {

	// The ARN of the S3 location that you created.
	LocationArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateLocationS3Middlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateLocationS3{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateLocationS3{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateLocationS3"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateLocationS3ValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateLocationS3(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateLocationS3(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateLocationS3",
	}
}
