// Code generated by smithy-go-codegen DO NOT EDIT.

package datasync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datasync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modifies the following configuration parameters of the Amazon FSx for NetApp
// ONTAP transfer location that you're using with DataSync.
//
// For more information, see [Configuring DataSync transfers with FSx for ONTAP].
//
// [Configuring DataSync transfers with FSx for ONTAP]: https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html
func (c *Client) UpdateLocationFsxOntap(ctx context.Context, params *UpdateLocationFsxOntapInput, optFns ...func(*Options)) (*UpdateLocationFsxOntapOutput, error) {
	if params == nil {
		params = &UpdateLocationFsxOntapInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateLocationFsxOntap", params, optFns, c.addOperationUpdateLocationFsxOntapMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateLocationFsxOntapOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateLocationFsxOntapInput struct {

	// Specifies the Amazon Resource Name (ARN) of the FSx for ONTAP transfer location
	// that you're updating.
	//
	// This member is required.
	LocationArn *string

	// Specifies the data transfer protocol that DataSync uses to access your Amazon
	// FSx file system.
	Protocol *types.FsxUpdateProtocol

	// Specifies a path to the file share in the storage virtual machine (SVM) where
	// you want to transfer data to or from.
	//
	// You can specify a junction path (also known as a mount point), qtree path (for
	// NFS file shares), or share name (for SMB file shares). For example, your mount
	// path might be /vol1 , /vol1/tree1 , or /share1 .
	//
	// Don't specify a junction path in the SVM's root volume. For more information,
	// see [Managing FSx for ONTAP storage virtual machines]in the Amazon FSx for NetApp ONTAP User Guide.
	//
	// [Managing FSx for ONTAP storage virtual machines]: https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html
	Subdirectory *string

	noSmithyDocumentSerde
}

type UpdateLocationFsxOntapOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateLocationFsxOntapMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateLocationFsxOntap{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateLocationFsxOntap{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateLocationFsxOntap"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateLocationFsxOntapValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateLocationFsxOntap(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateLocationFsxOntap(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateLocationFsxOntap",
	}
}
