// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a project profile.
func (c *Client) CreateProjectProfile(ctx context.Context, params *CreateProjectProfileInput, optFns ...func(*Options)) (*CreateProjectProfileOutput, error) {
	if params == nil {
		params = &CreateProjectProfileInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateProjectProfile", params, optFns, c.addOperationCreateProjectProfileMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateProjectProfileOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateProjectProfileInput struct {

	// A domain ID of the project profile.
	//
	// This member is required.
	DomainIdentifier *string

	// Project profile name.
	//
	// This member is required.
	Name *string

	// A description of a project profile.
	Description *string

	// A domain unit ID of the project profile.
	DomainUnitIdentifier *string

	// Environment configurations of the project profile.
	EnvironmentConfigurations []types.EnvironmentConfiguration

	// Project profile status.
	Status types.Status

	noSmithyDocumentSerde
}

type CreateProjectProfileOutput struct {

	// A user who created a project profile.
	//
	// This member is required.
	CreatedBy *string

	// The ID of the domain where a project profile is created.
	//
	// This member is required.
	DomainId *string

	// Project profile ID.
	//
	// This member is required.
	Id *string

	// Project profile name.
	//
	// This member is required.
	Name *string

	// A timestamp at which a project profile is created.
	CreatedAt *time.Time

	// A project profile description.
	Description *string

	// The ID of the domain unit where a project profile is created.
	DomainUnitId *string

	// Environment configurations of a project profile.
	EnvironmentConfigurations []types.EnvironmentConfiguration

	// A timestamp when a project profile was last updated.
	LastUpdatedAt *time.Time

	// Project profile status.
	Status types.Status

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateProjectProfileMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateProjectProfile{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateProjectProfile{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateProjectProfile"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateProjectProfileValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateProjectProfile(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateProjectProfile(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateProjectProfile",
	}
}
