// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets the data product.
func (c *Client) GetDataProduct(ctx context.Context, params *GetDataProductInput, optFns ...func(*Options)) (*GetDataProductOutput, error) {
	if params == nil {
		params = &GetDataProductInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetDataProduct", params, optFns, c.addOperationGetDataProductMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetDataProductOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetDataProductInput struct {

	// The ID of the domain where the data product lives.
	//
	// This member is required.
	DomainIdentifier *string

	// The ID of the data product.
	//
	// This member is required.
	Identifier *string

	// The revision of the data product.
	Revision *string

	noSmithyDocumentSerde
}

type GetDataProductOutput struct {

	// The ID of the domain where the data product lives.
	//
	// This member is required.
	DomainId *string

	// The ID of the data product.
	//
	// This member is required.
	Id *string

	// The name of the data product.
	//
	// This member is required.
	Name *string

	// The ID of the owning project of the data product.
	//
	// This member is required.
	OwningProjectId *string

	// The revision of the data product.
	//
	// This member is required.
	Revision *string

	// The status of the data product.
	//
	// This member is required.
	Status types.DataProductStatus

	// The timestamp at which the data product is created.
	CreatedAt *time.Time

	// The user who created the data product.
	CreatedBy *string

	// The description of the data product.
	Description *string

	// The timestamp at which the first revision of the data product is created.
	FirstRevisionCreatedAt *time.Time

	// The user who created the first revision of the data product.
	FirstRevisionCreatedBy *string

	// The metadata forms of the data product.
	FormsOutput []types.FormOutput

	// The glossary terms of the data product.
	GlossaryTerms []string

	// The data assets of the data product.
	Items []types.DataProductItem

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetDataProductMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetDataProduct{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetDataProduct{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetDataProduct"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetDataProductValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetDataProduct(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetDataProduct(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetDataProduct",
	}
}
