// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists data source runs in Amazon DataZone.
func (c *Client) ListDataSourceRuns(ctx context.Context, params *ListDataSourceRunsInput, optFns ...func(*Options)) (*ListDataSourceRunsOutput, error) {
	if params == nil {
		params = &ListDataSourceRunsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDataSourceRuns", params, optFns, c.addOperationListDataSourceRunsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDataSourceRunsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDataSourceRunsInput struct {

	// The identifier of the data source.
	//
	// This member is required.
	DataSourceIdentifier *string

	// The identifier of the Amazon DataZone domain in which to invoke the
	// ListDataSourceRuns action.
	//
	// This member is required.
	DomainIdentifier *string

	// The maximum number of runs to return in a single call to ListDataSourceRuns .
	// When the number of runs to be listed is greater than the value of MaxResults ,
	// the response contains a NextToken value that you can use in a subsequent call
	// to ListDataSourceRuns to list the next set of runs.
	MaxResults *int32

	// When the number of runs is greater than the default value for the MaxResults
	// parameter, or if you explicitly specify a value for MaxResults that is less
	// than the number of runs, the response includes a pagination token named
	// NextToken . You can specify this NextToken value in a subsequent call to
	// ListDataSourceRuns to list the next set of runs.
	NextToken *string

	// The status of the data source.
	Status types.DataSourceRunStatus

	noSmithyDocumentSerde
}

type ListDataSourceRunsOutput struct {

	// The results of the ListDataSourceRuns action.
	//
	// This member is required.
	Items []types.DataSourceRunSummary

	// When the number of runs is greater than the default value for the MaxResults
	// parameter, or if you explicitly specify a value for MaxResults that is less
	// than the number of runs, the response includes a pagination token named
	// NextToken . You can specify this NextToken value in a subsequent call to
	// ListDataSourceRuns to list the next set of runs.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDataSourceRunsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDataSourceRuns{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDataSourceRuns{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDataSourceRuns"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListDataSourceRunsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDataSourceRuns(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListDataSourceRunsPaginatorOptions is the paginator options for
// ListDataSourceRuns
type ListDataSourceRunsPaginatorOptions struct {
	// The maximum number of runs to return in a single call to ListDataSourceRuns .
	// When the number of runs to be listed is greater than the value of MaxResults ,
	// the response contains a NextToken value that you can use in a subsequent call
	// to ListDataSourceRuns to list the next set of runs.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDataSourceRunsPaginator is a paginator for ListDataSourceRuns
type ListDataSourceRunsPaginator struct {
	options   ListDataSourceRunsPaginatorOptions
	client    ListDataSourceRunsAPIClient
	params    *ListDataSourceRunsInput
	nextToken *string
	firstPage bool
}

// NewListDataSourceRunsPaginator returns a new ListDataSourceRunsPaginator
func NewListDataSourceRunsPaginator(client ListDataSourceRunsAPIClient, params *ListDataSourceRunsInput, optFns ...func(*ListDataSourceRunsPaginatorOptions)) *ListDataSourceRunsPaginator {
	if params == nil {
		params = &ListDataSourceRunsInput{}
	}

	options := ListDataSourceRunsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDataSourceRunsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDataSourceRunsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDataSourceRuns page.
func (p *ListDataSourceRunsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDataSourceRunsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDataSourceRuns(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDataSourceRunsAPIClient is a client that implements the ListDataSourceRuns
// operation.
type ListDataSourceRunsAPIClient interface {
	ListDataSourceRuns(context.Context, *ListDataSourceRunsInput, ...func(*Options)) (*ListDataSourceRunsOutput, error)
}

var _ ListDataSourceRunsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDataSourceRuns(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDataSourceRuns",
	}
}
