// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the entity (domain units) owners.
func (c *Client) ListEntityOwners(ctx context.Context, params *ListEntityOwnersInput, optFns ...func(*Options)) (*ListEntityOwnersOutput, error) {
	if params == nil {
		params = &ListEntityOwnersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEntityOwners", params, optFns, c.addOperationListEntityOwnersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEntityOwnersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEntityOwnersInput struct {

	// The ID of the domain where you want to list entity owners.
	//
	// This member is required.
	DomainIdentifier *string

	// The ID of the entity that you want to list.
	//
	// This member is required.
	EntityIdentifier *string

	// The type of the entity that you want to list.
	//
	// This member is required.
	EntityType types.DataZoneEntityType

	// The maximum number of entities to return in a single call to ListEntityOwners .
	// When the number of entities to be listed is greater than the value of MaxResults
	// , the response contains a NextToken value that you can use in a subsequent call
	// to ListEntityOwners to list the next set of entities.
	MaxResults *int32

	// When the number of entities is greater than the default value for the MaxResults
	// parameter, or if you explicitly specify a value for MaxResults that is less
	// than the number of entities, the response includes a pagination token named
	// NextToken . You can specify this NextToken value in a subsequent call to
	// ListEntityOwners to list the next set of entities.
	NextToken *string

	noSmithyDocumentSerde
}

type ListEntityOwnersOutput struct {

	// The owners of the entity.
	//
	// This member is required.
	Owners []types.OwnerPropertiesOutput

	// When the number of entities is greater than the default value for the MaxResults
	// parameter, or if you explicitly specify a value for MaxResults that is less
	// than the number of entities, the response includes a pagination token named
	// NextToken . You can specify this NextToken value in a subsequent call to
	// ListEntityOwners to list the next set of entities.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEntityOwnersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListEntityOwners{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListEntityOwners{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEntityOwners"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListEntityOwnersValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEntityOwners(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListEntityOwnersPaginatorOptions is the paginator options for ListEntityOwners
type ListEntityOwnersPaginatorOptions struct {
	// The maximum number of entities to return in a single call to ListEntityOwners .
	// When the number of entities to be listed is greater than the value of MaxResults
	// , the response contains a NextToken value that you can use in a subsequent call
	// to ListEntityOwners to list the next set of entities.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEntityOwnersPaginator is a paginator for ListEntityOwners
type ListEntityOwnersPaginator struct {
	options   ListEntityOwnersPaginatorOptions
	client    ListEntityOwnersAPIClient
	params    *ListEntityOwnersInput
	nextToken *string
	firstPage bool
}

// NewListEntityOwnersPaginator returns a new ListEntityOwnersPaginator
func NewListEntityOwnersPaginator(client ListEntityOwnersAPIClient, params *ListEntityOwnersInput, optFns ...func(*ListEntityOwnersPaginatorOptions)) *ListEntityOwnersPaginator {
	if params == nil {
		params = &ListEntityOwnersInput{}
	}

	options := ListEntityOwnersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEntityOwnersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEntityOwnersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEntityOwners page.
func (p *ListEntityOwnersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEntityOwnersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEntityOwners(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEntityOwnersAPIClient is a client that implements the ListEntityOwners
// operation.
type ListEntityOwnersAPIClient interface {
	ListEntityOwners(context.Context, *ListEntityOwnersInput, ...func(*Options)) (*ListEntityOwnersOutput, error)
}

var _ ListEntityOwnersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEntityOwners(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEntityOwners",
	}
}
