// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Start the run of the specified data source in Amazon DataZone.
func (c *Client) StartDataSourceRun(ctx context.Context, params *StartDataSourceRunInput, optFns ...func(*Options)) (*StartDataSourceRunOutput, error) {
	if params == nil {
		params = &StartDataSourceRunInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartDataSourceRun", params, optFns, c.addOperationStartDataSourceRunMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartDataSourceRunOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartDataSourceRunInput struct {

	// The identifier of the data source.
	//
	// This member is required.
	DataSourceIdentifier *string

	// The identifier of the Amazon DataZone domain in which to start a data source
	// run.
	//
	// This member is required.
	DomainIdentifier *string

	// A unique, case-sensitive identifier that is provided to ensure the idempotency
	// of the request.
	ClientToken *string

	noSmithyDocumentSerde
}

type StartDataSourceRunOutput struct {

	// The timestamp of when data source run was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The identifier of the data source.
	//
	// This member is required.
	DataSourceId *string

	// The identifier of the Amazon DataZone domain in which to start a data source
	// run.
	//
	// This member is required.
	DomainId *string

	// The identifier of the data source run.
	//
	// This member is required.
	Id *string

	// The identifier of the project.
	//
	// This member is required.
	ProjectId *string

	// The status of the data source run.
	//
	// This member is required.
	Status types.DataSourceRunStatus

	// The type of the data source run.
	//
	// This member is required.
	Type types.DataSourceRunType

	// The timestamp of when the data source run was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The configuration snapshot of the data source that is being run.
	DataSourceConfigurationSnapshot *string

	// Specifies the error message that is returned if the operation cannot be
	// successfully completed.
	ErrorMessage *types.DataSourceErrorMessage

	// Specifies run statistics for assets.
	RunStatisticsForAssets *types.RunStatisticsForAssets

	// The timestamp of when the data source run was started.
	StartedAt *time.Time

	// The timestamp of when the data source run was stopped.
	StoppedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartDataSourceRunMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartDataSourceRun{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartDataSourceRun{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartDataSourceRun"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartDataSourceRunMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartDataSourceRunValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartDataSourceRun(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartDataSourceRun struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartDataSourceRun) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartDataSourceRun) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartDataSourceRunInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartDataSourceRunInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartDataSourceRunMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartDataSourceRun{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartDataSourceRun(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartDataSourceRun",
	}
}
