// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates the specified subscription target in Amazon DataZone.
func (c *Client) UpdateSubscriptionTarget(ctx context.Context, params *UpdateSubscriptionTargetInput, optFns ...func(*Options)) (*UpdateSubscriptionTargetOutput, error) {
	if params == nil {
		params = &UpdateSubscriptionTargetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateSubscriptionTarget", params, optFns, c.addOperationUpdateSubscriptionTargetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateSubscriptionTargetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateSubscriptionTargetInput struct {

	// The identifier of the Amazon DataZone domain in which a subscription target is
	// to be updated.
	//
	// This member is required.
	DomainIdentifier *string

	// The identifier of the environment in which a subscription target is to be
	// updated.
	//
	// This member is required.
	EnvironmentIdentifier *string

	// Identifier of the subscription target that is to be updated.
	//
	// This member is required.
	Identifier *string

	// The applicable asset types to be updated as part of the UpdateSubscriptionTarget
	// action.
	ApplicableAssetTypes []string

	// The authorized principals to be updated as part of the UpdateSubscriptionTarget
	// action.
	AuthorizedPrincipals []string

	// The manage access role to be updated as part of the UpdateSubscriptionTarget
	// action.
	ManageAccessRole *string

	// The name to be updated as part of the UpdateSubscriptionTarget action.
	Name *string

	// The provider to be updated as part of the UpdateSubscriptionTarget action.
	Provider *string

	// The configuration to be updated as part of the UpdateSubscriptionTarget action.
	SubscriptionTargetConfig []types.SubscriptionTargetForm

	noSmithyDocumentSerde
}

type UpdateSubscriptionTargetOutput struct {

	// The applicable asset types to be updated as part of the UpdateSubscriptionTarget
	// action.
	//
	// This member is required.
	ApplicableAssetTypes []string

	// The authorized principals to be updated as part of the UpdateSubscriptionTarget
	// action.
	//
	// This member is required.
	AuthorizedPrincipals []string

	// The timestamp of when a subscription target was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon DataZone user who created the subscription target.
	//
	// This member is required.
	CreatedBy *string

	// The identifier of the Amazon DataZone domain in which a subscription target is
	// to be updated.
	//
	// This member is required.
	DomainId *string

	// The identifier of the environment in which a subscription target is to be
	// updated.
	//
	// This member is required.
	EnvironmentId *string

	// Identifier of the subscription target that is to be updated.
	//
	// This member is required.
	Id *string

	// The name to be updated as part of the UpdateSubscriptionTarget action.
	//
	// This member is required.
	Name *string

	// The identifier of the project in which a subscription target is to be updated.
	//
	// This member is required.
	ProjectId *string

	// The provider to be updated as part of the UpdateSubscriptionTarget action.
	//
	// This member is required.
	Provider *string

	// The configuration to be updated as part of the UpdateSubscriptionTarget action.
	//
	// This member is required.
	SubscriptionTargetConfig []types.SubscriptionTargetForm

	// The type to be updated as part of the UpdateSubscriptionTarget action.
	//
	// This member is required.
	Type *string

	// The manage access role to be updated as part of the UpdateSubscriptionTarget
	// action.
	ManageAccessRole *string

	// The timestamp of when the subscription target was updated.
	UpdatedAt *time.Time

	// The Amazon DataZone user who updated the subscription target.
	UpdatedBy *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateSubscriptionTargetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateSubscriptionTarget{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateSubscriptionTarget{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateSubscriptionTarget"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateSubscriptionTargetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateSubscriptionTarget(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateSubscriptionTarget(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateSubscriptionTarget",
	}
}
