// Code generated by smithy-go-codegen DO NOT EDIT.

package deadline

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/deadline/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpAssociateMemberToFarm struct {
}

func (*awsRestjson1_serializeOpAssociateMemberToFarm) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateMemberToFarm) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateMemberToFarmInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/members/{principalId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociateMemberToFarmInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateMemberToFarmInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateMemberToFarmInput(v *AssociateMemberToFarmInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.PrincipalId == nil || len(*v.PrincipalId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member principalId must not be empty")}
	}
	if v.PrincipalId != nil {
		if err := encoder.SetURI("principalId").String(*v.PrincipalId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateMemberToFarmInput(v *AssociateMemberToFarmInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdentityStoreId != nil {
		ok := object.Key("identityStoreId")
		ok.String(*v.IdentityStoreId)
	}

	if len(v.MembershipLevel) > 0 {
		ok := object.Key("membershipLevel")
		ok.String(string(v.MembershipLevel))
	}

	if len(v.PrincipalType) > 0 {
		ok := object.Key("principalType")
		ok.String(string(v.PrincipalType))
	}

	return nil
}

type awsRestjson1_serializeOpAssociateMemberToFleet struct {
}

func (*awsRestjson1_serializeOpAssociateMemberToFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateMemberToFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateMemberToFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/fleets/{fleetId}/members/{principalId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociateMemberToFleetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateMemberToFleetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateMemberToFleetInput(v *AssociateMemberToFleetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	if v.PrincipalId == nil || len(*v.PrincipalId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member principalId must not be empty")}
	}
	if v.PrincipalId != nil {
		if err := encoder.SetURI("principalId").String(*v.PrincipalId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateMemberToFleetInput(v *AssociateMemberToFleetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdentityStoreId != nil {
		ok := object.Key("identityStoreId")
		ok.String(*v.IdentityStoreId)
	}

	if len(v.MembershipLevel) > 0 {
		ok := object.Key("membershipLevel")
		ok.String(string(v.MembershipLevel))
	}

	if len(v.PrincipalType) > 0 {
		ok := object.Key("principalType")
		ok.String(string(v.PrincipalType))
	}

	return nil
}

type awsRestjson1_serializeOpAssociateMemberToJob struct {
}

func (*awsRestjson1_serializeOpAssociateMemberToJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateMemberToJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateMemberToJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/members/{principalId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociateMemberToJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateMemberToJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateMemberToJobInput(v *AssociateMemberToJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.PrincipalId == nil || len(*v.PrincipalId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member principalId must not be empty")}
	}
	if v.PrincipalId != nil {
		if err := encoder.SetURI("principalId").String(*v.PrincipalId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateMemberToJobInput(v *AssociateMemberToJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdentityStoreId != nil {
		ok := object.Key("identityStoreId")
		ok.String(*v.IdentityStoreId)
	}

	if len(v.MembershipLevel) > 0 {
		ok := object.Key("membershipLevel")
		ok.String(string(v.MembershipLevel))
	}

	if len(v.PrincipalType) > 0 {
		ok := object.Key("principalType")
		ok.String(string(v.PrincipalType))
	}

	return nil
}

type awsRestjson1_serializeOpAssociateMemberToQueue struct {
}

func (*awsRestjson1_serializeOpAssociateMemberToQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateMemberToQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateMemberToQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/members/{principalId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociateMemberToQueueInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateMemberToQueueInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateMemberToQueueInput(v *AssociateMemberToQueueInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.PrincipalId == nil || len(*v.PrincipalId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member principalId must not be empty")}
	}
	if v.PrincipalId != nil {
		if err := encoder.SetURI("principalId").String(*v.PrincipalId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateMemberToQueueInput(v *AssociateMemberToQueueInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdentityStoreId != nil {
		ok := object.Key("identityStoreId")
		ok.String(*v.IdentityStoreId)
	}

	if len(v.MembershipLevel) > 0 {
		ok := object.Key("membershipLevel")
		ok.String(string(v.MembershipLevel))
	}

	if len(v.PrincipalType) > 0 {
		ok := object.Key("principalType")
		ok.String(string(v.PrincipalType))
	}

	return nil
}

type awsRestjson1_serializeOpAssumeFleetRoleForRead struct {
}

func (*awsRestjson1_serializeOpAssumeFleetRoleForRead) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssumeFleetRoleForRead) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssumeFleetRoleForReadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/fleets/{fleetId}/read-roles")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssumeFleetRoleForReadInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssumeFleetRoleForReadInput(v *AssumeFleetRoleForReadInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAssumeFleetRoleForWorker struct {
}

func (*awsRestjson1_serializeOpAssumeFleetRoleForWorker) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssumeFleetRoleForWorker) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssumeFleetRoleForWorkerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers/{workerId}/fleet-roles")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssumeFleetRoleForWorkerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssumeFleetRoleForWorkerInput(v *AssumeFleetRoleForWorkerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	if v.WorkerId == nil || len(*v.WorkerId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workerId must not be empty")}
	}
	if v.WorkerId != nil {
		if err := encoder.SetURI("workerId").String(*v.WorkerId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAssumeQueueRoleForRead struct {
}

func (*awsRestjson1_serializeOpAssumeQueueRoleForRead) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssumeQueueRoleForRead) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssumeQueueRoleForReadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/read-roles")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssumeQueueRoleForReadInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssumeQueueRoleForReadInput(v *AssumeQueueRoleForReadInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAssumeQueueRoleForUser struct {
}

func (*awsRestjson1_serializeOpAssumeQueueRoleForUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssumeQueueRoleForUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssumeQueueRoleForUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/user-roles")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssumeQueueRoleForUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssumeQueueRoleForUserInput(v *AssumeQueueRoleForUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAssumeQueueRoleForWorker struct {
}

func (*awsRestjson1_serializeOpAssumeQueueRoleForWorker) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssumeQueueRoleForWorker) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssumeQueueRoleForWorkerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers/{workerId}/queue-roles")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssumeQueueRoleForWorkerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssumeQueueRoleForWorkerInput(v *AssumeQueueRoleForWorkerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	if v.QueueId != nil {
		encoder.SetQuery("queueId").String(*v.QueueId)
	}

	if v.WorkerId == nil || len(*v.WorkerId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workerId must not be empty")}
	}
	if v.WorkerId != nil {
		if err := encoder.SetURI("workerId").String(*v.WorkerId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchGetJobEntity struct {
}

func (*awsRestjson1_serializeOpBatchGetJobEntity) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchGetJobEntity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetJobEntityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers/{workerId}/batchGetJobEntity")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchGetJobEntityInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchGetJobEntityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchGetJobEntityInput(v *BatchGetJobEntityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	if v.WorkerId == nil || len(*v.WorkerId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workerId must not be empty")}
	}
	if v.WorkerId != nil {
		if err := encoder.SetURI("workerId").String(*v.WorkerId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchGetJobEntityInput(v *BatchGetJobEntityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Identifiers != nil {
		ok := object.Key("identifiers")
		if err := awsRestjson1_serializeDocumentJobEntityIdentifiers(v.Identifiers, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCopyJobTemplate struct {
}

func (*awsRestjson1_serializeOpCopyJobTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCopyJobTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CopyJobTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/template")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCopyJobTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCopyJobTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCopyJobTemplateInput(v *CopyJobTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCopyJobTemplateInput(v *CopyJobTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TargetS3Location != nil {
		ok := object.Key("targetS3Location")
		if err := awsRestjson1_serializeDocumentS3Location(v.TargetS3Location, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateBudget struct {
}

func (*awsRestjson1_serializeOpCreateBudget) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBudget) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBudgetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/budgets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateBudgetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBudgetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBudgetInput(v *CreateBudgetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBudgetInput(v *CreateBudgetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("actions")
		if err := awsRestjson1_serializeDocumentBudgetActionsToAdd(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ApproximateDollarLimit != nil {
		ok := object.Key("approximateDollarLimit")
		switch {
		case math.IsNaN(float64(*v.ApproximateDollarLimit)):
			ok.String("NaN")

		case math.IsInf(float64(*v.ApproximateDollarLimit), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.ApproximateDollarLimit), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.ApproximateDollarLimit)

		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.Schedule != nil {
		ok := object.Key("schedule")
		if err := awsRestjson1_serializeDocumentBudgetSchedule(v.Schedule, ok); err != nil {
			return err
		}
	}

	if v.UsageTrackingResource != nil {
		ok := object.Key("usageTrackingResource")
		if err := awsRestjson1_serializeDocumentUsageTrackingResource(v.UsageTrackingResource, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateFarm struct {
}

func (*awsRestjson1_serializeOpCreateFarm) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateFarm) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFarmInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateFarmInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateFarmInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateFarmInput(v *CreateFarmInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateFarmInput(v *CreateFarmInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.KmsKeyArn != nil {
		ok := object.Key("kmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateFleet struct {
}

func (*awsRestjson1_serializeOpCreateFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/fleets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateFleetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateFleetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateFleetInput(v *CreateFleetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateFleetInput(v *CreateFleetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsRestjson1_serializeDocumentFleetConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.MaxWorkerCount != nil {
		ok := object.Key("maxWorkerCount")
		ok.Integer(*v.MaxWorkerCount)
	}

	if v.MinWorkerCount != 0 {
		ok := object.Key("minWorkerCount")
		ok.Integer(v.MinWorkerCount)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateJob struct {
}

func (*awsRestjson1_serializeOpCreateJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateJobInput(v *CreateJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateJobInput(v *CreateJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attachments != nil {
		ok := object.Key("attachments")
		if err := awsRestjson1_serializeDocumentAttachments(v.Attachments, ok); err != nil {
			return err
		}
	}

	if v.MaxFailedTasksCount != nil {
		ok := object.Key("maxFailedTasksCount")
		ok.Integer(*v.MaxFailedTasksCount)
	}

	if v.MaxRetriesPerTask != nil {
		ok := object.Key("maxRetriesPerTask")
		ok.Integer(*v.MaxRetriesPerTask)
	}

	if v.MaxWorkerCount != nil {
		ok := object.Key("maxWorkerCount")
		ok.Integer(*v.MaxWorkerCount)
	}

	if v.Parameters != nil {
		ok := object.Key("parameters")
		if err := awsRestjson1_serializeDocumentJobParameters(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.Priority != nil {
		ok := object.Key("priority")
		ok.Integer(*v.Priority)
	}

	if v.SourceJobId != nil {
		ok := object.Key("sourceJobId")
		ok.String(*v.SourceJobId)
	}

	if v.StorageProfileId != nil {
		ok := object.Key("storageProfileId")
		ok.String(*v.StorageProfileId)
	}

	if len(v.TargetTaskRunStatus) > 0 {
		ok := object.Key("targetTaskRunStatus")
		ok.String(string(v.TargetTaskRunStatus))
	}

	if v.Template != nil {
		ok := object.Key("template")
		ok.String(*v.Template)
	}

	if len(v.TemplateType) > 0 {
		ok := object.Key("templateType")
		ok.String(string(v.TemplateType))
	}

	return nil
}

type awsRestjson1_serializeOpCreateLicenseEndpoint struct {
}

func (*awsRestjson1_serializeOpCreateLicenseEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateLicenseEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateLicenseEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/license-endpoints")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateLicenseEndpointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateLicenseEndpointInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateLicenseEndpointInput(v *CreateLicenseEndpointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateLicenseEndpointInput(v *CreateLicenseEndpointInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroupIds != nil {
		ok := object.Key("securityGroupIds")
		if err := awsRestjson1_serializeDocumentSecurityGroupIdList(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("subnetIds")
		if err := awsRestjson1_serializeDocumentSubnetIdList(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VpcId != nil {
		ok := object.Key("vpcId")
		ok.String(*v.VpcId)
	}

	return nil
}

type awsRestjson1_serializeOpCreateLimit struct {
}

func (*awsRestjson1_serializeOpCreateLimit) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateLimit) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateLimitInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/limits")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateLimitInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateLimitInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateLimitInput(v *CreateLimitInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateLimitInput(v *CreateLimitInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AmountRequirementName != nil {
		ok := object.Key("amountRequirementName")
		ok.String(*v.AmountRequirementName)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.MaxCount != nil {
		ok := object.Key("maxCount")
		ok.Integer(*v.MaxCount)
	}

	return nil
}

type awsRestjson1_serializeOpCreateMonitor struct {
}

func (*awsRestjson1_serializeOpCreateMonitor) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateMonitor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMonitorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/monitors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateMonitorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateMonitorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateMonitorInput(v *CreateMonitorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateMonitorInput(v *CreateMonitorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.IdentityCenterInstanceArn != nil {
		ok := object.Key("identityCenterInstanceArn")
		ok.String(*v.IdentityCenterInstanceArn)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Subdomain != nil {
		ok := object.Key("subdomain")
		ok.String(*v.Subdomain)
	}

	return nil
}

type awsRestjson1_serializeOpCreateQueue struct {
}

func (*awsRestjson1_serializeOpCreateQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateQueueInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateQueueInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateQueueInput(v *CreateQueueInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateQueueInput(v *CreateQueueInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedStorageProfileIds != nil {
		ok := object.Key("allowedStorageProfileIds")
		if err := awsRestjson1_serializeDocumentAllowedStorageProfileIds(v.AllowedStorageProfileIds, ok); err != nil {
			return err
		}
	}

	if len(v.DefaultBudgetAction) > 0 {
		ok := object.Key("defaultBudgetAction")
		ok.String(string(v.DefaultBudgetAction))
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.JobAttachmentSettings != nil {
		ok := object.Key("jobAttachmentSettings")
		if err := awsRestjson1_serializeDocumentJobAttachmentSettings(v.JobAttachmentSettings, ok); err != nil {
			return err
		}
	}

	if v.JobRunAsUser != nil {
		ok := object.Key("jobRunAsUser")
		if err := awsRestjson1_serializeDocumentJobRunAsUser(v.JobRunAsUser, ok); err != nil {
			return err
		}
	}

	if v.RequiredFileSystemLocationNames != nil {
		ok := object.Key("requiredFileSystemLocationNames")
		if err := awsRestjson1_serializeDocumentRequiredFileSystemLocationNames(v.RequiredFileSystemLocationNames, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateQueueEnvironment struct {
}

func (*awsRestjson1_serializeOpCreateQueueEnvironment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateQueueEnvironment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateQueueEnvironmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/environments")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateQueueEnvironmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateQueueEnvironmentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateQueueEnvironmentInput(v *CreateQueueEnvironmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateQueueEnvironmentInput(v *CreateQueueEnvironmentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Priority != nil {
		ok := object.Key("priority")
		ok.Integer(*v.Priority)
	}

	if v.Template != nil {
		ok := object.Key("template")
		ok.String(*v.Template)
	}

	if len(v.TemplateType) > 0 {
		ok := object.Key("templateType")
		ok.String(string(v.TemplateType))
	}

	return nil
}

type awsRestjson1_serializeOpCreateQueueFleetAssociation struct {
}

func (*awsRestjson1_serializeOpCreateQueueFleetAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateQueueFleetAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateQueueFleetAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queue-fleet-associations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateQueueFleetAssociationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateQueueFleetAssociationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateQueueFleetAssociationInput(v *CreateQueueFleetAssociationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateQueueFleetAssociationInput(v *CreateQueueFleetAssociationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("fleetId")
		ok.String(*v.FleetId)
	}

	if v.QueueId != nil {
		ok := object.Key("queueId")
		ok.String(*v.QueueId)
	}

	return nil
}

type awsRestjson1_serializeOpCreateQueueLimitAssociation struct {
}

func (*awsRestjson1_serializeOpCreateQueueLimitAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateQueueLimitAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateQueueLimitAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queue-limit-associations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateQueueLimitAssociationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateQueueLimitAssociationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateQueueLimitAssociationInput(v *CreateQueueLimitAssociationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateQueueLimitAssociationInput(v *CreateQueueLimitAssociationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LimitId != nil {
		ok := object.Key("limitId")
		ok.String(*v.LimitId)
	}

	if v.QueueId != nil {
		ok := object.Key("queueId")
		ok.String(*v.QueueId)
	}

	return nil
}

type awsRestjson1_serializeOpCreateStorageProfile struct {
}

func (*awsRestjson1_serializeOpCreateStorageProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateStorageProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateStorageProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/storage-profiles")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateStorageProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateStorageProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateStorageProfileInput(v *CreateStorageProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateStorageProfileInput(v *CreateStorageProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.FileSystemLocations != nil {
		ok := object.Key("fileSystemLocations")
		if err := awsRestjson1_serializeDocumentFileSystemLocationsList(v.FileSystemLocations, ok); err != nil {
			return err
		}
	}

	if len(v.OsFamily) > 0 {
		ok := object.Key("osFamily")
		ok.String(string(v.OsFamily))
	}

	return nil
}

type awsRestjson1_serializeOpCreateWorker struct {
}

func (*awsRestjson1_serializeOpCreateWorker) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateWorker) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateWorkerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateWorkerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateWorkerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateWorkerInput(v *CreateWorkerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateWorkerInput(v *CreateWorkerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HostProperties != nil {
		ok := object.Key("hostProperties")
		if err := awsRestjson1_serializeDocumentHostPropertiesRequest(v.HostProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBudget struct {
}

func (*awsRestjson1_serializeOpDeleteBudget) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBudget) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBudgetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/budgets/{budgetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBudgetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBudgetInput(v *DeleteBudgetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BudgetId == nil || len(*v.BudgetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member budgetId must not be empty")}
	}
	if v.BudgetId != nil {
		if err := encoder.SetURI("budgetId").String(*v.BudgetId); err != nil {
			return err
		}
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteFarm struct {
}

func (*awsRestjson1_serializeOpDeleteFarm) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteFarm) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFarmInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteFarmInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFarmInput(v *DeleteFarmInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteFleet struct {
}

func (*awsRestjson1_serializeOpDeleteFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/fleets/{fleetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteFleetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFleetInput(v *DeleteFleetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteLicenseEndpoint struct {
}

func (*awsRestjson1_serializeOpDeleteLicenseEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteLicenseEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLicenseEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/license-endpoints/{licenseEndpointId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteLicenseEndpointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteLicenseEndpointInput(v *DeleteLicenseEndpointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LicenseEndpointId == nil || len(*v.LicenseEndpointId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member licenseEndpointId must not be empty")}
	}
	if v.LicenseEndpointId != nil {
		if err := encoder.SetURI("licenseEndpointId").String(*v.LicenseEndpointId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteLimit struct {
}

func (*awsRestjson1_serializeOpDeleteLimit) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteLimit) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLimitInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/limits/{limitId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteLimitInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteLimitInput(v *DeleteLimitInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.LimitId == nil || len(*v.LimitId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member limitId must not be empty")}
	}
	if v.LimitId != nil {
		if err := encoder.SetURI("limitId").String(*v.LimitId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteMeteredProduct struct {
}

func (*awsRestjson1_serializeOpDeleteMeteredProduct) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteMeteredProduct) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMeteredProductInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/license-endpoints/{licenseEndpointId}/metered-products/{productId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteMeteredProductInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteMeteredProductInput(v *DeleteMeteredProductInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LicenseEndpointId == nil || len(*v.LicenseEndpointId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member licenseEndpointId must not be empty")}
	}
	if v.LicenseEndpointId != nil {
		if err := encoder.SetURI("licenseEndpointId").String(*v.LicenseEndpointId); err != nil {
			return err
		}
	}

	if v.ProductId == nil || len(*v.ProductId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member productId must not be empty")}
	}
	if v.ProductId != nil {
		if err := encoder.SetURI("productId").String(*v.ProductId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteMonitor struct {
}

func (*awsRestjson1_serializeOpDeleteMonitor) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteMonitor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMonitorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/monitors/{monitorId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteMonitorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteMonitorInput(v *DeleteMonitorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MonitorId == nil || len(*v.MonitorId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member monitorId must not be empty")}
	}
	if v.MonitorId != nil {
		if err := encoder.SetURI("monitorId").String(*v.MonitorId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteQueue struct {
}

func (*awsRestjson1_serializeOpDeleteQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteQueueInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteQueueInput(v *DeleteQueueInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteQueueEnvironment struct {
}

func (*awsRestjson1_serializeOpDeleteQueueEnvironment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteQueueEnvironment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteQueueEnvironmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/environments/{queueEnvironmentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteQueueEnvironmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteQueueEnvironmentInput(v *DeleteQueueEnvironmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.QueueEnvironmentId == nil || len(*v.QueueEnvironmentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueEnvironmentId must not be empty")}
	}
	if v.QueueEnvironmentId != nil {
		if err := encoder.SetURI("queueEnvironmentId").String(*v.QueueEnvironmentId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteQueueFleetAssociation struct {
}

func (*awsRestjson1_serializeOpDeleteQueueFleetAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteQueueFleetAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteQueueFleetAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queue-fleet-associations/{queueId}/{fleetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteQueueFleetAssociationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteQueueFleetAssociationInput(v *DeleteQueueFleetAssociationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteQueueLimitAssociation struct {
}

func (*awsRestjson1_serializeOpDeleteQueueLimitAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteQueueLimitAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteQueueLimitAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queue-limit-associations/{queueId}/{limitId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteQueueLimitAssociationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteQueueLimitAssociationInput(v *DeleteQueueLimitAssociationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.LimitId == nil || len(*v.LimitId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member limitId must not be empty")}
	}
	if v.LimitId != nil {
		if err := encoder.SetURI("limitId").String(*v.LimitId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteStorageProfile struct {
}

func (*awsRestjson1_serializeOpDeleteStorageProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteStorageProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteStorageProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/storage-profiles/{storageProfileId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteStorageProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteStorageProfileInput(v *DeleteStorageProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.StorageProfileId == nil || len(*v.StorageProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member storageProfileId must not be empty")}
	}
	if v.StorageProfileId != nil {
		if err := encoder.SetURI("storageProfileId").String(*v.StorageProfileId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteWorker struct {
}

func (*awsRestjson1_serializeOpDeleteWorker) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteWorker) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteWorkerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers/{workerId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteWorkerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteWorkerInput(v *DeleteWorkerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	if v.WorkerId == nil || len(*v.WorkerId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workerId must not be empty")}
	}
	if v.WorkerId != nil {
		if err := encoder.SetURI("workerId").String(*v.WorkerId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateMemberFromFarm struct {
}

func (*awsRestjson1_serializeOpDisassociateMemberFromFarm) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateMemberFromFarm) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateMemberFromFarmInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/members/{principalId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateMemberFromFarmInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateMemberFromFarmInput(v *DisassociateMemberFromFarmInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.PrincipalId == nil || len(*v.PrincipalId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member principalId must not be empty")}
	}
	if v.PrincipalId != nil {
		if err := encoder.SetURI("principalId").String(*v.PrincipalId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateMemberFromFleet struct {
}

func (*awsRestjson1_serializeOpDisassociateMemberFromFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateMemberFromFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateMemberFromFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/fleets/{fleetId}/members/{principalId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateMemberFromFleetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateMemberFromFleetInput(v *DisassociateMemberFromFleetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	if v.PrincipalId == nil || len(*v.PrincipalId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member principalId must not be empty")}
	}
	if v.PrincipalId != nil {
		if err := encoder.SetURI("principalId").String(*v.PrincipalId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateMemberFromJob struct {
}

func (*awsRestjson1_serializeOpDisassociateMemberFromJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateMemberFromJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateMemberFromJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/members/{principalId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateMemberFromJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateMemberFromJobInput(v *DisassociateMemberFromJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.PrincipalId == nil || len(*v.PrincipalId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member principalId must not be empty")}
	}
	if v.PrincipalId != nil {
		if err := encoder.SetURI("principalId").String(*v.PrincipalId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateMemberFromQueue struct {
}

func (*awsRestjson1_serializeOpDisassociateMemberFromQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateMemberFromQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateMemberFromQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/members/{principalId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateMemberFromQueueInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateMemberFromQueueInput(v *DisassociateMemberFromQueueInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.PrincipalId == nil || len(*v.PrincipalId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member principalId must not be empty")}
	}
	if v.PrincipalId != nil {
		if err := encoder.SetURI("principalId").String(*v.PrincipalId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetBudget struct {
}

func (*awsRestjson1_serializeOpGetBudget) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBudget) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBudgetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/budgets/{budgetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBudgetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBudgetInput(v *GetBudgetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BudgetId == nil || len(*v.BudgetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member budgetId must not be empty")}
	}
	if v.BudgetId != nil {
		if err := encoder.SetURI("budgetId").String(*v.BudgetId); err != nil {
			return err
		}
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetFarm struct {
}

func (*awsRestjson1_serializeOpGetFarm) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetFarm) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFarmInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetFarmInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetFarmInput(v *GetFarmInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetFleet struct {
}

func (*awsRestjson1_serializeOpGetFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/fleets/{fleetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetFleetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetFleetInput(v *GetFleetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetJob struct {
}

func (*awsRestjson1_serializeOpGetJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetJobInput(v *GetJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetLicenseEndpoint struct {
}

func (*awsRestjson1_serializeOpGetLicenseEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetLicenseEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLicenseEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/license-endpoints/{licenseEndpointId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetLicenseEndpointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetLicenseEndpointInput(v *GetLicenseEndpointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LicenseEndpointId == nil || len(*v.LicenseEndpointId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member licenseEndpointId must not be empty")}
	}
	if v.LicenseEndpointId != nil {
		if err := encoder.SetURI("licenseEndpointId").String(*v.LicenseEndpointId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetLimit struct {
}

func (*awsRestjson1_serializeOpGetLimit) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetLimit) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLimitInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/limits/{limitId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetLimitInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetLimitInput(v *GetLimitInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.LimitId == nil || len(*v.LimitId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member limitId must not be empty")}
	}
	if v.LimitId != nil {
		if err := encoder.SetURI("limitId").String(*v.LimitId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetMonitor struct {
}

func (*awsRestjson1_serializeOpGetMonitor) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMonitor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMonitorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/monitors/{monitorId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetMonitorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMonitorInput(v *GetMonitorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MonitorId == nil || len(*v.MonitorId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member monitorId must not be empty")}
	}
	if v.MonitorId != nil {
		if err := encoder.SetURI("monitorId").String(*v.MonitorId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetQueue struct {
}

func (*awsRestjson1_serializeOpGetQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetQueueInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetQueueInput(v *GetQueueInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetQueueEnvironment struct {
}

func (*awsRestjson1_serializeOpGetQueueEnvironment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetQueueEnvironment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetQueueEnvironmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/environments/{queueEnvironmentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetQueueEnvironmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetQueueEnvironmentInput(v *GetQueueEnvironmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.QueueEnvironmentId == nil || len(*v.QueueEnvironmentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueEnvironmentId must not be empty")}
	}
	if v.QueueEnvironmentId != nil {
		if err := encoder.SetURI("queueEnvironmentId").String(*v.QueueEnvironmentId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetQueueFleetAssociation struct {
}

func (*awsRestjson1_serializeOpGetQueueFleetAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetQueueFleetAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetQueueFleetAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queue-fleet-associations/{queueId}/{fleetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetQueueFleetAssociationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetQueueFleetAssociationInput(v *GetQueueFleetAssociationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetQueueLimitAssociation struct {
}

func (*awsRestjson1_serializeOpGetQueueLimitAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetQueueLimitAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetQueueLimitAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queue-limit-associations/{queueId}/{limitId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetQueueLimitAssociationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetQueueLimitAssociationInput(v *GetQueueLimitAssociationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.LimitId == nil || len(*v.LimitId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member limitId must not be empty")}
	}
	if v.LimitId != nil {
		if err := encoder.SetURI("limitId").String(*v.LimitId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetSession struct {
}

func (*awsRestjson1_serializeOpGetSession) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/sessions/{sessionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSessionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSessionInput(v *GetSessionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetSessionAction struct {
}

func (*awsRestjson1_serializeOpGetSessionAction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSessionAction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSessionActionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/session-actions/{sessionActionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSessionActionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSessionActionInput(v *GetSessionActionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	if v.SessionActionId == nil || len(*v.SessionActionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionActionId must not be empty")}
	}
	if v.SessionActionId != nil {
		if err := encoder.SetURI("sessionActionId").String(*v.SessionActionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetSessionsStatisticsAggregation struct {
}

func (*awsRestjson1_serializeOpGetSessionsStatisticsAggregation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSessionsStatisticsAggregation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSessionsStatisticsAggregationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/sessions-statistics-aggregation")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSessionsStatisticsAggregationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSessionsStatisticsAggregationInput(v *GetSessionsStatisticsAggregationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AggregationId != nil {
		encoder.SetQuery("aggregationId").String(*v.AggregationId)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetStep struct {
}

func (*awsRestjson1_serializeOpGetStep) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetStep) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStepInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/steps/{stepId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetStepInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetStepInput(v *GetStepInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	if v.StepId == nil || len(*v.StepId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member stepId must not be empty")}
	}
	if v.StepId != nil {
		if err := encoder.SetURI("stepId").String(*v.StepId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetStorageProfile struct {
}

func (*awsRestjson1_serializeOpGetStorageProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetStorageProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStorageProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/storage-profiles/{storageProfileId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetStorageProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetStorageProfileInput(v *GetStorageProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.StorageProfileId == nil || len(*v.StorageProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member storageProfileId must not be empty")}
	}
	if v.StorageProfileId != nil {
		if err := encoder.SetURI("storageProfileId").String(*v.StorageProfileId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetStorageProfileForQueue struct {
}

func (*awsRestjson1_serializeOpGetStorageProfileForQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetStorageProfileForQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStorageProfileForQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/storage-profiles/{storageProfileId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetStorageProfileForQueueInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetStorageProfileForQueueInput(v *GetStorageProfileForQueueInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	if v.StorageProfileId == nil || len(*v.StorageProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member storageProfileId must not be empty")}
	}
	if v.StorageProfileId != nil {
		if err := encoder.SetURI("storageProfileId").String(*v.StorageProfileId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetTask struct {
}

func (*awsRestjson1_serializeOpGetTask) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/steps/{stepId}/tasks/{taskId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetTaskInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetTaskInput(v *GetTaskInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	if v.StepId == nil || len(*v.StepId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member stepId must not be empty")}
	}
	if v.StepId != nil {
		if err := encoder.SetURI("stepId").String(*v.StepId); err != nil {
			return err
		}
	}

	if v.TaskId == nil || len(*v.TaskId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member taskId must not be empty")}
	}
	if v.TaskId != nil {
		if err := encoder.SetURI("taskId").String(*v.TaskId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetWorker struct {
}

func (*awsRestjson1_serializeOpGetWorker) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetWorker) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetWorkerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers/{workerId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetWorkerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetWorkerInput(v *GetWorkerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	if v.WorkerId == nil || len(*v.WorkerId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workerId must not be empty")}
	}
	if v.WorkerId != nil {
		if err := encoder.SetURI("workerId").String(*v.WorkerId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListAvailableMeteredProducts struct {
}

func (*awsRestjson1_serializeOpListAvailableMeteredProducts) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAvailableMeteredProducts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAvailableMeteredProductsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/metered-products")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAvailableMeteredProductsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAvailableMeteredProductsInput(v *ListAvailableMeteredProductsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListBudgets struct {
}

func (*awsRestjson1_serializeOpListBudgets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBudgets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBudgetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/budgets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBudgetsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBudgetsInput(v *ListBudgetsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.Status) > 0 {
		encoder.SetQuery("status").String(string(v.Status))
	}

	return nil
}

type awsRestjson1_serializeOpListFarmMembers struct {
}

func (*awsRestjson1_serializeOpListFarmMembers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFarmMembers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFarmMembersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/members")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFarmMembersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFarmMembersInput(v *ListFarmMembersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListFarms struct {
}

func (*awsRestjson1_serializeOpListFarms) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFarms) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFarmsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFarmsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFarmsInput(v *ListFarmsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.PrincipalId != nil {
		encoder.SetQuery("principalId").String(*v.PrincipalId)
	}

	return nil
}

type awsRestjson1_serializeOpListFleetMembers struct {
}

func (*awsRestjson1_serializeOpListFleetMembers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFleetMembers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFleetMembersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/fleets/{fleetId}/members")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFleetMembersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFleetMembersInput(v *ListFleetMembersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListFleets struct {
}

func (*awsRestjson1_serializeOpListFleets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFleets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFleetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/fleets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFleetsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFleetsInput(v *ListFleetsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DisplayName != nil {
		encoder.SetQuery("displayName").String(*v.DisplayName)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.PrincipalId != nil {
		encoder.SetQuery("principalId").String(*v.PrincipalId)
	}

	if len(v.Status) > 0 {
		encoder.SetQuery("status").String(string(v.Status))
	}

	return nil
}

type awsRestjson1_serializeOpListJobMembers struct {
}

func (*awsRestjson1_serializeOpListJobMembers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListJobMembers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListJobMembersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/members")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListJobMembersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListJobMembersInput(v *ListJobMembersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListJobParameterDefinitions struct {
}

func (*awsRestjson1_serializeOpListJobParameterDefinitions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListJobParameterDefinitions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListJobParameterDefinitionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/parameter-definitions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListJobParameterDefinitionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListJobParameterDefinitionsInput(v *ListJobParameterDefinitionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListJobs struct {
}

func (*awsRestjson1_serializeOpListJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListJobsInput(v *ListJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.PrincipalId != nil {
		encoder.SetQuery("principalId").String(*v.PrincipalId)
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListLicenseEndpoints struct {
}

func (*awsRestjson1_serializeOpListLicenseEndpoints) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListLicenseEndpoints) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListLicenseEndpointsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/license-endpoints")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListLicenseEndpointsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListLicenseEndpointsInput(v *ListLicenseEndpointsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListLimits struct {
}

func (*awsRestjson1_serializeOpListLimits) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListLimits) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListLimitsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/limits")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListLimitsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListLimitsInput(v *ListLimitsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListMeteredProducts struct {
}

func (*awsRestjson1_serializeOpListMeteredProducts) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListMeteredProducts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMeteredProductsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/license-endpoints/{licenseEndpointId}/metered-products")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListMeteredProductsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListMeteredProductsInput(v *ListMeteredProductsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LicenseEndpointId == nil || len(*v.LicenseEndpointId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member licenseEndpointId must not be empty")}
	}
	if v.LicenseEndpointId != nil {
		if err := encoder.SetURI("licenseEndpointId").String(*v.LicenseEndpointId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListMonitors struct {
}

func (*awsRestjson1_serializeOpListMonitors) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListMonitors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMonitorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/monitors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListMonitorsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListMonitorsInput(v *ListMonitorsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListQueueEnvironments struct {
}

func (*awsRestjson1_serializeOpListQueueEnvironments) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListQueueEnvironments) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListQueueEnvironmentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/environments")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListQueueEnvironmentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListQueueEnvironmentsInput(v *ListQueueEnvironmentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListQueueFleetAssociations struct {
}

func (*awsRestjson1_serializeOpListQueueFleetAssociations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListQueueFleetAssociations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListQueueFleetAssociationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queue-fleet-associations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListQueueFleetAssociationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListQueueFleetAssociationsInput(v *ListQueueFleetAssociationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId != nil {
		encoder.SetQuery("fleetId").String(*v.FleetId)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.QueueId != nil {
		encoder.SetQuery("queueId").String(*v.QueueId)
	}

	return nil
}

type awsRestjson1_serializeOpListQueueLimitAssociations struct {
}

func (*awsRestjson1_serializeOpListQueueLimitAssociations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListQueueLimitAssociations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListQueueLimitAssociationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queue-limit-associations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListQueueLimitAssociationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListQueueLimitAssociationsInput(v *ListQueueLimitAssociationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.LimitId != nil {
		encoder.SetQuery("limitId").String(*v.LimitId)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.QueueId != nil {
		encoder.SetQuery("queueId").String(*v.QueueId)
	}

	return nil
}

type awsRestjson1_serializeOpListQueueMembers struct {
}

func (*awsRestjson1_serializeOpListQueueMembers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListQueueMembers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListQueueMembersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/members")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListQueueMembersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListQueueMembersInput(v *ListQueueMembersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListQueues struct {
}

func (*awsRestjson1_serializeOpListQueues) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListQueues) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListQueuesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListQueuesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListQueuesInput(v *ListQueuesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.PrincipalId != nil {
		encoder.SetQuery("principalId").String(*v.PrincipalId)
	}

	if len(v.Status) > 0 {
		encoder.SetQuery("status").String(string(v.Status))
	}

	return nil
}

type awsRestjson1_serializeOpListSessionActions struct {
}

func (*awsRestjson1_serializeOpListSessionActions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListSessionActions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSessionActionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/session-actions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListSessionActionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListSessionActionsInput(v *ListSessionActionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	if v.SessionId != nil {
		encoder.SetQuery("sessionId").String(*v.SessionId)
	}

	if v.TaskId != nil {
		encoder.SetQuery("taskId").String(*v.TaskId)
	}

	return nil
}

type awsRestjson1_serializeOpListSessions struct {
}

func (*awsRestjson1_serializeOpListSessions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListSessions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSessionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/sessions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListSessionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListSessionsInput(v *ListSessionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListSessionsForWorker struct {
}

func (*awsRestjson1_serializeOpListSessionsForWorker) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListSessionsForWorker) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSessionsForWorkerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers/{workerId}/sessions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListSessionsForWorkerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListSessionsForWorkerInput(v *ListSessionsForWorkerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.WorkerId == nil || len(*v.WorkerId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workerId must not be empty")}
	}
	if v.WorkerId != nil {
		if err := encoder.SetURI("workerId").String(*v.WorkerId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListStepConsumers struct {
}

func (*awsRestjson1_serializeOpListStepConsumers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListStepConsumers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListStepConsumersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/steps/{stepId}/consumers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListStepConsumersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListStepConsumersInput(v *ListStepConsumersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	if v.StepId == nil || len(*v.StepId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member stepId must not be empty")}
	}
	if v.StepId != nil {
		if err := encoder.SetURI("stepId").String(*v.StepId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListStepDependencies struct {
}

func (*awsRestjson1_serializeOpListStepDependencies) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListStepDependencies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListStepDependenciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/steps/{stepId}/dependencies")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListStepDependenciesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListStepDependenciesInput(v *ListStepDependenciesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	if v.StepId == nil || len(*v.StepId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member stepId must not be empty")}
	}
	if v.StepId != nil {
		if err := encoder.SetURI("stepId").String(*v.StepId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListSteps struct {
}

func (*awsRestjson1_serializeOpListSteps) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListSteps) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListStepsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/steps")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListStepsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListStepsInput(v *ListStepsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListStorageProfiles struct {
}

func (*awsRestjson1_serializeOpListStorageProfiles) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListStorageProfiles) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListStorageProfilesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/storage-profiles")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListStorageProfilesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListStorageProfilesInput(v *ListStorageProfilesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListStorageProfilesForQueue struct {
}

func (*awsRestjson1_serializeOpListStorageProfilesForQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListStorageProfilesForQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListStorageProfilesForQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/storage-profiles")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListStorageProfilesForQueueInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListStorageProfilesForQueueInput(v *ListStorageProfilesForQueueInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTasks struct {
}

func (*awsRestjson1_serializeOpListTasks) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTasks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTasksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/steps/{stepId}/tasks")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTasksInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTasksInput(v *ListTasksInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	if v.StepId == nil || len(*v.StepId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member stepId must not be empty")}
	}
	if v.StepId != nil {
		if err := encoder.SetURI("stepId").String(*v.StepId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListWorkers struct {
}

func (*awsRestjson1_serializeOpListWorkers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListWorkers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListWorkersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListWorkersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListWorkersInput(v *ListWorkersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpPutMeteredProduct struct {
}

func (*awsRestjson1_serializeOpPutMeteredProduct) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutMeteredProduct) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutMeteredProductInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/license-endpoints/{licenseEndpointId}/metered-products/{productId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutMeteredProductInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutMeteredProductInput(v *PutMeteredProductInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LicenseEndpointId == nil || len(*v.LicenseEndpointId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member licenseEndpointId must not be empty")}
	}
	if v.LicenseEndpointId != nil {
		if err := encoder.SetURI("licenseEndpointId").String(*v.LicenseEndpointId); err != nil {
			return err
		}
	}

	if v.ProductId == nil || len(*v.ProductId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member productId must not be empty")}
	}
	if v.ProductId != nil {
		if err := encoder.SetURI("productId").String(*v.ProductId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSearchJobs struct {
}

func (*awsRestjson1_serializeOpSearchJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/search/jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchJobsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchJobsInput(v *SearchJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchJobsInput(v *SearchJobsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilterExpressions != nil {
		ok := object.Key("filterExpressions")
		if err := awsRestjson1_serializeDocumentSearchGroupedFilterExpressions(v.FilterExpressions, ok); err != nil {
			return err
		}
	}

	if v.ItemOffset != nil {
		ok := object.Key("itemOffset")
		ok.Integer(*v.ItemOffset)
	}

	if v.PageSize != nil {
		ok := object.Key("pageSize")
		ok.Integer(*v.PageSize)
	}

	if v.QueueIds != nil {
		ok := object.Key("queueIds")
		if err := awsRestjson1_serializeDocumentQueueIds(v.QueueIds, ok); err != nil {
			return err
		}
	}

	if v.SortExpressions != nil {
		ok := object.Key("sortExpressions")
		if err := awsRestjson1_serializeDocumentSearchSortExpressions(v.SortExpressions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSearchSteps struct {
}

func (*awsRestjson1_serializeOpSearchSteps) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchSteps) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchStepsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/search/steps")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchStepsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchStepsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchStepsInput(v *SearchStepsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchStepsInput(v *SearchStepsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilterExpressions != nil {
		ok := object.Key("filterExpressions")
		if err := awsRestjson1_serializeDocumentSearchGroupedFilterExpressions(v.FilterExpressions, ok); err != nil {
			return err
		}
	}

	if v.ItemOffset != nil {
		ok := object.Key("itemOffset")
		ok.Integer(*v.ItemOffset)
	}

	if v.JobId != nil {
		ok := object.Key("jobId")
		ok.String(*v.JobId)
	}

	if v.PageSize != nil {
		ok := object.Key("pageSize")
		ok.Integer(*v.PageSize)
	}

	if v.QueueIds != nil {
		ok := object.Key("queueIds")
		if err := awsRestjson1_serializeDocumentQueueIds(v.QueueIds, ok); err != nil {
			return err
		}
	}

	if v.SortExpressions != nil {
		ok := object.Key("sortExpressions")
		if err := awsRestjson1_serializeDocumentSearchSortExpressions(v.SortExpressions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSearchTasks struct {
}

func (*awsRestjson1_serializeOpSearchTasks) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchTasks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchTasksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/search/tasks")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchTasksInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchTasksInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchTasksInput(v *SearchTasksInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchTasksInput(v *SearchTasksInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilterExpressions != nil {
		ok := object.Key("filterExpressions")
		if err := awsRestjson1_serializeDocumentSearchGroupedFilterExpressions(v.FilterExpressions, ok); err != nil {
			return err
		}
	}

	if v.ItemOffset != nil {
		ok := object.Key("itemOffset")
		ok.Integer(*v.ItemOffset)
	}

	if v.JobId != nil {
		ok := object.Key("jobId")
		ok.String(*v.JobId)
	}

	if v.PageSize != nil {
		ok := object.Key("pageSize")
		ok.Integer(*v.PageSize)
	}

	if v.QueueIds != nil {
		ok := object.Key("queueIds")
		if err := awsRestjson1_serializeDocumentQueueIds(v.QueueIds, ok); err != nil {
			return err
		}
	}

	if v.SortExpressions != nil {
		ok := object.Key("sortExpressions")
		if err := awsRestjson1_serializeDocumentSearchSortExpressions(v.SortExpressions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSearchWorkers struct {
}

func (*awsRestjson1_serializeOpSearchWorkers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchWorkers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchWorkersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/search/workers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchWorkersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchWorkersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchWorkersInput(v *SearchWorkersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchWorkersInput(v *SearchWorkersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilterExpressions != nil {
		ok := object.Key("filterExpressions")
		if err := awsRestjson1_serializeDocumentSearchGroupedFilterExpressions(v.FilterExpressions, ok); err != nil {
			return err
		}
	}

	if v.FleetIds != nil {
		ok := object.Key("fleetIds")
		if err := awsRestjson1_serializeDocumentFleetIds(v.FleetIds, ok); err != nil {
			return err
		}
	}

	if v.ItemOffset != nil {
		ok := object.Key("itemOffset")
		ok.Integer(*v.ItemOffset)
	}

	if v.PageSize != nil {
		ok := object.Key("pageSize")
		ok.Integer(*v.PageSize)
	}

	if v.SortExpressions != nil {
		ok := object.Key("sortExpressions")
		if err := awsRestjson1_serializeDocumentSearchSortExpressions(v.SortExpressions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartSessionsStatisticsAggregation struct {
}

func (*awsRestjson1_serializeOpStartSessionsStatisticsAggregation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartSessionsStatisticsAggregation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartSessionsStatisticsAggregationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/sessions-statistics-aggregation")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartSessionsStatisticsAggregationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartSessionsStatisticsAggregationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartSessionsStatisticsAggregationInput(v *StartSessionsStatisticsAggregationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartSessionsStatisticsAggregationInput(v *StartSessionsStatisticsAggregationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTime != nil {
		ok := object.Key("endTime")
		ok.String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.GroupBy != nil {
		ok := object.Key("groupBy")
		if err := awsRestjson1_serializeDocumentUsageGroupBy(v.GroupBy, ok); err != nil {
			return err
		}
	}

	if len(v.Period) > 0 {
		ok := object.Key("period")
		ok.String(string(v.Period))
	}

	if v.ResourceIds != nil {
		ok := object.Key("resourceIds")
		if err := awsRestjson1_serializeDocumentSessionsStatisticsResources(v.ResourceIds, ok); err != nil {
			return err
		}
	}

	if v.StartTime != nil {
		ok := object.Key("startTime")
		ok.String(smithytime.FormatDateTime(*v.StartTime))
	}

	if v.Statistics != nil {
		ok := object.Key("statistics")
		if err := awsRestjson1_serializeDocumentUsageStatistics(v.Statistics, ok); err != nil {
			return err
		}
	}

	if v.Timezone != nil {
		ok := object.Key("timezone")
		ok.String(*v.Timezone)
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBudget struct {
}

func (*awsRestjson1_serializeOpUpdateBudget) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBudget) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBudgetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/budgets/{budgetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBudgetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBudgetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBudgetInput(v *UpdateBudgetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BudgetId == nil || len(*v.BudgetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member budgetId must not be empty")}
	}
	if v.BudgetId != nil {
		if err := encoder.SetURI("budgetId").String(*v.BudgetId); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBudgetInput(v *UpdateBudgetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionsToAdd != nil {
		ok := object.Key("actionsToAdd")
		if err := awsRestjson1_serializeDocumentBudgetActionsToAdd(v.ActionsToAdd, ok); err != nil {
			return err
		}
	}

	if v.ActionsToRemove != nil {
		ok := object.Key("actionsToRemove")
		if err := awsRestjson1_serializeDocumentBudgetActionsToRemove(v.ActionsToRemove, ok); err != nil {
			return err
		}
	}

	if v.ApproximateDollarLimit != nil {
		ok := object.Key("approximateDollarLimit")
		switch {
		case math.IsNaN(float64(*v.ApproximateDollarLimit)):
			ok.String("NaN")

		case math.IsInf(float64(*v.ApproximateDollarLimit), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.ApproximateDollarLimit), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.ApproximateDollarLimit)

		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.Schedule != nil {
		ok := object.Key("schedule")
		if err := awsRestjson1_serializeDocumentBudgetSchedule(v.Schedule, ok); err != nil {
			return err
		}
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFarm struct {
}

func (*awsRestjson1_serializeOpUpdateFarm) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFarm) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFarmInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFarmInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFarmInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFarmInput(v *UpdateFarmInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFarmInput(v *UpdateFarmInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFleet struct {
}

func (*awsRestjson1_serializeOpUpdateFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/fleets/{fleetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFleetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFleetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFleetInput(v *UpdateFleetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFleetInput(v *UpdateFleetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsRestjson1_serializeDocumentFleetConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.MaxWorkerCount != nil {
		ok := object.Key("maxWorkerCount")
		ok.Integer(*v.MaxWorkerCount)
	}

	if v.MinWorkerCount != nil {
		ok := object.Key("minWorkerCount")
		ok.Integer(*v.MinWorkerCount)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateJob struct {
}

func (*awsRestjson1_serializeOpUpdateJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateJobInput(v *UpdateJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateJobInput(v *UpdateJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.LifecycleStatus) > 0 {
		ok := object.Key("lifecycleStatus")
		ok.String(string(v.LifecycleStatus))
	}

	if v.MaxFailedTasksCount != nil {
		ok := object.Key("maxFailedTasksCount")
		ok.Integer(*v.MaxFailedTasksCount)
	}

	if v.MaxRetriesPerTask != nil {
		ok := object.Key("maxRetriesPerTask")
		ok.Integer(*v.MaxRetriesPerTask)
	}

	if v.MaxWorkerCount != nil {
		ok := object.Key("maxWorkerCount")
		ok.Integer(*v.MaxWorkerCount)
	}

	if v.Priority != nil {
		ok := object.Key("priority")
		ok.Integer(*v.Priority)
	}

	if len(v.TargetTaskRunStatus) > 0 {
		ok := object.Key("targetTaskRunStatus")
		ok.String(string(v.TargetTaskRunStatus))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateLimit struct {
}

func (*awsRestjson1_serializeOpUpdateLimit) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateLimit) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateLimitInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/limits/{limitId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateLimitInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateLimitInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateLimitInput(v *UpdateLimitInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.LimitId == nil || len(*v.LimitId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member limitId must not be empty")}
	}
	if v.LimitId != nil {
		if err := encoder.SetURI("limitId").String(*v.LimitId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateLimitInput(v *UpdateLimitInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.MaxCount != nil {
		ok := object.Key("maxCount")
		ok.Integer(*v.MaxCount)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateMonitor struct {
}

func (*awsRestjson1_serializeOpUpdateMonitor) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateMonitor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateMonitorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/monitors/{monitorId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateMonitorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateMonitorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateMonitorInput(v *UpdateMonitorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MonitorId == nil || len(*v.MonitorId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member monitorId must not be empty")}
	}
	if v.MonitorId != nil {
		if err := encoder.SetURI("monitorId").String(*v.MonitorId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateMonitorInput(v *UpdateMonitorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Subdomain != nil {
		ok := object.Key("subdomain")
		ok.String(*v.Subdomain)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateQueue struct {
}

func (*awsRestjson1_serializeOpUpdateQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateQueueInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateQueueInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateQueueInput(v *UpdateQueueInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateQueueInput(v *UpdateQueueInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedStorageProfileIdsToAdd != nil {
		ok := object.Key("allowedStorageProfileIdsToAdd")
		if err := awsRestjson1_serializeDocumentAllowedStorageProfileIds(v.AllowedStorageProfileIdsToAdd, ok); err != nil {
			return err
		}
	}

	if v.AllowedStorageProfileIdsToRemove != nil {
		ok := object.Key("allowedStorageProfileIdsToRemove")
		if err := awsRestjson1_serializeDocumentAllowedStorageProfileIds(v.AllowedStorageProfileIdsToRemove, ok); err != nil {
			return err
		}
	}

	if len(v.DefaultBudgetAction) > 0 {
		ok := object.Key("defaultBudgetAction")
		ok.String(string(v.DefaultBudgetAction))
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.JobAttachmentSettings != nil {
		ok := object.Key("jobAttachmentSettings")
		if err := awsRestjson1_serializeDocumentJobAttachmentSettings(v.JobAttachmentSettings, ok); err != nil {
			return err
		}
	}

	if v.JobRunAsUser != nil {
		ok := object.Key("jobRunAsUser")
		if err := awsRestjson1_serializeDocumentJobRunAsUser(v.JobRunAsUser, ok); err != nil {
			return err
		}
	}

	if v.RequiredFileSystemLocationNamesToAdd != nil {
		ok := object.Key("requiredFileSystemLocationNamesToAdd")
		if err := awsRestjson1_serializeDocumentRequiredFileSystemLocationNames(v.RequiredFileSystemLocationNamesToAdd, ok); err != nil {
			return err
		}
	}

	if v.RequiredFileSystemLocationNamesToRemove != nil {
		ok := object.Key("requiredFileSystemLocationNamesToRemove")
		if err := awsRestjson1_serializeDocumentRequiredFileSystemLocationNames(v.RequiredFileSystemLocationNamesToRemove, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateQueueEnvironment struct {
}

func (*awsRestjson1_serializeOpUpdateQueueEnvironment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateQueueEnvironment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateQueueEnvironmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/environments/{queueEnvironmentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateQueueEnvironmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateQueueEnvironmentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateQueueEnvironmentInput(v *UpdateQueueEnvironmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.QueueEnvironmentId == nil || len(*v.QueueEnvironmentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueEnvironmentId must not be empty")}
	}
	if v.QueueEnvironmentId != nil {
		if err := encoder.SetURI("queueEnvironmentId").String(*v.QueueEnvironmentId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateQueueEnvironmentInput(v *UpdateQueueEnvironmentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Priority != nil {
		ok := object.Key("priority")
		ok.Integer(*v.Priority)
	}

	if v.Template != nil {
		ok := object.Key("template")
		ok.String(*v.Template)
	}

	if len(v.TemplateType) > 0 {
		ok := object.Key("templateType")
		ok.String(string(v.TemplateType))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateQueueFleetAssociation struct {
}

func (*awsRestjson1_serializeOpUpdateQueueFleetAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateQueueFleetAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateQueueFleetAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queue-fleet-associations/{queueId}/{fleetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateQueueFleetAssociationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateQueueFleetAssociationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateQueueFleetAssociationInput(v *UpdateQueueFleetAssociationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateQueueFleetAssociationInput(v *UpdateQueueFleetAssociationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateQueueLimitAssociation struct {
}

func (*awsRestjson1_serializeOpUpdateQueueLimitAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateQueueLimitAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateQueueLimitAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queue-limit-associations/{queueId}/{limitId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateQueueLimitAssociationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateQueueLimitAssociationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateQueueLimitAssociationInput(v *UpdateQueueLimitAssociationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.LimitId == nil || len(*v.LimitId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member limitId must not be empty")}
	}
	if v.LimitId != nil {
		if err := encoder.SetURI("limitId").String(*v.LimitId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateQueueLimitAssociationInput(v *UpdateQueueLimitAssociationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateSession struct {
}

func (*awsRestjson1_serializeOpUpdateSession) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/sessions/{sessionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateSessionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateSessionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateSessionInput(v *UpdateSessionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateSessionInput(v *UpdateSessionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.TargetLifecycleStatus) > 0 {
		ok := object.Key("targetLifecycleStatus")
		ok.String(string(v.TargetLifecycleStatus))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateStep struct {
}

func (*awsRestjson1_serializeOpUpdateStep) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateStep) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateStepInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/steps/{stepId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateStepInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateStepInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateStepInput(v *UpdateStepInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	if v.StepId == nil || len(*v.StepId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member stepId must not be empty")}
	}
	if v.StepId != nil {
		if err := encoder.SetURI("stepId").String(*v.StepId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateStepInput(v *UpdateStepInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.TargetTaskRunStatus) > 0 {
		ok := object.Key("targetTaskRunStatus")
		ok.String(string(v.TargetTaskRunStatus))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateStorageProfile struct {
}

func (*awsRestjson1_serializeOpUpdateStorageProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateStorageProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateStorageProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/storage-profiles/{storageProfileId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateStorageProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateStorageProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateStorageProfileInput(v *UpdateStorageProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.StorageProfileId == nil || len(*v.StorageProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member storageProfileId must not be empty")}
	}
	if v.StorageProfileId != nil {
		if err := encoder.SetURI("storageProfileId").String(*v.StorageProfileId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateStorageProfileInput(v *UpdateStorageProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.FileSystemLocationsToAdd != nil {
		ok := object.Key("fileSystemLocationsToAdd")
		if err := awsRestjson1_serializeDocumentFileSystemLocationsList(v.FileSystemLocationsToAdd, ok); err != nil {
			return err
		}
	}

	if v.FileSystemLocationsToRemove != nil {
		ok := object.Key("fileSystemLocationsToRemove")
		if err := awsRestjson1_serializeDocumentFileSystemLocationsList(v.FileSystemLocationsToRemove, ok); err != nil {
			return err
		}
	}

	if len(v.OsFamily) > 0 {
		ok := object.Key("osFamily")
		ok.String(string(v.OsFamily))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTask struct {
}

func (*awsRestjson1_serializeOpUpdateTask) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/steps/{stepId}/tasks/{taskId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateTaskInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateTaskInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateTaskInput(v *UpdateTaskInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.QueueId == nil || len(*v.QueueId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member queueId must not be empty")}
	}
	if v.QueueId != nil {
		if err := encoder.SetURI("queueId").String(*v.QueueId); err != nil {
			return err
		}
	}

	if v.StepId == nil || len(*v.StepId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member stepId must not be empty")}
	}
	if v.StepId != nil {
		if err := encoder.SetURI("stepId").String(*v.StepId); err != nil {
			return err
		}
	}

	if v.TaskId == nil || len(*v.TaskId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member taskId must not be empty")}
	}
	if v.TaskId != nil {
		if err := encoder.SetURI("taskId").String(*v.TaskId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateTaskInput(v *UpdateTaskInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.TargetRunStatus) > 0 {
		ok := object.Key("targetRunStatus")
		ok.String(string(v.TargetRunStatus))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateWorker struct {
}

func (*awsRestjson1_serializeOpUpdateWorker) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateWorker) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateWorkerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers/{workerId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateWorkerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateWorkerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateWorkerInput(v *UpdateWorkerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	if v.WorkerId == nil || len(*v.WorkerId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workerId must not be empty")}
	}
	if v.WorkerId != nil {
		if err := encoder.SetURI("workerId").String(*v.WorkerId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateWorkerInput(v *UpdateWorkerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Capabilities != nil {
		ok := object.Key("capabilities")
		if err := awsRestjson1_serializeDocumentWorkerCapabilities(v.Capabilities, ok); err != nil {
			return err
		}
	}

	if v.HostProperties != nil {
		ok := object.Key("hostProperties")
		if err := awsRestjson1_serializeDocumentHostPropertiesRequest(v.HostProperties, ok); err != nil {
			return err
		}
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateWorkerSchedule struct {
}

func (*awsRestjson1_serializeOpUpdateWorkerSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateWorkerSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateWorkerScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers/{workerId}/schedule")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateWorkerScheduleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateWorkerScheduleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateWorkerScheduleInput(v *UpdateWorkerScheduleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FarmId == nil || len(*v.FarmId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member farmId must not be empty")}
	}
	if v.FarmId != nil {
		if err := encoder.SetURI("farmId").String(*v.FarmId); err != nil {
			return err
		}
	}

	if v.FleetId == nil || len(*v.FleetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fleetId must not be empty")}
	}
	if v.FleetId != nil {
		if err := encoder.SetURI("fleetId").String(*v.FleetId); err != nil {
			return err
		}
	}

	if v.WorkerId == nil || len(*v.WorkerId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workerId must not be empty")}
	}
	if v.WorkerId != nil {
		if err := encoder.SetURI("workerId").String(*v.WorkerId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateWorkerScheduleInput(v *UpdateWorkerScheduleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UpdatedSessionActions != nil {
		ok := object.Key("updatedSessionActions")
		if err := awsRestjson1_serializeDocumentUpdatedSessionActions(v.UpdatedSessionActions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAcceleratorCapabilities(v *types.AcceleratorCapabilities, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Count != nil {
		ok := object.Key("count")
		if err := awsRestjson1_serializeDocumentAcceleratorCountRange(v.Count, ok); err != nil {
			return err
		}
	}

	if v.Selections != nil {
		ok := object.Key("selections")
		if err := awsRestjson1_serializeDocumentAcceleratorSelections(v.Selections, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAcceleratorCountRange(v *types.AcceleratorCountRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Max != nil {
		ok := object.Key("max")
		ok.Integer(*v.Max)
	}

	if v.Min != nil {
		ok := object.Key("min")
		ok.Integer(*v.Min)
	}

	return nil
}

func awsRestjson1_serializeDocumentAcceleratorSelection(v *types.AcceleratorSelection, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if v.Runtime != nil {
		ok := object.Key("runtime")
		ok.String(*v.Runtime)
	}

	return nil
}

func awsRestjson1_serializeDocumentAcceleratorSelections(v []types.AcceleratorSelection, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAcceleratorSelection(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAcceleratorTotalMemoryMiBRange(v *types.AcceleratorTotalMemoryMiBRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Max != nil {
		ok := object.Key("max")
		ok.Integer(*v.Max)
	}

	if v.Min != nil {
		ok := object.Key("min")
		ok.Integer(*v.Min)
	}

	return nil
}

func awsRestjson1_serializeDocumentAcceleratorTypes(v []types.AcceleratorType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentAllowedStorageProfileIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAttachments(v *types.Attachments, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FileSystem) > 0 {
		ok := object.Key("fileSystem")
		ok.String(string(v.FileSystem))
	}

	if v.Manifests != nil {
		ok := object.Key("manifests")
		if err := awsRestjson1_serializeDocumentManifestPropertiesList(v.Manifests, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAttributeCapabilityValuesList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentBudgetActionsToAdd(v []types.BudgetActionToAdd, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBudgetActionToAdd(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBudgetActionsToRemove(v []types.BudgetActionToRemove, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBudgetActionToRemove(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBudgetActionToAdd(v *types.BudgetActionToAdd, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.ThresholdPercentage != nil {
		ok := object.Key("thresholdPercentage")
		switch {
		case math.IsNaN(float64(*v.ThresholdPercentage)):
			ok.String("NaN")

		case math.IsInf(float64(*v.ThresholdPercentage), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.ThresholdPercentage), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.ThresholdPercentage)

		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentBudgetActionToRemove(v *types.BudgetActionToRemove, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ThresholdPercentage != nil {
		ok := object.Key("thresholdPercentage")
		switch {
		case math.IsNaN(float64(*v.ThresholdPercentage)):
			ok.String("NaN")

		case math.IsInf(float64(*v.ThresholdPercentage), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.ThresholdPercentage), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.ThresholdPercentage)

		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentBudgetSchedule(v types.BudgetSchedule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.BudgetScheduleMemberFixed:
		av := object.Key("fixed")
		if err := awsRestjson1_serializeDocumentFixedBudgetSchedule(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentCustomerManagedFleetConfiguration(v *types.CustomerManagedFleetConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Mode) > 0 {
		ok := object.Key("mode")
		ok.String(string(v.Mode))
	}

	if v.StorageProfileId != nil {
		ok := object.Key("storageProfileId")
		ok.String(*v.StorageProfileId)
	}

	if v.WorkerCapabilities != nil {
		ok := object.Key("workerCapabilities")
		if err := awsRestjson1_serializeDocumentCustomerManagedWorkerCapabilities(v.WorkerCapabilities, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomerManagedWorkerCapabilities(v *types.CustomerManagedWorkerCapabilities, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AcceleratorCount != nil {
		ok := object.Key("acceleratorCount")
		if err := awsRestjson1_serializeDocumentAcceleratorCountRange(v.AcceleratorCount, ok); err != nil {
			return err
		}
	}

	if v.AcceleratorTotalMemoryMiB != nil {
		ok := object.Key("acceleratorTotalMemoryMiB")
		if err := awsRestjson1_serializeDocumentAcceleratorTotalMemoryMiBRange(v.AcceleratorTotalMemoryMiB, ok); err != nil {
			return err
		}
	}

	if v.AcceleratorTypes != nil {
		ok := object.Key("acceleratorTypes")
		if err := awsRestjson1_serializeDocumentAcceleratorTypes(v.AcceleratorTypes, ok); err != nil {
			return err
		}
	}

	if len(v.CpuArchitectureType) > 0 {
		ok := object.Key("cpuArchitectureType")
		ok.String(string(v.CpuArchitectureType))
	}

	if v.CustomAmounts != nil {
		ok := object.Key("customAmounts")
		if err := awsRestjson1_serializeDocumentCustomFleetAmountCapabilities(v.CustomAmounts, ok); err != nil {
			return err
		}
	}

	if v.CustomAttributes != nil {
		ok := object.Key("customAttributes")
		if err := awsRestjson1_serializeDocumentCustomFleetAttributeCapabilities(v.CustomAttributes, ok); err != nil {
			return err
		}
	}

	if v.MemoryMiB != nil {
		ok := object.Key("memoryMiB")
		if err := awsRestjson1_serializeDocumentMemoryMiBRange(v.MemoryMiB, ok); err != nil {
			return err
		}
	}

	if len(v.OsFamily) > 0 {
		ok := object.Key("osFamily")
		ok.String(string(v.OsFamily))
	}

	if v.VCpuCount != nil {
		ok := object.Key("vCpuCount")
		if err := awsRestjson1_serializeDocumentVCpuCountRange(v.VCpuCount, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomFleetAmountCapabilities(v []types.FleetAmountCapability, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFleetAmountCapability(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCustomFleetAttributeCapabilities(v []types.FleetAttributeCapability, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFleetAttributeCapability(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDateTimeFilterExpression(v *types.DateTimeFilterExpression, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateTime != nil {
		ok := object.Key("dateTime")
		ok.String(smithytime.FormatDateTime(*v.DateTime))
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	return nil
}

func awsRestjson1_serializeDocumentEc2EbsVolume(v *types.Ec2EbsVolume, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Iops != nil {
		ok := object.Key("iops")
		ok.Integer(*v.Iops)
	}

	if v.SizeGiB != nil {
		ok := object.Key("sizeGiB")
		ok.Integer(*v.SizeGiB)
	}

	if v.ThroughputMiB != nil {
		ok := object.Key("throughputMiB")
		ok.Integer(*v.ThroughputMiB)
	}

	return nil
}

func awsRestjson1_serializeDocumentEnvironmentDetailsIdentifiers(v *types.EnvironmentDetailsIdentifiers, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EnvironmentId != nil {
		ok := object.Key("environmentId")
		ok.String(*v.EnvironmentId)
	}

	if v.JobId != nil {
		ok := object.Key("jobId")
		ok.String(*v.JobId)
	}

	return nil
}

func awsRestjson1_serializeDocumentFieldSortExpression(v *types.FieldSortExpression, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentFileSystemLocation(v *types.FileSystemLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Path != nil {
		ok := object.Key("path")
		ok.String(*v.Path)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentFileSystemLocationsList(v []types.FileSystemLocation, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFileSystemLocation(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFixedBudgetSchedule(v *types.FixedBudgetSchedule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTime != nil {
		ok := object.Key("endTime")
		ok.String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.StartTime != nil {
		ok := object.Key("startTime")
		ok.String(smithytime.FormatDateTime(*v.StartTime))
	}

	return nil
}

func awsRestjson1_serializeDocumentFleetAmountCapability(v *types.FleetAmountCapability, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Max != nil {
		ok := object.Key("max")
		switch {
		case math.IsNaN(float64(*v.Max)):
			ok.String("NaN")

		case math.IsInf(float64(*v.Max), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.Max), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.Max)

		}
	}

	if v.Min != nil {
		ok := object.Key("min")
		switch {
		case math.IsNaN(float64(*v.Min)):
			ok.String("NaN")

		case math.IsInf(float64(*v.Min), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.Min), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.Min)

		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentFleetAttributeCapability(v *types.FleetAttributeCapability, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentAttributeCapabilityValuesList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFleetConfiguration(v types.FleetConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.FleetConfigurationMemberCustomerManaged:
		av := object.Key("customerManaged")
		if err := awsRestjson1_serializeDocumentCustomerManagedFleetConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.FleetConfigurationMemberServiceManagedEc2:
		av := object.Key("serviceManagedEc2")
		if err := awsRestjson1_serializeDocumentServiceManagedEc2FleetConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentFleetIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentHostPropertiesRequest(v *types.HostPropertiesRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HostName != nil {
		ok := object.Key("hostName")
		ok.String(*v.HostName)
	}

	if v.IpAddresses != nil {
		ok := object.Key("ipAddresses")
		if err := awsRestjson1_serializeDocumentIpAddresses(v.IpAddresses, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInstanceTypes(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentIpAddresses(v *types.IpAddresses, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IpV4Addresses != nil {
		ok := object.Key("ipV4Addresses")
		if err := awsRestjson1_serializeDocumentIpV4Addresses(v.IpV4Addresses, ok); err != nil {
			return err
		}
	}

	if v.IpV6Addresses != nil {
		ok := object.Key("ipV6Addresses")
		if err := awsRestjson1_serializeDocumentIpV6Addresses(v.IpV6Addresses, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIpV4Addresses(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentIpV6Addresses(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentJobAttachmentDetailsIdentifiers(v *types.JobAttachmentDetailsIdentifiers, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("jobId")
		ok.String(*v.JobId)
	}

	return nil
}

func awsRestjson1_serializeDocumentJobAttachmentSettings(v *types.JobAttachmentSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RootPrefix != nil {
		ok := object.Key("rootPrefix")
		ok.String(*v.RootPrefix)
	}

	if v.S3BucketName != nil {
		ok := object.Key("s3BucketName")
		ok.String(*v.S3BucketName)
	}

	return nil
}

func awsRestjson1_serializeDocumentJobDetailsIdentifiers(v *types.JobDetailsIdentifiers, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("jobId")
		ok.String(*v.JobId)
	}

	return nil
}

func awsRestjson1_serializeDocumentJobEntityIdentifiers(v []types.JobEntityIdentifiersUnion, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentJobEntityIdentifiersUnion(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentJobEntityIdentifiersUnion(v types.JobEntityIdentifiersUnion, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.JobEntityIdentifiersUnionMemberEnvironmentDetails:
		av := object.Key("environmentDetails")
		if err := awsRestjson1_serializeDocumentEnvironmentDetailsIdentifiers(&uv.Value, av); err != nil {
			return err
		}

	case *types.JobEntityIdentifiersUnionMemberJobAttachmentDetails:
		av := object.Key("jobAttachmentDetails")
		if err := awsRestjson1_serializeDocumentJobAttachmentDetailsIdentifiers(&uv.Value, av); err != nil {
			return err
		}

	case *types.JobEntityIdentifiersUnionMemberJobDetails:
		av := object.Key("jobDetails")
		if err := awsRestjson1_serializeDocumentJobDetailsIdentifiers(&uv.Value, av); err != nil {
			return err
		}

	case *types.JobEntityIdentifiersUnionMemberStepDetails:
		av := object.Key("stepDetails")
		if err := awsRestjson1_serializeDocumentStepDetailsIdentifiers(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentJobParameter(v types.JobParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.JobParameterMemberFloat:
		av := object.Key("float")
		av.String(uv.Value)

	case *types.JobParameterMemberInt:
		av := object.Key("int")
		av.String(uv.Value)

	case *types.JobParameterMemberPath:
		av := object.Key("path")
		av.String(uv.Value)

	case *types.JobParameterMemberString:
		av := object.Key("string")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentJobParameters(v map[string]types.JobParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentJobParameter(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentJobRunAsUser(v *types.JobRunAsUser, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Posix != nil {
		ok := object.Key("posix")
		if err := awsRestjson1_serializeDocumentPosixUser(v.Posix, ok); err != nil {
			return err
		}
	}

	if len(v.RunAs) > 0 {
		ok := object.Key("runAs")
		ok.String(string(v.RunAs))
	}

	if v.Windows != nil {
		ok := object.Key("windows")
		if err := awsRestjson1_serializeDocumentWindowsUser(v.Windows, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentManifestProperties(v *types.ManifestProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FileSystemLocationName != nil {
		ok := object.Key("fileSystemLocationName")
		ok.String(*v.FileSystemLocationName)
	}

	if v.InputManifestHash != nil {
		ok := object.Key("inputManifestHash")
		ok.String(*v.InputManifestHash)
	}

	if v.InputManifestPath != nil {
		ok := object.Key("inputManifestPath")
		ok.String(*v.InputManifestPath)
	}

	if v.OutputRelativeDirectories != nil {
		ok := object.Key("outputRelativeDirectories")
		if err := awsRestjson1_serializeDocumentOutputRelativeDirectoriesList(v.OutputRelativeDirectories, ok); err != nil {
			return err
		}
	}

	if v.RootPath != nil {
		ok := object.Key("rootPath")
		ok.String(*v.RootPath)
	}

	if len(v.RootPathFormat) > 0 {
		ok := object.Key("rootPathFormat")
		ok.String(string(v.RootPathFormat))
	}

	return nil
}

func awsRestjson1_serializeDocumentManifestPropertiesList(v []types.ManifestProperties, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentManifestProperties(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMemoryMiBRange(v *types.MemoryMiBRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Max != nil {
		ok := object.Key("max")
		ok.Integer(*v.Max)
	}

	if v.Min != nil {
		ok := object.Key("min")
		ok.Integer(*v.Min)
	}

	return nil
}

func awsRestjson1_serializeDocumentOutputRelativeDirectoriesList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentParameterFilterExpression(v *types.ParameterFilterExpression, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentParameterSortExpression(v *types.ParameterSortExpression, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("sortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentPosixUser(v *types.PosixUser, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Group != nil {
		ok := object.Key("group")
		ok.String(*v.Group)
	}

	if v.User != nil {
		ok := object.Key("user")
		ok.String(*v.User)
	}

	return nil
}

func awsRestjson1_serializeDocumentQueueIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentRequiredFileSystemLocationNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentS3Location(v *types.S3Location, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("bucketName")
		ok.String(*v.BucketName)
	}

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeDocumentSearchFilterExpression(v types.SearchFilterExpression, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.SearchFilterExpressionMemberDateTimeFilter:
		av := object.Key("dateTimeFilter")
		if err := awsRestjson1_serializeDocumentDateTimeFilterExpression(&uv.Value, av); err != nil {
			return err
		}

	case *types.SearchFilterExpressionMemberGroupFilter:
		av := object.Key("groupFilter")
		if err := awsRestjson1_serializeDocumentSearchGroupedFilterExpressions(&uv.Value, av); err != nil {
			return err
		}

	case *types.SearchFilterExpressionMemberParameterFilter:
		av := object.Key("parameterFilter")
		if err := awsRestjson1_serializeDocumentParameterFilterExpression(&uv.Value, av); err != nil {
			return err
		}

	case *types.SearchFilterExpressionMemberSearchTermFilter:
		av := object.Key("searchTermFilter")
		if err := awsRestjson1_serializeDocumentSearchTermFilterExpression(&uv.Value, av); err != nil {
			return err
		}

	case *types.SearchFilterExpressionMemberStringFilter:
		av := object.Key("stringFilter")
		if err := awsRestjson1_serializeDocumentStringFilterExpression(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentSearchFilterExpressions(v []types.SearchFilterExpression, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentSearchFilterExpression(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSearchGroupedFilterExpressions(v *types.SearchGroupedFilterExpressions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentSearchFilterExpressions(v.Filters, ok); err != nil {
			return err
		}
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	return nil
}

func awsRestjson1_serializeDocumentSearchSortExpression(v types.SearchSortExpression, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.SearchSortExpressionMemberFieldSort:
		av := object.Key("fieldSort")
		if err := awsRestjson1_serializeDocumentFieldSortExpression(&uv.Value, av); err != nil {
			return err
		}

	case *types.SearchSortExpressionMemberParameterSort:
		av := object.Key("parameterSort")
		if err := awsRestjson1_serializeDocumentParameterSortExpression(&uv.Value, av); err != nil {
			return err
		}

	case *types.SearchSortExpressionMemberUserJobsFirst:
		av := object.Key("userJobsFirst")
		if err := awsRestjson1_serializeDocumentUserJobsFirst(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentSearchSortExpressions(v []types.SearchSortExpression, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentSearchSortExpression(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSearchTermFilterExpression(v *types.SearchTermFilterExpression, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SearchTerm != nil {
		ok := object.Key("searchTerm")
		ok.String(*v.SearchTerm)
	}

	return nil
}

func awsRestjson1_serializeDocumentSecurityGroupIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentServiceManagedEc2FleetConfiguration(v *types.ServiceManagedEc2FleetConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InstanceCapabilities != nil {
		ok := object.Key("instanceCapabilities")
		if err := awsRestjson1_serializeDocumentServiceManagedEc2InstanceCapabilities(v.InstanceCapabilities, ok); err != nil {
			return err
		}
	}

	if v.InstanceMarketOptions != nil {
		ok := object.Key("instanceMarketOptions")
		if err := awsRestjson1_serializeDocumentServiceManagedEc2InstanceMarketOptions(v.InstanceMarketOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentServiceManagedEc2InstanceCapabilities(v *types.ServiceManagedEc2InstanceCapabilities, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AcceleratorCapabilities != nil {
		ok := object.Key("acceleratorCapabilities")
		if err := awsRestjson1_serializeDocumentAcceleratorCapabilities(v.AcceleratorCapabilities, ok); err != nil {
			return err
		}
	}

	if v.AllowedInstanceTypes != nil {
		ok := object.Key("allowedInstanceTypes")
		if err := awsRestjson1_serializeDocumentInstanceTypes(v.AllowedInstanceTypes, ok); err != nil {
			return err
		}
	}

	if len(v.CpuArchitectureType) > 0 {
		ok := object.Key("cpuArchitectureType")
		ok.String(string(v.CpuArchitectureType))
	}

	if v.CustomAmounts != nil {
		ok := object.Key("customAmounts")
		if err := awsRestjson1_serializeDocumentCustomFleetAmountCapabilities(v.CustomAmounts, ok); err != nil {
			return err
		}
	}

	if v.CustomAttributes != nil {
		ok := object.Key("customAttributes")
		if err := awsRestjson1_serializeDocumentCustomFleetAttributeCapabilities(v.CustomAttributes, ok); err != nil {
			return err
		}
	}

	if v.ExcludedInstanceTypes != nil {
		ok := object.Key("excludedInstanceTypes")
		if err := awsRestjson1_serializeDocumentInstanceTypes(v.ExcludedInstanceTypes, ok); err != nil {
			return err
		}
	}

	if v.MemoryMiB != nil {
		ok := object.Key("memoryMiB")
		if err := awsRestjson1_serializeDocumentMemoryMiBRange(v.MemoryMiB, ok); err != nil {
			return err
		}
	}

	if len(v.OsFamily) > 0 {
		ok := object.Key("osFamily")
		ok.String(string(v.OsFamily))
	}

	if v.RootEbsVolume != nil {
		ok := object.Key("rootEbsVolume")
		if err := awsRestjson1_serializeDocumentEc2EbsVolume(v.RootEbsVolume, ok); err != nil {
			return err
		}
	}

	if v.VCpuCount != nil {
		ok := object.Key("vCpuCount")
		if err := awsRestjson1_serializeDocumentVCpuCountRange(v.VCpuCount, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentServiceManagedEc2InstanceMarketOptions(v *types.ServiceManagedEc2InstanceMarketOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentSessionsStatisticsResources(v types.SessionsStatisticsResources, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.SessionsStatisticsResourcesMemberFleetIds:
		av := object.Key("fleetIds")
		if err := awsRestjson1_serializeDocumentFleetIds(uv.Value, av); err != nil {
			return err
		}

	case *types.SessionsStatisticsResourcesMemberQueueIds:
		av := object.Key("queueIds")
		if err := awsRestjson1_serializeDocumentQueueIds(uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentStepDetailsIdentifiers(v *types.StepDetailsIdentifiers, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("jobId")
		ok.String(*v.JobId)
	}

	if v.StepId != nil {
		ok := object.Key("stepId")
		ok.String(*v.StepId)
	}

	return nil
}

func awsRestjson1_serializeDocumentStringFilterExpression(v *types.StringFilterExpression, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentSubnetIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTags(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentUpdatedSessionActionInfo(v *types.UpdatedSessionActionInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CompletedStatus) > 0 {
		ok := object.Key("completedStatus")
		ok.String(string(v.CompletedStatus))
	}

	if v.EndedAt != nil {
		ok := object.Key("endedAt")
		ok.String(smithytime.FormatDateTime(*v.EndedAt))
	}

	if v.ProcessExitCode != nil {
		ok := object.Key("processExitCode")
		ok.Integer(*v.ProcessExitCode)
	}

	if v.ProgressMessage != nil {
		ok := object.Key("progressMessage")
		ok.String(*v.ProgressMessage)
	}

	if v.ProgressPercent != nil {
		ok := object.Key("progressPercent")
		switch {
		case math.IsNaN(float64(*v.ProgressPercent)):
			ok.String("NaN")

		case math.IsInf(float64(*v.ProgressPercent), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.ProgressPercent), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.ProgressPercent)

		}
	}

	if v.StartedAt != nil {
		ok := object.Key("startedAt")
		ok.String(smithytime.FormatDateTime(*v.StartedAt))
	}

	if v.UpdatedAt != nil {
		ok := object.Key("updatedAt")
		ok.String(smithytime.FormatDateTime(*v.UpdatedAt))
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdatedSessionActions(v map[string]types.UpdatedSessionActionInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentUpdatedSessionActionInfo(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentUsageGroupBy(v []types.UsageGroupByField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentUsageStatistics(v []types.UsageStatistic, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentUsageTrackingResource(v types.UsageTrackingResource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.UsageTrackingResourceMemberQueueId:
		av := object.Key("queueId")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentUserJobsFirst(v *types.UserJobsFirst, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UserIdentityId != nil {
		ok := object.Key("userIdentityId")
		ok.String(*v.UserIdentityId)
	}

	return nil
}

func awsRestjson1_serializeDocumentVCpuCountRange(v *types.VCpuCountRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Max != nil {
		ok := object.Key("max")
		ok.Integer(*v.Max)
	}

	if v.Min != nil {
		ok := object.Key("min")
		ok.Integer(*v.Min)
	}

	return nil
}

func awsRestjson1_serializeDocumentWindowsUser(v *types.WindowsUser, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PasswordArn != nil {
		ok := object.Key("passwordArn")
		ok.String(*v.PasswordArn)
	}

	if v.User != nil {
		ok := object.Key("user")
		ok.String(*v.User)
	}

	return nil
}

func awsRestjson1_serializeDocumentWorkerAmountCapability(v *types.WorkerAmountCapability, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("value")
		switch {
		case math.IsNaN(float64(*v.Value)):
			ok.String("NaN")

		case math.IsInf(float64(*v.Value), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.Value), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.Value)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWorkerAmountCapabilityList(v []types.WorkerAmountCapability, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentWorkerAmountCapability(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentWorkerAttributeCapability(v *types.WorkerAttributeCapability, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentAttributeCapabilityValuesList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWorkerAttributeCapabilityList(v []types.WorkerAttributeCapability, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentWorkerAttributeCapability(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentWorkerCapabilities(v *types.WorkerCapabilities, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Amounts != nil {
		ok := object.Key("amounts")
		if err := awsRestjson1_serializeDocumentWorkerAmountCapabilityList(v.Amounts, ok); err != nil {
			return err
		}
	}

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsRestjson1_serializeDocumentWorkerAttributeCapabilityList(v.Attributes, ok); err != nil {
			return err
		}
	}

	return nil
}
