// Code generated by smithy-go-codegen DO NOT EDIT.

package detective

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/detective/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets the indicators from an investigation. You can use the information from the
// indicators to determine if an IAM user and/or IAM role is involved in an unusual
// activity that could indicate malicious behavior and its impact.
func (c *Client) ListIndicators(ctx context.Context, params *ListIndicatorsInput, optFns ...func(*Options)) (*ListIndicatorsOutput, error) {
	if params == nil {
		params = &ListIndicatorsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListIndicators", params, optFns, c.addOperationListIndicatorsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListIndicatorsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListIndicatorsInput struct {

	// The Amazon Resource Name (ARN) of the behavior graph.
	//
	// This member is required.
	GraphArn *string

	// The investigation ID of the investigation report.
	//
	// This member is required.
	InvestigationId *string

	// For the list of indicators of compromise that are generated by Detective
	// investigations, see [Detective investigations].
	//
	// [Detective investigations]: https://docs.aws.amazon.com/detective/latest/userguide/detective-investigation-about.html
	IndicatorType types.IndicatorType

	// Lists the maximum number of indicators in a page.
	MaxResults *int32

	// Lists if there are more results available. The value of nextToken is a unique
	// pagination token for each page. Repeat the call using the returned token to
	// retrieve the next page. Keep all other arguments unchanged.
	//
	// Each pagination token expires after 24 hours. Using an expired pagination token
	// will return a Validation Exception error.
	NextToken *string

	noSmithyDocumentSerde
}

type ListIndicatorsOutput struct {

	// The Amazon Resource Name (ARN) of the behavior graph.
	GraphArn *string

	// Lists the indicators of compromise.
	Indicators []types.Indicator

	// The investigation ID of the investigation report.
	InvestigationId *string

	// Lists if there are more results available. The value of nextToken is a unique
	// pagination token for each page. Repeat the call using the returned token to
	// retrieve the next page. Keep all other arguments unchanged.
	//
	// Each pagination token expires after 24 hours. Using an expired pagination token
	// will return a Validation Exception error.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListIndicatorsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListIndicators{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListIndicators{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListIndicators"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListIndicatorsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListIndicators(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opListIndicators(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListIndicators",
	}
}
