// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A container for account-level settings in AWS Device Farm.
type AccountSettings struct {

	// The AWS account number specified in the AccountSettings container.
	AwsAccountNumber *string

	// The default number of minutes (at the account level) a test run executes before
	// it times out. The default value is 150 minutes.
	DefaultJobTimeoutMinutes *int32

	// The maximum number of minutes a test run executes before it times out.
	MaxJobTimeoutMinutes *int32

	// The maximum number of device slots that the AWS account can purchase. Each
	// maximum is expressed as an offering-id:number pair, where the offering-id
	// represents one of the IDs returned by the ListOfferings command.
	MaxSlots map[string]int32

	// When set to true , for private devices, Device Farm does not sign your app
	// again. For public devices, Device Farm always signs your apps again.
	//
	// For more information about how Device Farm re-signs your apps, see [Do you modify my app?] in the AWS
	// Device Farm FAQs.
	//
	// [Do you modify my app?]: http://aws.amazon.com/device-farm/faqs/
	SkipAppResign *bool

	// Information about an AWS account's usage of free trial device minutes.
	TrialMinutes *TrialMinutes

	// Returns the unmetered devices you have purchased or want to purchase.
	UnmeteredDevices map[string]int32

	// Returns the unmetered remote access devices you have purchased or want to
	// purchase.
	UnmeteredRemoteAccessDevices map[string]int32

	noSmithyDocumentSerde
}

// Represents the output of a test. Examples of artifacts include logs and
// screenshots.
type Artifact struct {

	// The artifact's ARN.
	Arn *string

	// The artifact's file extension.
	Extension *string

	// The artifact's name.
	Name *string

	// The artifact's type.
	//
	// Allowed values include the following:
	//
	//   - UNKNOWN
	//
	//   - SCREENSHOT
	//
	//   - DEVICE_LOG
	//
	//   - MESSAGE_LOG
	//
	//   - VIDEO_LOG
	//
	//   - RESULT_LOG
	//
	//   - SERVICE_LOG
	//
	//   - WEBKIT_LOG
	//
	//   - INSTRUMENTATION_OUTPUT
	//
	//   - EXERCISER_MONKEY_OUTPUT: the artifact (log) generated by an Android fuzz
	//   test.
	//
	//   - APPIUM_SERVER_OUTPUT
	//
	//   - APPIUM_JAVA_OUTPUT
	//
	//   - APPIUM_JAVA_XML_OUTPUT
	//
	//   - APPIUM_PYTHON_OUTPUT
	//
	//   - APPIUM_PYTHON_XML_OUTPUT
	//
	//   - APPLICATION_CRASH_REPORT
	//
	//   - XCTEST_LOG
	//
	//   - VIDEO
	//
	//   - CUSTOMER_ARTIFACT
	//
	//   - CUSTOMER_ARTIFACT_LOG
	//
	//   - TESTSPEC_OUTPUT
	Type ArtifactType

	// The presigned Amazon S3 URL that can be used with a GET request to download the
	// artifact's file.
	Url *string

	noSmithyDocumentSerde
}

// Represents entity counters.
type Counters struct {

	// The number of errored entities.
	Errored *int32

	// The number of failed entities.
	Failed *int32

	// The number of passed entities.
	Passed *int32

	// The number of skipped entities.
	Skipped *int32

	// The number of stopped entities.
	Stopped *int32

	// The total number of entities.
	Total *int32

	// The number of warned entities.
	Warned *int32

	noSmithyDocumentSerde
}

// Represents the amount of CPU that an app is using on a physical device. Does
// not represent system-wide CPU usage.
type CPU struct {

	// The CPU's architecture (for example, x86 or ARM).
	Architecture *string

	// The clock speed of the device's CPU, expressed in hertz (Hz). For example, a
	// 1.2 GHz CPU is expressed as 1200000000.
	Clock *float64

	// The CPU's frequency.
	Frequency *string

	noSmithyDocumentSerde
}

// Configuration settings for a remote access session, including billing method.
type CreateRemoteAccessSessionConfiguration struct {

	// The billing method for the remote access session.
	BillingMethod BillingMethod

	// An array of ARNs included in the VPC endpoint configuration.
	VpceConfigurationArns []string

	noSmithyDocumentSerde
}

// A JSON object that specifies the paths where the artifacts generated by the
// customer's tests, on the device or in the test environment, are pulled from.
//
// Specify deviceHostPaths and optionally specify either iosPaths or androidPaths .
//
// For web app tests, you can specify both iosPaths and androidPaths .
type CustomerArtifactPaths struct {

	// Comma-separated list of paths on the Android device where the artifacts
	// generated by the customer's tests are pulled from.
	AndroidPaths []string

	// Comma-separated list of paths in the test execution environment where the
	// artifacts generated by the customer's tests are pulled from.
	DeviceHostPaths []string

	// Comma-separated list of paths on the iOS device where the artifacts generated
	// by the customer's tests are pulled from.
	IosPaths []string

	noSmithyDocumentSerde
}

// Represents a device type that an app is tested against.
type Device struct {

	// The device's ARN.
	Arn *string

	// Indicates how likely a device is available for a test run. Currently available
	// in the ListDevicesand GetDevice API methods.
	Availability DeviceAvailability

	// The device's carrier.
	Carrier *string

	// Information about the device's CPU.
	Cpu *CPU

	// The name of the fleet to which this device belongs.
	FleetName *string

	// The type of fleet to which this device belongs. Possible values are PRIVATE and
	// PUBLIC.
	FleetType *string

	// The device's form factor.
	//
	// Allowed values include:
	//
	//   - PHONE
	//
	//   - TABLET
	FormFactor DeviceFormFactor

	// The device's heap size, expressed in bytes.
	HeapSize *int64

	// The device's image name.
	Image *string

	// The instances that belong to this device.
	Instances []DeviceInstance

	// The device's manufacturer name.
	Manufacturer *string

	// The device's total memory size, expressed in bytes.
	Memory *int64

	// The device's model name.
	Model *string

	// The device's model ID.
	ModelId *string

	// The device's display name.
	Name *string

	// The device's operating system type.
	Os *string

	// The device's platform.
	//
	// Allowed values include:
	//
	//   - ANDROID
	//
	//   - IOS
	Platform DevicePlatform

	// The device's radio.
	Radio *string

	// Specifies whether remote access has been enabled for the specified device.
	RemoteAccessEnabled *bool

	// This flag is set to true if remote debugging is enabled for the device.
	//
	// Remote debugging is [no longer supported].
	//
	// [no longer supported]: https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html
	RemoteDebugEnabled *bool

	// The resolution of the device.
	Resolution *Resolution

	noSmithyDocumentSerde
}

// Represents a device filter used to select a set of devices to be included in a
// test run. This data structure is passed in as the deviceSelectionConfiguration
// parameter to ScheduleRun . For an example of the JSON request syntax, see ScheduleRun.
//
// It is also passed in as the filters parameter to ListDevices . For an example of
// the JSON request syntax, see ListDevices.
type DeviceFilter struct {

	// The aspect of a device such as platform or model used as the selection criteria
	// in a device filter.
	//
	// The supported operators for each attribute are provided in the following list.
	//
	// ARN The Amazon Resource Name (ARN) of the device (for example,
	// arn:aws:devicefarm:us-west-2::device:12345Example ).
	//
	// Supported operators: EQUALS , IN , NOT_IN
	//
	// PLATFORM The device platform. Valid values are ANDROID or IOS.
	//
	// Supported operators: EQUALS
	//
	// OS_VERSION The operating system version (for example, 10.3.2).
	//
	// Supported operators: EQUALS , GREATER_THAN , GREATER_THAN_OR_EQUALS , IN ,
	// LESS_THAN , LESS_THAN_OR_EQUALS , NOT_IN
	//
	// MODEL The device model (for example, iPad 5th Gen).
	//
	// Supported operators: CONTAINS , EQUALS , IN , NOT_IN
	//
	// AVAILABILITY The current availability of the device. Valid values are
	// AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.
	//
	// Supported operators: EQUALS
	//
	// FORM_FACTOR The device form factor. Valid values are PHONE or TABLET.
	//
	// Supported operators: EQUALS
	//
	// MANUFACTURER The device manufacturer (for example, Apple).
	//
	// Supported operators: EQUALS , IN , NOT_IN
	//
	// REMOTE_ACCESS_ENABLED Whether the device is enabled for remote access. Valid
	// values are TRUE or FALSE.
	//
	// Supported operators: EQUALS
	//
	// REMOTE_DEBUG_ENABLED Whether the device is enabled for remote debugging. Valid
	// values are TRUE or FALSE.
	//
	// Supported operators: EQUALS
	//
	// Because remote debugging is [no longer supported], this filter is ignored.
	//
	// INSTANCE_ARN The Amazon Resource Name (ARN) of the device instance.
	//
	// Supported operators: EQUALS , IN , NOT_IN
	//
	// INSTANCE_LABELS The label of the device instance.
	//
	// Supported operators: CONTAINS
	//
	// FLEET_TYPE The fleet type. Valid values are PUBLIC or PRIVATE.
	//
	// Supported operators: EQUALS
	//
	// [no longer supported]: https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html
	//
	// This member is required.
	Attribute DeviceFilterAttribute

	// Specifies how Device Farm compares the filter's attribute to the value. See the
	// attribute descriptions.
	//
	// This member is required.
	Operator RuleOperator

	// An array of one or more filter values used in a device filter.
	//
	// Operator Values
	//
	//   - The IN and NOT_IN operators can take a values array that has more than one
	//   element.
	//
	//   - The other operators require an array with a single element.
	//
	// Attribute Values
	//
	//   - The PLATFORM attribute can be set to ANDROID or IOS.
	//
	//   - The AVAILABILITY attribute can be set to AVAILABLE, HIGHLY_AVAILABLE, BUSY,
	//   or TEMPORARY_NOT_AVAILABLE.
	//
	//   - The FORM_FACTOR attribute can be set to PHONE or TABLET.
	//
	//   - The FLEET_TYPE attribute can be set to PUBLIC or PRIVATE.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Represents the device instance.
type DeviceInstance struct {

	// The Amazon Resource Name (ARN) of the device instance.
	Arn *string

	// The ARN of the device.
	DeviceArn *string

	// A object that contains information about the instance profile.
	InstanceProfile *InstanceProfile

	// An array of strings that describe the device instance.
	Labels []string

	// The status of the device instance. Valid values are listed here.
	Status InstanceStatus

	// Unique device identifier for the device instance.
	Udid *string

	noSmithyDocumentSerde
}

// Represents the total (metered or unmetered) minutes used by the resource to run
// tests. Contains the sum of minutes consumed by all children.
type DeviceMinutes struct {

	// When specified, represents only the sum of metered minutes used by the resource
	// to run tests.
	Metered *float64

	// When specified, represents the total minutes used by the resource to run tests.
	Total *float64

	// When specified, represents only the sum of unmetered minutes used by the
	// resource to run tests.
	Unmetered *float64

	noSmithyDocumentSerde
}

// Represents a collection of device types.
type DevicePool struct {

	// The device pool's ARN.
	Arn *string

	// The device pool's description.
	Description *string

	// The number of devices that Device Farm can add to your device pool. Device Farm
	// adds devices that are available and meet the criteria that you assign for the
	// rules parameter. Depending on how many devices meet these constraints, your
	// device pool might contain fewer devices than the value for this parameter.
	//
	// By specifying the maximum number of devices, you can control the costs that you
	// incur by running tests.
	MaxDevices *int32

	// The device pool's name.
	Name *string

	// Information about the device pool's rules.
	Rules []Rule

	// The device pool's type.
	//
	// Allowed values include:
	//
	//   - CURATED: A device pool that is created and managed by AWS Device Farm.
	//
	//   - PRIVATE: A device pool that is created and managed by the device pool
	//   developer.
	Type DevicePoolType

	noSmithyDocumentSerde
}

// Represents a device pool compatibility result.
type DevicePoolCompatibilityResult struct {

	// Whether the result was compatible with the device pool.
	Compatible *bool

	// The device (phone or tablet) to return information about.
	Device *Device

	// Information about the compatibility.
	IncompatibilityMessages []IncompatibilityMessage

	noSmithyDocumentSerde
}

// Represents the device filters used in a test run and the maximum number of
// devices to be included in the run. It is passed in as the
// deviceSelectionConfiguration request parameter in ScheduleRun.
type DeviceSelectionConfiguration struct {

	// Used to dynamically select a set of devices for a test run. A filter is made up
	// of an attribute, an operator, and one or more values.
	//
	//   - Attribute
	//
	// The aspect of a device such as platform or model used as the selection criteria
	//   in a device filter.
	//
	// Allowed values include:
	//
	//   - ARN: The Amazon Resource Name (ARN) of the device (for example,
	//   arn:aws:devicefarm:us-west-2::device:12345Example ).
	//
	//   - PLATFORM: The device platform. Valid values are ANDROID or IOS.
	//
	//   - OS_VERSION: The operating system version (for example, 10.3.2).
	//
	//   - MODEL: The device model (for example, iPad 5th Gen).
	//
	//   - AVAILABILITY: The current availability of the device. Valid values are
	//   AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.
	//
	//   - FORM_FACTOR: The device form factor. Valid values are PHONE or TABLET.
	//
	//   - MANUFACTURER: The device manufacturer (for example, Apple).
	//
	//   - REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
	//   Valid values are TRUE or FALSE.
	//
	//   - REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging.
	//   Valid values are TRUE or FALSE. Because remote debugging is [no longer supported], this filter is
	//   ignored.
	//
	//   - INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.
	//
	//   - INSTANCE_LABELS: The label of the device instance.
	//
	//   - FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.
	//
	//   - Operator
	//
	// The filter operator.
	//
	//   - The EQUALS operator is available for every attribute except INSTANCE_LABELS.
	//
	//   - The CONTAINS operator is available for the INSTANCE_LABELS and MODEL
	//   attributes.
	//
	//   - The IN and NOT_IN operators are available for the ARN, OS_VERSION, MODEL,
	//   MANUFACTURER, and INSTANCE_ARN attributes.
	//
	//   - The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and
	//   GREATER_THAN_OR_EQUALS operators are also available for the OS_VERSION
	//   attribute.
	//
	//   - Values
	//
	// An array of one or more filter values.
	//
	// Operator Values
	//
	//   - The IN and NOT_IN operators can take a values array that has more than one
	//   element.
	//
	//   - The other operators require an array with a single element.
	//
	// Attribute Values
	//
	//   - The PLATFORM attribute can be set to ANDROID or IOS.
	//
	//   - The AVAILABILITY attribute can be set to AVAILABLE, HIGHLY_AVAILABLE, BUSY,
	//   or TEMPORARY_NOT_AVAILABLE.
	//
	//   - The FORM_FACTOR attribute can be set to PHONE or TABLET.
	//
	//   - The FLEET_TYPE attribute can be set to PUBLIC or PRIVATE.
	//
	// [no longer supported]: https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html
	//
	// This member is required.
	Filters []DeviceFilter

	// The maximum number of devices to be included in a test run.
	//
	// This member is required.
	MaxDevices *int32

	noSmithyDocumentSerde
}

// Contains the run results requested by the device selection configuration and
// how many devices were returned. For an example of the JSON response syntax, see ScheduleRun
// .
type DeviceSelectionResult struct {

	// The filters in a device selection result.
	Filters []DeviceFilter

	// The number of devices that matched the device filter selection criteria.
	MatchedDevicesCount *int32

	// The maximum number of devices to be selected by a device filter and included in
	// a test run.
	MaxDevices *int32

	noSmithyDocumentSerde
}

// Represents configuration information about a test run, such as the execution
// timeout (in minutes).
type ExecutionConfiguration struct {

	// True if account cleanup is enabled at the beginning of the test. Otherwise,
	// false.
	AccountsCleanup *bool

	// True if app package cleanup is enabled at the beginning of the test. Otherwise,
	// false.
	AppPackagesCleanup *bool

	// The number of minutes a test run executes before it times out.
	JobTimeoutMinutes *int32

	// When set to true , for private devices, Device Farm does not sign your app
	// again. For public devices, Device Farm always signs your apps again.
	//
	// For more information about how Device Farm re-signs your apps, see [Do you modify my app?] in the AWS
	// Device Farm FAQs.
	//
	// [Do you modify my app?]: http://aws.amazon.com/device-farm/faqs/
	SkipAppResign *bool

	// Set to true to enable video capture. Otherwise, set to false. The default is
	// true.
	VideoCapture *bool

	noSmithyDocumentSerde
}

// Represents information about incompatibility.
type IncompatibilityMessage struct {

	// A message about the incompatibility.
	Message *string

	// The type of incompatibility.
	//
	// Allowed values include:
	//
	//   - ARN
	//
	//   - FORM_FACTOR (for example, phone or tablet)
	//
	//   - MANUFACTURER
	//
	//   - PLATFORM (for example, Android or iOS)
	//
	//   - REMOTE_ACCESS_ENABLED
	//
	//   - APPIUM_VERSION
	Type DeviceAttribute

	noSmithyDocumentSerde
}

// Represents the instance profile.
type InstanceProfile struct {

	// The Amazon Resource Name (ARN) of the instance profile.
	Arn *string

	// The description of the instance profile.
	Description *string

	// An array of strings containing the list of app packages that should not be
	// cleaned up from the device after a test run completes.
	//
	// The list of packages is considered only if you set packageCleanup to true .
	ExcludeAppPackagesFromCleanup []string

	// The name of the instance profile.
	Name *string

	// When set to true , Device Farm removes app packages after a test run. The
	// default value is false for private devices.
	PackageCleanup *bool

	// When set to true , Device Farm reboots the instance after a test run. The
	// default value is true .
	RebootAfterUse *bool

	noSmithyDocumentSerde
}

// Represents a device.
type Job struct {

	// The job's ARN.
	Arn *string

	// The job's result counters.
	Counters *Counters

	// When the job was created.
	Created *time.Time

	// The device (phone or tablet).
	Device *Device

	// Represents the total (metered or unmetered) minutes used by the job.
	DeviceMinutes *DeviceMinutes

	// The ARN of the instance.
	InstanceArn *string

	// A message about the job's result.
	Message *string

	// The job's name.
	Name *string

	// The job's result.
	//
	// Allowed values include:
	//
	//   - PENDING
	//
	//   - PASSED
	//
	//   - WARNED
	//
	//   - FAILED
	//
	//   - SKIPPED
	//
	//   - ERRORED
	//
	//   - STOPPED
	Result ExecutionResult

	// The job's start time.
	Started *time.Time

	// The job's status.
	//
	// Allowed values include:
	//
	//   - PENDING
	//
	//   - PENDING_CONCURRENCY
	//
	//   - PENDING_DEVICE
	//
	//   - PROCESSING
	//
	//   - SCHEDULING
	//
	//   - PREPARING
	//
	//   - RUNNING
	//
	//   - COMPLETED
	//
	//   - STOPPING
	Status ExecutionStatus

	// The job's stop time.
	Stopped *time.Time

	// The job's type.
	//
	// Allowed values include the following:
	//
	//   - BUILTIN_FUZZ
	//
	//   - APPIUM_JAVA_JUNIT
	//
	//   - APPIUM_JAVA_TESTNG
	//
	//   - APPIUM_PYTHON
	//
	//   - APPIUM_NODE
	//
	//   - APPIUM_RUBY
	//
	//   - APPIUM_WEB_JAVA_JUNIT
	//
	//   - APPIUM_WEB_JAVA_TESTNG
	//
	//   - APPIUM_WEB_PYTHON
	//
	//   - APPIUM_WEB_NODE
	//
	//   - APPIUM_WEB_RUBY
	//
	//   - INSTRUMENTATION
	//
	//   - XCTEST
	//
	//   - XCTEST_UI
	Type TestType

	// This value is set to true if video capture is enabled. Otherwise, it is set to
	// false.
	VideoCapture *bool

	// The endpoint for streaming device video.
	VideoEndpoint *string

	noSmithyDocumentSerde
}

// Represents a latitude and longitude pair, expressed in geographic coordinate
// system degrees (for example, 47.6204, -122.3491).
//
// Elevation is currently not supported.
type Location struct {

	// The latitude.
	//
	// This member is required.
	Latitude *float64

	// The longitude.
	//
	// This member is required.
	Longitude *float64

	noSmithyDocumentSerde
}

// A number that represents the monetary amount for an offering or transaction.
type MonetaryAmount struct {

	// The numerical amount of an offering or transaction.
	Amount *float64

	// The currency code of a monetary amount. For example, USD means U.S. dollars.
	CurrencyCode CurrencyCode

	noSmithyDocumentSerde
}

// An array of settings that describes characteristics of a network profile.
type NetworkProfile struct {

	// The Amazon Resource Name (ARN) of the network profile.
	Arn *string

	// The description of the network profile.
	Description *string

	// The data throughput rate in bits per second, as an integer from 0 to 104857600.
	DownlinkBandwidthBits *int64

	// Delay time for all packets to destination in milliseconds as an integer from 0
	// to 2000.
	DownlinkDelayMs *int64

	// Time variation in the delay of received packets in milliseconds as an integer
	// from 0 to 2000.
	DownlinkJitterMs *int64

	// Proportion of received packets that fail to arrive from 0 to 100 percent.
	DownlinkLossPercent int32

	// The name of the network profile.
	Name *string

	// The type of network profile. Valid values are listed here.
	Type NetworkProfileType

	// The data throughput rate in bits per second, as an integer from 0 to 104857600.
	UplinkBandwidthBits *int64

	// Delay time for all packets to destination in milliseconds as an integer from 0
	// to 2000.
	UplinkDelayMs *int64

	// Time variation in the delay of received packets in milliseconds as an integer
	// from 0 to 2000.
	UplinkJitterMs *int64

	// Proportion of transmitted packets that fail to arrive from 0 to 100 percent.
	UplinkLossPercent int32

	noSmithyDocumentSerde
}

// Represents the metadata of a device offering.
type Offering struct {

	// A string that describes the offering.
	Description *string

	// The ID that corresponds to a device offering.
	Id *string

	// The platform of the device (for example, ANDROID or IOS ).
	Platform DevicePlatform

	// Specifies whether there are recurring charges for the offering.
	RecurringCharges []RecurringCharge

	// The type of offering (for example, RECURRING ) for a device.
	Type OfferingType

	noSmithyDocumentSerde
}

// Represents information about an offering promotion.
type OfferingPromotion struct {

	// A string that describes the offering promotion.
	Description *string

	// The ID of the offering promotion.
	Id *string

	noSmithyDocumentSerde
}

// The status of the offering.
type OfferingStatus struct {

	// The date on which the offering is effective.
	EffectiveOn *time.Time

	// Represents the metadata of an offering status.
	Offering *Offering

	// The number of available devices in the offering.
	Quantity *int32

	// The type specified for the offering status.
	Type OfferingTransactionType

	noSmithyDocumentSerde
}

// Represents the metadata of an offering transaction.
type OfferingTransaction struct {

	// The cost of an offering transaction.
	Cost *MonetaryAmount

	// The date on which an offering transaction was created.
	CreatedOn *time.Time

	// The ID that corresponds to a device offering promotion.
	OfferingPromotionId *string

	// The status of an offering transaction.
	OfferingStatus *OfferingStatus

	// The transaction ID of the offering transaction.
	TransactionId *string

	noSmithyDocumentSerde
}

// Represents a specific warning or failure.
type Problem struct {

	// Information about the associated device.
	Device *Device

	// Information about the associated job.
	Job *ProblemDetail

	// A message about the problem's result.
	Message *string

	// The problem's result.
	//
	// Allowed values include:
	//
	//   - PENDING
	//
	//   - PASSED
	//
	//   - WARNED
	//
	//   - FAILED
	//
	//   - SKIPPED
	//
	//   - ERRORED
	//
	//   - STOPPED
	Result ExecutionResult

	// Information about the associated run.
	Run *ProblemDetail

	// Information about the associated suite.
	Suite *ProblemDetail

	// Information about the associated test.
	Test *ProblemDetail

	noSmithyDocumentSerde
}

// Information about a problem detail.
type ProblemDetail struct {

	// The problem detail's ARN.
	Arn *string

	// The problem detail's name.
	Name *string

	noSmithyDocumentSerde
}

// Represents an operating-system neutral workspace for running and managing tests.
type Project struct {

	// The project's ARN.
	Arn *string

	// When the project was created.
	Created *time.Time

	// The default number of minutes (at the project level) a test run executes before
	// it times out. The default value is 150 minutes.
	DefaultJobTimeoutMinutes *int32

	// The project's name.
	Name *string

	// The VPC security groups and subnets that are attached to a project.
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// Represents the set of radios and their states on a device. Examples of radios
// include Wi-Fi, GPS, Bluetooth, and NFC.
type Radios struct {

	// True if Bluetooth is enabled at the beginning of the test. Otherwise, false.
	Bluetooth *bool

	// True if GPS is enabled at the beginning of the test. Otherwise, false.
	Gps *bool

	// True if NFC is enabled at the beginning of the test. Otherwise, false.
	Nfc *bool

	// True if Wi-Fi is enabled at the beginning of the test. Otherwise, false.
	Wifi *bool

	noSmithyDocumentSerde
}

// Specifies whether charges for devices are recurring.
type RecurringCharge struct {

	// The cost of the recurring charge.
	Cost *MonetaryAmount

	// The frequency in which charges recur.
	Frequency RecurringChargeFrequency

	noSmithyDocumentSerde
}

// Represents information about the remote access session.
type RemoteAccessSession struct {

	// The Amazon Resource Name (ARN) of the remote access session.
	Arn *string

	// The billing method of the remote access session. Possible values include METERED
	// or UNMETERED . For more information about metered devices, see [AWS Device Farm terminology].
	//
	// [AWS Device Farm terminology]: https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology
	BillingMethod BillingMethod

	// Unique identifier of your client for the remote access session. Only returned
	// if remote debugging is enabled for the remote access session.
	//
	// Remote debugging is [no longer supported].
	//
	// [no longer supported]: https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html
	ClientId *string

	// The date and time the remote access session was created.
	Created *time.Time

	// The device (phone or tablet) used in the remote access session.
	Device *Device

	// The number of minutes a device is used in a remote access session (including
	// setup and teardown minutes).
	DeviceMinutes *DeviceMinutes

	// Unique device identifier for the remote device. Only returned if remote
	// debugging is enabled for the remote access session.
	//
	// Remote debugging is [no longer supported].
	//
	// [no longer supported]: https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html
	DeviceUdid *string

	// The endpoint for the remote access sesssion.
	Endpoint *string

	// IP address of the EC2 host where you need to connect to remotely debug devices.
	// Only returned if remote debugging is enabled for the remote access session.
	//
	// Remote debugging is [no longer supported].
	//
	// [no longer supported]: https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html
	HostAddress *string

	// The ARN of the instance.
	InstanceArn *string

	// The interaction mode of the remote access session. Valid values are:
	//
	//   - INTERACTIVE: You can interact with the iOS device by viewing, touching, and
	//   rotating the screen. You cannot run XCUITest framework-based tests in this mode.
	//
	//   - NO_VIDEO: You are connected to the device, but cannot interact with it or
	//   view the screen. This mode has the fastest test execution speed. You can run
	//   XCUITest framework-based tests in this mode.
	//
	//   - VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can
	//   run XCUITest framework-based tests and watch the screen in this mode.
	InteractionMode InteractionMode

	// A message about the remote access session.
	Message *string

	// The name of the remote access session.
	Name *string

	// This flag is set to true if remote debugging is enabled for the remote access
	// session.
	//
	// Remote debugging is [no longer supported].
	//
	// [no longer supported]: https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html
	RemoteDebugEnabled *bool

	// The ARN for the app to be recorded in the remote access session.
	RemoteRecordAppArn *string

	// This flag is set to true if remote recording is enabled for the remote access
	// session.
	RemoteRecordEnabled *bool

	// The result of the remote access session. Can be any of the following:
	//
	//   - PENDING.
	//
	//   - PASSED.
	//
	//   - WARNED.
	//
	//   - FAILED.
	//
	//   - SKIPPED.
	//
	//   - ERRORED.
	//
	//   - STOPPED.
	Result ExecutionResult

	// When set to true , for private devices, Device Farm does not sign your app
	// again. For public devices, Device Farm always signs your apps again.
	//
	// For more information about how Device Farm re-signs your apps, see [Do you modify my app?] in the AWS
	// Device Farm FAQs.
	//
	// [Do you modify my app?]: http://aws.amazon.com/device-farm/faqs/
	SkipAppResign *bool

	// The date and time the remote access session was started.
	Started *time.Time

	// The status of the remote access session. Can be any of the following:
	//
	//   - PENDING.
	//
	//   - PENDING_CONCURRENCY.
	//
	//   - PENDING_DEVICE.
	//
	//   - PROCESSING.
	//
	//   - SCHEDULING.
	//
	//   - PREPARING.
	//
	//   - RUNNING.
	//
	//   - COMPLETED.
	//
	//   - STOPPING.
	Status ExecutionStatus

	// The date and time the remote access session was stopped.
	Stopped *time.Time

	// The VPC security groups and subnets that are attached to a project.
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// Represents the screen resolution of a device in height and width, expressed in
// pixels.
type Resolution struct {

	// The screen resolution's height, expressed in pixels.
	Height *int32

	// The screen resolution's width, expressed in pixels.
	Width *int32

	noSmithyDocumentSerde
}

// Represents a condition for a device pool.
type Rule struct {

	// The rule's stringified attribute. For example, specify the value as "\"abc\"" .
	//
	// The supported operators for each attribute are provided in the following list.
	//
	// APPIUM_VERSION The Appium version for the test.
	//
	// Supported operators: CONTAINS
	//
	// ARN The Amazon Resource Name (ARN) of the device (for example,
	// arn:aws:devicefarm:us-west-2::device:12345Example .
	//
	// Supported operators: EQUALS , IN , NOT_IN
	//
	// AVAILABILITY The current availability of the device. Valid values are
	// AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.
	//
	// Supported operators: EQUALS
	//
	// FLEET_TYPE The fleet type. Valid values are PUBLIC or PRIVATE.
	//
	// Supported operators: EQUALS
	//
	// FORM_FACTOR The device form factor. Valid values are PHONE or TABLET.
	//
	// Supported operators: EQUALS , IN , NOT_IN
	//
	// INSTANCE_ARN The Amazon Resource Name (ARN) of the device instance.
	//
	// Supported operators: IN , NOT_IN
	//
	// INSTANCE_LABELS The label of the device instance.
	//
	// Supported operators: CONTAINS
	//
	// MANUFACTURER The device manufacturer (for example, Apple).
	//
	// Supported operators: EQUALS , IN , NOT_IN
	//
	// MODEL The device model, such as Apple iPad Air 2 or Google Pixel.
	//
	// Supported operators: CONTAINS , EQUALS , IN , NOT_IN
	//
	// OS_VERSION The operating system version (for example, 10.3.2).
	//
	// Supported operators: EQUALS , GREATER_THAN , GREATER_THAN_OR_EQUALS , IN ,
	// LESS_THAN , LESS_THAN_OR_EQUALS , NOT_IN
	//
	// PLATFORM The device platform. Valid values are ANDROID or IOS.
	//
	// Supported operators: EQUALS , IN , NOT_IN
	//
	// REMOTE_ACCESS_ENABLED Whether the device is enabled for remote access. Valid
	// values are TRUE or FALSE.
	//
	// Supported operators: EQUALS
	//
	// REMOTE_DEBUG_ENABLED Whether the device is enabled for remote debugging. Valid
	// values are TRUE or FALSE.
	//
	// Supported operators: EQUALS
	//
	// Because remote debugging is [no longer supported], this filter is ignored.
	//
	// [no longer supported]: https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html
	Attribute DeviceAttribute

	// Specifies how Device Farm compares the rule's attribute to the value. For the
	// operators that are supported by each attribute, see the attribute descriptions.
	Operator RuleOperator

	// The rule's value.
	Value *string

	noSmithyDocumentSerde
}

// Represents a test run on a set of devices with a given app package, test
// parameters, and so on.
type Run struct {

	// An app to upload or that has been uploaded.
	AppUpload *string

	// The run's ARN.
	Arn *string

	// Specifies the billing method for a test run: metered or unmetered . If the
	// parameter is not specified, the default value is metered .
	//
	// If you have unmetered device slots, you must set this to unmetered to use them.
	// Otherwise, the run is counted toward metered device minutes.
	BillingMethod BillingMethod

	// The total number of completed jobs.
	CompletedJobs *int32

	// The run's result counters.
	Counters *Counters

	// When the run was created.
	Created *time.Time

	// Output CustomerArtifactPaths object for the test run.
	CustomerArtifactPaths *CustomerArtifactPaths

	// Represents the total (metered or unmetered) minutes used by the test run.
	DeviceMinutes *DeviceMinutes

	// The ARN of the device pool for the run.
	DevicePoolArn *string

	// The results of a device filter used to select the devices for a test run.
	DeviceSelectionResult *DeviceSelectionResult

	// For fuzz tests, this is the number of events, between 1 and 10000, that the UI
	// fuzz test should perform.
	EventCount *int32

	// The number of minutes the job executes before it times out.
	JobTimeoutMinutes *int32

	// Information about the locale that is used for the run.
	Locale *string

	// Information about the location that is used for the run.
	Location *Location

	// A message about the run's result.
	Message *string

	// The run's name.
	Name *string

	// The network profile being used for a test run.
	NetworkProfile *NetworkProfile

	// Read-only URL for an object in an S3 bucket where you can get the parsing
	// results of the test package. If the test package doesn't parse, the reason why
	// it doesn't parse appears in the file that this URL points to.
	ParsingResultUrl *string

	// The run's platform.
	//
	// Allowed values include:
	//
	//   - ANDROID
	//
	//   - IOS
	Platform DevicePlatform

	// Information about the radio states for the run.
	Radios *Radios

	// The run's result.
	//
	// Allowed values include:
	//
	//   - PENDING
	//
	//   - PASSED
	//
	//   - WARNED
	//
	//   - FAILED
	//
	//   - SKIPPED
	//
	//   - ERRORED
	//
	//   - STOPPED
	Result ExecutionResult

	// Supporting field for the result field. Set only if result is SKIPPED .
	// PARSING_FAILED if the result is skipped because of test package parsing failure.
	ResultCode ExecutionResultCode

	// For fuzz tests, this is a seed to use for randomizing the UI fuzz test. Using
	// the same seed value between tests ensures identical event sequences.
	Seed *int32

	// When set to true , for private devices, Device Farm does not sign your app
	// again. For public devices, Device Farm always signs your apps again.
	//
	// For more information about how Device Farm re-signs your apps, see [Do you modify my app?] in the AWS
	// Device Farm FAQs.
	//
	// [Do you modify my app?]: http://aws.amazon.com/device-farm/faqs/
	SkipAppResign *bool

	// The run's start time.
	Started *time.Time

	// The run's status.
	//
	// Allowed values include:
	//
	//   - PENDING
	//
	//   - PENDING_CONCURRENCY
	//
	//   - PENDING_DEVICE
	//
	//   - PROCESSING
	//
	//   - SCHEDULING
	//
	//   - PREPARING
	//
	//   - RUNNING
	//
	//   - COMPLETED
	//
	//   - STOPPING
	Status ExecutionStatus

	// The run's stop time.
	Stopped *time.Time

	// The ARN of the YAML-formatted test specification for the run.
	TestSpecArn *string

	// The total number of jobs for the run.
	TotalJobs *int32

	// The run's type.
	//
	// Must be one of the following values:
	//
	//   - BUILTIN_FUZZ
	//
	//   - APPIUM_JAVA_JUNIT
	//
	//   - APPIUM_JAVA_TESTNG
	//
	//   - APPIUM_PYTHON
	//
	//   - APPIUM_NODE
	//
	//   - APPIUM_RUBY
	//
	//   - APPIUM_WEB_JAVA_JUNIT
	//
	//   - APPIUM_WEB_JAVA_TESTNG
	//
	//   - APPIUM_WEB_PYTHON
	//
	//   - APPIUM_WEB_NODE
	//
	//   - APPIUM_WEB_RUBY
	//
	//   - INSTRUMENTATION
	//
	//   - XCTEST
	//
	//   - XCTEST_UI
	Type TestType

	// The VPC security groups and subnets that are attached to a project.
	VpcConfig *VpcConfig

	// The Device Farm console URL for the recording of the run.
	WebUrl *string

	noSmithyDocumentSerde
}

// Represents a sample of performance data.
type Sample struct {

	// The sample's ARN.
	Arn *string

	// The sample's type.
	//
	// Must be one of the following values:
	//
	//   - CPU: A CPU sample type. This is expressed as the app processing CPU time
	//   (including child processes) as reported by process, as a percentage.
	//
	//   - MEMORY: A memory usage sample type. This is expressed as the total
	//   proportional set size of an app process, in kilobytes.
	//
	//   - NATIVE_AVG_DRAWTIME
	//
	//   - NATIVE_FPS
	//
	//   - NATIVE_FRAMES
	//
	//   - NATIVE_MAX_DRAWTIME
	//
	//   - NATIVE_MIN_DRAWTIME
	//
	//   - OPENGL_AVG_DRAWTIME
	//
	//   - OPENGL_FPS
	//
	//   - OPENGL_FRAMES
	//
	//   - OPENGL_MAX_DRAWTIME
	//
	//   - OPENGL_MIN_DRAWTIME
	//
	//   - RX
	//
	//   - RX_RATE: The total number of bytes per second (TCP and UDP) that are sent,
	//   by app process.
	//
	//   - THREADS: A threads sample type. This is expressed as the total number of
	//   threads per app process.
	//
	//   - TX
	//
	//   - TX_RATE: The total number of bytes per second (TCP and UDP) that are
	//   received, by app process.
	Type SampleType

	// The presigned Amazon S3 URL that can be used with a GET request to download the
	// sample's file.
	Url *string

	noSmithyDocumentSerde
}

// Represents the settings for a run. Includes things like location, radio states,
// auxiliary apps, and network profiles.
type ScheduleRunConfiguration struct {

	// A list of upload ARNs for app packages to be installed with your app.
	AuxiliaryApps []string

	// Specifies the billing method for a test run: metered or unmetered . If the
	// parameter is not specified, the default value is metered .
	//
	// If you have purchased unmetered device slots, you must set this parameter to
	// unmetered to make use of them. Otherwise, your run counts against your metered
	// time.
	BillingMethod BillingMethod

	// Input CustomerArtifactPaths object for the scheduled run configuration.
	CustomerArtifactPaths *CustomerArtifactPaths

	// The ARN of the extra data for the run. The extra data is a .zip file that AWS
	// Device Farm extracts to external data for Android or the app's sandbox for iOS.
	ExtraDataPackageArn *string

	// Information about the locale that is used for the run.
	Locale *string

	// Information about the location that is used for the run.
	Location *Location

	// Reserved for internal use.
	NetworkProfileArn *string

	// Information about the radio states for the run.
	Radios *Radios

	// An array of ARNs for your VPC endpoint configurations.
	VpceConfigurationArns []string

	noSmithyDocumentSerde
}

// Represents test settings. This data structure is passed in as the test
// parameter to ScheduleRun. For an example of the JSON request syntax, see ScheduleRun.
type ScheduleRunTest struct {

	// The test's type.
	//
	// Must be one of the following values:
	//
	//   - BUILTIN_FUZZ
	//
	//   - APPIUM_JAVA_JUNIT
	//
	//   - APPIUM_JAVA_TESTNG
	//
	//   - APPIUM_PYTHON
	//
	//   - APPIUM_NODE
	//
	//   - APPIUM_RUBY
	//
	//   - APPIUM_WEB_JAVA_JUNIT
	//
	//   - APPIUM_WEB_JAVA_TESTNG
	//
	//   - APPIUM_WEB_PYTHON
	//
	//   - APPIUM_WEB_NODE
	//
	//   - APPIUM_WEB_RUBY
	//
	//   - INSTRUMENTATION
	//
	//   - XCTEST
	//
	//   - XCTEST_UI
	//
	// This member is required.
	Type TestType

	// The test's filter.
	Filter *string

	// The test's parameters, such as test framework parameters and fixture settings.
	// Parameters are represented by name-value pairs of strings.
	//
	// For all tests:
	//
	//   - app_performance_monitoring : Performance monitoring is enabled by default.
	//   Set this parameter to false to disable it.
	//
	// For Appium tests (all types):
	//
	//   - appium_version: The Appium version. Currently supported values are 1.6.5
	//   (and later), latest, and default.
	//
	//   - latest runs the latest Appium version supported by Device Farm (1.9.1).
	//
	//   - For default, Device Farm selects a compatible version of Appium for the
	//   device. The current behavior is to run 1.7.2 on Android devices and iOS 9 and
	//   earlier and 1.7.2 for iOS 10 and later.
	//
	//   - This behavior is subject to change.
	//
	// For fuzz tests (Android only):
	//
	//   - event_count: The number of events, between 1 and 10000, that the UI fuzz
	//   test should perform.
	//
	//   - throttle: The time, in ms, between 0 and 1000, that the UI fuzz test should
	//   wait between events.
	//
	//   - seed: A seed to use for randomizing the UI fuzz test. Using the same seed
	//   value between tests ensures identical event sequences.
	//
	// For Instrumentation:
	//
	//   - filter: A test filter string. Examples:
	//
	//   - Running a single test case: com.android.abc.Test1
	//
	//   - Running a single test: com.android.abc.Test1#smoke
	//
	//   - Running multiple tests: com.android.abc.Test1,com.android.abc.Test2
	//
	// For XCTest and XCTestUI:
	//
	//   - filter: A test filter string. Examples:
	//
	//   - Running a single test class: LoginTests
	//
	//   - Running a multiple test classes: LoginTests,SmokeTests
	//
	//   - Running a single test: LoginTests/testValid
	//
	//   - Running multiple tests: LoginTests/testValid,LoginTests/testInvalid
	Parameters map[string]string

	// The ARN of the uploaded test to be run.
	TestPackageArn *string

	// The ARN of the YAML-formatted test specification.
	TestSpecArn *string

	noSmithyDocumentSerde
}

// Represents a collection of one or more tests.
type Suite struct {

	// The suite's ARN.
	Arn *string

	// The suite's result counters.
	Counters *Counters

	// When the suite was created.
	Created *time.Time

	// Represents the total (metered or unmetered) minutes used by the test suite.
	DeviceMinutes *DeviceMinutes

	// A message about the suite's result.
	Message *string

	// The suite's name.
	Name *string

	// The suite's result.
	//
	// Allowed values include:
	//
	//   - PENDING
	//
	//   - PASSED
	//
	//   - WARNED
	//
	//   - FAILED
	//
	//   - SKIPPED
	//
	//   - ERRORED
	//
	//   - STOPPED
	Result ExecutionResult

	// The suite's start time.
	Started *time.Time

	// The suite's status.
	//
	// Allowed values include:
	//
	//   - PENDING
	//
	//   - PENDING_CONCURRENCY
	//
	//   - PENDING_DEVICE
	//
	//   - PROCESSING
	//
	//   - SCHEDULING
	//
	//   - PREPARING
	//
	//   - RUNNING
	//
	//   - COMPLETED
	//
	//   - STOPPING
	Status ExecutionStatus

	// The suite's stop time.
	Stopped *time.Time

	// The suite's type.
	//
	// Must be one of the following values:
	//
	//   - BUILTIN_FUZZ
	//
	//   - APPIUM_JAVA_JUNIT
	//
	//   - APPIUM_JAVA_TESTNG
	//
	//   - APPIUM_PYTHON
	//
	//   - APPIUM_NODE
	//
	//   - APPIUM_RUBY
	//
	//   - APPIUM_WEB_JAVA_JUNIT
	//
	//   - APPIUM_WEB_JAVA_TESTNG
	//
	//   - APPIUM_WEB_PYTHON
	//
	//   - APPIUM_WEB_NODE
	//
	//   - APPIUM_WEB_RUBY
	//
	//   - INSTRUMENTATION
	//
	//   - XCTEST
	//
	//   - XCTEST_UI
	Type TestType

	noSmithyDocumentSerde
}

// The metadata that you apply to a resource to help you categorize and organize
// it. Each tag consists of a key and an optional value, both of which you define.
// Tag keys can have a maximum character length of 128 characters. Tag values can
// have a maximum length of 256 characters.
type Tag struct {

	// One part of a key-value pair that makes up a tag. A key is a general label that
	// acts like a category for more specific tag values.
	//
	// This member is required.
	Key *string

	// The optional part of a key-value pair that makes up a tag. A value acts as a
	// descriptor in a tag category (key).
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Represents a condition that is evaluated.
type Test struct {

	// The test's ARN.
	Arn *string

	// The test's result counters.
	Counters *Counters

	// When the test was created.
	Created *time.Time

	// Represents the total (metered or unmetered) minutes used by the test.
	DeviceMinutes *DeviceMinutes

	// A message about the test's result.
	Message *string

	// The test's name.
	Name *string

	// The test's result.
	//
	// Allowed values include:
	//
	//   - PENDING
	//
	//   - PASSED
	//
	//   - WARNED
	//
	//   - FAILED
	//
	//   - SKIPPED
	//
	//   - ERRORED
	//
	//   - STOPPED
	Result ExecutionResult

	// The test's start time.
	Started *time.Time

	// The test's status.
	//
	// Allowed values include:
	//
	//   - PENDING
	//
	//   - PENDING_CONCURRENCY
	//
	//   - PENDING_DEVICE
	//
	//   - PROCESSING
	//
	//   - SCHEDULING
	//
	//   - PREPARING
	//
	//   - RUNNING
	//
	//   - COMPLETED
	//
	//   - STOPPING
	Status ExecutionStatus

	// The test's stop time.
	Stopped *time.Time

	// The test's type.
	//
	// Must be one of the following values:
	//
	//   - BUILTIN_FUZZ
	//
	//   - APPIUM_JAVA_JUNIT
	//
	//   - APPIUM_JAVA_TESTNG
	//
	//   - APPIUM_PYTHON
	//
	//   - APPIUM_NODE
	//
	//   - APPIUM_RUBY
	//
	//   - APPIUM_WEB_JAVA_JUNIT
	//
	//   - APPIUM_WEB_JAVA_TESTNG
	//
	//   - APPIUM_WEB_PYTHON
	//
	//   - APPIUM_WEB_NODE
	//
	//   - APPIUM_WEB_RUBY
	//
	//   - INSTRUMENTATION
	//
	//   - XCTEST
	//
	//   - XCTEST_UI
	Type TestType

	noSmithyDocumentSerde
}

// A Selenium testing project. Projects are used to collect and collate sessions.
type TestGridProject struct {

	// The ARN for the project.
	Arn *string

	// When the project was created.
	Created *time.Time

	// A human-readable description for the project.
	Description *string

	// A human-readable name for the project.
	Name *string

	// The VPC security groups and subnets that are attached to a project.
	VpcConfig *TestGridVpcConfig

	noSmithyDocumentSerde
}

// A TestGridSession is a single instance of a browser launched from the URL provided by a call
// to CreateTestGridUrl.
type TestGridSession struct {

	// The ARN of the session.
	Arn *string

	// The number of billed minutes that were used for this session.
	BillingMinutes *float64

	// The time that the session was started.
	Created *time.Time

	// The time the session ended.
	Ended *time.Time

	// A JSON object of options and parameters passed to the Selenium WebDriver.
	SeleniumProperties *string

	// The state of the session.
	Status TestGridSessionStatus

	noSmithyDocumentSerde
}

// An action taken by a TestGridSession browser instance.
type TestGridSessionAction struct {

	// The action taken by the session.
	Action *string

	// The time, in milliseconds, that the action took to complete in the browser.
	Duration *int64

	// HTTP method that the browser used to make the request.
	RequestMethod *string

	// The time that the session invoked the action.
	Started *time.Time

	// HTTP status code returned to the browser when the action was taken.
	StatusCode *string

	noSmithyDocumentSerde
}

// Artifacts are video and other files that are produced in the process of running
// a browser in an automated context.
//
// Video elements might be broken up into multiple artifacts as they grow in size
// during creation.
type TestGridSessionArtifact struct {

	// The file name of the artifact.
	Filename *string

	// The kind of artifact.
	Type TestGridSessionArtifactType

	// A semi-stable URL to the content of the object.
	Url *string

	noSmithyDocumentSerde
}

// The VPC security groups and subnets that are attached to a project.
type TestGridVpcConfig struct {

	// A list of VPC security group IDs in your Amazon VPC.
	//
	// This member is required.
	SecurityGroupIds []string

	// A list of VPC subnet IDs in your Amazon VPC.
	//
	// This member is required.
	SubnetIds []string

	// The ID of the Amazon VPC.
	//
	// This member is required.
	VpcId *string

	noSmithyDocumentSerde
}

// Represents information about free trial device minutes for an AWS account.
type TrialMinutes struct {

	// The number of free trial minutes remaining in the account.
	Remaining *float64

	// The total number of free trial minutes that the account started with.
	Total *float64

	noSmithyDocumentSerde
}

// A collection of one or more problems, grouped by their result.
type UniqueProblem struct {

	// A message about the unique problems' result.
	Message *string

	// Information about the problems.
	Problems []Problem

	noSmithyDocumentSerde
}

// An app or a set of one or more tests to upload or that have been uploaded.
type Upload struct {

	// The upload's ARN.
	Arn *string

	// The upload's category. Allowed values include:
	//
	//   - CURATED: An upload managed by AWS Device Farm.
	//
	//   - PRIVATE: An upload managed by the AWS Device Farm customer.
	Category UploadCategory

	// The upload's content type (for example, application/octet-stream ).
	ContentType *string

	// When the upload was created.
	Created *time.Time

	// A message about the upload's result.
	Message *string

	// The upload's metadata. For example, for Android, this contains information that
	// is parsed from the manifest and is displayed in the AWS Device Farm console
	// after the associated app is uploaded.
	Metadata *string

	// The upload's file name.
	Name *string

	// The upload's status.
	//
	// Must be one of the following values:
	//
	//   - FAILED
	//
	//   - INITIALIZED
	//
	//   - PROCESSING
	//
	//   - SUCCEEDED
	Status UploadStatus

	// The upload's type.
	//
	// Must be one of the following values:
	//
	//   - ANDROID_APP
	//
	//   - IOS_APP
	//
	//   - WEB_APP
	//
	//   - EXTERNAL_DATA
	//
	//   - APPIUM_JAVA_JUNIT_TEST_PACKAGE
	//
	//   - APPIUM_JAVA_TESTNG_TEST_PACKAGE
	//
	//   - APPIUM_PYTHON_TEST_PACKAGE
	//
	//   - APPIUM_NODE_TEST_PACKAGE
	//
	//   - APPIUM_RUBY_TEST_PACKAGE
	//
	//   - APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE
	//
	//   - APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE
	//
	//   - APPIUM_WEB_PYTHON_TEST_PACKAGE
	//
	//   - APPIUM_WEB_NODE_TEST_PACKAGE
	//
	//   - APPIUM_WEB_RUBY_TEST_PACKAGE
	//
	//   - INSTRUMENTATION_TEST_PACKAGE
	//
	//   - XCTEST_TEST_PACKAGE
	//
	//   - XCTEST_UI_TEST_PACKAGE
	//
	//   - APPIUM_JAVA_JUNIT_TEST_SPEC
	//
	//   - APPIUM_JAVA_TESTNG_TEST_SPEC
	//
	//   - APPIUM_PYTHON_TEST_SPEC
	//
	//   - APPIUM_NODE_TEST_SPEC
	//
	//   - APPIUM_RUBY_TEST_SPEC
	//
	//   - APPIUM_WEB_JAVA_JUNIT_TEST_SPEC
	//
	//   - APPIUM_WEB_JAVA_TESTNG_TEST_SPEC
	//
	//   - APPIUM_WEB_PYTHON_TEST_SPEC
	//
	//   - APPIUM_WEB_NODE_TEST_SPEC
	//
	//   - APPIUM_WEB_RUBY_TEST_SPEC
	//
	//   - INSTRUMENTATION_TEST_SPEC
	//
	//   - XCTEST_UI_TEST_SPEC
	Type UploadType

	// The presigned Amazon S3 URL that was used to store a file using a PUT request.
	Url *string

	noSmithyDocumentSerde
}

// Contains the VPC configuration data necessary to interface with AWS Device
// Farm's services.
type VpcConfig struct {

	// An array of one or more security groups IDs in your Amazon VPC.
	//
	// This member is required.
	SecurityGroupIds []string

	// An array of one or more subnet IDs in your Amazon VPC.
	//
	// This member is required.
	SubnetIds []string

	// The ID of the Amazon VPC.
	//
	// This member is required.
	VpcId *string

	noSmithyDocumentSerde
}

// Represents an Amazon Virtual Private Cloud (VPC) endpoint configuration.
type VPCEConfiguration struct {

	// The Amazon Resource Name (ARN) of the VPC endpoint configuration.
	Arn *string

	// The DNS name that maps to the private IP address of the service you want to
	// access.
	ServiceDnsName *string

	// An optional description that provides details about your VPC endpoint
	// configuration.
	VpceConfigurationDescription *string

	// The friendly name you give to your VPC endpoint configuration to manage your
	// configurations more easily.
	VpceConfigurationName *string

	// The name of the VPC endpoint service running in your AWS account that you want
	// Device Farm to test.
	VpceServiceName *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
