// Code generated by smithy-go-codegen DO NOT EDIT.

package directoryservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/directoryservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves information about the type of client authentication for the specified
// directory, if the type is specified. If no type is specified, information about
// all client authentication types that are supported for the specified directory
// is retrieved. Currently, only SmartCard is supported.
func (c *Client) DescribeClientAuthenticationSettings(ctx context.Context, params *DescribeClientAuthenticationSettingsInput, optFns ...func(*Options)) (*DescribeClientAuthenticationSettingsOutput, error) {
	if params == nil {
		params = &DescribeClientAuthenticationSettingsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeClientAuthenticationSettings", params, optFns, c.addOperationDescribeClientAuthenticationSettingsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeClientAuthenticationSettingsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeClientAuthenticationSettingsInput struct {

	// The identifier of the directory for which to retrieve information.
	//
	// This member is required.
	DirectoryId *string

	// The maximum number of items to return. If this value is zero, the maximum
	// number of items is specified by the limitations of the operation.
	Limit *int32

	// The DescribeClientAuthenticationSettingsResult.NextToken value from a previous
	// call to DescribeClientAuthenticationSettings. Pass null if this is the first call.
	NextToken *string

	// The type of client authentication for which to retrieve information. If no type
	// is specified, a list of all client authentication types that are supported for
	// the specified directory is retrieved.
	Type types.ClientAuthenticationType

	noSmithyDocumentSerde
}

type DescribeClientAuthenticationSettingsOutput struct {

	// Information about the type of client authentication for the specified
	// directory. The following information is retrieved: The date and time when the
	// status of the client authentication type was last updated, whether the client
	// authentication type is enabled or disabled, and the type of client
	// authentication.
	ClientAuthenticationSettingsInfo []types.ClientAuthenticationSettingInfo

	// The next token used to retrieve the client authentication settings if the
	// number of setting types exceeds page limit and there is another page.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeClientAuthenticationSettingsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeClientAuthenticationSettings{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeClientAuthenticationSettings{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeClientAuthenticationSettings"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeClientAuthenticationSettingsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeClientAuthenticationSettings(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// DescribeClientAuthenticationSettingsPaginatorOptions is the paginator options
// for DescribeClientAuthenticationSettings
type DescribeClientAuthenticationSettingsPaginatorOptions struct {
	// The maximum number of items to return. If this value is zero, the maximum
	// number of items is specified by the limitations of the operation.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeClientAuthenticationSettingsPaginator is a paginator for
// DescribeClientAuthenticationSettings
type DescribeClientAuthenticationSettingsPaginator struct {
	options   DescribeClientAuthenticationSettingsPaginatorOptions
	client    DescribeClientAuthenticationSettingsAPIClient
	params    *DescribeClientAuthenticationSettingsInput
	nextToken *string
	firstPage bool
}

// NewDescribeClientAuthenticationSettingsPaginator returns a new
// DescribeClientAuthenticationSettingsPaginator
func NewDescribeClientAuthenticationSettingsPaginator(client DescribeClientAuthenticationSettingsAPIClient, params *DescribeClientAuthenticationSettingsInput, optFns ...func(*DescribeClientAuthenticationSettingsPaginatorOptions)) *DescribeClientAuthenticationSettingsPaginator {
	if params == nil {
		params = &DescribeClientAuthenticationSettingsInput{}
	}

	options := DescribeClientAuthenticationSettingsPaginatorOptions{}
	if params.Limit != nil {
		options.Limit = *params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeClientAuthenticationSettingsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeClientAuthenticationSettingsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeClientAuthenticationSettings page.
func (p *DescribeClientAuthenticationSettingsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeClientAuthenticationSettingsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.Limit = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeClientAuthenticationSettings(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeClientAuthenticationSettingsAPIClient is a client that implements the
// DescribeClientAuthenticationSettings operation.
type DescribeClientAuthenticationSettingsAPIClient interface {
	DescribeClientAuthenticationSettings(context.Context, *DescribeClientAuthenticationSettingsInput, ...func(*Options)) (*DescribeClientAuthenticationSettingsOutput, error)
}

var _ DescribeClientAuthenticationSettingsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeClientAuthenticationSettings(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeClientAuthenticationSettings",
	}
}
