// Code generated by smithy-go-codegen DO NOT EDIT.

package directoryservicedata

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/directoryservicedata/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Returns group information for the specified member.
//
// This operation supports pagination with the use of the NextToken request and
// response parameters. If more results are available, the
// ListGroupsForMember.NextToken member contains a token that you pass in the next
// call to ListGroupsForMember . This retrieves the next set of items.
//
// You can also specify a maximum number of return results with the MaxResults
// parameter.
func (c *Client) ListGroupsForMember(ctx context.Context, params *ListGroupsForMemberInput, optFns ...func(*Options)) (*ListGroupsForMemberOutput, error) {
	if params == nil {
		params = &ListGroupsForMemberInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListGroupsForMember", params, optFns, c.addOperationListGroupsForMemberMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListGroupsForMemberOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListGroupsForMemberInput struct {

	//  The identifier (ID) of the directory that's associated with the member.
	//
	// This member is required.
	DirectoryId *string

	//  The SAMAccountName of the user, group, or computer that's a member of the
	// group.
	//
	// This member is required.
	SAMAccountName *string

	//  The maximum number of results to be returned per request.
	MaxResults *int32

	//  The domain name that's associated with the group member.
	//
	// This parameter is optional, so you can limit your results to the group members
	// in a specific domain.
	//
	// This parameter is case insensitive and defaults to Realm
	MemberRealm *string

	//  An encoded paging token for paginated calls that can be passed back to
	// retrieve the next page.
	NextToken *string

	//  The domain name that's associated with the group.
	//
	// This parameter is optional, so you can return groups outside of your Managed
	// Microsoft AD domain. When no value is defined, only your Managed Microsoft AD
	// groups are returned.
	//
	// This value is case insensitive and defaults to your Managed Microsoft AD
	// domain.
	Realm *string

	noSmithyDocumentSerde
}

type ListGroupsForMemberOutput struct {

	//  The identifier (ID) of the directory that's associated with the member.
	DirectoryId *string

	//  The group information that the request returns.
	Groups []types.GroupSummary

	//  The domain that's associated with the member.
	MemberRealm *string

	//  An encoded paging token for paginated calls that can be passed back to
	// retrieve the next page.
	NextToken *string

	//  The domain that's associated with the group.
	Realm *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListGroupsForMemberMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListGroupsForMember{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListGroupsForMember{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListGroupsForMember"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListGroupsForMemberValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListGroupsForMember(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListGroupsForMemberPaginatorOptions is the paginator options for
// ListGroupsForMember
type ListGroupsForMemberPaginatorOptions struct {
	//  The maximum number of results to be returned per request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListGroupsForMemberPaginator is a paginator for ListGroupsForMember
type ListGroupsForMemberPaginator struct {
	options   ListGroupsForMemberPaginatorOptions
	client    ListGroupsForMemberAPIClient
	params    *ListGroupsForMemberInput
	nextToken *string
	firstPage bool
}

// NewListGroupsForMemberPaginator returns a new ListGroupsForMemberPaginator
func NewListGroupsForMemberPaginator(client ListGroupsForMemberAPIClient, params *ListGroupsForMemberInput, optFns ...func(*ListGroupsForMemberPaginatorOptions)) *ListGroupsForMemberPaginator {
	if params == nil {
		params = &ListGroupsForMemberInput{}
	}

	options := ListGroupsForMemberPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListGroupsForMemberPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListGroupsForMemberPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListGroupsForMember page.
func (p *ListGroupsForMemberPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListGroupsForMemberOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListGroupsForMember(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListGroupsForMemberAPIClient is a client that implements the
// ListGroupsForMember operation.
type ListGroupsForMemberAPIClient interface {
	ListGroupsForMember(context.Context, *ListGroupsForMemberInput, ...func(*Options)) (*ListGroupsForMemberOutput, error)
}

var _ ListGroupsForMemberAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListGroupsForMember(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListGroupsForMember",
	}
}
