// Code generated by smithy-go-codegen DO NOT EDIT.

package docdb

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/docdb/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an Amazon DocumentDB global cluster that can span multiple multiple
// Amazon Web Services Regions. The global cluster contains one primary cluster
// with read-write capability, and up-to give read-only secondary clusters. Global
// clusters uses storage-based fast replication across regions with latencies less
// than one second, using dedicated infrastructure with no impact to your
// workload’s performance.
//
// You can create a global cluster that is initially empty, and then add a primary
// and a secondary to it. Or you can specify an existing cluster during the create
// operation, and this cluster becomes the primary of the global cluster.
//
// This action only applies to Amazon DocumentDB clusters.
func (c *Client) CreateGlobalCluster(ctx context.Context, params *CreateGlobalClusterInput, optFns ...func(*Options)) (*CreateGlobalClusterOutput, error) {
	if params == nil {
		params = &CreateGlobalClusterInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateGlobalCluster", params, optFns, c.addOperationCreateGlobalClusterMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateGlobalClusterOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input to CreateGlobalCluster.
type CreateGlobalClusterInput struct {

	// The cluster identifier of the new global cluster.
	//
	// This member is required.
	GlobalClusterIdentifier *string

	// The name for your database of up to 64 alpha-numeric characters. If you do not
	// provide a name, Amazon DocumentDB will not create a database in the global
	// cluster you are creating.
	DatabaseName *string

	// The deletion protection setting for the new global cluster. The global cluster
	// can't be deleted when deletion protection is enabled.
	DeletionProtection *bool

	// The name of the database engine to be used for this cluster.
	Engine *string

	// The engine version of the global cluster.
	EngineVersion *string

	// The Amazon Resource Name (ARN) to use as the primary cluster of the global
	// cluster. This parameter is optional.
	SourceDBClusterIdentifier *string

	// The storage encryption setting for the new global cluster.
	StorageEncrypted *bool

	noSmithyDocumentSerde
}

type CreateGlobalClusterOutput struct {

	// A data type representing an Amazon DocumentDB global cluster.
	GlobalCluster *types.GlobalCluster

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateGlobalClusterMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpCreateGlobalCluster{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpCreateGlobalCluster{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateGlobalCluster"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateGlobalClusterValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateGlobalCluster(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateGlobalCluster(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateGlobalCluster",
	}
}
