// Code generated by smithy-go-codegen DO NOT EDIT.

package efs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/efs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a replication conﬁguration to either a new or existing EFS file system.
// For more information, see [Amazon EFS replication]in the Amazon EFS User Guide. The replication
// configuration specifies the following:
//
//   - Source file system – The EFS file system that you want to replicate.
//
//   - Destination file system – The destination file system to which the source
//     file system is replicated. There can only be one destination file system in a
//     replication configuration.
//
// A file system can be part of only one replication configuration.
//
// The destination parameters for the replication configuration depend on whether
//
//	you are replicating to a new file system or to an existing file system, and if
//	you are replicating across Amazon Web Services accounts. See DestinationToCreatefor more
//	information.
//
// This operation requires permissions for the
// elasticfilesystem:CreateReplicationConfiguration action. Additionally, other
// permissions are required depending on how you are replicating file systems. For
// more information, see [Required permissions for replication]in the Amazon EFS User Guide.
//
// [Required permissions for replication]: https://docs.aws.amazon.com/efs/latest/ug/efs-replication.html#efs-replication-permissions
// [Amazon EFS replication]: https://docs.aws.amazon.com/efs/latest/ug/efs-replication.html
func (c *Client) CreateReplicationConfiguration(ctx context.Context, params *CreateReplicationConfigurationInput, optFns ...func(*Options)) (*CreateReplicationConfigurationOutput, error) {
	if params == nil {
		params = &CreateReplicationConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateReplicationConfiguration", params, optFns, c.addOperationCreateReplicationConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateReplicationConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateReplicationConfigurationInput struct {

	// An array of destination configuration objects. Only one destination
	// configuration object is supported.
	//
	// This member is required.
	Destinations []types.DestinationToCreate

	// Specifies the Amazon EFS file system that you want to replicate. This file
	// system cannot already be a source or destination file system in another
	// replication configuration.
	//
	// This member is required.
	SourceFileSystemId *string

	noSmithyDocumentSerde
}

// Describes the replication configuration for a specific file system.
type CreateReplicationConfigurationOutput struct {

	// Describes when the replication configuration was created.
	//
	// This member is required.
	CreationTime *time.Time

	// An array of destination objects. Only one destination object is supported.
	//
	// This member is required.
	Destinations []types.Destination

	// The Amazon Resource Name (ARN) of the original source EFS file system in the
	// replication configuration.
	//
	// This member is required.
	OriginalSourceFileSystemArn *string

	// The Amazon Resource Name (ARN) of the current source file system in the
	// replication configuration.
	//
	// This member is required.
	SourceFileSystemArn *string

	// The ID of the source Amazon EFS file system that is being replicated.
	//
	// This member is required.
	SourceFileSystemId *string

	// The Amazon Web Services Region in which the source EFS file system is located.
	//
	// This member is required.
	SourceFileSystemRegion *string

	// ID of the Amazon Web Services account in which the source file system resides.
	SourceFileSystemOwnerId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateReplicationConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateReplicationConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateReplicationConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateReplicationConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateReplicationConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateReplicationConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateReplicationConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateReplicationConfiguration",
	}
}
