// Code generated by smithy-go-codegen DO NOT EDIT.

package elasticache

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/elasticache/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modifies a replication group's shards (node groups) by allowing you to add
// shards, remove shards, or rebalance the keyspaces among existing shards.
func (c *Client) ModifyReplicationGroupShardConfiguration(ctx context.Context, params *ModifyReplicationGroupShardConfigurationInput, optFns ...func(*Options)) (*ModifyReplicationGroupShardConfigurationOutput, error) {
	if params == nil {
		params = &ModifyReplicationGroupShardConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ModifyReplicationGroupShardConfiguration", params, optFns, c.addOperationModifyReplicationGroupShardConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ModifyReplicationGroupShardConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input for a ModifyReplicationGroupShardConfiguration operation.
type ModifyReplicationGroupShardConfigurationInput struct {

	// Indicates that the shard reconfiguration process begins immediately. At
	// present, the only permitted value for this parameter is true .
	//
	// Value: true
	//
	// This member is required.
	ApplyImmediately *bool

	// The number of node groups (shards) that results from the modification of the
	// shard configuration.
	//
	// This member is required.
	NodeGroupCount *int32

	// The name of the Valkey or Redis OSS (cluster mode enabled) cluster (replication
	// group) on which the shards are to be configured.
	//
	// This member is required.
	ReplicationGroupId *string

	// If the value of NodeGroupCount is less than the current number of node groups
	// (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required.
	// NodeGroupsToRemove is a list of NodeGroupId s to remove from the cluster.
	//
	// ElastiCache will attempt to remove all node groups listed by NodeGroupsToRemove
	// from the cluster.
	NodeGroupsToRemove []string

	// If the value of NodeGroupCount is less than the current number of node groups
	// (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required.
	// NodeGroupsToRetain is a list of NodeGroupId s to retain in the cluster.
	//
	// ElastiCache will attempt to remove all node groups except those listed by
	// NodeGroupsToRetain from the cluster.
	NodeGroupsToRetain []string

	// Specifies the preferred availability zones for each node group in the cluster.
	// If the value of NodeGroupCount is greater than the current number of node
	// groups (shards), you can use this parameter to specify the preferred
	// availability zones of the cluster's shards. If you omit this parameter
	// ElastiCache selects availability zones for you.
	//
	// You can specify this parameter only if the value of NodeGroupCount is greater
	// than the current number of node groups (shards).
	ReshardingConfiguration []types.ReshardingConfiguration

	noSmithyDocumentSerde
}

type ModifyReplicationGroupShardConfigurationOutput struct {

	// Contains all of the attributes of a specific Valkey or Redis OSS replication
	// group.
	ReplicationGroup *types.ReplicationGroup

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationModifyReplicationGroupShardConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpModifyReplicationGroupShardConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpModifyReplicationGroupShardConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ModifyReplicationGroupShardConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpModifyReplicationGroupShardConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opModifyReplicationGroupShardConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opModifyReplicationGroupShardConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ModifyReplicationGroupShardConfiguration",
	}
}
