// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// With Amazon EMR release version 4.0 and later, the only accepted parameter is
// the application name. To pass arguments to applications, you use configuration
// classifications specified using configuration JSON objects. For more
// information, see [Configuring Applications].
//
// With earlier Amazon EMR releases, the application is any Amazon or third-party
// software that you can add to the cluster. This structure contains a list of
// strings that indicates the software to use with the cluster and accepts a user
// argument list. Amazon EMR accepts and forwards the argument list to the
// corresponding installation script as bootstrap action argument.
//
// [Configuring Applications]: https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html
type Application struct {

	// This option is for advanced users only. This is meta information about
	// third-party applications that third-party vendors use for testing purposes.
	AdditionalInfo map[string]string

	// Arguments for Amazon EMR to pass to the application.
	Args []string

	// The name of the application.
	Name *string

	// The version of the application.
	Version *string

	noSmithyDocumentSerde
}

// An automatic scaling policy for a core instance group or task instance group in
// an Amazon EMR cluster. An automatic scaling policy defines how an instance group
// dynamically adds and terminates Amazon EC2 instances in response to the value of
// a CloudWatch metric. See PutAutoScalingPolicy.
type AutoScalingPolicy struct {

	// The upper and lower Amazon EC2 instance limits for an automatic scaling policy.
	// Automatic scaling activity will not cause an instance group to grow above or
	// below these limits.
	//
	// This member is required.
	Constraints *ScalingConstraints

	// The scale-in and scale-out rules that comprise the automatic scaling policy.
	//
	// This member is required.
	Rules []ScalingRule

	noSmithyDocumentSerde
}

// An automatic scaling policy for a core instance group or task instance group in
// an Amazon EMR cluster. The automatic scaling policy defines how an instance
// group dynamically adds and terminates Amazon EC2 instances in response to the
// value of a CloudWatch metric. See PutAutoScalingPolicy.
type AutoScalingPolicyDescription struct {

	// The upper and lower Amazon EC2 instance limits for an automatic scaling policy.
	// Automatic scaling activity will not cause an instance group to grow above or
	// below these limits.
	Constraints *ScalingConstraints

	// The scale-in and scale-out rules that comprise the automatic scaling policy.
	Rules []ScalingRule

	// The status of an automatic scaling policy.
	Status *AutoScalingPolicyStatus

	noSmithyDocumentSerde
}

// The reason for an AutoScalingPolicyStatus change.
type AutoScalingPolicyStateChangeReason struct {

	// The code indicating the reason for the change in status. USER_REQUEST indicates
	// that the scaling policy status was changed by a user. PROVISION_FAILURE
	// indicates that the status change was because the policy failed to provision.
	// CLEANUP_FAILURE indicates an error.
	Code AutoScalingPolicyStateChangeReasonCode

	// A friendly, more verbose message that accompanies an automatic scaling policy
	// state change.
	Message *string

	noSmithyDocumentSerde
}

// The status of an automatic scaling policy.
type AutoScalingPolicyStatus struct {

	// Indicates the status of the automatic scaling policy.
	State AutoScalingPolicyState

	// The reason for a change in status.
	StateChangeReason *AutoScalingPolicyStateChangeReason

	noSmithyDocumentSerde
}

// An auto-termination policy for an Amazon EMR cluster. An auto-termination
// policy defines the amount of idle time in seconds after which a cluster
// automatically terminates. For alternative cluster termination options, see [Control cluster termination].
//
// [Control cluster termination]: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html
type AutoTerminationPolicy struct {

	// Specifies the amount of idle time in seconds after which the cluster
	// automatically terminates. You can specify a minimum of 60 seconds and a maximum
	// of 604800 seconds (seven days).
	IdleTimeout *int64

	noSmithyDocumentSerde
}

// A configuration for Amazon EMR block public access. When
// BlockPublicSecurityGroupRules is set to true , Amazon EMR prevents cluster
// creation if one of the cluster's security groups has a rule that allows inbound
// traffic from 0.0.0.0/0 or ::/0 on a port, unless the port is specified as an
// exception using PermittedPublicSecurityGroupRuleRanges .
type BlockPublicAccessConfiguration struct {

	// Indicates whether Amazon EMR block public access is enabled ( true ) or disabled
	// ( false ). By default, the value is false for accounts that have created Amazon
	// EMR clusters before July 2019. For accounts created after this, the default is
	// true .
	//
	// This member is required.
	BlockPublicSecurityGroupRules *bool

	// The classification within a configuration.
	Classification *string

	// A list of additional configurations to apply within a configuration object.
	Configurations []Configuration

	// Specifies ports and port ranges that are permitted to have security group rules
	// that allow inbound traffic from all public sources. For example, if Port 23
	// (Telnet) is specified for PermittedPublicSecurityGroupRuleRanges , Amazon EMR
	// allows cluster creation if a security group associated with the cluster has a
	// rule that allows inbound traffic on Port 23 from IPv4 0.0.0.0/0 or IPv6 port
	// ::/0 as the source.
	//
	// By default, Port 22, which is used for SSH access to the cluster Amazon EC2
	// instances, is in the list of PermittedPublicSecurityGroupRuleRanges .
	PermittedPublicSecurityGroupRuleRanges []PortRange

	// A set of properties specified within a configuration classification.
	Properties map[string]string

	noSmithyDocumentSerde
}

// Properties that describe the Amazon Web Services principal that created the
// BlockPublicAccessConfiguration using the PutBlockPublicAccessConfiguration
// action as well as the date and time that the configuration was created. Each
// time a configuration for block public access is updated, Amazon EMR updates this
// metadata.
type BlockPublicAccessConfigurationMetadata struct {

	// The Amazon Resource Name that created or last modified the configuration.
	//
	// This member is required.
	CreatedByArn *string

	// The date and time that the configuration was created.
	//
	// This member is required.
	CreationDateTime *time.Time

	noSmithyDocumentSerde
}

// Configuration of a bootstrap action.
type BootstrapActionConfig struct {

	// The name of the bootstrap action.
	//
	// This member is required.
	Name *string

	// The script run by the bootstrap action.
	//
	// This member is required.
	ScriptBootstrapAction *ScriptBootstrapActionConfig

	noSmithyDocumentSerde
}

// Reports the configuration of a bootstrap action in a cluster (job flow).
type BootstrapActionDetail struct {

	// A description of the bootstrap action.
	BootstrapActionConfig *BootstrapActionConfig

	noSmithyDocumentSerde
}

// Specification of the status of a CancelSteps request. Available only in Amazon
// EMR version 4.8.0 and later, excluding version 5.0.0.
type CancelStepsInfo struct {

	// The reason for the failure if the CancelSteps request fails.
	Reason *string

	// The status of a CancelSteps Request. The value may be SUBMITTED or FAILED.
	Status CancelStepsRequestStatus

	// The encrypted StepId of a step.
	StepId *string

	noSmithyDocumentSerde
}

// The definition of a CloudWatch metric alarm, which determines when an automatic
// scaling activity is triggered. When the defined alarm conditions are satisfied,
// scaling activity begins.
type CloudWatchAlarmDefinition struct {

	// Determines how the metric specified by MetricName is compared to the value
	// specified by Threshold .
	//
	// This member is required.
	ComparisonOperator ComparisonOperator

	// The name of the CloudWatch metric that is watched to determine an alarm
	// condition.
	//
	// This member is required.
	MetricName *string

	// The period, in seconds, over which the statistic is applied. CloudWatch metrics
	// for Amazon EMR are emitted every five minutes (300 seconds), so if you specify a
	// CloudWatch metric, specify 300 .
	//
	// This member is required.
	Period *int32

	// The value against which the specified statistic is compared.
	//
	// This member is required.
	Threshold *float64

	// A CloudWatch metric dimension.
	Dimensions []MetricDimension

	// The number of periods, in five-minute increments, during which the alarm
	// condition must exist before the alarm triggers automatic scaling activity. The
	// default value is 1 .
	EvaluationPeriods *int32

	// The namespace for the CloudWatch metric. The default is AWS/ElasticMapReduce .
	Namespace *string

	// The statistic to apply to the metric associated with the alarm. The default is
	// AVERAGE .
	Statistic Statistic

	// The unit of measure associated with the CloudWatch metric being watched. The
	// value specified for Unit must correspond to the units specified in the
	// CloudWatch metric.
	Unit Unit

	noSmithyDocumentSerde
}

// The detailed description of the cluster.
type Cluster struct {

	// The applications installed on this cluster.
	Applications []Application

	// An IAM role for automatic scaling policies. The default role is
	// EMR_AutoScaling_DefaultRole . The IAM role provides permissions that the
	// automatic scaling feature requires to launch and terminate Amazon EC2 instances
	// in an instance group.
	AutoScalingRole *string

	// Specifies whether the cluster should terminate after completing all steps.
	AutoTerminate *bool

	// The Amazon Resource Name of the cluster.
	ClusterArn *string

	// Applies only to Amazon EMR releases 4.x and later. The list of configurations
	// that are supplied to the Amazon EMR cluster.
	Configurations []Configuration

	// Available only in Amazon EMR releases 5.7.0 and later. The ID of a custom
	// Amazon EBS-backed Linux AMI if the cluster uses a custom AMI.
	CustomAmiId *string

	// The IOPS, of the Amazon EBS root device volume of the Linux AMI that is used
	// for each Amazon EC2 instance. Available in Amazon EMR releases 6.15.0 and later.
	EbsRootVolumeIops *int32

	// The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is
	// used for each Amazon EC2 instance. Available in Amazon EMR releases 4.x and
	// later.
	EbsRootVolumeSize *int32

	// The throughput, in MiB/s, of the Amazon EBS root device volume of the Linux AMI
	// that is used for each Amazon EC2 instance. Available in Amazon EMR releases
	// 6.15.0 and later.
	EbsRootVolumeThroughput *int32

	// Provides information about the Amazon EC2 instances in a cluster grouped by
	// category. For example, key name, subnet ID, IAM instance profile, and so on.
	Ec2InstanceAttributes *Ec2InstanceAttributes

	// The unique identifier for the cluster.
	Id *string

	// The instance fleet configuration is available only in Amazon EMR releases 4.8.0
	// and later, excluding 5.0.x versions.
	//
	// The instance group configuration of the cluster. A value of INSTANCE_GROUP
	// indicates a uniform instance group configuration. A value of INSTANCE_FLEET
	// indicates an instance fleets configuration.
	InstanceCollectionType InstanceCollectionType

	// Attributes for Kerberos configuration when Kerberos authentication is enabled
	// using a security configuration. For more information see [Use Kerberos Authentication]in the Amazon EMR
	// Management Guide.
	//
	// [Use Kerberos Authentication]: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html
	KerberosAttributes *KerberosAttributes

	//  The KMS key used for encrypting log files. This attribute is only available
	// with Amazon EMR 5.30.0 and later, excluding Amazon EMR 6.0.0.
	LogEncryptionKmsKeyId *string

	// The path to the Amazon S3 location where logs for this cluster are stored.
	LogUri *string

	// The DNS name of the master node. If the cluster is on a private subnet, this is
	// the private DNS name. On a public subnet, this is the public DNS name.
	MasterPublicDnsName *string

	// The name of the cluster. This parameter can't contain the characters <, >, $,
	// |, or ` (backtick).
	Name *string

	// An approximation of the cost of the cluster, represented in m1.small/hours.
	// This value is incremented one time for every hour an m1.small instance runs.
	// Larger instances are weighted more, so an Amazon EC2 instance that is roughly
	// four times more expensive would result in the normalized instance hours being
	// incremented by four. This result is only an approximation and does not reflect
	// the actual billing rate.
	NormalizedInstanceHours *int32

	// The Amazon Linux release specified in a cluster launch RunJobFlow request. If
	// no Amazon Linux release was specified, the default Amazon Linux release is shown
	// in the response.
	OSReleaseLabel *string

	//  The Amazon Resource Name (ARN) of the Outpost where the cluster is launched.
	OutpostArn *string

	// Placement group configured for an Amazon EMR cluster.
	PlacementGroups []PlacementGroupConfig

	// The Amazon EMR release label, which determines the version of open-source
	// application packages installed on the cluster. Release labels are in the form
	// emr-x.x.x , where x.x.x is an Amazon EMR release version such as emr-5.14.0 .
	// For more information about Amazon EMR release versions and included application
	// versions and features, see [https://docs.aws.amazon.com/emr/latest/ReleaseGuide/]. The release label applies only to Amazon EMR
	// releases version 4.0 and later. Earlier versions use AmiVersion .
	//
	// [https://docs.aws.amazon.com/emr/latest/ReleaseGuide/]: https://docs.aws.amazon.com/emr/latest/ReleaseGuide/
	ReleaseLabel *string

	// Applies only when CustomAmiID is used. Specifies the type of updates that the
	// Amazon Linux AMI package repositories apply when an instance boots using the
	// AMI.
	RepoUpgradeOnBoot RepoUpgradeOnBoot

	// The AMI version requested for this cluster.
	RequestedAmiVersion *string

	// The AMI version running on this cluster.
	RunningAmiVersion *string

	// The way that individual Amazon EC2 instances terminate when an automatic
	// scale-in activity occurs or an instance group is resized.
	// TERMINATE_AT_INSTANCE_HOUR indicates that Amazon EMR terminates nodes at the
	// instance-hour boundary, regardless of when the request to terminate the instance
	// was submitted. This option is only available with Amazon EMR 5.1.0 and later and
	// is the default for clusters created using that version.
	// TERMINATE_AT_TASK_COMPLETION indicates that Amazon EMR adds nodes to a deny list
	// and drains tasks from nodes before terminating the Amazon EC2 instances,
	// regardless of the instance-hour boundary. With either behavior, Amazon EMR
	// removes the least active nodes first and blocks instance termination if it could
	// lead to HDFS corruption. TERMINATE_AT_TASK_COMPLETION is available only in
	// Amazon EMR releases 4.1.0 and later, and is the default for versions of Amazon
	// EMR earlier than 5.1.0.
	ScaleDownBehavior ScaleDownBehavior

	// The name of the security configuration applied to the cluster.
	SecurityConfiguration *string

	// The IAM role that Amazon EMR assumes in order to access Amazon Web Services
	// resources on your behalf.
	ServiceRole *string

	// The current status details about the cluster.
	Status *ClusterStatus

	// Specifies the number of steps that can be executed concurrently.
	StepConcurrencyLevel *int32

	// A list of tags associated with a cluster.
	Tags []Tag

	// Indicates whether Amazon EMR will lock the cluster to prevent the Amazon EC2
	// instances from being terminated by an API call or user intervention, or in the
	// event of a cluster error.
	TerminationProtected *bool

	// Indicates whether Amazon EMR should gracefully replace Amazon EC2 core
	// instances that have degraded within the cluster.
	UnhealthyNodeReplacement *bool

	// Indicates whether the cluster is visible to IAM principals in the Amazon Web
	// Services account associated with the cluster. When true , IAM principals in the
	// Amazon Web Services account can perform Amazon EMR cluster actions on the
	// cluster that their IAM policies allow. When false , only the IAM principal that
	// created the cluster and the Amazon Web Services account root user can perform
	// Amazon EMR actions, regardless of IAM permissions policies attached to other IAM
	// principals.
	//
	// The default value is true if a value is not provided when creating a cluster
	// using the Amazon EMR API RunJobFlowcommand, the CLI [create-cluster] command, or the Amazon Web Services
	// Management Console.
	//
	// [create-cluster]: https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html
	VisibleToAllUsers *bool

	noSmithyDocumentSerde
}

// The reason that the cluster changed to its current state.
type ClusterStateChangeReason struct {

	// The programmatic code for the state change reason.
	Code ClusterStateChangeReasonCode

	// The descriptive message for the state change reason.
	Message *string

	noSmithyDocumentSerde
}

// The detailed status of the cluster.
type ClusterStatus struct {

	// A list of tuples that provides information about the errors that caused a
	// cluster to terminate. This structure can contain up to 10 different ErrorDetail
	// tuples.
	ErrorDetails []ErrorDetail

	// The current state of the cluster.
	State ClusterState

	// The reason for the cluster status change.
	StateChangeReason *ClusterStateChangeReason

	// A timeline that represents the status of a cluster over the lifetime of the
	// cluster.
	Timeline *ClusterTimeline

	noSmithyDocumentSerde
}

// The summary description of the cluster.
type ClusterSummary struct {

	// The Amazon Resource Name of the cluster.
	ClusterArn *string

	// The unique identifier for the cluster.
	Id *string

	// The name of the cluster.
	Name *string

	// An approximation of the cost of the cluster, represented in m1.small/hours.
	// This value is incremented one time for every hour an m1.small instance runs.
	// Larger instances are weighted more, so an Amazon EC2 instance that is roughly
	// four times more expensive would result in the normalized instance hours being
	// incremented by four. This result is only an approximation and does not reflect
	// the actual billing rate.
	NormalizedInstanceHours *int32

	//  The Amazon Resource Name (ARN) of the Outpost where the cluster is launched.
	OutpostArn *string

	// The details about the current status of the cluster.
	Status *ClusterStatus

	noSmithyDocumentSerde
}

// Represents the timeline of the cluster's lifecycle.
type ClusterTimeline struct {

	// The creation date and time of the cluster.
	CreationDateTime *time.Time

	// The date and time when the cluster was terminated.
	EndDateTime *time.Time

	// The date and time when the cluster was ready to run steps.
	ReadyDateTime *time.Time

	noSmithyDocumentSerde
}

// An entity describing an executable that runs on a cluster.
type Command struct {

	// Arguments for Amazon EMR to pass to the command for execution.
	Args []string

	// The name of the command.
	Name *string

	// The Amazon S3 location of the command script.
	ScriptPath *string

	noSmithyDocumentSerde
}

//	The Amazon EC2 unit limits for a managed scaling policy. The managed scaling
//
// activity of a cluster can not be above or below these limits. The limit only
// applies to the core and task nodes. The master node cannot be scaled after
// initial configuration.
type ComputeLimits struct {

	//  The upper boundary of Amazon EC2 units. It is measured through vCPU cores or
	// instances for instance groups and measured through units for instance fleets.
	// Managed scaling activities are not allowed beyond this boundary. The limit only
	// applies to the core and task nodes. The master node cannot be scaled after
	// initial configuration.
	//
	// This member is required.
	MaximumCapacityUnits *int32

	//  The lower boundary of Amazon EC2 units. It is measured through vCPU cores or
	// instances for instance groups and measured through units for instance fleets.
	// Managed scaling activities are not allowed beyond this boundary. The limit only
	// applies to the core and task nodes. The master node cannot be scaled after
	// initial configuration.
	//
	// This member is required.
	MinimumCapacityUnits *int32

	//  The unit type used for specifying a managed scaling policy.
	//
	// This member is required.
	UnitType ComputeLimitsUnitType

	//  The upper boundary of Amazon EC2 units for core node type in a cluster. It is
	// measured through vCPU cores or instances for instance groups and measured
	// through units for instance fleets. The core units are not allowed to scale
	// beyond this boundary. The parameter is used to split capacity allocation between
	// core and task nodes.
	MaximumCoreCapacityUnits *int32

	//  The upper boundary of On-Demand Amazon EC2 units. It is measured through vCPU
	// cores or instances for instance groups and measured through units for instance
	// fleets. The On-Demand units are not allowed to scale beyond this boundary. The
	// parameter is used to split capacity allocation between On-Demand and Spot
	// Instances.
	MaximumOnDemandCapacityUnits *int32

	noSmithyDocumentSerde
}

// Amazon EMR releases 4.x or later.
//
// An optional configuration specification to be used when provisioning cluster
// instances, which can include configurations for applications and software
// bundled with Amazon EMR. A configuration consists of a classification,
// properties, and optional nested configurations. A classification refers to an
// application-specific configuration file. Properties are the settings you want to
// change in that file. For more information, see [Configuring Applications].
//
// [Configuring Applications]: https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html
type Configuration struct {

	// The classification within a configuration.
	Classification *string

	// A list of additional configurations to apply within a configuration object.
	Configurations []Configuration

	// A set of properties specified within a configuration classification.
	Properties map[string]string

	noSmithyDocumentSerde
}

// The credentials that you can use to connect to cluster endpoints. Credentials
// consist of a username and a password.
//
// The following types satisfy this interface:
//
//	CredentialsMemberUsernamePassword
type Credentials interface {
	isCredentials()
}

// The username and password that you use to connect to cluster endpoints.
type CredentialsMemberUsernamePassword struct {
	Value UsernamePassword

	noSmithyDocumentSerde
}

func (*CredentialsMemberUsernamePassword) isCredentials() {}

// Configuration of requested EBS block device associated with the instance group.
type EbsBlockDevice struct {

	// The device name that is exposed to the instance, such as /dev/sdh.
	Device *string

	// EBS volume specifications such as volume type, IOPS, size (GiB) and throughput
	// (MiB/s) that are requested for the EBS volume attached to an Amazon EC2 instance
	// in the cluster.
	VolumeSpecification *VolumeSpecification

	noSmithyDocumentSerde
}

// Configuration of requested EBS block device associated with the instance group
// with count of volumes that are associated to every instance.
type EbsBlockDeviceConfig struct {

	// EBS volume specifications such as volume type, IOPS, size (GiB) and throughput
	// (MiB/s) that are requested for the EBS volume attached to an Amazon EC2 instance
	// in the cluster.
	//
	// This member is required.
	VolumeSpecification *VolumeSpecification

	// Number of EBS volumes with a specific volume configuration that are associated
	// with every instance in the instance group
	VolumesPerInstance *int32

	noSmithyDocumentSerde
}

// The Amazon EBS configuration of a cluster instance.
type EbsConfiguration struct {

	// An array of Amazon EBS volume specifications attached to a cluster instance.
	EbsBlockDeviceConfigs []EbsBlockDeviceConfig

	// Indicates whether an Amazon EBS volume is EBS-optimized.
	EbsOptimized *bool

	noSmithyDocumentSerde
}

// EBS block device that's attached to an Amazon EC2 instance.
type EbsVolume struct {

	// The device name that is exposed to the instance, such as /dev/sdh.
	Device *string

	// The volume identifier of the EBS volume.
	VolumeId *string

	noSmithyDocumentSerde
}

// Provides information about the Amazon EC2 instances in a cluster grouped by
// category. For example, key name, subnet ID, IAM instance profile, and so on.
type Ec2InstanceAttributes struct {

	// A list of additional Amazon EC2 security group IDs for the master node.
	AdditionalMasterSecurityGroups []string

	// A list of additional Amazon EC2 security group IDs for the core and task nodes.
	AdditionalSlaveSecurityGroups []string

	// The Availability Zone in which the cluster will run.
	Ec2AvailabilityZone *string

	// The name of the Amazon EC2 key pair to use when connecting with SSH into the
	// master node as a user named "hadoop".
	Ec2KeyName *string

	// Set this parameter to the identifier of the Amazon VPC subnet where you want
	// the cluster to launch. If you do not specify this value, and your account
	// supports EC2-Classic, the cluster launches in EC2-Classic.
	Ec2SubnetId *string

	// The identifier of the Amazon EC2 security group for the master node.
	EmrManagedMasterSecurityGroup *string

	// The identifier of the Amazon EC2 security group for the core and task nodes.
	EmrManagedSlaveSecurityGroup *string

	// The IAM role that was specified when the cluster was launched. The Amazon EC2
	// instances of the cluster assume this role.
	IamInstanceProfile *string

	// Applies to clusters configured with the instance fleets option. Specifies one
	// or more Availability Zones in which to launch Amazon EC2 cluster instances when
	// the EC2-Classic network configuration is supported. Amazon EMR chooses the
	// Availability Zone with the best fit from among the list of
	// RequestedEc2AvailabilityZones , and then launches all cluster instances within
	// that Availability Zone. If you do not specify this value, Amazon EMR chooses the
	// Availability Zone for you. RequestedEc2SubnetIDs and
	// RequestedEc2AvailabilityZones cannot be specified together.
	RequestedEc2AvailabilityZones []string

	// Applies to clusters configured with the instance fleets option. Specifies the
	// unique identifier of one or more Amazon EC2 subnets in which to launch Amazon
	// EC2 cluster instances. Subnets must exist within the same VPC. Amazon EMR
	// chooses the Amazon EC2 subnet with the best fit from among the list of
	// RequestedEc2SubnetIds , and then launches all cluster instances within that
	// Subnet. If this value is not specified, and the account and Region support
	// EC2-Classic networks, the cluster launches instances in the EC2-Classic network
	// and uses RequestedEc2AvailabilityZones instead of this setting. If EC2-Classic
	// is not supported, and no Subnet is specified, Amazon EMR chooses the subnet for
	// you. RequestedEc2SubnetIDs and RequestedEc2AvailabilityZones cannot be
	// specified together.
	RequestedEc2SubnetIds []string

	// The identifier of the Amazon EC2 security group for the Amazon EMR service to
	// access clusters in VPC private subnets.
	ServiceAccessSecurityGroup *string

	noSmithyDocumentSerde
}

// A tuple that provides information about an error that caused a cluster to
// terminate.
type ErrorDetail struct {

	// The name or code associated with the error.
	ErrorCode *string

	// A list of key value pairs that provides contextual information about why an
	// error occured.
	ErrorData []map[string]string

	// A message that describes the error.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Specifies the execution engine (cluster) to run the notebook and perform the
// notebook execution, for example, an Amazon EMR cluster.
type ExecutionEngineConfig struct {

	// The unique identifier of the execution engine. For an Amazon EMR cluster, this
	// is the cluster ID.
	//
	// This member is required.
	Id *string

	// The execution role ARN required for the notebook execution.
	ExecutionRoleArn *string

	// An optional unique ID of an Amazon EC2 security group to associate with the
	// master instance of the Amazon EMR cluster for this notebook execution. For more
	// information see [Specifying Amazon EC2 Security Groups for Amazon EMR Notebooks]in the EMR Management Guide.
	//
	// [Specifying Amazon EC2 Security Groups for Amazon EMR Notebooks]: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html
	MasterInstanceSecurityGroupId *string

	// The type of execution engine. A value of EMR specifies an Amazon EMR cluster.
	Type ExecutionEngineType

	noSmithyDocumentSerde
}

// The details of the step failure. The service attempts to detect the root cause
// for many common failures.
type FailureDetails struct {

	// The path to the log file where the step failure root cause was originally
	// recorded.
	LogFile *string

	// The descriptive message including the error the Amazon EMR service has
	// identified as the cause of step failure. This is text from an error log that
	// describes the root cause of the failure.
	Message *string

	// The reason for the step failure. In the case where the service cannot
	// successfully determine the root cause of the failure, it returns "Unknown Error"
	// as a reason.
	Reason *string

	noSmithyDocumentSerde
}

// A job flow step consisting of a JAR file whose main function will be executed.
// The main function submits a job for Hadoop to execute and waits for the job to
// finish or fail.
type HadoopJarStepConfig struct {

	// A path to a JAR file run during the step.
	//
	// This member is required.
	Jar *string

	// A list of command line arguments passed to the JAR file's main function when
	// executed.
	Args []string

	// The name of the main class in the specified Java file. If not specified, the
	// JAR file should specify a Main-Class in its manifest file.
	MainClass *string

	// A list of Java properties that are set when the step runs. You can use these
	// properties to pass key-value pairs to your main function.
	Properties []KeyValue

	noSmithyDocumentSerde
}

// A cluster step consisting of a JAR file whose main function will be executed.
// The main function submits a job for Hadoop to execute and waits for the job to
// finish or fail.
type HadoopStepConfig struct {

	// The list of command line arguments to pass to the JAR file's main function for
	// execution.
	Args []string

	// The path to the JAR file that runs during the step.
	Jar *string

	// The name of the main class in the specified Java file. If not specified, the
	// JAR file should specify a main class in its manifest file.
	MainClass *string

	// The list of Java properties that are set when the step runs. You can use these
	// properties to pass key-value pairs to your main function.
	Properties map[string]string

	noSmithyDocumentSerde
}

// Represents an Amazon EC2 instance provisioned as part of cluster.
type Instance struct {

	// The list of Amazon EBS volumes that are attached to this instance.
	EbsVolumes []EbsVolume

	// The unique identifier of the instance in Amazon EC2.
	Ec2InstanceId *string

	// The unique identifier for the instance in Amazon EMR.
	Id *string

	// The unique identifier of the instance fleet to which an Amazon EC2 instance
	// belongs.
	InstanceFleetId *string

	// The identifier of the instance group to which this instance belongs.
	InstanceGroupId *string

	// The Amazon EC2 instance type, for example m3.xlarge .
	InstanceType *string

	// The instance purchasing option. Valid values are ON_DEMAND or SPOT .
	Market MarketType

	// The private DNS name of the instance.
	PrivateDnsName *string

	// The private IP address of the instance.
	PrivateIpAddress *string

	// The public DNS name of the instance.
	PublicDnsName *string

	// The public IP address of the instance.
	PublicIpAddress *string

	// The current status of the instance.
	Status *InstanceStatus

	noSmithyDocumentSerde
}

// Describes an instance fleet, which is a group of Amazon EC2 instances that host
// a particular node type (master, core, or task) in an Amazon EMR cluster.
// Instance fleets can consist of a mix of instance types and On-Demand and Spot
// Instances, which are provisioned to meet a defined target capacity.
//
// The instance fleet configuration is available only in Amazon EMR releases 4.8.0
// and later, excluding 5.0.x versions.
type InstanceFleet struct {

	// Reserved.
	Context *string

	// The unique identifier of the instance fleet.
	Id *string

	// The node type that the instance fleet hosts. Valid values are MASTER, CORE, or
	// TASK.
	InstanceFleetType InstanceFleetType

	// An array of specifications for the instance types that comprise an instance
	// fleet.
	InstanceTypeSpecifications []InstanceTypeSpecification

	// Describes the launch specification for an instance fleet.
	LaunchSpecifications *InstanceFleetProvisioningSpecifications

	// A friendly name for the instance fleet.
	Name *string

	// The number of On-Demand units that have been provisioned for the instance fleet
	// to fulfill TargetOnDemandCapacity . This provisioned capacity might be less than
	// or greater than TargetOnDemandCapacity .
	ProvisionedOnDemandCapacity *int32

	// The number of Spot units that have been provisioned for this instance fleet to
	// fulfill TargetSpotCapacity . This provisioned capacity might be less than or
	// greater than TargetSpotCapacity .
	ProvisionedSpotCapacity *int32

	// The resize specification for the instance fleet.
	ResizeSpecifications *InstanceFleetResizingSpecifications

	// The current status of the instance fleet.
	Status *InstanceFleetStatus

	// The target capacity of On-Demand units for the instance fleet, which determines
	// how many On-Demand Instances to provision. When the instance fleet launches,
	// Amazon EMR tries to provision On-Demand Instances as specified by InstanceTypeConfig. Each
	// instance configuration has a specified WeightedCapacity . When an On-Demand
	// Instance is provisioned, the WeightedCapacity units count toward the target
	// capacity. Amazon EMR provisions instances until the target capacity is totally
	// fulfilled, even if this results in an overage. For example, if there are 2 units
	// remaining to fulfill capacity, and Amazon EMR can only provision an instance
	// with a WeightedCapacity of 5 units, the instance is provisioned, and the target
	// capacity is exceeded by 3 units. You can use InstanceFleet$ProvisionedOnDemandCapacityto determine the Spot capacity
	// units that have been provisioned for the instance fleet.
	//
	// If not specified or set to 0, only Spot Instances are provisioned for the
	// instance fleet using TargetSpotCapacity . At least one of TargetSpotCapacity
	// and TargetOnDemandCapacity should be greater than 0. For a master instance
	// fleet, only one of TargetSpotCapacity and TargetOnDemandCapacity can be
	// specified, and its value must be 1.
	TargetOnDemandCapacity *int32

	// The target capacity of Spot units for the instance fleet, which determines how
	// many Spot Instances to provision. When the instance fleet launches, Amazon EMR
	// tries to provision Spot Instances as specified by InstanceTypeConfig. Each instance configuration
	// has a specified WeightedCapacity . When a Spot instance is provisioned, the
	// WeightedCapacity units count toward the target capacity. Amazon EMR provisions
	// instances until the target capacity is totally fulfilled, even if this results
	// in an overage. For example, if there are 2 units remaining to fulfill capacity,
	// and Amazon EMR can only provision an instance with a WeightedCapacity of 5
	// units, the instance is provisioned, and the target capacity is exceeded by 3
	// units. You can use InstanceFleet$ProvisionedSpotCapacityto determine the Spot capacity units that have been
	// provisioned for the instance fleet.
	//
	// If not specified or set to 0, only On-Demand Instances are provisioned for the
	// instance fleet. At least one of TargetSpotCapacity and TargetOnDemandCapacity
	// should be greater than 0. For a master instance fleet, only one of
	// TargetSpotCapacity and TargetOnDemandCapacity can be specified, and its value
	// must be 1.
	TargetSpotCapacity *int32

	noSmithyDocumentSerde
}

// The configuration that defines an instance fleet.
//
// The instance fleet configuration is available only in Amazon EMR releases 4.8.0
// and later, excluding 5.0.x versions.
type InstanceFleetConfig struct {

	// The node type that the instance fleet hosts. Valid values are MASTER, CORE, and
	// TASK.
	//
	// This member is required.
	InstanceFleetType InstanceFleetType

	// Reserved.
	Context *string

	// The instance type configurations that define the Amazon EC2 instances in the
	// instance fleet.
	InstanceTypeConfigs []InstanceTypeConfig

	// The launch specification for the instance fleet.
	LaunchSpecifications *InstanceFleetProvisioningSpecifications

	// The friendly name of the instance fleet.
	Name *string

	// The resize specification for the instance fleet.
	ResizeSpecifications *InstanceFleetResizingSpecifications

	// The target capacity of On-Demand units for the instance fleet, which determines
	// how many On-Demand Instances to provision. When the instance fleet launches,
	// Amazon EMR tries to provision On-Demand Instances as specified by InstanceTypeConfig. Each
	// instance configuration has a specified WeightedCapacity . When an On-Demand
	// Instance is provisioned, the WeightedCapacity units count toward the target
	// capacity. Amazon EMR provisions instances until the target capacity is totally
	// fulfilled, even if this results in an overage. For example, if there are 2 units
	// remaining to fulfill capacity, and Amazon EMR can only provision an instance
	// with a WeightedCapacity of 5 units, the instance is provisioned, and the target
	// capacity is exceeded by 3 units.
	//
	// If not specified or set to 0, only Spot Instances are provisioned for the
	// instance fleet using TargetSpotCapacity . At least one of TargetSpotCapacity
	// and TargetOnDemandCapacity should be greater than 0. For a master instance
	// fleet, only one of TargetSpotCapacity and TargetOnDemandCapacity can be
	// specified, and its value must be 1.
	TargetOnDemandCapacity *int32

	// The target capacity of Spot units for the instance fleet, which determines how
	// many Spot Instances to provision. When the instance fleet launches, Amazon EMR
	// tries to provision Spot Instances as specified by InstanceTypeConfig. Each instance configuration
	// has a specified WeightedCapacity . When a Spot Instance is provisioned, the
	// WeightedCapacity units count toward the target capacity. Amazon EMR provisions
	// instances until the target capacity is totally fulfilled, even if this results
	// in an overage. For example, if there are 2 units remaining to fulfill capacity,
	// and Amazon EMR can only provision an instance with a WeightedCapacity of 5
	// units, the instance is provisioned, and the target capacity is exceeded by 3
	// units.
	//
	// If not specified or set to 0, only On-Demand Instances are provisioned for the
	// instance fleet. At least one of TargetSpotCapacity and TargetOnDemandCapacity
	// should be greater than 0. For a master instance fleet, only one of
	// TargetSpotCapacity and TargetOnDemandCapacity can be specified, and its value
	// must be 1.
	TargetSpotCapacity *int32

	noSmithyDocumentSerde
}

// Configuration parameters for an instance fleet modification request.
//
// The instance fleet configuration is available only in Amazon EMR releases 4.8.0
// and later, excluding 5.0.x versions.
type InstanceFleetModifyConfig struct {

	// A unique identifier for the instance fleet.
	//
	// This member is required.
	InstanceFleetId *string

	// Reserved.
	Context *string

	// An array of InstanceTypeConfig objects that specify how Amazon EMR provisions
	// Amazon EC2 instances when it fulfills On-Demand and Spot capacities. For more
	// information, see [InstanceTypeConfig].
	//
	// [InstanceTypeConfig]: https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceTypeConfig.html
	InstanceTypeConfigs []InstanceTypeConfig

	// The resize specification for the instance fleet.
	ResizeSpecifications *InstanceFleetResizingSpecifications

	// The target capacity of On-Demand units for the instance fleet. For more
	// information see InstanceFleetConfig$TargetOnDemandCapacity.
	TargetOnDemandCapacity *int32

	// The target capacity of Spot units for the instance fleet. For more information,
	// see InstanceFleetConfig$TargetSpotCapacity.
	TargetSpotCapacity *int32

	noSmithyDocumentSerde
}

// The launch specification for On-Demand and Spot Instances in the fleet.
//
// The instance fleet configuration is available only in Amazon EMR releases 4.8.0
// and later, excluding 5.0.x versions. On-Demand and Spot instance allocation
// strategies are available in Amazon EMR releases 5.12.1 and later.
type InstanceFleetProvisioningSpecifications struct {

	//  The launch specification for On-Demand Instances in the instance fleet, which
	// determines the allocation strategy and capacity reservation options.
	//
	// The instance fleet configuration is available only in Amazon EMR releases 4.8.0
	// and later, excluding 5.0.x versions. On-Demand Instances allocation strategy is
	// available in Amazon EMR releases 5.12.1 and later.
	OnDemandSpecification *OnDemandProvisioningSpecification

	// The launch specification for Spot instances in the fleet, which determines the
	// allocation strategy, defined duration, and provisioning timeout behavior.
	SpotSpecification *SpotProvisioningSpecification

	noSmithyDocumentSerde
}

// The resize specification for On-Demand and Spot Instances in the fleet.
type InstanceFleetResizingSpecifications struct {

	// The resize specification for On-Demand Instances in the instance fleet, which
	// contains the allocation strategy, capacity reservation options, and the resize
	// timeout period.
	OnDemandResizeSpecification *OnDemandResizingSpecification

	// The resize specification for Spot Instances in the instance fleet, which
	// contains the allocation strategy and the resize timeout period.
	SpotResizeSpecification *SpotResizingSpecification

	noSmithyDocumentSerde
}

// Provides status change reason details for the instance fleet.
//
// The instance fleet configuration is available only in Amazon EMR releases 4.8.0
// and later, excluding 5.0.x versions.
type InstanceFleetStateChangeReason struct {

	// A code corresponding to the reason the state change occurred.
	Code InstanceFleetStateChangeReasonCode

	// An explanatory message.
	Message *string

	noSmithyDocumentSerde
}

// The status of the instance fleet.
//
// The instance fleet configuration is available only in Amazon EMR releases 4.8.0
// and later, excluding 5.0.x versions.
type InstanceFleetStatus struct {

	// A code representing the instance fleet status.
	//
	//   - PROVISIONING —The instance fleet is provisioning Amazon EC2 resources and is
	//   not yet ready to run jobs.
	//
	//   - BOOTSTRAPPING —Amazon EC2 instances and other resources have been
	//   provisioned and the bootstrap actions specified for the instances are underway.
	//
	//   - RUNNING —Amazon EC2 instances and other resources are running. They are
	//   either executing jobs or waiting to execute jobs.
	//
	//   - RESIZING —A resize operation is underway. Amazon EC2 instances are either
	//   being added or removed.
	//
	//   - SUSPENDED —A resize operation could not complete. Existing Amazon EC2
	//   instances are running, but instances can't be added or removed.
	//
	//   - TERMINATING —The instance fleet is terminating Amazon EC2 instances.
	//
	//   - TERMINATED —The instance fleet is no longer active, and all Amazon EC2
	//   instances have been terminated.
	State InstanceFleetState

	// Provides status change reason details for the instance fleet.
	StateChangeReason *InstanceFleetStateChangeReason

	// Provides historical timestamps for the instance fleet, including the time of
	// creation, the time it became ready to run jobs, and the time of termination.
	Timeline *InstanceFleetTimeline

	noSmithyDocumentSerde
}

// Provides historical timestamps for the instance fleet, including the time of
// creation, the time it became ready to run jobs, and the time of termination.
//
// The instance fleet configuration is available only in Amazon EMR releases 4.8.0
// and later, excluding 5.0.x versions.
type InstanceFleetTimeline struct {

	// The time and date the instance fleet was created.
	CreationDateTime *time.Time

	// The time and date the instance fleet terminated.
	EndDateTime *time.Time

	// The time and date the instance fleet was ready to run jobs.
	ReadyDateTime *time.Time

	noSmithyDocumentSerde
}

// This entity represents an instance group, which is a group of instances that
// have common purpose. For example, CORE instance group is used for HDFS.
type InstanceGroup struct {

	// An automatic scaling policy for a core instance group or task instance group in
	// an Amazon EMR cluster. The automatic scaling policy defines how an instance
	// group dynamically adds and terminates Amazon EC2 instances in response to the
	// value of a CloudWatch metric. See PutAutoScalingPolicy.
	AutoScalingPolicy *AutoScalingPolicyDescription

	// If specified, indicates that the instance group uses Spot Instances. This is
	// the maximum price you are willing to pay for Spot Instances. Specify
	// OnDemandPrice to set the amount equal to the On-Demand price, or specify an
	// amount in USD.
	BidPrice *string

	// Amazon EMR releases 4.x or later.
	//
	// The list of configurations supplied for an Amazon EMR cluster instance group.
	// You can specify a separate configuration for each instance group (master, core,
	// and task).
	Configurations []Configuration

	// The version number of the requested configuration specification for this
	// instance group.
	ConfigurationsVersion *int64

	// The custom AMI ID to use for the provisioned instance group.
	CustomAmiId *string

	// The EBS block devices that are mapped to this instance group.
	EbsBlockDevices []EbsBlockDevice

	// If the instance group is EBS-optimized. An Amazon EBS-optimized instance uses
	// an optimized configuration stack and provides additional, dedicated capacity for
	// Amazon EBS I/O.
	EbsOptimized *bool

	// The identifier of the instance group.
	Id *string

	// The type of the instance group. Valid values are MASTER, CORE or TASK.
	InstanceGroupType InstanceGroupType

	// The Amazon EC2 instance type for all instances in the instance group.
	InstanceType *string

	// A list of configurations that were successfully applied for an instance group
	// last time.
	LastSuccessfullyAppliedConfigurations []Configuration

	// The version number of a configuration specification that was successfully
	// applied for an instance group last time.
	LastSuccessfullyAppliedConfigurationsVersion *int64

	// The marketplace to provision instances for this group. Valid values are
	// ON_DEMAND or SPOT.
	Market MarketType

	// The name of the instance group.
	Name *string

	// The target number of instances for the instance group.
	RequestedInstanceCount *int32

	// The number of instances currently running in this instance group.
	RunningInstanceCount *int32

	// Policy for customizing shrink operations.
	ShrinkPolicy *ShrinkPolicy

	// The current status of the instance group.
	Status *InstanceGroupStatus

	noSmithyDocumentSerde
}

// Configuration defining a new instance group.
type InstanceGroupConfig struct {

	// Target number of instances for the instance group.
	//
	// This member is required.
	InstanceCount *int32

	// The role of the instance group in the cluster.
	//
	// This member is required.
	InstanceRole InstanceRoleType

	// The Amazon EC2 instance type for all instances in the instance group.
	//
	// This member is required.
	InstanceType *string

	// An automatic scaling policy for a core instance group or task instance group in
	// an Amazon EMR cluster. The automatic scaling policy defines how an instance
	// group dynamically adds and terminates Amazon EC2 instances in response to the
	// value of a CloudWatch metric. See PutAutoScalingPolicy.
	AutoScalingPolicy *AutoScalingPolicy

	// If specified, indicates that the instance group uses Spot Instances. This is
	// the maximum price you are willing to pay for Spot Instances. Specify
	// OnDemandPrice to set the amount equal to the On-Demand price, or specify an
	// amount in USD.
	BidPrice *string

	// Amazon EMR releases 4.x or later.
	//
	// The list of configurations supplied for an Amazon EMR cluster instance group.
	// You can specify a separate configuration for each instance group (master, core,
	// and task).
	Configurations []Configuration

	// The custom AMI ID to use for the provisioned instance group.
	CustomAmiId *string

	// EBS configurations that will be attached to each Amazon EC2 instance in the
	// instance group.
	EbsConfiguration *EbsConfiguration

	// Market type of the Amazon EC2 instances used to create a cluster node.
	Market MarketType

	// Friendly name given to the instance group.
	Name *string

	noSmithyDocumentSerde
}

// Detailed information about an instance group.
type InstanceGroupDetail struct {

	// The date/time the instance group was created.
	//
	// This member is required.
	CreationDateTime *time.Time

	// Target number of instances to run in the instance group.
	//
	// This member is required.
	InstanceRequestCount *int32

	// Instance group role in the cluster
	//
	// This member is required.
	InstanceRole InstanceRoleType

	// Actual count of running instances.
	//
	// This member is required.
	InstanceRunningCount *int32

	// Amazon EC2 instance type.
	//
	// This member is required.
	InstanceType *string

	// Market type of the Amazon EC2 instances used to create a cluster node.
	//
	// This member is required.
	Market MarketType

	// State of instance group. The following values are no longer supported:
	// STARTING, TERMINATED, and FAILED.
	//
	// This member is required.
	State InstanceGroupState

	// If specified, indicates that the instance group uses Spot Instances. This is
	// the maximum price you are willing to pay for Spot Instances. Specify
	// OnDemandPrice to set the amount equal to the On-Demand price, or specify an
	// amount in USD.
	BidPrice *string

	// The custom AMI ID to use for the provisioned instance group.
	CustomAmiId *string

	// The date/time the instance group was terminated.
	EndDateTime *time.Time

	// Unique identifier for the instance group.
	InstanceGroupId *string

	// Details regarding the state of the instance group.
	LastStateChangeReason *string

	// Friendly name for the instance group.
	Name *string

	// The date/time the instance group was available to the cluster.
	ReadyDateTime *time.Time

	// The date/time the instance group was started.
	StartDateTime *time.Time

	noSmithyDocumentSerde
}

// Modify the size or configurations of an instance group.
type InstanceGroupModifyConfig struct {

	// Unique ID of the instance group to modify.
	//
	// This member is required.
	InstanceGroupId *string

	// A list of new or modified configurations to apply for an instance group.
	Configurations []Configuration

	// The Amazon EC2 InstanceIds to terminate. After you terminate the instances, the
	// instance group will not return to its original requested size.
	EC2InstanceIdsToTerminate []string

	// Target size for the instance group.
	InstanceCount *int32

	// Type of reconfiguration requested. Valid values are MERGE and OVERWRITE.
	ReconfigurationType ReconfigurationType

	// Policy for customizing shrink operations.
	ShrinkPolicy *ShrinkPolicy

	noSmithyDocumentSerde
}

// The status change reason details for the instance group.
type InstanceGroupStateChangeReason struct {

	// The programmable code for the state change reason.
	Code InstanceGroupStateChangeReasonCode

	// The status change reason description.
	Message *string

	noSmithyDocumentSerde
}

// The details of the instance group status.
type InstanceGroupStatus struct {

	// The current state of the instance group.
	State InstanceGroupState

	// The status change reason details for the instance group.
	StateChangeReason *InstanceGroupStateChangeReason

	// The timeline of the instance group status over time.
	Timeline *InstanceGroupTimeline

	noSmithyDocumentSerde
}

// The timeline of the instance group lifecycle.
type InstanceGroupTimeline struct {

	// The creation date and time of the instance group.
	CreationDateTime *time.Time

	// The date and time when the instance group terminated.
	EndDateTime *time.Time

	// The date and time when the instance group became ready to perform tasks.
	ReadyDateTime *time.Time

	noSmithyDocumentSerde
}

// Custom policy for requesting termination protection or termination of specific
// instances when shrinking an instance group.
type InstanceResizePolicy struct {

	// Decommissioning timeout override for the specific list of instances to be
	// terminated.
	InstanceTerminationTimeout *int32

	// Specific list of instances to be protected when shrinking an instance group.
	InstancesToProtect []string

	// Specific list of instances to be terminated when shrinking an instance group.
	InstancesToTerminate []string

	noSmithyDocumentSerde
}

// The details of the status change reason for the instance.
type InstanceStateChangeReason struct {

	// The programmable code for the state change reason.
	Code InstanceStateChangeReasonCode

	// The status change reason description.
	Message *string

	noSmithyDocumentSerde
}

// The instance status details.
type InstanceStatus struct {

	// The current state of the instance.
	State InstanceState

	// The details of the status change reason for the instance.
	StateChangeReason *InstanceStateChangeReason

	// The timeline of the instance status over time.
	Timeline *InstanceTimeline

	noSmithyDocumentSerde
}

// The timeline of the instance lifecycle.
type InstanceTimeline struct {

	// The creation date and time of the instance.
	CreationDateTime *time.Time

	// The date and time when the instance was terminated.
	EndDateTime *time.Time

	// The date and time when the instance was ready to perform tasks.
	ReadyDateTime *time.Time

	noSmithyDocumentSerde
}

// An instance type configuration for each instance type in an instance fleet,
// which determines the Amazon EC2 instances Amazon EMR attempts to provision to
// fulfill On-Demand and Spot target capacities. When you use an allocation
// strategy, you can include a maximum of 30 instance type configurations for a
// fleet. For more information about how to use an allocation strategy, see [Configure Instance Fleets].
// Without an allocation strategy, you may specify a maximum of five instance type
// configurations for a fleet.
//
// The instance fleet configuration is available only in Amazon EMR releases 4.8.0
// and later, excluding 5.0.x versions.
//
// [Configure Instance Fleets]: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html
type InstanceTypeConfig struct {

	// An Amazon EC2 instance type, such as m3.xlarge .
	//
	// This member is required.
	InstanceType *string

	// The bid price for each Amazon EC2 Spot Instance type as defined by InstanceType
	// . Expressed in USD. If neither BidPrice nor BidPriceAsPercentageOfOnDemandPrice
	// is provided, BidPriceAsPercentageOfOnDemandPrice defaults to 100%.
	BidPrice *string

	// The bid price, as a percentage of On-Demand price, for each Amazon EC2 Spot
	// Instance as defined by InstanceType . Expressed as a number (for example, 20
	// specifies 20%). If neither BidPrice nor BidPriceAsPercentageOfOnDemandPrice is
	// provided, BidPriceAsPercentageOfOnDemandPrice defaults to 100%.
	BidPriceAsPercentageOfOnDemandPrice *float64

	// A configuration classification that applies when provisioning cluster
	// instances, which can include configurations for applications and software that
	// run on the cluster.
	Configurations []Configuration

	// The custom AMI ID to use for the instance type.
	CustomAmiId *string

	// The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each
	// instance as defined by InstanceType .
	EbsConfiguration *EbsConfiguration

	// The priority at which Amazon EMR launches the Amazon EC2 instances with this
	// instance type. Priority starts at 0, which is the highest priority. Amazon EMR
	// considers the highest priority first.
	Priority *float64

	// The number of units that a provisioned instance of this type provides toward
	// fulfilling the target capacities defined in InstanceFleetConfig. This value is 1 for a master
	// instance fleet, and must be 1 or greater for core and task instance fleets.
	// Defaults to 1 if not specified.
	WeightedCapacity *int32

	noSmithyDocumentSerde
}

// The configuration specification for each instance type in an instance fleet.
//
// The instance fleet configuration is available only in Amazon EMR releases 4.8.0
// and later, excluding 5.0.x versions.
type InstanceTypeSpecification struct {

	// The bid price for each Amazon EC2 Spot Instance type as defined by InstanceType
	// . Expressed in USD.
	BidPrice *string

	// The bid price, as a percentage of On-Demand price, for each Amazon EC2 Spot
	// Instance as defined by InstanceType . Expressed as a number (for example, 20
	// specifies 20%).
	BidPriceAsPercentageOfOnDemandPrice *float64

	// A configuration classification that applies when provisioning cluster
	// instances, which can include configurations for applications and software
	// bundled with Amazon EMR.
	Configurations []Configuration

	// The custom AMI ID to use for the instance type.
	CustomAmiId *string

	// The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each
	// instance as defined by InstanceType .
	EbsBlockDevices []EbsBlockDevice

	// Evaluates to TRUE when the specified InstanceType is EBS-optimized.
	EbsOptimized *bool

	// The Amazon EC2 instance type, for example m3.xlarge .
	InstanceType *string

	// The priority at which Amazon EMR launches the Amazon EC2 instances with this
	// instance type. Priority starts at 0, which is the highest priority. Amazon EMR
	// considers the highest priority first.
	Priority *float64

	// The number of units that a provisioned instance of this type provides toward
	// fulfilling the target capacities defined in InstanceFleetConfig. Capacity values represent
	// performance characteristics such as vCPUs, memory, or I/O. If not specified, the
	// default value is 1.
	WeightedCapacity *int32

	noSmithyDocumentSerde
}

// A description of a cluster (job flow).
type JobFlowDetail struct {

	// Describes the execution status of the job flow.
	//
	// This member is required.
	ExecutionStatusDetail *JobFlowExecutionStatusDetail

	// Describes the Amazon EC2 instances of the job flow.
	//
	// This member is required.
	Instances *JobFlowInstancesDetail

	// The job flow identifier.
	//
	// This member is required.
	JobFlowId *string

	// The name of the job flow.
	//
	// This member is required.
	Name *string

	// Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases
	// 4.0 and later, ReleaseLabel is used. To specify a custom AMI, use CustomAmiID .
	AmiVersion *string

	// An IAM role for automatic scaling policies. The default role is
	// EMR_AutoScaling_DefaultRole . The IAM role provides a way for the automatic
	// scaling feature to get the required permissions it needs to launch and terminate
	// Amazon EC2 instances in an instance group.
	AutoScalingRole *string

	// A list of the bootstrap actions run by the job flow.
	BootstrapActions []BootstrapActionDetail

	// The IAM role that was specified when the job flow was launched. The Amazon EC2
	// instances of the job flow assume this role.
	JobFlowRole *string

	// The KMS key used for encrypting log files. This attribute is only available
	// with Amazon EMR 5.30.0 and later, excluding 6.0.0.
	LogEncryptionKmsKeyId *string

	// The location in Amazon S3 where log files for the job are stored.
	LogUri *string

	// The way that individual Amazon EC2 instances terminate when an automatic
	// scale-in activity occurs or an instance group is resized.
	// TERMINATE_AT_INSTANCE_HOUR indicates that Amazon EMR terminates nodes at the
	// instance-hour boundary, regardless of when the request to terminate the instance
	// was submitted. This option is only available with Amazon EMR 5.1.0 and later and
	// is the default for clusters created using that version.
	// TERMINATE_AT_TASK_COMPLETION indicates that Amazon EMR adds nodes to a deny list
	// and drains tasks from nodes before terminating the Amazon EC2 instances,
	// regardless of the instance-hour boundary. With either behavior, Amazon EMR
	// removes the least active nodes first and blocks instance termination if it could
	// lead to HDFS corruption. TERMINATE_AT_TASK_COMPLETION available only in Amazon
	// EMR releases 4.1.0 and later, and is the default for releases of Amazon EMR
	// earlier than 5.1.0.
	ScaleDownBehavior ScaleDownBehavior

	// The IAM role that is assumed by the Amazon EMR service to access Amazon Web
	// Services resources on your behalf.
	ServiceRole *string

	// A list of steps run by the job flow.
	Steps []StepDetail

	// A list of strings set by third-party software when the job flow is launched. If
	// you are not using third-party software to manage the job flow, this value is
	// empty.
	SupportedProducts []string

	// Indicates whether the cluster is visible to IAM principals in the Amazon Web
	// Services account associated with the cluster. When true , IAM principals in the
	// Amazon Web Services account can perform Amazon EMR cluster actions that their
	// IAM policies allow. When false , only the IAM principal that created the cluster
	// and the Amazon Web Services account root user can perform Amazon EMR actions,
	// regardless of IAM permissions policies attached to other IAM principals.
	//
	// The default value is true if a value is not provided when creating a cluster
	// using the Amazon EMR API RunJobFlowcommand, the CLI [create-cluster] command, or the Amazon Web Services
	// Management Console.
	//
	// [create-cluster]: https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html
	VisibleToAllUsers *bool

	noSmithyDocumentSerde
}

// Describes the status of the cluster (job flow).
type JobFlowExecutionStatusDetail struct {

	// The creation date and time of the job flow.
	//
	// This member is required.
	CreationDateTime *time.Time

	// The state of the job flow.
	//
	// This member is required.
	State JobFlowExecutionState

	// The completion date and time of the job flow.
	EndDateTime *time.Time

	// Description of the job flow last changed state.
	LastStateChangeReason *string

	// The date and time when the job flow was ready to start running bootstrap
	// actions.
	ReadyDateTime *time.Time

	// The start date and time of the job flow.
	StartDateTime *time.Time

	noSmithyDocumentSerde
}

// A description of the Amazon EC2 instance on which the cluster (job flow) runs.
// A valid JobFlowInstancesConfig must contain either InstanceGroups or
// InstanceFleets. They cannot be used together. You may also have
// MasterInstanceType, SlaveInstanceType, and InstanceCount (all three must be
// present), but we don't recommend this configuration.
type JobFlowInstancesConfig struct {

	// A list of additional Amazon EC2 security group IDs for the master node.
	AdditionalMasterSecurityGroups []string

	// A list of additional Amazon EC2 security group IDs for the core and task nodes.
	AdditionalSlaveSecurityGroups []string

	// The name of the Amazon EC2 key pair that can be used to connect to the master
	// node using SSH as the user called "hadoop."
	Ec2KeyName *string

	// Applies to clusters that use the uniform instance group configuration. To
	// launch the cluster in Amazon Virtual Private Cloud (Amazon VPC), set this
	// parameter to the identifier of the Amazon VPC subnet where you want the cluster
	// to launch. If you do not specify this value and your account supports
	// EC2-Classic, the cluster launches in EC2-Classic.
	Ec2SubnetId *string

	// Applies to clusters that use the instance fleet configuration. When multiple
	// Amazon EC2 subnet IDs are specified, Amazon EMR evaluates them and launches
	// instances in the optimal subnet.
	//
	// The instance fleet configuration is available only in Amazon EMR releases 4.8.0
	// and later, excluding 5.0.x versions.
	Ec2SubnetIds []string

	// The identifier of the Amazon EC2 security group for the master node. If you
	// specify EmrManagedMasterSecurityGroup , you must also specify
	// EmrManagedSlaveSecurityGroup .
	EmrManagedMasterSecurityGroup *string

	// The identifier of the Amazon EC2 security group for the core and task nodes. If
	// you specify EmrManagedSlaveSecurityGroup , you must also specify
	// EmrManagedMasterSecurityGroup .
	EmrManagedSlaveSecurityGroup *string

	// Applies only to Amazon EMR release versions earlier than 4.0. The Hadoop
	// version for the cluster. Valid inputs are "0.18" (no longer maintained), "0.20"
	// (no longer maintained), "0.20.205" (no longer maintained), "1.0.3", "2.2.0", or
	// "2.4.0". If you do not set this value, the default of 0.18 is used, unless the
	// AmiVersion parameter is set in the RunJobFlow call, in which case the default
	// version of Hadoop for that AMI version is used.
	HadoopVersion *string

	// The number of Amazon EC2 instances in the cluster.
	InstanceCount *int32

	// The instance fleet configuration is available only in Amazon EMR releases 4.8.0
	// and later, excluding 5.0.x versions.
	//
	// Describes the Amazon EC2 instances and instance configurations for clusters
	// that use the instance fleet configuration.
	InstanceFleets []InstanceFleetConfig

	// Configuration for the instance groups in a cluster.
	InstanceGroups []InstanceGroupConfig

	// Specifies whether the cluster should remain available after completing all
	// steps. Defaults to false . For more information about configuring cluster
	// termination, see [Control Cluster Termination]in the EMR Management Guide.
	//
	// [Control Cluster Termination]: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html
	KeepJobFlowAliveWhenNoSteps *bool

	// The Amazon EC2 instance type of the master node.
	MasterInstanceType *string

	// The Availability Zone in which the cluster runs.
	Placement *PlacementType

	// The identifier of the Amazon EC2 security group for the Amazon EMR service to
	// access clusters in VPC private subnets.
	ServiceAccessSecurityGroup *string

	// The Amazon EC2 instance type of the core and task nodes.
	SlaveInstanceType *string

	// Specifies whether to lock the cluster to prevent the Amazon EC2 instances from
	// being terminated by API call, user intervention, or in the event of a job-flow
	// error.
	TerminationProtected *bool

	// Indicates whether Amazon EMR should gracefully replace core nodes that have
	// degraded within the cluster.
	UnhealthyNodeReplacement *bool

	noSmithyDocumentSerde
}

// Specify the type of Amazon EC2 instances that the cluster (job flow) runs on.
type JobFlowInstancesDetail struct {

	// The number of Amazon EC2 instances in the cluster. If the value is 1, the same
	// instance serves as both the master and core and task node. If the value is
	// greater than 1, one instance is the master node and all others are core and task
	// nodes.
	//
	// This member is required.
	InstanceCount *int32

	// The Amazon EC2 master node instance type.
	//
	// This member is required.
	MasterInstanceType *string

	// The Amazon EC2 core and task node instance type.
	//
	// This member is required.
	SlaveInstanceType *string

	// The name of an Amazon EC2 key pair that can be used to connect to the master
	// node using SSH.
	Ec2KeyName *string

	// For clusters launched within Amazon Virtual Private Cloud, this is the
	// identifier of the subnet where the cluster was launched.
	Ec2SubnetId *string

	// The Hadoop version for the cluster.
	HadoopVersion *string

	// Details about the instance groups in a cluster.
	InstanceGroups []InstanceGroupDetail

	// Specifies whether the cluster should remain available after completing all
	// steps.
	KeepJobFlowAliveWhenNoSteps *bool

	// The Amazon EC2 instance identifier of the master node.
	MasterInstanceId *string

	// The DNS name of the master node. If the cluster is on a private subnet, this is
	// the private DNS name. On a public subnet, this is the public DNS name.
	MasterPublicDnsName *string

	// An approximation of the cost of the cluster, represented in m1.small/hours.
	// This value is increased one time for every hour that an m1.small instance runs.
	// Larger instances are weighted more heavily, so an Amazon EC2 instance that is
	// roughly four times more expensive would result in the normalized instance hours
	// being increased incrementally four times. This result is only an approximation
	// and does not reflect the actual billing rate.
	NormalizedInstanceHours *int32

	// The Amazon EC2 Availability Zone for the cluster.
	Placement *PlacementType

	// Specifies whether the Amazon EC2 instances in the cluster are protected from
	// termination by API calls, user intervention, or in the event of a job-flow
	// error.
	TerminationProtected *bool

	// Indicates whether Amazon EMR should gracefully replace core nodes that have
	// degraded within the cluster.
	UnhealthyNodeReplacement *bool

	noSmithyDocumentSerde
}

// Attributes for Kerberos configuration when Kerberos authentication is enabled
// using a security configuration. For more information see [Use Kerberos Authentication]in the Amazon EMR
// Management Guide.
//
// [Use Kerberos Authentication]: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html
type KerberosAttributes struct {

	// The password used within the cluster for the kadmin service on the
	// cluster-dedicated KDC, which maintains Kerberos principals, password policies,
	// and keytabs for the cluster.
	//
	// This member is required.
	KdcAdminPassword *string

	// The name of the Kerberos realm to which all nodes in a cluster belong. For
	// example, EC2.INTERNAL .
	//
	// This member is required.
	Realm *string

	// The Active Directory password for ADDomainJoinUser .
	ADDomainJoinPassword *string

	// Required only when establishing a cross-realm trust with an Active Directory
	// domain. A user with sufficient privileges to join resources to the domain.
	ADDomainJoinUser *string

	// Required only when establishing a cross-realm trust with a KDC in a different
	// realm. The cross-realm principal password, which must be identical across
	// realms.
	CrossRealmTrustPrincipalPassword *string

	noSmithyDocumentSerde
}

// A key-value pair.
type KeyValue struct {

	// The unique identifier of a key-value pair.
	Key *string

	// The value part of the identified key.
	Value *string

	noSmithyDocumentSerde
}

//	Managed scaling policy for an Amazon EMR cluster. The policy specifies the
//
// limits for resources that can be added or terminated from a cluster. The policy
// only applies to the core and task nodes. The master node cannot be scaled after
// initial configuration.
type ManagedScalingPolicy struct {

	// The Amazon EC2 unit limits for a managed scaling policy. The managed scaling
	// activity of a cluster is not allowed to go above or below these limits. The
	// limit only applies to the core and task nodes. The master node cannot be scaled
	// after initial configuration.
	ComputeLimits *ComputeLimits

	// Determines whether a custom scaling utilization performance index can be set.
	// Possible values include ADVANCED or DEFAULT.
	ScalingStrategy ScalingStrategy

	// An integer value that represents an advanced scaling strategy. Setting a higher
	// value optimizes for performance. Setting a lower value optimizes for resource
	// conservation. Setting the value to 50 balances performance and resource
	// conservation. Possible values are 1, 25, 50, 75, and 100.
	UtilizationPerformanceIndex *int32

	noSmithyDocumentSerde
}

// A CloudWatch dimension, which is specified using a Key (known as a Name in
// CloudWatch), Value pair. By default, Amazon EMR uses one dimension whose Key is
// JobFlowID and Value is a variable representing the cluster ID, which is
// ${emr.clusterId} . This enables the rule to bootstrap when the cluster ID
// becomes available.
type MetricDimension struct {

	// The dimension name.
	Key *string

	// The dimension value.
	Value *string

	noSmithyDocumentSerde
}

// A notebook execution. An execution is a specific instance that an Amazon EMR
// Notebook is run using the StartNotebookExecution action.
type NotebookExecution struct {

	// The Amazon Resource Name (ARN) of the notebook execution.
	Arn *string

	// The unique identifier of the Amazon EMR Notebook that is used for the notebook
	// execution.
	EditorId *string

	// The timestamp when notebook execution ended.
	EndTime *time.Time

	// The environment variables associated with the notebook execution.
	EnvironmentVariables map[string]string

	// The execution engine, such as an Amazon EMR cluster, used to run the Amazon EMR
	// notebook and perform the notebook execution.
	ExecutionEngine *ExecutionEngineConfig

	// The reason for the latest status change of the notebook execution.
	LastStateChangeReason *string

	// The unique identifier of a notebook execution.
	NotebookExecutionId *string

	// A name for the notebook execution.
	NotebookExecutionName *string

	// The unique identifier of the Amazon EC2 security group associated with the
	// Amazon EMR Notebook instance. For more information see [Specifying Amazon EC2 Security Groups for Amazon EMR Notebooks]in the Amazon EMR
	// Management Guide.
	//
	// [Specifying Amazon EC2 Security Groups for Amazon EMR Notebooks]: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html
	NotebookInstanceSecurityGroupId *string

	// Input parameters in JSON format passed to the Amazon EMR Notebook at runtime
	// for execution.
	NotebookParams *string

	// The Amazon S3 location that stores the notebook execution input.
	NotebookS3Location *NotebookS3LocationForOutput

	// The output format for the notebook execution.
	OutputNotebookFormat OutputNotebookFormat

	// The Amazon S3 location for the notebook execution output.
	OutputNotebookS3Location *OutputNotebookS3LocationForOutput

	// The location of the notebook execution's output file in Amazon S3.
	OutputNotebookURI *string

	// The timestamp when notebook execution started.
	StartTime *time.Time

	// The status of the notebook execution.
	//
	//   - START_PENDING indicates that the cluster has received the execution request
	//   but execution has not begun.
	//
	//   - STARTING indicates that the execution is starting on the cluster.
	//
	//   - RUNNING indicates that the execution is being processed by the cluster.
	//
	//   - FINISHING indicates that execution processing is in the final stages.
	//
	//   - FINISHED indicates that the execution has completed without error.
	//
	//   - FAILING indicates that the execution is failing and will not finish
	//   successfully.
	//
	//   - FAILED indicates that the execution failed.
	//
	//   - STOP_PENDING indicates that the cluster has received a StopNotebookExecution
	//   request and the stop is pending.
	//
	//   - STOPPING indicates that the cluster is in the process of stopping the
	//   execution as a result of a StopNotebookExecution request.
	//
	//   - STOPPED indicates that the execution stopped because of a
	//   StopNotebookExecution request.
	Status NotebookExecutionStatus

	// A list of tags associated with a notebook execution. Tags are user-defined
	// key-value pairs that consist of a required key string with a maximum of 128
	// characters and an optional value string with a maximum of 256 characters.
	Tags []Tag

	noSmithyDocumentSerde
}

// Details for a notebook execution. The details include information such as the
// unique ID and status of the notebook execution.
type NotebookExecutionSummary struct {

	// The unique identifier of the editor associated with the notebook execution.
	EditorId *string

	// The timestamp when notebook execution started.
	EndTime *time.Time

	// The unique ID of the execution engine for the notebook execution.
	ExecutionEngineId *string

	// The unique identifier of the notebook execution.
	NotebookExecutionId *string

	// The name of the notebook execution.
	NotebookExecutionName *string

	// The Amazon S3 location that stores the notebook execution input.
	NotebookS3Location *NotebookS3LocationForOutput

	// The timestamp when notebook execution started.
	StartTime *time.Time

	// The status of the notebook execution.
	//
	//   - START_PENDING indicates that the cluster has received the execution request
	//   but execution has not begun.
	//
	//   - STARTING indicates that the execution is starting on the cluster.
	//
	//   - RUNNING indicates that the execution is being processed by the cluster.
	//
	//   - FINISHING indicates that execution processing is in the final stages.
	//
	//   - FINISHED indicates that the execution has completed without error.
	//
	//   - FAILING indicates that the execution is failing and will not finish
	//   successfully.
	//
	//   - FAILED indicates that the execution failed.
	//
	//   - STOP_PENDING indicates that the cluster has received a StopNotebookExecution
	//   request and the stop is pending.
	//
	//   - STOPPING indicates that the cluster is in the process of stopping the
	//   execution as a result of a StopNotebookExecution request.
	//
	//   - STOPPED indicates that the execution stopped because of a
	//   StopNotebookExecution request.
	Status NotebookExecutionStatus

	noSmithyDocumentSerde
}

// The Amazon S3 location that stores the notebook execution input.
type NotebookS3LocationForOutput struct {

	// The Amazon S3 bucket that stores the notebook execution input.
	Bucket *string

	// The key to the Amazon S3 location that stores the notebook execution input.
	Key *string

	noSmithyDocumentSerde
}

// The Amazon S3 location that stores the notebook execution input.
type NotebookS3LocationFromInput struct {

	// The Amazon S3 bucket that stores the notebook execution input.
	Bucket *string

	// The key to the Amazon S3 location that stores the notebook execution input.
	Key *string

	noSmithyDocumentSerde
}

// Describes the strategy for using unused Capacity Reservations for fulfilling
// On-Demand capacity.
type OnDemandCapacityReservationOptions struct {

	// Indicates the instance's Capacity Reservation preferences. Possible preferences
	// include:
	//
	//   - open - The instance can run in any open Capacity Reservation that has
	//   matching attributes (instance type, platform, Availability Zone).
	//
	//   - none - The instance avoids running in a Capacity Reservation even if one is
	//   available. The instance runs as an On-Demand Instance.
	CapacityReservationPreference OnDemandCapacityReservationPreference

	// The ARN of the Capacity Reservation resource group in which to run the instance.
	CapacityReservationResourceGroupArn *string

	// Indicates whether to use unused Capacity Reservations for fulfilling On-Demand
	// capacity.
	//
	// If you specify use-capacity-reservations-first , the fleet uses unused Capacity
	// Reservations to fulfill On-Demand capacity up to the target On-Demand capacity.
	// If multiple instance pools have unused Capacity Reservations, the On-Demand
	// allocation strategy ( lowest-price ) is applied. If the number of unused
	// Capacity Reservations is less than the On-Demand target capacity, the remaining
	// On-Demand target capacity is launched according to the On-Demand allocation
	// strategy ( lowest-price ).
	//
	// If you do not specify a value, the fleet fulfills the On-Demand capacity
	// according to the chosen On-Demand allocation strategy.
	UsageStrategy OnDemandCapacityReservationUsageStrategy

	noSmithyDocumentSerde
}

//	The launch specification for On-Demand Instances in the instance fleet, which
//
// determines the allocation strategy.
//
// The instance fleet configuration is available only in Amazon EMR releases 4.8.0
// and later, excluding 5.0.x versions. On-Demand Instances allocation strategy is
// available in Amazon EMR releases 5.12.1 and later.
type OnDemandProvisioningSpecification struct {

	// Specifies the strategy to use in launching On-Demand instance fleets. Available
	// options are lowest-price and prioritized . lowest-price specifies to launch the
	// instances with the lowest price first, and prioritized specifies that Amazon
	// EMR should launch the instances with the highest priority first. The default is
	// lowest-price .
	//
	// This member is required.
	AllocationStrategy OnDemandProvisioningAllocationStrategy

	// The launch specification for On-Demand instances in the instance fleet, which
	// determines the allocation strategy.
	CapacityReservationOptions *OnDemandCapacityReservationOptions

	noSmithyDocumentSerde
}

// The resize specification for On-Demand Instances in the instance fleet, which
// contains the resize timeout period.
type OnDemandResizingSpecification struct {

	// Specifies the allocation strategy to use to launch On-Demand instances during a
	// resize. The default is lowest-price .
	AllocationStrategy OnDemandProvisioningAllocationStrategy

	// Describes the strategy for using unused Capacity Reservations for fulfilling
	// On-Demand capacity.
	CapacityReservationOptions *OnDemandCapacityReservationOptions

	// On-Demand resize timeout in minutes. If On-Demand Instances are not provisioned
	// within this time, the resize workflow stops. The minimum value is 5 minutes, and
	// the maximum value is 10,080 minutes (7 days). The timeout applies to all resize
	// workflows on the Instance Fleet. The resize could be triggered by Amazon EMR
	// Managed Scaling or by the customer (via Amazon EMR Console, Amazon EMR CLI
	// modify-instance-fleet or Amazon EMR SDK ModifyInstanceFleet API) or by Amazon
	// EMR due to Amazon EC2 Spot Reclamation.
	TimeoutDurationMinutes *int32

	noSmithyDocumentSerde
}

// The Amazon Linux release specified for a cluster in the RunJobFlow request.
type OSRelease struct {

	// The Amazon Linux release specified for a cluster in the RunJobFlow request. The
	// format is as shown in [Amazon Linux 2 Release Notes]. For example, 2.0.20220218.1.
	//
	// [Amazon Linux 2 Release Notes]: https://docs.aws.amazon.com/AL2/latest/relnotes/relnotes-20220218.html
	Label *string

	noSmithyDocumentSerde
}

// The Amazon S3 location that stores the notebook execution output.
type OutputNotebookS3LocationForOutput struct {

	// The Amazon S3 bucket that stores the notebook execution output.
	Bucket *string

	// The key to the Amazon S3 location that stores the notebook execution output.
	Key *string

	noSmithyDocumentSerde
}

// The Amazon S3 location that stores the notebook execution output.
type OutputNotebookS3LocationFromInput struct {

	// The Amazon S3 bucket that stores the notebook execution output.
	Bucket *string

	// The key to the Amazon S3 location that stores the notebook execution output.
	Key *string

	noSmithyDocumentSerde
}

// Placement group configuration for an Amazon EMR cluster. The configuration
// specifies the placement strategy that can be applied to instance roles during
// cluster creation.
//
// To use this configuration, consider attaching managed policy
// AmazonElasticMapReducePlacementGroupPolicy to the Amazon EMR role.
type PlacementGroupConfig struct {

	// Role of the instance in the cluster.
	//
	// Starting with Amazon EMR release 5.23.0, the only supported instance role is
	// MASTER .
	//
	// This member is required.
	InstanceRole InstanceRoleType

	// Amazon EC2 Placement Group strategy associated with instance role.
	//
	// Starting with Amazon EMR release 5.23.0, the only supported placement strategy
	// is SPREAD for the MASTER instance role.
	PlacementStrategy PlacementGroupStrategy

	noSmithyDocumentSerde
}

// The Amazon EC2 Availability Zone configuration of the cluster (job flow).
type PlacementType struct {

	// The Amazon EC2 Availability Zone for the cluster. AvailabilityZone is used for
	// uniform instance groups, while AvailabilityZones (plural) is used for instance
	// fleets.
	AvailabilityZone *string

	// When multiple Availability Zones are specified, Amazon EMR evaluates them and
	// launches instances in the optimal Availability Zone. AvailabilityZones is used
	// for instance fleets, while AvailabilityZone (singular) is used for uniform
	// instance groups.
	//
	// The instance fleet configuration is available only in Amazon EMR releases 4.8.0
	// and later, excluding 5.0.x versions.
	AvailabilityZones []string

	noSmithyDocumentSerde
}

// A list of port ranges that are permitted to allow inbound traffic from all
// public IP addresses. To specify a single port, use the same value for MinRange
// and MaxRange .
type PortRange struct {

	// The smallest port number in a specified range of port numbers.
	//
	// This member is required.
	MinRange *int32

	// The smallest port number in a specified range of port numbers.
	MaxRange *int32

	noSmithyDocumentSerde
}

// The release label filters by application or version prefix.
type ReleaseLabelFilter struct {

	// Optional release label application filter. For example, spark@2.1.0 .
	Application *string

	// Optional release label version prefix filter. For example, emr-5 .
	Prefix *string

	noSmithyDocumentSerde
}

// The type of adjustment the automatic scaling activity makes when triggered, and
// the periodicity of the adjustment.
type ScalingAction struct {

	// The type of adjustment the automatic scaling activity makes when triggered, and
	// the periodicity of the adjustment.
	//
	// This member is required.
	SimpleScalingPolicyConfiguration *SimpleScalingPolicyConfiguration

	// Not available for instance groups. Instance groups use the market type
	// specified for the group.
	Market MarketType

	noSmithyDocumentSerde
}

// The upper and lower Amazon EC2 instance limits for an automatic scaling policy.
// Automatic scaling activities triggered by automatic scaling rules will not cause
// an instance group to grow above or below these limits.
type ScalingConstraints struct {

	// The upper boundary of Amazon EC2 instances in an instance group beyond which
	// scaling activities are not allowed to grow. Scale-out activities will not add
	// instances beyond this boundary.
	//
	// This member is required.
	MaxCapacity *int32

	// The lower boundary of Amazon EC2 instances in an instance group below which
	// scaling activities are not allowed to shrink. Scale-in activities will not
	// terminate instances below this boundary.
	//
	// This member is required.
	MinCapacity *int32

	noSmithyDocumentSerde
}

// A scale-in or scale-out rule that defines scaling activity, including the
// CloudWatch metric alarm that triggers activity, how Amazon EC2 instances are
// added or removed, and the periodicity of adjustments. The automatic scaling
// policy for an instance group can comprise one or more automatic scaling rules.
type ScalingRule struct {

	// The conditions that trigger an automatic scaling activity.
	//
	// This member is required.
	Action *ScalingAction

	// The name used to identify an automatic scaling rule. Rule names must be unique
	// within a scaling policy.
	//
	// This member is required.
	Name *string

	// The CloudWatch alarm definition that determines when automatic scaling activity
	// is triggered.
	//
	// This member is required.
	Trigger *ScalingTrigger

	// A friendly, more verbose description of the automatic scaling rule.
	Description *string

	noSmithyDocumentSerde
}

// The conditions that trigger an automatic scaling activity.
type ScalingTrigger struct {

	// The definition of a CloudWatch metric alarm. When the defined alarm conditions
	// are met along with other trigger parameters, scaling activity begins.
	//
	// This member is required.
	CloudWatchAlarmDefinition *CloudWatchAlarmDefinition

	noSmithyDocumentSerde
}

// Configuration of the script to run during a bootstrap action.
type ScriptBootstrapActionConfig struct {

	// Location in Amazon S3 of the script to run during a bootstrap action.
	//
	// This member is required.
	Path *string

	// A list of command line arguments to pass to the bootstrap action script.
	Args []string

	noSmithyDocumentSerde
}

// The creation date and time, and name, of a security configuration.
type SecurityConfigurationSummary struct {

	// The date and time the security configuration was created.
	CreationDateTime *time.Time

	// The name of the security configuration.
	Name *string

	noSmithyDocumentSerde
}

// Details for an Amazon EMR Studio session mapping including creation time, user
// or group ID, Studio ID, and so on.
type SessionMappingDetail struct {

	// The time the session mapping was created.
	CreationTime *time.Time

	// The globally unique identifier (GUID) of the user or group.
	IdentityId *string

	// The name of the user or group. For more information, see [UserName] and [DisplayName] in the IAM
	// Identity Center Identity Store API Reference.
	//
	// [UserName]: https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName
	// [DisplayName]: https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName
	IdentityName *string

	// Specifies whether the identity mapped to the Amazon EMR Studio is a user or a
	// group.
	IdentityType IdentityType

	// The time the session mapping was last modified.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of the session policy associated with the user
	// or group.
	SessionPolicyArn *string

	// The ID of the Amazon EMR Studio.
	StudioId *string

	noSmithyDocumentSerde
}

// Details for an Amazon EMR Studio session mapping. The details do not include
// the time the session mapping was last modified.
type SessionMappingSummary struct {

	// The time the session mapping was created.
	CreationTime *time.Time

	// The globally unique identifier (GUID) of the user or group from the IAM
	// Identity Center Identity Store.
	IdentityId *string

	// The name of the user or group. For more information, see [UserName] and [DisplayName] in the IAM
	// Identity Center Identity Store API Reference.
	//
	// [UserName]: https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName
	// [DisplayName]: https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName
	IdentityName *string

	// Specifies whether the identity mapped to the Amazon EMR Studio is a user or a
	// group.
	IdentityType IdentityType

	// The Amazon Resource Name (ARN) of the session policy associated with the user
	// or group.
	SessionPolicyArn *string

	// The ID of the Amazon EMR Studio.
	StudioId *string

	noSmithyDocumentSerde
}

// Policy for customizing shrink operations. Allows configuration of
// decommissioning timeout and targeted instance shrinking.
type ShrinkPolicy struct {

	// The desired timeout for decommissioning an instance. Overrides the default YARN
	// decommissioning timeout.
	DecommissionTimeout *int32

	// Custom policy for requesting termination protection or termination of specific
	// instances when shrinking an instance group.
	InstanceResizePolicy *InstanceResizePolicy

	noSmithyDocumentSerde
}

// An automatic scaling configuration, which describes how the policy adds or
// removes instances, the cooldown period, and the number of Amazon EC2 instances
// that will be added each time the CloudWatch metric alarm condition is satisfied.
type SimpleScalingPolicyConfiguration struct {

	// The amount by which to scale in or scale out, based on the specified
	// AdjustmentType . A positive value adds to the instance group's Amazon EC2
	// instance count while a negative number removes instances. If AdjustmentType is
	// set to EXACT_CAPACITY , the number should only be a positive integer. If
	// AdjustmentType is set to PERCENT_CHANGE_IN_CAPACITY , the value should express
	// the percentage as an integer. For example, -20 indicates a decrease in 20%
	// increments of cluster capacity.
	//
	// This member is required.
	ScalingAdjustment *int32

	// The way in which Amazon EC2 instances are added (if ScalingAdjustment is a
	// positive number) or terminated (if ScalingAdjustment is a negative number) each
	// time the scaling activity is triggered. CHANGE_IN_CAPACITY is the default.
	// CHANGE_IN_CAPACITY indicates that the Amazon EC2 instance count increments or
	// decrements by ScalingAdjustment , which should be expressed as an integer.
	// PERCENT_CHANGE_IN_CAPACITY indicates the instance count increments or decrements
	// by the percentage specified by ScalingAdjustment , which should be expressed as
	// an integer. For example, 20 indicates an increase in 20% increments of cluster
	// capacity. EXACT_CAPACITY indicates the scaling activity results in an instance
	// group with the number of Amazon EC2 instances specified by ScalingAdjustment ,
	// which should be expressed as a positive integer.
	AdjustmentType AdjustmentType

	// The amount of time, in seconds, after a scaling activity completes before any
	// further trigger-related scaling activities can start. The default value is 0.
	CoolDown *int32

	noSmithyDocumentSerde
}

// The returned release label application names or versions.
type SimplifiedApplication struct {

	// The returned release label application name. For example, hadoop .
	Name *string

	// The returned release label application version. For example, 3.2.1 .
	Version *string

	noSmithyDocumentSerde
}

// The launch specification for Spot Instances in the instance fleet, which
// determines the defined duration, provisioning timeout behavior, and allocation
// strategy.
//
// The instance fleet configuration is available only in Amazon EMR releases 4.8.0
// and later, excluding 5.0.x versions. Spot Instance allocation strategy is
// available in Amazon EMR releases 5.12.1 and later.
//
// Spot Instances with a defined duration (also known as Spot blocks) are no
// longer available to new customers from July 1, 2021. For customers who have
// previously used the feature, we will continue to support Spot Instances with a
// defined duration until December 31, 2022.
type SpotProvisioningSpecification struct {

	// The action to take when TargetSpotCapacity has not been fulfilled when the
	// TimeoutDurationMinutes has expired; that is, when all Spot Instances could not
	// be provisioned within the Spot provisioning timeout. Valid values are
	// TERMINATE_CLUSTER and SWITCH_TO_ON_DEMAND . SWITCH_TO_ON_DEMAND specifies that
	// if no Spot Instances are available, On-Demand Instances should be provisioned to
	// fulfill any remaining Spot capacity.
	//
	// This member is required.
	TimeoutAction SpotProvisioningTimeoutAction

	// The Spot provisioning timeout period in minutes. If Spot Instances are not
	// provisioned within this time period, the TimeOutAction is taken. Minimum value
	// is 5 and maximum value is 1440. The timeout applies only during initial
	// provisioning, when the cluster is first created.
	//
	// This member is required.
	TimeoutDurationMinutes *int32

	// Specifies one of the following strategies to launch Spot Instance fleets:
	// capacity-optimized , price-capacity-optimized , lowest-price , or diversified ,
	// and capacity-optimized-prioritized . For more information on the provisioning
	// strategies, see [Allocation strategies for Spot Instances]in the Amazon EC2 User Guide for Linux Instances.
	//
	// When you launch a Spot Instance fleet with the old console, it automatically
	// launches with the capacity-optimized strategy. You can't change the allocation
	// strategy from the old console.
	//
	// [Allocation strategies for Spot Instances]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-allocation-strategy.html
	AllocationStrategy SpotProvisioningAllocationStrategy

	// The defined duration for Spot Instances (also known as Spot blocks) in minutes.
	// When specified, the Spot Instance does not terminate before the defined duration
	// expires, and defined duration pricing for Spot Instances applies. Valid values
	// are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot
	// Instance receives its instance ID. At the end of the duration, Amazon EC2 marks
	// the Spot Instance for termination and provides a Spot Instance termination
	// notice, which gives the instance a two-minute warning before it terminates.
	//
	// Spot Instances with a defined duration (also known as Spot blocks) are no
	// longer available to new customers from July 1, 2021. For customers who have
	// previously used the feature, we will continue to support Spot Instances with a
	// defined duration until December 31, 2022.
	BlockDurationMinutes *int32

	noSmithyDocumentSerde
}

// The resize specification for Spot Instances in the instance fleet, which
// contains the resize timeout period.
type SpotResizingSpecification struct {

	// Specifies the allocation strategy to use to launch Spot instances during a
	// resize. If you run Amazon EMR releases 6.9.0 or higher, the default is
	// price-capacity-optimized . If you run Amazon EMR releases 6.8.0 or lower, the
	// default is capacity-optimized .
	AllocationStrategy SpotProvisioningAllocationStrategy

	// Spot resize timeout in minutes. If Spot Instances are not provisioned within
	// this time, the resize workflow will stop provisioning of Spot instances. Minimum
	// value is 5 minutes and maximum value is 10,080 minutes (7 days). The timeout
	// applies to all resize workflows on the Instance Fleet. The resize could be
	// triggered by Amazon EMR Managed Scaling or by the customer (via Amazon EMR
	// Console, Amazon EMR CLI modify-instance-fleet or Amazon EMR SDK
	// ModifyInstanceFleet API) or by Amazon EMR due to Amazon EC2 Spot Reclamation.
	TimeoutDurationMinutes *int32

	noSmithyDocumentSerde
}

// This represents a step in a cluster.
type Step struct {

	// The action to take when the cluster step fails. Possible values are
	// TERMINATE_CLUSTER , CANCEL_AND_WAIT , and CONTINUE . TERMINATE_JOB_FLOW is
	// provided for backward compatibility. We recommend using TERMINATE_CLUSTER
	// instead.
	//
	// If a cluster's StepConcurrencyLevel is greater than 1 , do not use
	// AddJobFlowSteps to submit a step with this parameter set to CANCEL_AND_WAIT or
	// TERMINATE_CLUSTER . The step is not submitted and the action fails with a
	// message that the ActionOnFailure setting is not valid.
	//
	// If you change a cluster's StepConcurrencyLevel to be greater than 1 while a
	// step is running, the ActionOnFailure parameter may not behave as you expect. In
	// this case, for a step that fails with this parameter set to CANCEL_AND_WAIT ,
	// pending steps and the running step are not canceled; for a step that fails with
	// this parameter set to TERMINATE_CLUSTER , the cluster does not terminate.
	ActionOnFailure ActionOnFailure

	// The Hadoop job configuration of the cluster step.
	Config *HadoopStepConfig

	// The Amazon Resource Name (ARN) of the runtime role for a step on the cluster.
	// The runtime role can be a cross-account IAM role. The runtime role ARN is a
	// combination of account ID, role name, and role type using the following format:
	// arn:partition:service:region:account:resource .
	//
	// For example, arn:aws:IAM::1234567890:role/ReadOnly is a correctly formatted
	// runtime role ARN.
	ExecutionRoleArn *string

	// The identifier of the cluster step.
	Id *string

	// The name of the cluster step.
	Name *string

	// The current execution status details of the cluster step.
	Status *StepStatus

	noSmithyDocumentSerde
}

// Specification for a cluster (job flow) step.
type StepConfig struct {

	// The JAR file used for the step.
	//
	// This member is required.
	HadoopJarStep *HadoopJarStepConfig

	// The name of the step.
	//
	// This member is required.
	Name *string

	// The action to take when the step fails. Use one of the following values:
	//
	//   - TERMINATE_CLUSTER - Shuts down the cluster.
	//
	//   - CANCEL_AND_WAIT - Cancels any pending steps and returns the cluster to the
	//   WAITING state.
	//
	//   - CONTINUE - Continues to the next step in the queue.
	//
	//   - TERMINATE_JOB_FLOW - Shuts down the cluster. TERMINATE_JOB_FLOW is provided
	//   for backward compatibility. We recommend using TERMINATE_CLUSTER instead.
	//
	// If a cluster's StepConcurrencyLevel is greater than 1 , do not use
	// AddJobFlowSteps to submit a step with this parameter set to CANCEL_AND_WAIT or
	// TERMINATE_CLUSTER . The step is not submitted and the action fails with a
	// message that the ActionOnFailure setting is not valid.
	//
	// If you change a cluster's StepConcurrencyLevel to be greater than 1 while a
	// step is running, the ActionOnFailure parameter may not behave as you expect. In
	// this case, for a step that fails with this parameter set to CANCEL_AND_WAIT ,
	// pending steps and the running step are not canceled; for a step that fails with
	// this parameter set to TERMINATE_CLUSTER , the cluster does not terminate.
	ActionOnFailure ActionOnFailure

	noSmithyDocumentSerde
}

// Combines the execution state and configuration of a step.
type StepDetail struct {

	// The description of the step status.
	//
	// This member is required.
	ExecutionStatusDetail *StepExecutionStatusDetail

	// The step configuration.
	//
	// This member is required.
	StepConfig *StepConfig

	noSmithyDocumentSerde
}

// The execution state of a step.
type StepExecutionStatusDetail struct {

	// The creation date and time of the step.
	//
	// This member is required.
	CreationDateTime *time.Time

	// The state of the step.
	//
	// This member is required.
	State StepExecutionState

	// The completion date and time of the step.
	EndDateTime *time.Time

	// A description of the step's current state.
	LastStateChangeReason *string

	// The start date and time of the step.
	StartDateTime *time.Time

	noSmithyDocumentSerde
}

// The details of the step state change reason.
type StepStateChangeReason struct {

	// The programmable code for the state change reason. Note: Currently, the service
	// provides no code for the state change.
	Code StepStateChangeReasonCode

	// The descriptive message for the state change reason.
	Message *string

	noSmithyDocumentSerde
}

// The execution status details of the cluster step.
type StepStatus struct {

	// The details for the step failure including reason, message, and log file path
	// where the root cause was identified.
	FailureDetails *FailureDetails

	// The execution state of the cluster step.
	State StepState

	// The reason for the step execution status change.
	StateChangeReason *StepStateChangeReason

	// The timeline of the cluster step status over time.
	Timeline *StepTimeline

	noSmithyDocumentSerde
}

// The summary of the cluster step.
type StepSummary struct {

	// The action to take when the cluster step fails. Possible values are
	// TERMINATE_CLUSTER, CANCEL_AND_WAIT, and CONTINUE. TERMINATE_JOB_FLOW is
	// available for backward compatibility.
	ActionOnFailure ActionOnFailure

	// The Hadoop job configuration of the cluster step.
	Config *HadoopStepConfig

	// The identifier of the cluster step.
	Id *string

	// The name of the cluster step.
	Name *string

	// The current execution status details of the cluster step.
	Status *StepStatus

	noSmithyDocumentSerde
}

// The timeline of the cluster step lifecycle.
type StepTimeline struct {

	// The date and time when the cluster step was created.
	CreationDateTime *time.Time

	// The date and time when the cluster step execution completed or failed.
	EndDateTime *time.Time

	// The date and time when the cluster step execution started.
	StartDateTime *time.Time

	noSmithyDocumentSerde
}

// Details for an Amazon EMR Studio including ID, creation time, name, and so on.
type Studio struct {

	// Specifies whether the Amazon EMR Studio authenticates users with IAM or IAM
	// Identity Center.
	AuthMode AuthMode

	// The time the Amazon EMR Studio was created.
	CreationTime *time.Time

	// The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook
	// files.
	DefaultS3Location *string

	// The detailed description of the Amazon EMR Studio.
	Description *string

	// The KMS key identifier (ARN) used to encrypt Amazon EMR Studio workspace and
	// notebook files when backed up to Amazon S3.
	EncryptionKeyArn *string

	// The ID of the Engine security group associated with the Amazon EMR Studio. The
	// Engine security group allows inbound network traffic from resources in the
	// Workspace security group.
	EngineSecurityGroupId *string

	//  The ARN of the IAM Identity Center instance the Studio application belongs to.
	IdcInstanceArn *string

	//  Indicates whether the Studio has REQUIRED or OPTIONAL IAM Identity Center user
	// assignment. If the value is set to REQUIRED , users must be explicitly assigned
	// to the Studio application to access the Studio.
	IdcUserAssignment IdcUserAssignment

	// Your identity provider's authentication endpoint. Amazon EMR Studio redirects
	// federated users to this endpoint for authentication when logging in to a Studio
	// with the Studio URL.
	IdpAuthUrl *string

	// The name of your identity provider's RelayState parameter.
	IdpRelayStateParameterName *string

	// The name of the Amazon EMR Studio.
	Name *string

	// The name of the IAM role assumed by the Amazon EMR Studio.
	ServiceRole *string

	// The Amazon Resource Name (ARN) of the Amazon EMR Studio.
	StudioArn *string

	// The ID of the Amazon EMR Studio.
	StudioId *string

	// The list of IDs of the subnets associated with the Amazon EMR Studio.
	SubnetIds []string

	// A list of tags associated with the Amazon EMR Studio.
	Tags []Tag

	//  Indicates whether the Studio has Trusted identity propagation enabled. The
	// default value is false .
	TrustedIdentityPropagationEnabled *bool

	// The unique access URL of the Amazon EMR Studio.
	Url *string

	// The name of the IAM role assumed by users logged in to the Amazon EMR Studio. A
	// Studio only requires a UserRole when you use IAM authentication.
	UserRole *string

	// The ID of the VPC associated with the Amazon EMR Studio.
	VpcId *string

	// The ID of the Workspace security group associated with the Amazon EMR Studio.
	// The Workspace security group allows outbound network traffic to resources in the
	// Engine security group and to the internet.
	WorkspaceSecurityGroupId *string

	noSmithyDocumentSerde
}

// Details for an Amazon EMR Studio, including ID, Name, VPC, and Description. To
// fetch additional details such as subnets, IAM roles, security groups, and tags
// for the Studio, use the DescribeStudioAPI.
type StudioSummary struct {

	// Specifies whether the Studio authenticates users using IAM or IAM Identity
	// Center.
	AuthMode AuthMode

	// The time when the Amazon EMR Studio was created.
	CreationTime *time.Time

	// The detailed description of the Amazon EMR Studio.
	Description *string

	// The name of the Amazon EMR Studio.
	Name *string

	// The ID of the Amazon EMR Studio.
	StudioId *string

	// The unique access URL of the Amazon EMR Studio.
	Url *string

	// The ID of the Virtual Private Cloud (Amazon VPC) associated with the Amazon EMR
	// Studio.
	VpcId *string

	noSmithyDocumentSerde
}

// An instance type that the specified Amazon EMR release supports.
type SupportedInstanceType struct {

	// The CPU architecture, for example X86_64 or AARCH64 .
	Architecture *string

	// Indicates whether the SupportedInstanceType supports Amazon EBS optimization.
	EbsOptimizedAvailable *bool

	// Indicates whether the SupportedInstanceType uses Amazon EBS optimization by
	// default.
	EbsOptimizedByDefault *bool

	// Indicates whether the SupportedInstanceType only supports Amazon EBS.
	EbsStorageOnly *bool

	// The Amazon EC2 family and generation for the SupportedInstanceType .
	InstanceFamilyId *string

	// Indicates whether the SupportedInstanceType only supports 64-bit architecture.
	Is64BitsOnly *bool

	// The amount of memory that is available to Amazon EMR from the
	// SupportedInstanceType . The kernel and hypervisor software consume some memory,
	// so this value might be lower than the overall memory for the instance type.
	MemoryGB *float32

	// Number of disks for the SupportedInstanceType . This value is 0 for Amazon
	// EBS-only instance types.
	NumberOfDisks *int32

	// StorageGB represents the storage capacity of the SupportedInstanceType . This
	// value is 0 for Amazon EBS-only instance types.
	StorageGB *int32

	// The [Amazon EC2 instance type], for example m5.xlarge , of the SupportedInstanceType .
	//
	// [Amazon EC2 instance type]: http://aws.amazon.com/ec2/instance-types/
	Type *string

	// The number of vCPUs available for the SupportedInstanceType .
	VCPU *int32

	noSmithyDocumentSerde
}

// The list of supported product configurations that allow user-supplied
// arguments. Amazon EMR accepts these arguments and forwards them to the
// corresponding installation script as bootstrap action arguments.
type SupportedProductConfig struct {

	// The list of user-supplied arguments.
	Args []string

	// The name of the product configuration.
	Name *string

	noSmithyDocumentSerde
}

// A key-value pair containing user-defined metadata that you can associate with
// an Amazon EMR resource. Tags make it easier to associate clusters in various
// ways, such as grouping clusters to track your Amazon EMR resource allocation
// costs. For more information, see [Tag Clusters].
//
// [Tag Clusters]: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html
type Tag struct {

	// A user-defined key, which is the minimum required information for a valid tag.
	// For more information, see [Tag].
	//
	// [Tag]: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html
	Key *string

	// A user-defined value, which is optional in a tag. For more information, see [Tag Clusters].
	//
	// [Tag Clusters]: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html
	Value *string

	noSmithyDocumentSerde
}

// The username and password that you use to connect to cluster endpoints.
type UsernamePassword struct {

	// The password associated with the temporary credentials that you use to connect
	// to cluster endpoints.
	Password *string

	// The username associated with the temporary credentials that you use to connect
	// to cluster endpoints.
	Username *string

	noSmithyDocumentSerde
}

// EBS volume specifications such as volume type, IOPS, size (GiB) and throughput
// (MiB/s) that are requested for the EBS volume attached to an Amazon EC2 instance
// in the cluster.
type VolumeSpecification struct {

	// The volume size, in gibibytes (GiB). This can be a number from 1 - 1024. If the
	// volume type is EBS-optimized, the minimum value is 10.
	//
	// This member is required.
	SizeInGB *int32

	// The volume type. Volume types supported are gp3, gp2, io1, st1, sc1, and
	// standard.
	//
	// This member is required.
	VolumeType *string

	// The number of I/O operations per second (IOPS) that the volume supports.
	Iops *int32

	// The throughput, in mebibyte per second (MiB/s). This optional parameter can be
	// a number from 125 - 1000 and is valid only for gp3 volumes.
	Throughput *int32

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isCredentials() {}
