// Code generated by smithy-go-codegen DO NOT EDIT.

package freetier

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/freetier/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of all Free Tier usage objects that match your filters.
func (c *Client) GetFreeTierUsage(ctx context.Context, params *GetFreeTierUsageInput, optFns ...func(*Options)) (*GetFreeTierUsageOutput, error) {
	if params == nil {
		params = &GetFreeTierUsageInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetFreeTierUsage", params, optFns, c.addOperationGetFreeTierUsageMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetFreeTierUsageOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetFreeTierUsageInput struct {

	// An expression that specifies the conditions that you want each FreeTierUsage
	// object to meet.
	Filter *types.Expression

	// The maximum number of results to return in the response. MaxResults means that
	// there can be up to the specified number of values, but there might be fewer
	// results based on your filters.
	MaxResults *int32

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string

	noSmithyDocumentSerde
}

type GetFreeTierUsageOutput struct {

	// The list of Free Tier usage objects that meet your filter expression.
	//
	// This member is required.
	FreeTierUsages []types.FreeTierUsage

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetFreeTierUsageMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetFreeTierUsage{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetFreeTierUsage{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetFreeTierUsage"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetFreeTierUsageValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetFreeTierUsage(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// GetFreeTierUsagePaginatorOptions is the paginator options for GetFreeTierUsage
type GetFreeTierUsagePaginatorOptions struct {
	// The maximum number of results to return in the response. MaxResults means that
	// there can be up to the specified number of values, but there might be fewer
	// results based on your filters.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetFreeTierUsagePaginator is a paginator for GetFreeTierUsage
type GetFreeTierUsagePaginator struct {
	options   GetFreeTierUsagePaginatorOptions
	client    GetFreeTierUsageAPIClient
	params    *GetFreeTierUsageInput
	nextToken *string
	firstPage bool
}

// NewGetFreeTierUsagePaginator returns a new GetFreeTierUsagePaginator
func NewGetFreeTierUsagePaginator(client GetFreeTierUsageAPIClient, params *GetFreeTierUsageInput, optFns ...func(*GetFreeTierUsagePaginatorOptions)) *GetFreeTierUsagePaginator {
	if params == nil {
		params = &GetFreeTierUsageInput{}
	}

	options := GetFreeTierUsagePaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetFreeTierUsagePaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetFreeTierUsagePaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetFreeTierUsage page.
func (p *GetFreeTierUsagePaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetFreeTierUsageOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetFreeTierUsage(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetFreeTierUsageAPIClient is a client that implements the GetFreeTierUsage
// operation.
type GetFreeTierUsageAPIClient interface {
	GetFreeTierUsage(context.Context, *GetFreeTierUsageInput, ...func(*Options)) (*GetFreeTierUsageOutput, error)
}

var _ GetFreeTierUsageAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetFreeTierUsage(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetFreeTierUsage",
	}
}
